/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.fife.ui.autocomplete.Util;

public class SourceTreeNode
extends DefaultMutableTreeNode
implements Comparable<SourceTreeNode> {
    private boolean sortable;
    private boolean sorted;
    private Pattern pattern;
    private Vector<TreeNode> visibleChildren = new Vector();
    private int sortPriority;

    public SourceTreeNode(Object object) {
        this(object, false);
    }

    public SourceTreeNode(Object object, boolean bl) {
        super(object);
        this.setSortable(true);
        this.setSorted(bl);
    }

    @Override
    public void add(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode != null && mutableTreeNode.getParent() == this) {
            this.insert(mutableTreeNode, super.getChildCount() - 1);
        } else {
            this.insert(mutableTreeNode, super.getChildCount());
        }
        if (this.sortable && this.sorted) {
            this.refreshVisibleChildren();
        }
    }

    @Override
    public Enumeration<TreeNode> children() {
        return this.visibleChildren.elements();
    }

    @Override
    public Object clone() {
        SourceTreeNode sourceTreeNode = (SourceTreeNode)super.clone();
        sourceTreeNode.visibleChildren = new Vector();
        return sourceTreeNode;
    }

    public SourceTreeNode cloneWithChildren() {
        SourceTreeNode sourceTreeNode = (SourceTreeNode)this.clone();
        int n = 0;
        while (n < super.getChildCount()) {
            sourceTreeNode.add(((SourceTreeNode)super.getChildAt(n)).cloneWithChildren());
            ++n;
        }
        return sourceTreeNode;
    }

    @Override
    public int compareTo(SourceTreeNode sourceTreeNode) {
        int n = -1;
        if (sourceTreeNode != null && (n = this.getSortPriority() - sourceTreeNode.getSortPriority()) == 0 && ((SourceTreeNode)this.getParent()).isSorted()) {
            n = this.toString().compareToIgnoreCase(sourceTreeNode.toString());
        }
        return n;
    }

    protected void filter(Pattern pattern) {
        this.pattern = pattern;
        this.refreshVisibleChildren();
        int n = 0;
        while (n < super.getChildCount()) {
            Object e = this.children.get(n);
            if (e instanceof SourceTreeNode) {
                ((SourceTreeNode)e).filter(pattern);
            }
            ++n;
        }
    }

    @Override
    public TreeNode getChildAfter(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("child cannot be null");
        }
        int n = this.getIndex(treeNode);
        if (n == -1) {
            throw new IllegalArgumentException("child node not contained");
        }
        return n < this.getChildCount() - 1 ? this.getChildAt(n + 1) : null;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this.visibleChildren.get(n);
    }

    @Override
    public TreeNode getChildBefore(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("child cannot be null");
        }
        int n = this.getIndex(treeNode);
        if (n == -1) {
            throw new IllegalArgumentException("child node not contained");
        }
        return n > 0 ? this.getChildAt(n - 1) : null;
    }

    @Override
    public int getChildCount() {
        return this.visibleChildren.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("child cannot be null");
        }
        int n = 0;
        while (n < this.visibleChildren.size()) {
            TreeNode treeNode2 = this.visibleChildren.get(n);
            if (treeNode2.equals(treeNode)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getSortPriority() {
        return this.sortPriority;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void refresh() {
        this.refreshVisibleChildren();
        int n = 0;
        while (n < this.getChildCount()) {
            TreeNode treeNode = this.getChildAt(n);
            if (treeNode instanceof SourceTreeNode) {
                ((SourceTreeNode)treeNode).refresh();
            }
            ++n;
        }
    }

    private void refreshVisibleChildren() {
        this.visibleChildren.clear();
        if (this.children != null) {
            this.visibleChildren.addAll(this.children);
            if (this.sortable && this.sorted) {
                Collections.sort(this.visibleChildren);
            }
            if (this.pattern != null) {
                Iterator<TreeNode> iterator = this.visibleChildren.iterator();
                while (iterator.hasNext()) {
                    TreeNode treeNode = iterator.next();
                    if (!treeNode.isLeaf()) continue;
                    String string = treeNode.toString();
                    if (this.pattern.matcher(string = Util.stripHtml(string)).find()) continue;
                    iterator.remove();
                }
            }
        }
    }

    public void setSortable(boolean bl) {
        this.sortable = bl;
    }

    public void setSorted(boolean bl) {
        if (bl != this.sorted) {
            this.sorted = bl;
            if (this.sortable) {
                this.refreshVisibleChildren();
            }
            int n = 0;
            while (n < super.getChildCount()) {
                Object e = this.children.get(n);
                if (e instanceof SourceTreeNode) {
                    ((SourceTreeNode)e).setSorted(bl);
                }
                ++n;
            }
        }
    }

    public void setSortPriority(int n) {
        this.sortPriority = n;
    }
}

