/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.fife.rsta.ac.LanguageSupport;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class LanguageSupportFactory
implements PropertyChangeListener {
    private static LanguageSupportFactory INSTANCE = new LanguageSupportFactory();
    private Map<String, String> styleToSupportClass;
    private Map<String, LanguageSupport> styleToSupport;
    private static final String LANGUAGE_SUPPORT_PROPERTY = "org.fife.rsta.ac.LanguageSupport";

    private LanguageSupportFactory() {
        this.createSupportMap();
    }

    public void addLanguageSupport(String string, String string2) {
        this.styleToSupportClass.put(string, string2);
    }

    private void createSupportMap() {
        this.styleToSupport = new HashMap<String, LanguageSupport>();
        this.styleToSupportClass = new HashMap<String, String>();
        String string = "org.fife.rsta.ac.";
        this.addLanguageSupport("text/c", String.valueOf(string) + "c.CLanguageSupport");
        this.addLanguageSupport("text/css", String.valueOf(string) + "css.CssLanguageSupport");
        this.addLanguageSupport("text/groovy", String.valueOf(string) + "groovy.GroovyLanguageSupport");
        this.addLanguageSupport("text/html", String.valueOf(string) + "html.HtmlLanguageSupport");
        this.addLanguageSupport("text/java", String.valueOf(string) + "java.JavaLanguageSupport");
        this.addLanguageSupport("text/javascript", String.valueOf(string) + "js.JavaScriptLanguageSupport");
        this.addLanguageSupport("text/jsp", String.valueOf(string) + "jsp.JspLanguageSupport");
        this.addLanguageSupport("text/perl", String.valueOf(string) + "perl.PerlLanguageSupport");
        this.addLanguageSupport("text/php", String.valueOf(string) + "php.PhpLanguageSupport");
        this.addLanguageSupport("text/unix", String.valueOf(string) + "sh.ShellLanguageSupport");
        this.addLanguageSupport("text/xml", String.valueOf(string) + "xml.XmlLanguageSupport");
    }

    public static LanguageSupportFactory get() {
        return INSTANCE;
    }

    public static LanguageSupportFactory create() {
        INSTANCE = new LanguageSupportFactory();
        return INSTANCE;
    }

    public LanguageSupport getSupportFor(String string) {
        String string2;
        LanguageSupport languageSupport = this.styleToSupport.get(string);
        if (languageSupport == null && (string2 = this.styleToSupportClass.get(string)) != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                languageSupport = (LanguageSupport)clazz.newInstance();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.styleToSupport.put(string, languageSupport);
            this.styleToSupportClass.remove(string);
        }
        return languageSupport;
    }

    private void installSupport(RSyntaxTextArea rSyntaxTextArea) {
        String string = rSyntaxTextArea.getSyntaxEditingStyle();
        LanguageSupport languageSupport = this.getSupportFor(string);
        if (languageSupport != null) {
            languageSupport.install(rSyntaxTextArea);
        }
        rSyntaxTextArea.putClientProperty(LANGUAGE_SUPPORT_PROPERTY, languageSupport);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if ("RSTA.syntaxStyle".equals(string)) {
            this.uninstallSupport(rSyntaxTextArea);
            this.installSupport(rSyntaxTextArea);
        }
    }

    public void register(RSyntaxTextArea rSyntaxTextArea) {
        this.installSupport(rSyntaxTextArea);
        rSyntaxTextArea.addPropertyChangeListener("RSTA.syntaxStyle", this);
    }

    private void uninstallSupport(RSyntaxTextArea rSyntaxTextArea) {
        LanguageSupport languageSupport = (LanguageSupport)rSyntaxTextArea.getClientProperty(LANGUAGE_SUPPORT_PROPERTY);
        if (languageSupport != null) {
            languageSupport.uninstall(rSyntaxTextArea);
        }
    }

    public void unregister(RSyntaxTextArea rSyntaxTextArea) {
        this.uninstallSupport(rSyntaxTextArea);
        rSyntaxTextArea.removePropertyChangeListener("RSTA.syntaxStyle", this);
    }
}

