/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fife.rsta.ac.OutputCollector;

public class IOUtil {
    private static Map<String, String> DEFAULT_ENV;

    private IOUtil() {
    }

    private static Map<String, String> getDefaultEnvMap() {
        if (DEFAULT_ENV != null) {
            return DEFAULT_ENV;
        }
        try {
            DEFAULT_ENV = System.getenv();
        }
        catch (SecurityException securityException) {
            DEFAULT_ENV = Collections.emptyMap();
        }
        return DEFAULT_ENV;
    }

    public static String getEnvSafely(String string) {
        String string2 = null;
        try {
            string2 = System.getenv(string);
        }
        catch (SecurityException securityException) {}
        return string2;
    }

    public static String[] getEnvironmentSafely(String[] stringArray) {
        Map<String, String> map = IOUtil.getDefaultEnvMap();
        if (stringArray != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(map);
            int n = 0;
            while (n < stringArray.length) {
                hashMap.put(stringArray[n], stringArray[n + 1]);
                n += 2;
            }
            map = hashMap;
        }
        int n = map.size();
        String[] stringArray2 = new String[n];
        int n2 = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringArray2[n2++] = String.valueOf(entry.getKey()) + "=" + entry.getValue();
        }
        return stringArray2;
    }

    public static int waitForProcess(Process process, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws IOException {
        InputStream inputStream = process.getInputStream();
        InputStream inputStream2 = process.getErrorStream();
        Thread thread = new Thread(new OutputCollector(inputStream, stringBuffer));
        Thread thread2 = new Thread(new OutputCollector(inputStream2, stringBuffer2));
        thread.start();
        thread2.start();
        int n = -1;
        try {
            try {
                n = process.waitFor();
                thread.join();
                thread2.join();
            }
            catch (InterruptedException interruptedException) {
                process.destroy();
                inputStream.close();
                inputStream2.close();
            }
        }
        finally {
            inputStream.close();
            inputStream2.close();
        }
        return n;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = IOUtil.getEnvSafely(stringArray[n]);
            System.out.println(String.valueOf(stringArray[n]) + "=" + string);
            ++n;
        }
    }
}

