/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.fife.rsta.ac.AbstractSourceTree;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;

public class GoToMemberWindow
extends JWindow {
    private RSyntaxTextArea textArea;
    private JTextField field;
    private AbstractSourceTree tree;
    private Listener listener;

    public GoToMemberWindow(Window window, RSyntaxTextArea rSyntaxTextArea, AbstractSourceTree abstractSourceTree) {
        super(window);
        this.textArea = rSyntaxTextArea;
        ComponentOrientation componentOrientation = window.getComponentOrientation();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(TipUtil.getToolTipBorder());
        this.listener = new Listener();
        this.addWindowFocusListener(this.listener);
        window.addComponentListener(this.listener);
        this.field = this.createTextField();
        jPanel.add((Component)this.field, "North");
        this.tree = abstractSourceTree;
        this.tweakTreeBorder(this.tree);
        abstractSourceTree.setSorted(true);
        abstractSourceTree.setShowMajorElementsOnly(true);
        abstractSourceTree.setGotoSelectedElementOnClick(false);
        abstractSourceTree.setFocusable(false);
        abstractSourceTree.listenTo(rSyntaxTextArea);
        abstractSourceTree.addMouseListener(this.listener);
        JScrollPane jScrollPane = new JScrollPane(abstractSourceTree);
        jScrollPane.setBorder(null);
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jPanel.add(jScrollPane);
        Color color = TipUtil.getToolTipBackground();
        this.setBackground(color);
        this.field.setBackground(color);
        abstractSourceTree.setBackground(color);
        ((DefaultTreeCellRenderer)abstractSourceTree.getCellRenderer()).setBackgroundNonSelectionColor(color);
        this.setContentPane(jPanel);
        PopupWindowDecorator popupWindowDecorator = PopupWindowDecorator.get();
        if (popupWindowDecorator != null) {
            popupWindowDecorator.decorate(this);
        }
        this.applyComponentOrientation(componentOrientation);
        this.pack();
        JRootPane jRootPane = this.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "EscapePressed");
        ActionMap actionMap = jRootPane.getActionMap();
        actionMap.put("EscapePressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GoToMemberWindow.this.dispose();
            }
        });
    }

    private JTextField createTextField() {
        JTextField jTextField = new JTextField(30);
        jTextField.setUI(new BasicTextFieldUI());
        jTextField.setBorder(new TextFieldBorder());
        jTextField.addActionListener(this.listener);
        jTextField.addKeyListener(this.listener);
        jTextField.getDocument().addDocumentListener(this.listener);
        return jTextField;
    }

    @Override
    public void dispose() {
        this.listener.uninstall();
        super.dispose();
        this.textArea.requestFocusInWindow();
    }

    private void tweakTreeBorder(AbstractSourceTree abstractSourceTree) {
        Border border = abstractSourceTree.getBorder();
        if (border == null) {
            border = BorderFactory.createEmptyBorder(2, 0, 0, 0);
            abstractSourceTree.setBorder(border);
        } else if (border instanceof EmptyBorder && ((EmptyBorder)border).getBorderInsets().top == 0) {
            border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0), border);
            abstractSourceTree.setBorder(border);
        }
    }

    private class Listener
    extends MouseAdapter
    implements WindowFocusListener,
    ComponentListener,
    DocumentListener,
    ActionListener,
    KeyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (GoToMemberWindow.this.tree.gotoSelectedElement()) {
                GoToMemberWindow.this.dispose();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.handleDocumentEvent(documentEvent);
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            GoToMemberWindow.this.dispose();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            GoToMemberWindow.this.dispose();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoToMemberWindow.this.dispose();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        private void handleDocumentEvent(DocumentEvent documentEvent) {
            GoToMemberWindow.this.tree.filter(GoToMemberWindow.this.field.getText());
            GoToMemberWindow.this.tree.selectFirstNodeMatchingFilter();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.handleDocumentEvent(documentEvent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 40: {
                    GoToMemberWindow.this.tree.selectNextVisibleRow();
                    break;
                }
                case 38: {
                    GoToMemberWindow.this.tree.selectPreviousVisibleRow();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                GoToMemberWindow.this.tree.gotoSelectedElement();
                GoToMemberWindow.this.dispose();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleDocumentEvent(documentEvent);
        }

        public void uninstall() {
            GoToMemberWindow.this.field.removeActionListener(this);
            GoToMemberWindow.this.field.getDocument().removeDocumentListener(this);
            GoToMemberWindow.this.tree.removeMouseListener(this);
            GoToMemberWindow.this.removeWindowFocusListener(this);
        }

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
            GoToMemberWindow.this.dispose();
        }
    }

    private static class TextFieldBorder
    implements Border {
        private TextFieldBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(2, 5, 3, 5);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        }
    }
}

