/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.fife.rsta.ac.AbstractSourceTree;
import org.fife.rsta.ac.GoToMemberWindow;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class GoToMemberAction
extends TextAction {
    private Class<?> outlineTreeClass;

    public GoToMemberAction(Class<?> clazz) {
        super("GoToType");
        this.outlineTreeClass = clazz;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        AbstractSourceTree abstractSourceTree = this.createTree();
        if (abstractSourceTree == null) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        JTextComponent jTextComponent = this.getTextComponent(actionEvent);
        if (jTextComponent instanceof RSyntaxTextArea) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)jTextComponent;
            Window window = SwingUtilities.getWindowAncestor(rSyntaxTextArea);
            GoToMemberWindow goToMemberWindow = new GoToMemberWindow(window, rSyntaxTextArea, abstractSourceTree);
            this.setLocationBasedOn(goToMemberWindow, rSyntaxTextArea);
            goToMemberWindow.setVisible(true);
        } else {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        }
    }

    private AbstractSourceTree createTree() {
        AbstractSourceTree abstractSourceTree = null;
        try {
            abstractSourceTree = (AbstractSourceTree)this.outlineTreeClass.newInstance();
            abstractSourceTree.setSorted(true);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return abstractSourceTree;
    }

    private void setLocationBasedOn(GoToMemberWindow goToMemberWindow, RSyntaxTextArea rSyntaxTextArea) {
        Rectangle rectangle = rSyntaxTextArea.getVisibleRect();
        Dimension dimension = goToMemberWindow.getPreferredSize();
        int n = rectangle.x + (rectangle.width - dimension.width) / 2;
        int n2 = rectangle.y + (rectangle.height - dimension.height) / 2;
        Point point = new Point(n, n2);
        SwingUtilities.convertPointToScreen(point, rSyntaxTextArea);
        goToMemberWindow.setLocation(point);
    }
}

