/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac;

import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.fife.rsta.ac.SourceTreeNode;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public abstract class AbstractSourceTree
extends JTree {
    protected RSyntaxTextArea textArea;
    private boolean sorted;
    private Pattern pattern;
    private boolean gotoSelectedElementOnClick;
    private boolean showMajorElementsOnly;

    public AbstractSourceTree() {
        this.getSelectionModel().setSelectionMode(1);
        this.gotoSelectedElementOnClick = true;
        this.showMajorElementsOnly = false;
    }

    public abstract void expandInitialNodes();

    protected boolean fastExpandAll(TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() > 0) {
            boolean bl2 = false;
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                boolean bl3 = bl2 = this.fastExpandAll(treePath2, bl) || bl2;
            }
            if (!bl2) {
                if (bl) {
                    this.expandPath(treePath);
                } else {
                    this.collapsePath(treePath);
                }
            }
            return true;
        }
        return false;
    }

    public void filter(String string) {
        if (string == null && this.pattern != null || string != null && this.pattern == null || string != null && !string.equals(this.pattern.pattern())) {
            this.pattern = string == null || string.length() == 0 ? null : RSyntaxUtilities.wildcardToPattern("^" + string, false, false);
            Object object = this.getModel().getRoot();
            if (object instanceof SourceTreeNode) {
                ((SourceTreeNode)object).filter(this.pattern);
            }
            ((DefaultTreeModel)this.getModel()).reload();
            this.expandInitialNodes();
        }
    }

    public boolean getGotoSelectedElementOnClick() {
        return this.gotoSelectedElementOnClick;
    }

    public boolean getShowMajorElementsOnly() {
        return this.showMajorElementsOnly;
    }

    public abstract boolean gotoSelectedElement();

    public boolean isSorted() {
        return this.sorted;
    }

    public abstract void listenTo(RSyntaxTextArea var1);

    public void refresh() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        Object object = defaultTreeModel.getRoot();
        if (object instanceof SourceTreeNode) {
            SourceTreeNode sourceTreeNode = (SourceTreeNode)object;
            sourceTreeNode.refresh();
            defaultTreeModel.reload();
            this.expandInitialNodes();
        }
    }

    public void selectFirstNodeMatchingFilter() {
        if (this.pattern == null) {
            return;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            SourceTreeNode sourceTreeNode = (SourceTreeNode)enumeration.nextElement();
            JLabel jLabel = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, sourceTreeNode, true, true, sourceTreeNode.isLeaf(), 0, true);
            String string = jLabel.getText();
            if (string == null || !this.pattern.matcher(string).find()) continue;
            this.setSelectionPath(new TreePath(defaultTreeModel.getPathToRoot(sourceTreeNode)));
            return;
        }
    }

    public void selectNextVisibleRow() {
        int n = this.getLeadSelectionRow();
        if (++n < this.getRowCount()) {
            TreePath treePath = this.getPathForRow(n);
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
        }
    }

    public void selectPreviousVisibleRow() {
        int n = this.getLeadSelectionRow();
        if (--n >= 0) {
            TreePath treePath = this.getPathForRow(n);
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
        }
    }

    public void setGotoSelectedElementOnClick(boolean bl) {
        this.gotoSelectedElementOnClick = bl;
    }

    public void setShowMajorElementsOnly(boolean bl) {
        this.showMajorElementsOnly = bl;
    }

    public void setSorted(boolean bl) {
        if (this.sorted != bl) {
            this.sorted = bl;
            Object object = this.getModel().getRoot();
            if (object instanceof SourceTreeNode) {
                ((SourceTreeNode)object).setSorted(bl);
            }
            ((DefaultTreeModel)this.getModel()).reload();
            this.expandInitialNodes();
        }
    }

    public abstract void uninstall();
}

