/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac;

import java.awt.event.ActionEvent;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.TextAction;
import org.fife.rsta.ac.AbstractLanguageSupport;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;

public abstract class AbstractMarkupLanguageSupport
extends AbstractLanguageSupport {
    protected static final String INSERT_CLOSING_TAG_ACTION = "HtmlLanguageSupport.InsertClosingTag";
    private boolean autoAddClosingTags;

    protected AbstractMarkupLanguageSupport() {
        this.setAutoAddClosingTags(true);
    }

    public boolean getAutoAddClosingTags() {
        return this.autoAddClosingTags;
    }

    protected void installKeyboardShortcuts(RSyntaxTextArea rSyntaxTextArea) {
        InputMap inputMap = rSyntaxTextArea.getInputMap();
        ActionMap actionMap = rSyntaxTextArea.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke('>'), INSERT_CLOSING_TAG_ACTION);
        actionMap.put(INSERT_CLOSING_TAG_ACTION, new InsertClosingTagAction());
    }

    protected abstract boolean shouldAutoCloseTag(String var1);

    public void setAutoAddClosingTags(boolean bl) {
        this.autoAddClosingTags = bl;
    }

    protected void uninstallKeyboardShortcuts(RSyntaxTextArea rSyntaxTextArea) {
        InputMap inputMap = rSyntaxTextArea.getInputMap();
        ActionMap actionMap = rSyntaxTextArea.getActionMap();
        inputMap.remove(KeyStroke.getKeyStroke('>'));
        actionMap.remove(INSERT_CLOSING_TAG_ACTION);
    }

    private class InsertClosingTagAction
    extends TextAction {
        InsertClosingTagAction() {
            super(AbstractMarkupLanguageSupport.INSERT_CLOSING_TAG_ACTION);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.getTextComponent(actionEvent);
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
            Caret caret = rSyntaxTextArea.getCaret();
            int n = caret.getDot();
            boolean bl = n != caret.getMark();
            rSyntaxTextArea.replaceSelection(">");
            if (!bl && AbstractMarkupLanguageSupport.this.getAutoAddClosingTags()) {
                String string;
                Token token = rSyntaxDocument.getTokenListForLine(rSyntaxTextArea.getCaretLineNumber());
                if ((token = RSyntaxUtilities.getTokenAtOffset(token, n)) != null && token.isSingleChar(25, '>') && (string = this.discoverTagName(rSyntaxDocument, n)) != null) {
                    rSyntaxTextArea.replaceSelection("</" + string + ">");
                    rSyntaxTextArea.setCaretPosition(n + 1);
                }
            }
        }

        private String discoverTagName(RSyntaxDocument rSyntaxDocument, int n) {
            String string = null;
            Element element = rSyntaxDocument.getDefaultRootElement();
            int n2 = element.getElementIndex(n);
            Token token = rSyntaxDocument.getTokenListForLine(n2);
            while (token != null && token.isPaintable()) {
                if (token.getType() == 25) {
                    if (token.isSingleChar('<')) {
                        if ((token = token.getNextToken()) != null && token.isPaintable()) {
                            string = token.getLexeme();
                        }
                    } else if (token.isSingleChar('>')) {
                        if (token.getOffset() == n) {
                            if (string == null || AbstractMarkupLanguageSupport.this.shouldAutoCloseTag(string)) {
                                return string;
                            }
                            return null;
                        }
                    } else if (token.is(25, "</")) {
                        string = null;
                    }
                }
                token = token.getNextToken();
            }
            return null;
        }
    }
}

