/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.fife.rsta.ac.LanguageSupport;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.CompletionCellRenderer;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public abstract class AbstractLanguageSupport
implements LanguageSupport {
    private Map<RSyntaxTextArea, AutoCompletion> textAreaToAutoCompletion;
    private boolean autoCompleteEnabled;
    private boolean autoActivationEnabled;
    private int autoActivationDelay;
    private boolean parameterAssistanceEnabled;
    private boolean showDescWindow;
    private ListCellRenderer renderer;

    protected AbstractLanguageSupport() {
        this.setDefaultCompletionCellRenderer(null);
        this.textAreaToAutoCompletion = new HashMap<RSyntaxTextArea, AutoCompletion>();
        this.autoCompleteEnabled = true;
        this.autoActivationEnabled = false;
        this.autoActivationDelay = 300;
    }

    protected AutoCompletion createAutoCompletion(CompletionProvider completionProvider) {
        AutoCompletion autoCompletion = new AutoCompletion(completionProvider);
        autoCompletion.setListCellRenderer(this.getDefaultCompletionCellRenderer());
        autoCompletion.setAutoCompleteEnabled(this.isAutoCompleteEnabled());
        autoCompletion.setAutoActivationEnabled(this.isAutoActivationEnabled());
        autoCompletion.setAutoActivationDelay(this.getAutoActivationDelay());
        autoCompletion.setParameterAssistanceEnabled(this.isParameterAssistanceEnabled());
        autoCompletion.setShowDescWindow(this.getShowDescWindow());
        return autoCompletion;
    }

    protected ListCellRenderer createDefaultCompletionCellRenderer() {
        return new DefaultListCellRenderer();
    }

    private void delegateToSubstanceRenderer(CompletionCellRenderer completionCellRenderer) {
        try {
            completionCellRenderer.delegateToSubstanceRenderer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public int getAutoActivationDelay() {
        return this.autoActivationDelay;
    }

    protected AutoCompletion getAutoCompletionFor(RSyntaxTextArea rSyntaxTextArea) {
        return this.textAreaToAutoCompletion.get(rSyntaxTextArea);
    }

    @Override
    public ListCellRenderer getDefaultCompletionCellRenderer() {
        return this.renderer;
    }

    @Override
    public boolean getShowDescWindow() {
        return this.showDescWindow;
    }

    protected Set<RSyntaxTextArea> getTextAreas() {
        return this.textAreaToAutoCompletion.keySet();
    }

    protected void installImpl(RSyntaxTextArea rSyntaxTextArea, AutoCompletion autoCompletion) {
        this.textAreaToAutoCompletion.put(rSyntaxTextArea, autoCompletion);
    }

    @Override
    public boolean isAutoActivationEnabled() {
        return this.autoActivationEnabled;
    }

    @Override
    public boolean isAutoCompleteEnabled() {
        return this.autoCompleteEnabled;
    }

    @Override
    public boolean isParameterAssistanceEnabled() {
        return this.parameterAssistanceEnabled;
    }

    @Override
    public void setAutoActivationDelay(int n) {
        if ((n = Math.max(0, n)) != this.autoActivationDelay) {
            this.autoActivationDelay = n;
            for (AutoCompletion autoCompletion : this.textAreaToAutoCompletion.values()) {
                autoCompletion.setAutoActivationDelay(this.autoActivationDelay);
            }
        }
    }

    @Override
    public void setAutoActivationEnabled(boolean bl) {
        if (bl != this.autoActivationEnabled) {
            this.autoActivationEnabled = bl;
            for (AutoCompletion autoCompletion : this.textAreaToAutoCompletion.values()) {
                autoCompletion.setAutoActivationEnabled(bl);
            }
        }
    }

    @Override
    public void setAutoCompleteEnabled(boolean bl) {
        if (bl != this.autoCompleteEnabled) {
            this.autoCompleteEnabled = bl;
            for (AutoCompletion autoCompletion : this.textAreaToAutoCompletion.values()) {
                autoCompletion.setAutoCompleteEnabled(bl);
            }
        }
    }

    @Override
    public void setDefaultCompletionCellRenderer(ListCellRenderer listCellRenderer) {
        if (listCellRenderer == null) {
            listCellRenderer = this.createDefaultCompletionCellRenderer();
        }
        if (listCellRenderer instanceof CompletionCellRenderer && Util.getUseSubstanceRenderers() && UIManager.getLookAndFeel().getClass().getName().contains(".Substance")) {
            CompletionCellRenderer completionCellRenderer = (CompletionCellRenderer)listCellRenderer;
            this.delegateToSubstanceRenderer(completionCellRenderer);
        }
        this.renderer = listCellRenderer;
    }

    @Override
    public void setParameterAssistanceEnabled(boolean bl) {
        if (bl != this.parameterAssistanceEnabled) {
            this.parameterAssistanceEnabled = bl;
            for (AutoCompletion autoCompletion : this.textAreaToAutoCompletion.values()) {
                autoCompletion.setParameterAssistanceEnabled(bl);
            }
        }
    }

    @Override
    public void setShowDescWindow(boolean bl) {
        if (bl != this.showDescWindow) {
            this.showDescWindow = bl;
            for (AutoCompletion autoCompletion : this.textAreaToAutoCompletion.values()) {
                autoCompletion.setShowDescWindow(bl);
            }
        }
    }

    protected void uninstallImpl(RSyntaxTextArea rSyntaxTextArea) {
        AutoCompletion autoCompletion = this.getAutoCompletionFor(rSyntaxTextArea);
        if (autoCompletion != null) {
            autoCompletion.uninstall();
        }
        this.textAreaToAutoCompletion.remove(rSyntaxTextArea);
    }
}

