/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class OpenHashMap<K, V>
implements Serializable,
Cloneable,
SortedMap<K, V> {
    private static final long serialVersionUID = 0L;
    protected transient Object[] key;
    protected transient Object[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;
    protected transient int n;
    protected transient int maxFill;
    protected int size;
    protected final float f;
    protected V defRetValue;
    protected transient Iterable<Map.Entry<K, V>> fast;
    protected transient SortedSet<Map.Entry<K, V>> entries;
    protected transient SortedSet<K> keys;
    protected transient Collection<V> values;

    public OpenHashMap(int n, float f) {
        if (f > 0.0f && f <= 1.0f) {
            if (n < 0) {
                throw new IllegalArgumentException("The expected number of elements must be nonnegative");
            }
        } else {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        this.f = f;
        this.n = OpenHashMap.arraySize(n, f);
        this.mask = this.n - 1;
        this.maxFill = OpenHashMap.maxFill(this.n, f);
        this.key = new Object[this.n + 1];
        this.value = new Object[this.n + 1];
        this.link = new long[this.n + 1];
    }

    public OpenHashMap(int n) {
        this(n, 0.75f);
    }

    public OpenHashMap() {
        this(16, 0.75f);
    }

    public OpenHashMap(Map<? extends K, ? extends V> map, float f) {
        this(map.size(), f);
        this.putAll(map);
    }

    public OpenHashMap(Map<? extends K, ? extends V> map) {
        this(map, 0.75f);
    }

    public OpenHashMap(K[] KArray, V[] VArray, float f) {
        this(KArray.length, f);
        if (KArray.length != VArray.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + KArray.length + " and " + VArray.length + ")");
        }
        int n = 0;
        while (n < KArray.length) {
            this.put(KArray[n], VArray[n]);
            ++n;
        }
    }

    public OpenHashMap(K[] KArray, V[] VArray) {
        this(KArray, VArray, 0.75f);
    }

    public void defaultReturnValue(V v) {
        this.defRetValue = v;
    }

    public V defaultReturnValue() {
        return this.defRetValue;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        int n = map.size();
        if (this.size() != n) {
            return false;
        }
        Iterator<Map.Entry<K, V>> iterator = this.fast().iterator();
        while (n-- > 0) {
            Map.Entry<K, V> entry = iterator.next();
            K k = entry.getKey();
            V v = entry.getValue();
            Object v2 = map.get(k);
            if (!(v == null ? v2 != null : !v.equals(v2))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<K, V>> iterator = this.fast().iterator();
        int n = this.size();
        boolean bl = true;
        stringBuilder.append("{");
        while (n-- != 0) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            Map.Entry<K, V> entry = iterator.next();
            if (this == entry.getKey()) {
                stringBuilder.append("(this map)");
            } else {
                stringBuilder.append(String.valueOf(entry.getKey()));
            }
            stringBuilder.append("=>");
            if (this == entry.getValue()) {
                stringBuilder.append("(this map)");
                continue;
            }
            stringBuilder.append(String.valueOf(entry.getValue()));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    private void ensureCapacity(int n) {
        int n2 = OpenHashMap.arraySize(n, this.f);
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    private void tryCapacity(long l) {
        int n = (int)Math.min(0x40000000L, Math.max(2L, OpenHashMap.nextPowerOfTwo((long)Math.ceil((float)l / this.f))));
        if (n > this.n) {
            this.rehash(n);
        }
    }

    private V removeEntry(int n) {
        Object object = this.value[n];
        this.value[n] = null;
        --this.size;
        this.fixPointers(n);
        this.shiftKeys(n);
        if (this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return (V)object;
    }

    private V removeNullEntry() {
        this.containsNullKey = false;
        Object object = this.value[this.n];
        this.value[this.n] = null;
        --this.size;
        this.fixPointers(this.n);
        if (this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return (V)object;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(map.size());
        } else {
            this.tryCapacity(this.size() + map.size());
        }
        int n = map.size();
        if (map instanceof OpenHashMap) {
            Iterator<Map.Entry<K, V>> iterator = ((OpenHashMap)map).fast().iterator();
            while (n-- != 0) {
                Map.Entry<K, V> entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        } else {
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<K, V> entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int insert(K var1_1, V var2_2) {
        block6: {
            block7: {
                block5: {
                    if (var1_1 != null) break block5;
                    if (this.containsNullKey) {
                        return this.n;
                    }
                    this.containsNullKey = true;
                    var3_3 = this.n;
                    break block6;
                }
                var4_4 = this.key;
                var3_3 = OpenHashMap.mix(var1_1.hashCode()) & this.mask;
                var5_5 = var4_4[var3_3];
                if (var5_5 == null) break block7;
                if (!var5_5.equals(var1_1)) ** GOTO lbl16
                return var3_3;
lbl-1000:
                // 1 sources

                {
                    if (!var5_5.equals(var1_1)) continue;
                    return var3_3;
lbl16:
                    // 2 sources

                    ** while ((var5_5 = var4_4[var3_3 = var3_3 + 1 & this.mask]) != null)
                }
            }
            var4_4[var3_3] = var1_1;
        }
        this.value[var3_3] = var2_2;
        if (this.size == 0) {
            this.first = this.last = var3_3;
            this.link[var3_3] = -1L;
        } else {
            v0 = this.last;
            this.link[v0] = this.link[v0] ^ (this.link[this.last] ^ (long)var3_3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[var3_3] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = var3_3;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(OpenHashMap.arraySize(this.size + 1, this.f));
        }
        return -1;
    }

    @Override
    public V put(K k, V v) {
        int n = this.insert(k, v);
        if (n < 0) {
            return this.defRetValue;
        }
        Object object = this.value[n];
        this.value[n] = v;
        return (V)object;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public V getOrCompute(K var1_1) {
        block6: {
            block7: {
                block5: {
                    if (var1_1 != null) break block5;
                    if (this.containsNullKey) {
                        return (V)this.value[this.n];
                    }
                    this.containsNullKey = true;
                    var2_2 = this.n;
                    break block6;
                }
                var3_3 /* !! */  = this.key;
                var2_2 = OpenHashMap.mix(var1_1.hashCode()) & this.mask;
                var4_4 = var3_3 /* !! */ [var2_2];
                if (var4_4 == null) break block7;
                if (!var4_4.equals(var1_1)) ** GOTO lbl16
                return (V)this.value[var2_2];
lbl-1000:
                // 1 sources

                {
                    if (!var4_4.equals(var1_1)) continue;
                    return (V)this.value[var2_2];
lbl16:
                    // 2 sources

                    ** while ((var4_4 = var3_3 /* !! */ [var2_2 = var2_2 + 1 & this.mask]) != null)
                }
            }
            var3_3 /* !! */ [var2_2] = var1_1;
        }
        var3_3 /* !! */  = this.compute(var1_1);
        this.value[var2_2] = var3_3 /* !! */ ;
        if (this.size == 0) {
            this.first = this.last = var2_2;
            this.link[var2_2] = -1L;
        } else {
            v0 = this.last;
            this.link[v0] = this.link[v0] ^ (this.link[this.last] ^ (long)var2_2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[var2_2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = var2_2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(OpenHashMap.arraySize(this.size + 1, this.f));
        }
        return (V)var3_3 /* !! */ ;
    }

    protected V compute(K k) {
        throw new UnsupportedOperationException();
    }

    protected final void shiftKeys(int n) {
        Object[] objectArray = this.key;
        block0: while (true) {
            Object object;
            int n2 = n;
            n = n + 1 & this.mask;
            while ((object = objectArray[n]) != null) {
                int n3 = OpenHashMap.mix(object.hashCode()) & this.mask;
                if (!(n2 <= n ? n2 < n3 && n3 <= n : n2 < n3 || n3 <= n)) {
                    objectArray[n2] = object;
                    this.value[n2] = this.value[n];
                    this.fixPointers(n, n2);
                    continue block0;
                }
                n = n + 1 & this.mask;
            }
            break;
        }
        objectArray[n2] = null;
        this.value[n2] = null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public V remove(Object var1_1) {
        if (var1_1 == null) {
            return this.containsNullKey != false ? this.removeNullEntry() : this.defRetValue;
        }
        var2_2 = this.key;
        var4_3 = OpenHashMap.mix(var1_1.hashCode()) & this.mask;
        var3_4 = var2_2[var4_3];
        if (var3_4 == null) {
            return this.defRetValue;
        }
        if (!var1_1.equals(var3_4)) ** GOTO lbl12
        return this.removeEntry(var4_3);
lbl-1000:
        // 1 sources

        {
            if (!var1_1.equals(var3_4)) continue;
            return this.removeEntry(var4_3);
lbl12:
            // 2 sources

            ** while ((var3_4 = var2_2[var4_3 = var4_3 + 1 & this.mask]) != null)
        }
lbl13:
        // 1 sources

        return this.defRetValue;
    }

    private V setValue(int n, V v) {
        Object object = this.value[n];
        this.value[n] = v;
        return (V)object;
    }

    public V removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int n = this.first;
        this.first = (int)this.link[n];
        if (this.first >= 0) {
            int n2 = this.first;
            this.link[n2] = this.link[n2] | 0xFFFFFFFF00000000L;
        }
        --this.size;
        Object object = this.value[n];
        if (n == this.n) {
            this.containsNullKey = false;
            this.value[this.n] = null;
        } else {
            this.shiftKeys(n);
        }
        if (this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return (V)object;
    }

    public V removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int n = this.last;
        this.last = (int)(this.link[n] >>> 32);
        if (this.last >= 0) {
            int n2 = this.last;
            this.link[n2] = this.link[n2] | 0xFFFFFFFFL;
        }
        --this.size;
        Object object = this.value[n];
        if (n == this.n) {
            this.containsNullKey = false;
            this.value[this.n] = null;
        } else {
            this.shiftKeys(n);
        }
        if (this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return (V)object;
    }

    private void moveIndexToFirst(int n) {
        if (this.size != 1 && this.first != n) {
            if (this.last == n) {
                int n2 = this.last = (int)(this.link[n] >>> 32);
                this.link[n2] = this.link[n2] | 0xFFFFFFFFL;
            } else {
                long l = this.link[n];
                int n3 = (int)(l >>> 32);
                int n4 = (int)l;
                int n5 = n3;
                this.link[n5] = this.link[n5] ^ (this.link[n3] ^ l & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n6 = n4;
                this.link[n6] = this.link[n6] ^ (this.link[n4] ^ l & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
            }
            int n7 = this.first;
            this.link[n7] = this.link[n7] ^ (this.link[this.first] ^ ((long)n & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[n] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
            this.first = n;
        }
    }

    private void moveIndexToLast(int n) {
        if (this.size != 1 && this.last != n) {
            if (this.first == n) {
                int n2 = this.first = (int)this.link[n];
                this.link[n2] = this.link[n2] | 0xFFFFFFFF00000000L;
            } else {
                long l = this.link[n];
                int n3 = (int)(l >>> 32);
                int n4 = (int)l;
                int n5 = n3;
                this.link[n5] = this.link[n5] ^ (this.link[n3] ^ l & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n6 = n4;
                this.link[n6] = this.link[n6] ^ (this.link[n4] ^ l & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
            }
            int n7 = this.last;
            this.link[n7] = this.link[n7] ^ (this.link[this.last] ^ (long)n & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public V getAndMoveToFirst(K var1_1) {
        if (var1_1 == null) {
            if (this.containsNullKey) {
                this.moveIndexToFirst(this.n);
                return (V)this.value[this.n];
            }
            return this.defRetValue;
        }
        var2_2 = this.key;
        var4_3 = OpenHashMap.mix(var1_1.hashCode()) & this.mask;
        var3_4 = var2_2[var4_3];
        if (var3_4 == null) {
            return this.defRetValue;
        }
        if (!var1_1.equals(var3_4)) ** GOTO lbl17
        this.moveIndexToFirst(var4_3);
        return (V)this.value[var4_3];
lbl-1000:
        // 1 sources

        {
            if (!var1_1.equals(var3_4)) continue;
            this.moveIndexToFirst(var4_3);
            return (V)this.value[var4_3];
lbl17:
            // 2 sources

            ** while ((var3_4 = var2_2[var4_3 = var4_3 + 1 & this.mask]) != null)
        }
lbl18:
        // 1 sources

        return this.defRetValue;
    }

    /*
     * Unable to fully structure code
     */
    public V getAndMoveToLast(K var1_1) {
        if (var1_1 == null) {
            if (this.containsNullKey) {
                this.moveIndexToLast(this.n);
                return (V)this.value[this.n];
            }
            return this.defRetValue;
        }
        var2_2 = this.key;
        var4_3 = OpenHashMap.mix(var1_1.hashCode()) & this.mask;
        var3_4 = var2_2[var4_3];
        if (var3_4 == null) {
            return this.defRetValue;
        }
        if (!var1_1.equals(var3_4)) ** GOTO lbl17
        this.moveIndexToLast(var4_3);
        return (V)this.value[var4_3];
lbl-1000:
        // 1 sources

        {
            if (!var1_1.equals(var3_4)) continue;
            this.moveIndexToLast(var4_3);
            return (V)this.value[var4_3];
lbl17:
            // 2 sources

            ** while ((var3_4 = var2_2[var4_3 = var4_3 + 1 & this.mask]) != null)
        }
lbl18:
        // 1 sources

        return this.defRetValue;
    }

    /*
     * Unable to fully structure code
     */
    public V putAndMoveToFirst(K var1_1, V var2_2) {
        block6: {
            block7: {
                block5: {
                    if (var1_1 != null) break block5;
                    if (this.containsNullKey) {
                        this.moveIndexToFirst(this.n);
                        return this.setValue(this.n, var2_2);
                    }
                    this.containsNullKey = true;
                    var3_3 = this.n;
                    break block6;
                }
                var4_4 = this.key;
                var3_3 = OpenHashMap.mix(var1_1.hashCode()) & this.mask;
                var5_5 = var4_4[var3_3];
                if (var5_5 == null) break block7;
                if (!var5_5.equals(var1_1)) ** GOTO lbl19
                this.moveIndexToFirst(var3_3);
                return this.setValue(var3_3, var2_2);
lbl-1000:
                // 1 sources

                {
                    if (!var5_5.equals(var1_1)) continue;
                    this.moveIndexToFirst(var3_3);
                    return this.setValue(var3_3, var2_2);
lbl19:
                    // 2 sources

                    ** while ((var5_5 = var4_4[var3_3 = var3_3 + 1 & this.mask]) != null)
                }
            }
            var4_4[var3_3] = var1_1;
        }
        this.value[var3_3] = var2_2;
        if (this.size == 0) {
            this.first = this.last = var3_3;
            this.link[var3_3] = -1L;
        } else {
            v0 = this.first;
            this.link[v0] = this.link[v0] ^ (this.link[this.first] ^ ((long)var3_3 & 0xFFFFFFFFL) << 32) & -4294967296L;
            this.link[var3_3] = -4294967296L | (long)this.first & 0xFFFFFFFFL;
            this.first = var3_3;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(OpenHashMap.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    /*
     * Unable to fully structure code
     */
    public V putAndMoveToLast(K var1_1, V var2_2) {
        block6: {
            block7: {
                block5: {
                    if (var1_1 != null) break block5;
                    if (this.containsNullKey) {
                        this.moveIndexToLast(this.n);
                        return this.setValue(this.n, var2_2);
                    }
                    this.containsNullKey = true;
                    var3_3 = this.n;
                    break block6;
                }
                var4_4 = this.key;
                var3_3 = OpenHashMap.mix(var1_1.hashCode()) & this.mask;
                var5_5 = var4_4[var3_3];
                if (var5_5 == null) break block7;
                if (!var5_5.equals(var1_1)) ** GOTO lbl19
                this.moveIndexToLast(var3_3);
                return this.setValue(var3_3, var2_2);
lbl-1000:
                // 1 sources

                {
                    if (!var5_5.equals(var1_1)) continue;
                    this.moveIndexToLast(var3_3);
                    return this.setValue(var3_3, var2_2);
lbl19:
                    // 2 sources

                    ** while ((var5_5 = var4_4[var3_3 = var3_3 + 1 & this.mask]) != null)
                }
            }
            var4_4[var3_3] = var1_1;
        }
        this.value[var3_3] = var2_2;
        if (this.size == 0) {
            this.first = this.last = var3_3;
            this.link[var3_3] = -1L;
        } else {
            v0 = this.last;
            this.link[v0] = this.link[v0] ^ (this.link[this.last] ^ (long)var3_3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[var3_3] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = var3_3;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(OpenHashMap.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return (V)(this.containsNullKey ? this.value[this.n] : this.defRetValue);
        }
        Object[] objectArray = this.key;
        int n = OpenHashMap.mix(object.hashCode()) & this.mask;
        Object object2 = objectArray[n];
        if (object2 == null) {
            return this.defRetValue;
        }
        if (object.equals(object2)) {
            return (V)this.value[n];
        }
        do {
            if ((object2 = objectArray[n = n + 1 & this.mask]) != null) continue;
            return this.defRetValue;
        } while (!object.equals(object2));
        return (V)this.value[n];
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean containsKey(Object var1_1) {
        if (var1_1 == null) {
            return this.containsNullKey;
        }
        var2_2 = this.key;
        var4_3 = OpenHashMap.mix(var1_1.hashCode()) & this.mask;
        var3_4 = var2_2[var4_3];
        if (var3_4 == null) {
            return false;
        }
        if (!var1_1.equals(var3_4)) ** GOTO lbl12
        return true;
lbl-1000:
        // 1 sources

        {
            if (!var1_1.equals(var3_4)) continue;
            return true;
lbl12:
            // 2 sources

            ** while ((var3_4 = var2_2[var4_3 = var4_3 + 1 & this.mask]) != null)
        }
lbl13:
        // 1 sources

        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        Object[] objectArray = this.value;
        Object[] objectArray2 = this.key;
        if (this.containsNullKey && objectArray[this.n] == null && object == null || objectArray[this.n].equals(object)) {
            return true;
        }
        int n = this.n;
        while (n-- != 0) {
            if ((objectArray2[n] == null || objectArray[n] != null || object != null) && !objectArray[n].equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            this.size = 0;
            this.containsNullKey = false;
            Arrays.fill(this.key, null);
            Arrays.fill(this.value, null);
            this.last = -1;
            this.first = -1;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    protected void fixPointers(int n) {
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
        } else if (this.first == n) {
            this.first = (int)this.link[n];
            if (this.first >= 0) {
                int n2 = this.first;
                this.link[n2] = this.link[n2] | 0xFFFFFFFF00000000L;
            }
        } else if (this.last == n) {
            this.last = (int)(this.link[n] >>> 32);
            if (this.last >= 0) {
                int n3 = this.last;
                this.link[n3] = this.link[n3] | 0xFFFFFFFFL;
            }
        } else {
            long l = this.link[n];
            int n4 = (int)(l >>> 32);
            int n5 = (int)l;
            int n6 = n4;
            this.link[n6] = this.link[n6] ^ (this.link[n4] ^ l & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n7 = n5;
            this.link[n7] = this.link[n7] ^ (this.link[n5] ^ l & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
    }

    protected void fixPointers(int n, int n2) {
        if (this.size == 1) {
            this.first = this.last = n2;
            this.link[n2] = -1L;
        } else if (this.first == n) {
            this.first = n2;
            int n3 = (int)this.link[n];
            this.link[n3] = this.link[n3] ^ (this.link[(int)this.link[n]] ^ ((long)n2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[n2] = this.link[n];
        } else if (this.last == n) {
            this.last = n2;
            int n4 = (int)(this.link[n] >>> 32);
            this.link[n4] = this.link[n4] ^ (this.link[(int)(this.link[n] >>> 32)] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n2] = this.link[n];
        } else {
            long l = this.link[n];
            int n5 = (int)(l >>> 32);
            int n6 = (int)l;
            int n7 = n5;
            this.link[n7] = this.link[n7] ^ (this.link[n5] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n8 = n6;
            this.link[n8] = this.link[n8] ^ (this.link[n6] ^ ((long)n2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[n2] = l;
        }
    }

    @Override
    public K firstKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return (K)this.key[this.first];
    }

    @Override
    public K lastKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return (K)this.key[this.last];
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public SortedMap<K, V> tailMap(K k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedMap<K, V> headMap(K k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedMap<K, V> subMap(K k, K k2) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Map.Entry<K, V>> fast() {
        if (this.fast == null) {
            this.fast = new Iterable<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new FastEntryIterator();
                }
            };
        }
        return this.fast;
    }

    @Override
    public SortedSet<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public SortedSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractObjectCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return OpenHashMap.this.size;
                }

                @Override
                public boolean contains(Object object) {
                    return OpenHashMap.this.containsValue(object);
                }

                @Override
                public void clear() {
                    OpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean trim() {
        int n = OpenHashMap.arraySize(this.size, this.f);
        if (n >= this.n) {
            return true;
        }
        try {
            this.rehash(n);
            return true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
    }

    public boolean trim(int n) {
        int n2 = OpenHashMap.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (n <= n2) {
            return true;
        }
        try {
            this.rehash(n2);
            return true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
    }

    protected void rehash(int n) {
        Object[] objectArray = this.key;
        Object[] objectArray2 = this.value;
        int n2 = n - 1;
        Object[] objectArray3 = new Object[n + 1];
        Object[] objectArray4 = new Object[n + 1];
        int n3 = this.first;
        int n4 = -1;
        int n5 = -1;
        long[] lArray = this.link;
        long[] lArray2 = new long[n + 1];
        this.first = -1;
        int n6 = this.size;
        while (n6-- != 0) {
            int n7;
            if (objectArray[n3] == null) {
                n7 = n;
            } else {
                n7 = OpenHashMap.mix(objectArray[n3].hashCode()) & n2;
                while (objectArray3[n7] != null) {
                    n7 = n7 + 1 & n2;
                }
                objectArray3[n7] = objectArray[n3];
            }
            objectArray4[n7] = objectArray2[n3];
            if (n4 != -1) {
                int n8 = n5;
                lArray2[n8] = lArray2[n8] ^ (lArray2[n5] ^ (long)n7 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n9 = n7;
                lArray2[n9] = lArray2[n9] ^ (lArray2[n7] ^ ((long)n5 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                n5 = n7;
            } else {
                n5 = this.first = n7;
                lArray2[n7] = -1L;
            }
            int n10 = n3;
            n3 = (int)lArray[n3];
            n4 = n10;
        }
        this.link = lArray2;
        this.last = n5;
        if (n5 != -1) {
            int n11 = n5;
            lArray2[n11] = lArray2[n11] | 0xFFFFFFFFL;
        }
        this.n = n;
        this.mask = n2;
        this.maxFill = OpenHashMap.maxFill(this.n, this.f);
        this.key = objectArray3;
        this.value = objectArray4;
    }

    public OpenHashMap<K, V> clone() {
        OpenHashMap openHashMap;
        try {
            openHashMap = (OpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        openHashMap.fast = null;
        openHashMap.keys = null;
        openHashMap.values = null;
        openHashMap.entries = null;
        openHashMap.containsNullKey = this.containsNullKey;
        openHashMap.key = (Object[])this.key.clone();
        openHashMap.value = (Object[])this.value.clone();
        openHashMap.link = (long[])this.link.clone();
        return openHashMap;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int hashCode() {
        var1_1 = 0;
        var2_2 = this.realSize();
        var3_3 = 0;
        var4_4 = 0;
        ** GOTO lbl15
        {
            ++var3_3;
            do {
                if (this.key[var3_3] == null) continue block0;
                if (this != this.key[var3_3]) {
                    var4_4 = this.key[var3_3].hashCode();
                }
                if (this != this.value[var3_3]) {
                    var4_4 ^= this.value[var3_3] == null ? 0 : this.value[var3_3].hashCode();
                }
                var1_1 += var4_4;
                ++var3_3;
lbl15:
                // 2 sources

            } while (var2_2-- != 0);
        }
        if (this.containsNullKey) {
            var1_1 += this.value[this.n] == null ? 0 : this.value[this.n].hashCode();
        }
        return var1_1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object[] objectArray = this.key;
        Object[] objectArray2 = this.value;
        MapIterator mapIterator = new MapIterator(null, null, null);
        objectOutputStream.defaultWriteObject();
        int n = this.size;
        while (n-- != 0) {
            int n2 = mapIterator.nextEntry();
            objectOutputStream.writeObject(objectArray[n2]);
            objectOutputStream.writeObject(objectArray2[n2]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.n = OpenHashMap.arraySize(this.size, this.f);
        this.maxFill = OpenHashMap.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n + 1];
        Object[] objectArray = this.key;
        this.value = new Object[this.n + 1];
        Object[] objectArray2 = this.value;
        this.link = new long[this.n + 1];
        long[] lArray = this.link;
        int n = -1;
        this.last = -1;
        this.first = -1;
        int n2 = this.size;
        while (n2-- != 0) {
            int n3;
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null) {
                n3 = this.n;
                this.containsNullKey = true;
            } else {
                n3 = OpenHashMap.mix(object.hashCode()) & this.mask;
                while (objectArray[n3] != null) {
                    n3 = n3 + 1 & this.mask;
                }
                objectArray[n3] = object;
            }
            objectArray2[n3] = object2;
            if (this.first != -1) {
                int n4 = n;
                lArray[n4] = lArray[n4] ^ (lArray[n] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n5 = n3;
                lArray[n5] = lArray[n5] ^ (lArray[n3] ^ ((long)n & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                n = n3;
                continue;
            }
            n = this.first = n3;
            int n6 = n3;
            lArray[n6] = lArray[n6] | 0xFFFFFFFF00000000L;
        }
        this.last = n;
        if (n != -1) {
            int n7 = n;
            lArray[n7] = lArray[n7] | 0xFFFFFFFFL;
        }
    }

    private void checkTable() {
    }

    private static int arraySize(int n, float f) {
        long l = Math.max(2L, OpenHashMap.nextPowerOfTwo((long)Math.ceil((float)n / f)));
        if (l > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + n + " expected elements with load factor " + f + ")");
        }
        return (int)l;
    }

    private static int maxFill(int n, float f) {
        return Math.min((int)Math.ceil((float)n * f), n - 1);
    }

    private static int nextPowerOfTwo(int n) {
        if (n == 0) {
            return 1;
        }
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        return (n | n >> 16) + 1;
    }

    private static long nextPowerOfTwo(long l) {
        if (l == 0L) {
            return 1L;
        }
        --l;
        l |= l >> 1;
        l |= l >> 2;
        l |= l >> 4;
        l |= l >> 8;
        l |= l >> 16;
        return (l | l >> 32) + 1L;
    }

    private static int mix(int n) {
        int n2 = n * -1640531527;
        return n2 ^ n2 >>> 16;
    }

    private static <K> int unwrap(Iterator<? extends K> iterator, K[] KArray, int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + n2 + ") is negative");
        }
        if (n >= 0 && n + n2 <= KArray.length) {
            int n3 = n2;
            while (n3-- != 0 && iterator.hasNext()) {
                KArray[n++] = iterator.next();
            }
            return n2 - n3 - 1;
        }
        throw new IllegalArgumentException();
    }

    private static <K> int unwrap(Iterator<? extends K> iterator, K[] KArray) {
        return OpenHashMap.unwrap(iterator, KArray, 0, KArray.length);
    }

    public static abstract class AbstractObjectCollection<K>
    extends AbstractCollection<K> {
        protected AbstractObjectCollection() {
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            OpenHashMap.unwrap(this.iterator(), objectArray);
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            if (objectArray.length < this.size()) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size());
            }
            OpenHashMap.unwrap(this.iterator(), objectArray);
            return objectArray;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            boolean bl = false;
            Iterator<K> iterator = collection.iterator();
            int n = collection.size();
            while (n-- != 0) {
                if (!this.add(iterator.next())) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean add(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            int n = collection.size();
            Iterator<?> iterator = collection.iterator();
            do {
                if (n-- != 0) continue;
                return true;
            } while (this.contains(iterator.next()));
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            int n = this.size();
            Iterator iterator = this.iterator();
            while (n-- != 0) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            int n = collection.size();
            Iterator<?> iterator = collection.iterator();
            while (n-- != 0) {
                if (!this.remove(iterator.next())) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.iterator();
            int n = this.size();
            boolean bl = true;
            stringBuilder.append("{");
            while (n-- != 0) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                Object e = iterator.next();
                if (this == e) {
                    stringBuilder.append("(this collection)");
                    continue;
                }
                stringBuilder.append(String.valueOf(e));
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    public static abstract class AbstractObjectSet<K>
    extends AbstractObjectCollection<K>
    implements Cloneable {
        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Set)) {
                return false;
            }
            Set set = (Set)object;
            return set.size() == this.size() && this.containsAll(set);
        }

        @Override
        public int hashCode() {
            int n = 0;
            int n2 = this.size();
            Iterator iterator = this.iterator();
            while (n2-- != 0) {
                Object e = iterator.next();
                n += e == null ? 0 : e.hashCode();
            }
            return n;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements Iterator<Map.Entry<K, V>> {
        private MapEntry entry;

        public EntryIterator() {
        }

        public EntryIterator(Object object) {
            super(object);
        }

        @Override
        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        public MapEntry previous() {
            this.entry = new MapEntry(this.previousEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }

        public void set(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        public void add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements Iterator<Map.Entry<K, V>> {
        final MapEntry entry;

        public FastEntryIterator() {
            this.entry = new MapEntry();
        }

        public FastEntryIterator(Object object) {
            super(object);
            this.entry = new MapEntry();
        }

        @Override
        public MapEntry next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }

        public MapEntry previous() {
            this.entry.index = this.previousEntry();
            return this.entry;
        }

        public void set(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        public void add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements Iterator<K> {
        public KeyIterator(Object object) {
            super(object);
        }

        public K previous() {
            return OpenHashMap.this.key[this.previousEntry()];
        }

        public void set(K k) {
            throw new UnsupportedOperationException();
        }

        public void add(K k) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public K next() {
            return OpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractObjectSet<K>
    implements SortedSet<K> {
        private KeySet() {
        }

        public Iterator<K> iterator(K k) {
            return new KeyIterator(k);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return OpenHashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return OpenHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            int n = OpenHashMap.this.size;
            OpenHashMap.this.remove(object);
            return OpenHashMap.this.size != n;
        }

        @Override
        public void clear() {
            OpenHashMap.this.clear();
        }

        @Override
        public K first() {
            if (OpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return OpenHashMap.this.key[OpenHashMap.this.first];
        }

        @Override
        public K last() {
            if (OpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return OpenHashMap.this.key[OpenHashMap.this.last];
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public final SortedSet<K> tailSet(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final SortedSet<K> headSet(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final SortedSet<K> subSet(K k, K k2) {
            throw new UnsupportedOperationException();
        }
    }

    final class MapEntry
    implements Map.Entry<K, V> {
        int index;

        MapEntry(int n) {
            this.index = n;
        }

        MapEntry() {
        }

        @Override
        public K getKey() {
            return OpenHashMap.this.key[this.index];
        }

        @Override
        public V getValue() {
            return OpenHashMap.this.value[this.index];
        }

        @Override
        public V setValue(V v) {
            Object object = OpenHashMap.this.value[this.index];
            OpenHashMap.this.value[this.index] = v;
            return object;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (OpenHashMap.this.key[this.index] == null ? entry.getKey() != null : !OpenHashMap.this.key[this.index].equals(entry.getKey())) {
                return false;
            }
            return !(OpenHashMap.this.value[this.index] == null ? entry.getValue() != null : !OpenHashMap.this.value[this.index].equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return (OpenHashMap.this.key[this.index] == null ? 0 : OpenHashMap.this.key[this.index].hashCode()) ^ (OpenHashMap.this.value[this.index] == null ? 0 : OpenHashMap.this.value[this.index].hashCode());
        }

        public String toString() {
            return OpenHashMap.this.key[this.index] + "=>" + OpenHashMap.this.value[this.index];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Map.Entry<K, V>>
    implements SortedSet<Map.Entry<K, V>> {
        private MapEntrySet() {
        }

        public EntryIterator iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Map.Entry<K, V>> comparator() {
            return null;
        }

        @Override
        public SortedSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> entry, Map.Entry<K, V> entry2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> first() {
            if (OpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(OpenHashMap.this.first);
        }

        @Override
        public Map.Entry<K, V> last() {
            if (OpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(OpenHashMap.this.last);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean contains(Object var1_1) {
            if (!(var1_1 instanceof Map.Entry)) {
                return false;
            }
            var2_2 = (Map.Entry)var1_1;
            var3_3 = var2_2.getKey();
            if (var3_3 == null) {
                if (OpenHashMap.this.containsNullKey) {
                    return !(OpenHashMap.this.value[OpenHashMap.this.n] == null ? var2_2.getValue() != null : OpenHashMap.this.value[OpenHashMap.this.n].equals(var2_2.getValue()) == false);
                }
                return false;
            }
            var4_4 = OpenHashMap.this.key;
            var6_5 = OpenHashMap.access$3(var3_3.hashCode()) & OpenHashMap.this.mask;
            var5_6 = var4_4[var6_5];
            if (var5_6 == null) {
                return false;
            }
            if (!var3_3.equals(var5_6)) ** GOTO lbl18
            return OpenHashMap.this.value[var6_5] == null ? var2_2.getValue() == null : OpenHashMap.this.value[var6_5].equals(var2_2.getValue());
lbl-1000:
            // 1 sources

            {
                if (!var3_3.equals(var5_6)) continue;
                return OpenHashMap.this.value[var6_5] == null ? var2_2.getValue() == null : OpenHashMap.this.value[var6_5].equals(var2_2.getValue());
lbl18:
                // 2 sources

                ** while ((var5_6 = var4_4[var6_5 = var6_5 + 1 & OpenHashMap.this.mask]) != null)
            }
lbl19:
            // 1 sources

            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (k == null) {
                if (OpenHashMap.this.containsNullKey) {
                    if (OpenHashMap.this.value[OpenHashMap.this.n] == null ? v != null : !OpenHashMap.this.value[OpenHashMap.this.n].equals(v)) {
                        return false;
                    }
                    OpenHashMap.this.removeNullEntry();
                    return true;
                }
                return false;
            }
            Object[] objectArray = OpenHashMap.this.key;
            int n = OpenHashMap.mix(k.hashCode()) & OpenHashMap.this.mask;
            Object object2 = objectArray[n];
            if (object2 == null) {
                return false;
            }
            if (object2.equals(k)) {
                if (OpenHashMap.this.value[n] == null ? v != null : !OpenHashMap.this.value[n].equals(v)) {
                    return false;
                }
                OpenHashMap.this.removeEntry(n);
                return true;
            }
            do {
                if ((object2 = objectArray[n = n + 1 & OpenHashMap.this.mask]) != null) continue;
                return false;
            } while (!object2.equals(k) || !(OpenHashMap.this.value[n] == null ? v == null : OpenHashMap.this.value[n].equals(v)));
            OpenHashMap.this.removeEntry(n);
            return true;
        }

        @Override
        public int size() {
            return OpenHashMap.this.size;
        }

        @Override
        public void clear() {
            OpenHashMap.this.clear();
        }

        public EntryIterator iterator(Map.Entry<K, V> entry) {
            return new EntryIterator(entry.getKey());
        }

        public FastEntryIterator fastIterator() {
            return new FastEntryIterator();
        }

        public FastEntryIterator fastIterator(Map.Entry<K, V> entry) {
            return new FastEntryIterator(entry.getKey());
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = -1;

        private MapIterator() {
            this.next = OpenHashMap.this.first;
            this.index = 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private MapIterator(Object object) {
            if (object == null) {
                if (!OpenHashMap.this.containsNullKey) throw new NoSuchElementException("The key " + object + " does not belong to this map.");
                this.next = (int)OpenHashMap.this.link[OpenHashMap.this.n];
                this.prev = OpenHashMap.this.n;
                return;
            } else if (OpenHashMap.this.key[OpenHashMap.this.last] == null ? object == null : OpenHashMap.this.key[OpenHashMap.this.last].equals(object)) {
                this.prev = OpenHashMap.this.last;
                this.index = OpenHashMap.this.size;
                return;
            } else {
                int n = OpenHashMap.mix(object.hashCode()) & OpenHashMap.this.mask;
                while (OpenHashMap.this.key[n] != null) {
                    if (OpenHashMap.this.key[n].equals(object)) {
                        this.next = (int)OpenHashMap.this.link[n];
                        this.prev = n;
                        return;
                    }
                    n = n + 1 & OpenHashMap.this.mask;
                }
                throw new NoSuchElementException("The key " + object + " does not belong to this map.");
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        private void ensureIndexKnown() {
            if (this.index < 0) {
                if (this.prev == -1) {
                    this.index = 0;
                } else if (this.next == -1) {
                    this.index = OpenHashMap.this.size;
                } else {
                    int n = OpenHashMap.this.first;
                    this.index = 1;
                    while (n != this.prev) {
                        n = (int)OpenHashMap.this.link[n];
                        ++this.index;
                    }
                }
            }
        }

        public int nextIndex() {
            this.ensureIndexKnown();
            return this.index;
        }

        public int previousIndex() {
            this.ensureIndexKnown();
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = (int)OpenHashMap.this.link[this.curr];
            this.prev = this.curr;
            if (this.index >= 0) {
                ++this.index;
            }
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = (int)(OpenHashMap.this.link[this.curr] >>> 32);
            this.next = this.curr;
            if (this.index >= 0) {
                --this.index;
            }
            return this.curr;
        }

        public void remove() {
            this.ensureIndexKnown();
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = (int)(OpenHashMap.this.link[this.curr] >>> 32);
            } else {
                this.next = (int)OpenHashMap.this.link[this.curr];
            }
            --OpenHashMap.this.size;
            if (this.prev == -1) {
                OpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                OpenHashMap.this.link[n] = OpenHashMap.this.link[n] ^ (OpenHashMap.this.link[this.prev] ^ (long)this.next & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.next == -1) {
                OpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                OpenHashMap.this.link[n] = OpenHashMap.this.link[n] ^ (OpenHashMap.this.link[this.next] ^ ((long)this.prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int n = this.curr;
            this.curr = -1;
            if (n != OpenHashMap.this.n) {
                Object[] objectArray = OpenHashMap.this.key;
                while (true) {
                    Object object;
                    int n2 = n;
                    n = n2 + 1 & OpenHashMap.this.mask;
                    while (true) {
                        if ((object = objectArray[n]) == null) {
                            objectArray[n2] = null;
                            OpenHashMap.this.value[n2] = null;
                            return;
                        }
                        int n3 = OpenHashMap.mix(object.hashCode()) & OpenHashMap.this.mask;
                        if (n2 <= n ? n2 >= n3 || n3 > n : n2 >= n3 && n3 > n) break;
                        n = n + 1 & OpenHashMap.this.mask;
                    }
                    objectArray[n2] = object;
                    OpenHashMap.this.value[n2] = OpenHashMap.this.value[n];
                    if (this.next == n) {
                        this.next = n2;
                    }
                    if (this.prev == n) {
                        this.prev = n2;
                    }
                    OpenHashMap.this.fixPointers(n, n2);
                }
            }
            OpenHashMap.this.containsNullKey = false;
            OpenHashMap.this.value[OpenHashMap.this.n] = null;
        }

        public int skip(int n) {
            int n2 = n;
            while (n2-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - n2 - 1;
        }

        public int back(int n) {
            int n2 = n;
            while (n2-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - n2 - 1;
        }

        /* synthetic */ MapIterator(Object object, MapIterator mapIterator, MapIterator mapIterator2) {
            this(object);
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements Iterator<V> {
        public V previous() {
            return OpenHashMap.this.value[this.previousEntry()];
        }

        public void set(V v) {
            throw new UnsupportedOperationException();
        }

        public void add(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V next() {
            return OpenHashMap.this.value[this.nextEntry()];
        }
    }
}

