/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class CopyOnWriteSet<E>
implements Set<E>,
Cloneable {
    Object[] data;

    public CopyOnWriteSet() {
        this.data = new Object[0];
    }

    public CopyOnWriteSet(CopyOnWriteSet<? extends E> copyOnWriteSet) {
        this.data = copyOnWriteSet.data;
    }

    public CopyOnWriteSet(Collection<? extends E> collection) {
        this.data = collection.toArray(new Object[collection.size()]);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < CopyOnWriteSet.this.data.length;
            }

            @Override
            public E next() {
                return CopyOnWriteSet.this.data[this.idx++];
            }

            @Override
            public void remove() {
                CopyOnWriteSet.this.remove(--this.idx);
            }
        };
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public boolean add(E e) {
        Object[] objectArray = this.data;
        if (objectArray.length == 0) {
            this.data = new Object[]{e};
        } else {
            Object[] objectArray2;
            Object[] objectArray3 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                objectArray2 = objectArray3[n2];
                if (objectArray2 == null ? e == null : objectArray2.equals(e)) {
                    return false;
                }
                ++n2;
            }
            objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray.length] = e;
            this.data = objectArray2;
        }
        return true;
    }

    private void remove(int n) {
        Object[] objectArray = this.data;
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n2 - 1];
        int n3 = n2 - n - 1;
        if (n > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        if (n3 > 0) {
            System.arraycopy(objectArray, n + 1, objectArray2, n, n3);
        }
        this.data = objectArray2;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.data.clone();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = this.data.length;
        if (TArray.length < n) {
            return CopyOnWriteSet.copyOf(this.data, n, TArray.getClass());
        }
        System.arraycopy(this.data, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CopyOnWriteSet)) {
            return false;
        }
        Object[] objectArray = this.data;
        Object[] objectArray2 = ((CopyOnWriteSet)object).data;
        if (objectArray == objectArray2) {
            return true;
        }
        int n = objectArray.length;
        if (n != objectArray2.length) {
            return false;
        }
        int n2 = n;
        block0: while (n2-- > 0) {
            Object object2 = objectArray[n2];
            int n3 = n;
            while (n3-- > 0) {
                Object object3 = objectArray2[n3];
                if (object2 == object3 || object2 != null && object2.equals(object3)) continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public CopyOnWriteSet<E> clone() {
        try {
            return (CopyOnWriteSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            InternalError internalError = new InternalError();
            internalError.initCause(cloneNotSupportedException);
            throw internalError;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        int n = CopyOnWriteSet.indexOf(object, this.data, this.data.length);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    private static int indexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            int n2 = n;
            while (n2-- > 0) {
                if (objectArray[n2] != null) continue;
                return n2;
            }
        } else {
            int n3 = n;
            while (n3-- > 0) {
                if (!object.equals(objectArray[n3])) continue;
                return n3;
            }
        }
        return -1;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        if (objectArray.length == 0) {
            return false;
        }
        Object[] objectArray2 = this.data;
        int n = objectArray2.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            Object object = objectArray[n3];
            if (CopyOnWriteSet.indexOf(object, objectArray2, n) < 0 && CopyOnWriteSet.indexOf(object, objectArray, n2) < 0) {
                objectArray[n2++] = object;
            }
            ++n3;
        }
        if (n2 > 0) {
            Object[] objectArray3 = CopyOnWriteSet.copyOf(objectArray2, n + n2);
            System.arraycopy(objectArray, 0, objectArray3, n, n2);
            this.data = objectArray3;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public static <T> T[] copyOf(T[] TArray, int n) {
        return CopyOnWriteSet.copyOf(TArray, n, TArray.getClass());
    }

    public static <T, U> T[] copyOf(U[] UArray, int n, Class<? extends T[]> clazz) {
        Object[] objectArray = clazz == Object[].class ? new Object[n] : (Object[])Array.newInstance(clazz.getComponentType(), n);
        System.arraycopy(UArray, 0, objectArray, 0, Math.min(UArray.length, n));
        return objectArray;
    }
}

