/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.felix.resolver.util.CopyOnWriteSet;

public class CopyOnWriteList<E>
implements List<E>,
Cloneable {
    Object[] data;

    public CopyOnWriteList() {
        this.data = new Object[0];
    }

    public CopyOnWriteList(CopyOnWriteList<? extends E> copyOnWriteList) {
        this.data = copyOnWriteList.data;
    }

    public CopyOnWriteList(Collection<? extends E> collection) {
        this.data = collection.toArray(new Object[collection.size()]);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public E get(int n) {
        return (E)this.data[n];
    }

    @Override
    public E set(int n, E e) {
        this.data = CopyOnWriteSet.copyOf(this.data, this.data.length);
        Object object = this.data[n];
        this.data[n] = e;
        return (E)object;
    }

    @Override
    public void add(int n, E e) {
        Object[] objectArray = this.data;
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n2 + 1];
        int n3 = n2 - n;
        if (n > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        if (n3 > 0) {
            System.arraycopy(objectArray, n, objectArray2, n + 1, n3);
        }
        objectArray2[n] = e;
        this.data = objectArray2;
    }

    @Override
    public E remove(int n) {
        Object[] objectArray = this.data;
        int n2 = objectArray.length;
        Object object = objectArray[n];
        Object[] objectArray2 = new Object[n2 - 1];
        int n3 = n2 - n - 1;
        if (n > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        if (n3 > 0) {
            System.arraycopy(objectArray, n + 1, objectArray2, n, n3);
        }
        this.data = objectArray2;
        return (E)object;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < CopyOnWriteList.this.data.length;
            }

            @Override
            public E next() {
                return CopyOnWriteList.this.data[this.idx++];
            }

            @Override
            public void remove() {
                CopyOnWriteList.this.remove(--this.idx);
            }
        };
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.data.clone();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = this.data.length;
        if (TArray.length < n) {
            return CopyOnWriteSet.copyOf(this.data, n, TArray.getClass());
        }
        System.arraycopy(this.data, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Object[] objectArray = this.data;
        int n = objectArray.length;
        for (Object obj : collection) {
            if (CopyOnWriteList.indexOf(obj, objectArray, n) >= 0) continue;
            return false;
        }
        return true;
    }

    private static int indexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            int n2 = n;
            while (n2-- > 0) {
                if (objectArray[n2] != null) continue;
                return n2;
            }
        } else {
            int n3 = n;
            while (n3-- > 0) {
                if (!object.equals(objectArray[n3])) continue;
                return n3;
            }
        }
        return -1;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Object[] objectArray = this.data;
        Object[] objectArray2 = this.data;
        int n = 0;
        int n2 = 0;
        int n3 = objectArray2.length;
        while (n2 < n3) {
            if (collection.contains(objectArray2[n2])) {
                if (!bl) {
                    objectArray = (Object[])objectArray2.clone();
                    n = n2;
                    bl = true;
                }
            } else if (bl) {
                objectArray[n++] = objectArray2[n2];
            }
            ++n2;
        }
        if (bl) {
            this.data = CopyOnWriteSet.copyOf(objectArray, n);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.data = new Object[0];
    }

    @Override
    public int indexOf(Object object) {
        return CopyOnWriteList.indexOf(object, this.data, this.data.length);
    }

    @Override
    public int lastIndexOf(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public CopyOnWriteList<E> clone() {
        try {
            return (CopyOnWriteList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            InternalError internalError = new InternalError();
            internalError.initCause(cloneNotSupportedException);
            throw internalError;
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object var1_1) {
        if (!(var1_1 instanceof CopyOnWriteList)) {
            return false;
        }
        var2_2 = this.data;
        var3_3 = ((CopyOnWriteList)var1_1).data;
        if (var2_2 == var3_3) {
            return true;
        }
        var4_4 = var2_2.length;
        if (var4_4 == var3_3.length) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            var5_5 = var2_2[var4_4];
            var6_6 = var3_3[var4_4];
            if (!(var5_5 == null ? var6_6 != null : var5_5.equals(var6_6) == false)) continue;
            return false;
lbl14:
            // 2 sources

            ** while (var4_4-- > 0)
        }
lbl15:
        // 1 sources

        return true;
    }
}

