/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ArrayMap<K, V>
extends AbstractMap<K, V> {
    private Object[] table;
    private int size;
    protected transient Collection<V> values;

    public ArrayMap() {
        this(32);
    }

    public ArrayMap(int n) {
        this.table = new Object[n * 2];
        this.size = 0;
    }

    @Override
    public V get(Object object) {
        int n = 0;
        int n2 = this.size << 1;
        while (n < n2) {
            if (object.equals(this.table[n])) {
                return (V)this.table[n + 1];
            }
            n += 2;
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        int n = 0;
        int n2 = this.size << 1;
        while (n < n2) {
            if (k.equals(this.table[n])) {
                Object object = this.table[n + 1];
                this.table[n + 1] = v;
                return (V)object;
            }
            n += 2;
        }
        if (this.size * 2 == this.table.length) {
            Object[] objectArray = new Object[this.table.length * 2];
            System.arraycopy(this.table, 0, objectArray, 0, this.table.length);
            this.table = objectArray;
        }
        int n3 = this.size++ << 1;
        this.table[n3++] = k;
        this.table[n3] = v;
        return null;
    }

    public V getOrCompute(K k) {
        int n = 0;
        int n2 = this.size << 1;
        while (n < n2) {
            if (k.equals(this.table[n])) {
                return (V)this.table[n + 1];
            }
            n += 2;
        }
        V v = this.compute(k);
        if (this.size << 1 == this.table.length) {
            Object[] objectArray = new Object[this.table.length << 1];
            System.arraycopy(this.table, 0, objectArray, 0, this.table.length);
            this.table = objectArray;
        }
        n2 = this.size++ << 1;
        this.table[n2++] = k;
        this.table[n2] = v;
        return v;
    }

    protected V compute(K k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        int index = 0;

                        @Override
                        public boolean hasNext() {
                            return this.index < ArrayMap.this.size;
                        }

                        @Override
                        public V next() {
                            if (this.index >= ArrayMap.this.size) {
                                throw new NoSuchElementException();
                            }
                            return ArrayMap.this.table[(this.index++ << 1) + 1];
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return ArrayMap.this.size;
                }
            };
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    FastEntry entry = new FastEntry();
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < ArrayMap.this.size;
                    }

                    @Override
                    public FastEntry next() {
                        if (this.index >= ArrayMap.this.size) {
                            throw new NoSuchElementException();
                        }
                        int n = this.index << 1;
                        this.entry.key = ArrayMap.this.table[n];
                        this.entry.value = ArrayMap.this.table[n + 1];
                        ++this.index;
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ArrayMap.this.size;
            }
        };
    }

    static class FastEntry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        FastEntry() {
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }
    }
}

