/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.resolver.WrappedCapability;
import org.apache.felix.resolver.WrappedRequirement;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

class WrappedResource
implements Resource {
    private final Resource m_host;
    private final List<Resource> m_fragments;
    private List<Capability> m_cachedCapabilities = null;
    private List<Requirement> m_cachedRequirements = null;

    public WrappedResource(Resource resource, List<Resource> list) {
        this.m_host = resource;
        this.m_fragments = list;
    }

    public Resource getDeclaredResource() {
        return this.m_host;
    }

    public List<Resource> getFragments() {
        return this.m_fragments;
    }

    @Override
    public List<Capability> getCapabilities(String string) {
        if (this.m_cachedCapabilities == null) {
            ArrayList<WrappedCapability> arrayList = new ArrayList<WrappedCapability>();
            for (Capability object : this.m_host.getCapabilities(string)) {
                arrayList.add(new WrappedCapability(this, object));
            }
            if (this.m_fragments != null) {
                for (Resource resource : this.m_fragments) {
                    for (Capability capability : resource.getCapabilities(string)) {
                        arrayList.add(new WrappedCapability(this, capability));
                    }
                }
            }
            this.m_cachedCapabilities = Collections.unmodifiableList(arrayList);
        }
        return this.m_cachedCapabilities;
    }

    @Override
    public List<Requirement> getRequirements(String string) {
        if (this.m_cachedRequirements == null) {
            ArrayList<WrappedRequirement> arrayList = new ArrayList<WrappedRequirement>();
            for (Requirement object : this.m_host.getRequirements(null)) {
                arrayList.add(new WrappedRequirement(this, object));
            }
            if (this.m_fragments != null) {
                for (Resource resource : this.m_fragments) {
                    for (Requirement requirement : resource.getRequirements(null)) {
                        if (requirement.getNamespace().equals("osgi.wiring.host") || requirement.getNamespace().equals("osgi.ee")) continue;
                        arrayList.add(new WrappedRequirement(this, requirement));
                    }
                }
            }
            this.m_cachedRequirements = Collections.unmodifiableList(arrayList);
        }
        return this.m_cachedRequirements;
    }

    public String toString() {
        return this.m_host.toString();
    }
}

