/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.Map;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;
import org.osgi.service.resolver.HostedCapability;

public class WrappedCapability
implements HostedCapability {
    private final Resource m_host;
    private final Capability m_cap;

    public WrappedCapability(Resource resource, Capability capability) {
        this.m_host = resource;
        this.m_cap = capability;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WrappedCapability wrappedCapability = (WrappedCapability)object;
        if (!(this.m_host == wrappedCapability.m_host || this.m_host != null && this.m_host.equals(wrappedCapability.m_host))) {
            return false;
        }
        return this.m_cap == wrappedCapability.m_cap || this.m_cap != null && this.m_cap.equals(wrappedCapability.m_cap);
    }

    @Override
    public int hashCode() {
        int n = 7;
        n = 37 * n + (this.m_host != null ? this.m_host.hashCode() : 0);
        n = 37 * n + (this.m_cap != null ? this.m_cap.hashCode() : 0);
        return n;
    }

    @Override
    public Capability getDeclaredCapability() {
        return this.m_cap;
    }

    @Override
    public Resource getResource() {
        return this.m_host;
    }

    @Override
    public String getNamespace() {
        return this.m_cap.getNamespace();
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.m_cap.getDirectives();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.m_cap.getAttributes();
    }

    public String toString() {
        if (this.m_host == null) {
            return this.getAttributes().toString();
        }
        if (this.getNamespace().equals("osgi.wiring.package")) {
            return "[" + this.m_host + "] " + this.getNamespace() + "; " + this.getAttributes().get("osgi.wiring.package");
        }
        return "[" + this.m_host + "] " + this.getNamespace() + "; " + this.getAttributes();
    }
}

