/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;

class WireImpl
implements Wire {
    private final Resource m_requirer;
    private final Requirement m_req;
    private final Resource m_provider;
    private final Capability m_cap;

    public WireImpl(Resource resource, Requirement requirement, Resource resource2, Capability capability) {
        this.m_requirer = resource;
        this.m_req = requirement;
        this.m_provider = resource2;
        this.m_cap = capability;
    }

    @Override
    public Resource getRequirer() {
        return this.m_requirer;
    }

    @Override
    public Requirement getRequirement() {
        return this.m_req;
    }

    @Override
    public Resource getProvider() {
        return this.m_provider;
    }

    @Override
    public Capability getCapability() {
        return this.m_cap;
    }

    public String toString() {
        return this.m_req + " -> " + "[" + this.m_provider + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Wire)) {
            return false;
        }
        Wire wire = (Wire)object;
        if (!(this.m_requirer == wire.getRequirer() || this.m_requirer != null && this.m_requirer.equals(wire.getRequirer()))) {
            return false;
        }
        if (!(this.m_req == wire.getRequirement() || this.m_req != null && this.m_req.equals(wire.getRequirement()))) {
            return false;
        }
        if (!(this.m_provider == wire.getProvider() || this.m_provider != null && this.m_provider.equals(wire.getProvider()))) {
            return false;
        }
        return this.m_cap == wire.getCapability() || this.m_cap != null && this.m_cap.equals(wire.getCapability());
    }

    @Override
    public int hashCode() {
        int n = 5;
        n = 29 * n + (this.m_requirer != null ? this.m_requirer.hashCode() : 0);
        n = 29 * n + (this.m_req != null ? this.m_req.hashCode() : 0);
        n = 29 * n + (this.m_provider != null ? this.m_provider.hashCode() : 0);
        n = 29 * n + (this.m_cap != null ? this.m_cap.hashCode() : 0);
        return n;
    }
}

