/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class Util {
    public static String getSymbolicName(Resource resource) {
        List<Capability> list = resource.getCapabilities(null);
        for (Capability capability : list) {
            if (!capability.getNamespace().equals("osgi.identity")) continue;
            return capability.getAttributes().get("osgi.identity").toString();
        }
        return null;
    }

    public static Version getVersion(Resource resource) {
        List<Capability> list = resource.getCapabilities(null);
        for (Capability capability : list) {
            if (!capability.getNamespace().equals("osgi.identity")) continue;
            return (Version)capability.getAttributes().get("version");
        }
        return null;
    }

    public static boolean isFragment(Resource resource) {
        List<Capability> list = resource.getCapabilities(null);
        for (Capability capability : list) {
            if (!capability.getNamespace().equals("osgi.identity")) continue;
            String string = (String)capability.getAttributes().get("type");
            return string != null && string.equals("osgi.fragment");
        }
        return false;
    }

    public static boolean isOptional(Requirement requirement) {
        String string = requirement.getDirectives().get("resolution");
        return "optional".equalsIgnoreCase(string);
    }

    public static boolean isMultiple(Requirement requirement) {
        return "multiple".equals(requirement.getDirectives().get("cardinality")) && !Util.isDynamic(requirement);
    }

    public static boolean isDynamic(Requirement requirement) {
        return "dynamic".equals(requirement.getDirectives().get("resolution"));
    }

    public static boolean isReexport(Requirement requirement) {
        return "reexport".equals(requirement.getDirectives().get("visibility"));
    }

    public static List<Requirement> getDynamicRequirements(List<Requirement> list) {
        ArrayList<Requirement> arrayList = new ArrayList<Requirement>();
        if (list != null) {
            for (Requirement requirement : list) {
                String string = requirement.getDirectives().get("resolution");
                if (string == null || !string.equals("dynamic")) continue;
                arrayList.add(requirement);
            }
        }
        return arrayList;
    }
}

