/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.resolver.Candidates;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.ResolutionError;
import org.apache.felix.resolver.Util;
import org.apache.felix.resolver.WireImpl;
import org.apache.felix.resolver.WrappedCapability;
import org.apache.felix.resolver.WrappedRequirement;
import org.apache.felix.resolver.WrappedResource;
import org.apache.felix.resolver.util.ArrayMap;
import org.apache.felix.resolver.util.OpenHashMap;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;
import org.osgi.service.resolver.Resolver;

public class ResolverImpl
implements Resolver {
    private final AccessControlContext m_acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
    private final Logger m_logger;
    private final int m_parallelism;
    private final Executor m_executor;

    public ResolverImpl(Logger logger) {
        this(logger, Runtime.getRuntime().availableProcessors());
    }

    public ResolverImpl(Logger logger, int n) {
        this.m_logger = logger;
        this.m_parallelism = n;
        this.m_executor = null;
    }

    public ResolverImpl(Logger logger, Executor executor) {
        this.m_logger = logger;
        this.m_parallelism = -1;
        this.m_executor = executor;
    }

    @Override
    public Map<Resource, List<Wire>> resolve(ResolveContext resolveContext) throws ResolutionException {
        if (this.m_executor != null) {
            return this.resolve(resolveContext, this.m_executor);
        }
        if (this.m_parallelism > 1) {
            Map<Resource, List<Wire>> map;
            ExecutorService executorService = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<ExecutorService>(){

                @Override
                public ExecutorService run() {
                    return Executors.newFixedThreadPool(ResolverImpl.this.m_parallelism);
                }
            }, this.m_acc) : Executors.newFixedThreadPool(this.m_parallelism);
            try {
                map = this.resolve(resolveContext, executorService);
            }
            catch (Throwable throwable) {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(executorService){
                        private final /* synthetic */ ExecutorService val$executor;
                        {
                            this.val$executor = executorService;
                        }

                        @Override
                        public Void run() {
                            this.val$executor.shutdownNow();
                            return null;
                        }
                    }, this.m_acc);
                } else {
                    executorService.shutdownNow();
                }
                throw throwable;
            }
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */, this.m_acc);
            } else {
                executorService.shutdownNow();
            }
            return map;
        }
        return this.resolve(resolveContext, new DumbExecutor());
    }

    /*
     * WARNING - void declaration
     */
    public Map<Resource, List<Wire>> resolve(ResolveContext resolveContext, Executor executor) throws ResolutionException {
        boolean bl;
        ResolveSession resolveSession = new ResolveSession(resolveContext);
        Map<Resource, List<Wire>> map = new HashMap<Resource, List<Wire>>();
        ArrayList<Resource> arrayList = new ArrayList<Resource>(resolveContext.getMandatoryResources());
        ArrayList<Resource> arrayList2 = new ArrayList<Resource>(resolveContext.getOptionalResources());
        HashMap<Resource, Boolean> hashMap = new HashMap<Resource, Boolean>(0);
        do {
            bl = false;
            try {
                Capability capability;
                Object object;
                Object object2;
                OpenHashMap<Resource, Resource> openHashMap;
                void object62;
                Object object3;
                Candidates candidates = new Candidates(hashMap);
                ArrayList<Resource> arrayList3 = new ArrayList<Resource>();
                ArrayList<Resource> arrayList4 = new ArrayList<Resource>();
                for (Resource resource : arrayList) {
                    if (!Util.isFragment(resource) && resolveContext.getWirings().get(resource) != null) continue;
                    arrayList3.add(resource);
                    arrayList4.add(resource);
                }
                for (Resource resource : arrayList2) {
                    if (!Util.isFragment(resource) && resolveContext.getWirings().get(resource) != null) continue;
                    arrayList4.add(resource);
                }
                candidates.addMandatoryResources(arrayList3);
                candidates.populate(resolveContext, arrayList4);
                ResolutionError resolutionError = candidates.prepare(resolveContext);
                if (resolutionError != null) {
                    throw resolutionError.toException();
                }
                LinkedHashSet<Resource> linkedHashSet = new LinkedHashSet<Resource>(arrayList);
                for (Resource resource : arrayList2) {
                    if (!candidates.isPopulated(resource)) continue;
                    linkedHashSet.add(resource);
                }
                ArrayList<Candidates> arrayList5 = new ArrayList<Candidates>();
                ArrayList arrayList6 = new ArrayList();
                ArrayList<Candidates> arrayList7 = new ArrayList<Candidates>();
                arrayList5.add(candidates);
                HashMap<Object, Requirement> hashMap2 = new HashMap<Object, Requirement>();
                HashMap<Resource, ResolutionError> hashMap3 = linkedHashSet.iterator();
                while (hashMap3.hasNext()) {
                    object3 = (Resource)hashMap3.next();
                    if (!Util.isFragment((Resource)object3)) continue;
                    hashMap2.put(object3, object3.getRequirements("osgi.wiring.host").get(0));
                }
                object3 = new HashSet();
                hashMap3 = null;
                do {
                    if (!arrayList5.isEmpty()) {
                        candidates = (Candidates)arrayList5.remove(0);
                    } else if (!arrayList6.isEmpty()) {
                        candidates = (Candidates)arrayList6.remove(0);
                    } else {
                        if (arrayList7.isEmpty()) break;
                        candidates = (Candidates)arrayList7.remove(0);
                    }
                    if (!object3.add(candidates.getDelta())) continue;
                    resolveSession.setMultipleCardCandidates(null);
                    ResolutionError resolutionError2 = candidates.checkSubstitutes(arrayList7);
                    if (resolutionError2 != null) continue;
                    openHashMap = new OpenHashMap<Resource, Resource>();
                    object2 = linkedHashSet.iterator();
                    while (object2.hasNext()) {
                        void var21_34;
                        Resource resource = (Resource)object2.next();
                        object = (Requirement)hashMap2.get(resource);
                        if (object != null) {
                            capability = candidates.getFirstCandidate((Requirement)object);
                            if (capability == null) continue;
                            Resource resource2 = capability.getResource();
                        }
                        openHashMap.put((Resource)var21_34, candidates.getWrappedHost((Resource)var21_34));
                    }
                    HashMap<Resource, ResolutionError> hashMap4 = new HashMap<Resource, ResolutionError>();
                    object2 = new ArrayList();
                    object = new ArrayList<Candidates>();
                    ResolutionError resolutionError3 = this.checkConsistency(executor, resolveSession, (List<Candidates>)object2, (List<Candidates>)object, candidates, (Map<Resource, ResolutionError>)hashMap4, (Map<Resource, Resource>)openHashMap, false);
                    arrayList5.addAll(0, (Collection<Candidates>)object2);
                    arrayList6.addAll(0, object);
                    if (hashMap4.isEmpty()) continue;
                    if (hashMap3 == null) {
                        hashMap3 = hashMap4;
                        continue;
                    }
                    if (hashMap3.size() <= hashMap4.size()) continue;
                    hashMap3 = hashMap4;
                } while (object62 != null);
                if (object62 != null) {
                    if (hashMap3 != null) {
                        openHashMap = hashMap3.keySet();
                        bl = arrayList2.removeAll((Collection<?>)((Object)openHashMap));
                        object2 = openHashMap.iterator();
                        while (object2.hasNext()) {
                            Resource resource = (Resource)object2.next();
                            object = (Boolean)hashMap.get(resource);
                            if (object == null || !((Boolean)object).booleanValue()) continue;
                            hashMap.put(resource, Boolean.FALSE);
                            bl = true;
                        }
                        for (Map.Entry entry : hashMap3.entrySet()) {
                            this.m_logger.logUsesConstraintViolation((Resource)entry.getKey(), (ResolutionError)entry.getValue());
                        }
                    }
                    if (bl) continue;
                    throw object62.toException();
                }
                if (resolveSession.getMultipleCardCandidates() != null) {
                    candidates = resolveSession.getMultipleCardCandidates();
                }
                Iterator iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    openHashMap = (Resource)iterator.next();
                    object2 = openHashMap;
                    object = (Requirement)hashMap2.get(openHashMap);
                    if (object != null) {
                        capability = candidates.getFirstCandidate((Requirement)object);
                        if (capability == null) continue;
                        object2 = capability.getResource();
                    }
                    if (!candidates.isPopulated((Resource)object2)) continue;
                    map = ResolverImpl.populateWireMap(resolveContext, candidates.getWrappedHost((Resource)object2), map, candidates);
                }
            }
            finally {
                resolveSession.setMultipleCardCandidates(null);
            }
        } while (bl);
        return map;
    }

    private ResolutionError checkConsistency(Executor executor, ResolveSession resolveSession, List<Candidates> list, List<Candidates> list2, Candidates candidates, Map<Resource, ResolutionError> map, Map<Resource, Resource> map2, boolean bl) {
        Map<Resource, Packages> map3 = ResolverImpl.calculatePackageSpaces(executor, resolveSession, candidates, map2.values());
        ResolutionError resolutionError = null;
        OpenHashMap<Resource, Object> openHashMap = new OpenHashMap<Resource, Object>(map3.size());
        for (Map.Entry<Resource, Resource> entry : map2.entrySet()) {
            ResolutionError resolutionError2 = this.checkPackageSpaceConsistency(resolveSession, list, list2, entry.getValue(), candidates, bl, map3, openHashMap);
            if (resolutionError2 == null) continue;
            Resource resource = entry.getKey();
            for (Requirement requirement : resolutionError2.getUnresolvedRequirements()) {
                if (!(requirement instanceof WrappedRequirement)) continue;
                resource = ((WrappedRequirement)requirement).getDeclaredRequirement().getResource();
                break;
            }
            map.put(resource, resolutionError2);
            resolutionError = resolutionError2;
        }
        return resolutionError;
    }

    public Map<Resource, List<Wire>> resolve(ResolveContext resolveContext, Resource resource, Requirement requirement, List<Capability> list) throws ResolutionException {
        ResolveSession resolveSession = new ResolveSession(resolveContext);
        Map<Resource, List<Wire>> map = new HashMap<Resource, List<Wire>>();
        if (!list.isEmpty() && resolveContext.getWirings().containsKey(resource)) {
            boolean bl;
            for (Capability object2 : list) {
                if (object2.getNamespace().equals("osgi.wiring.package")) continue;
                throw new IllegalArgumentException("Matching candidate does not provide a package name.");
            }
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            do {
                bl = false;
                try {
                    Candidates candidates = new Candidates(hashMap2);
                    ResolutionError resolutionError = candidates.populateDynamic(resolveContext, resource, requirement, list);
                    if (resolutionError == null) {
                        resolutionError = candidates.prepare(resolveContext);
                    }
                    if (resolutionError != null) {
                        throw resolutionError.toException();
                    }
                    ArrayList<Candidates> arrayList = new ArrayList<Candidates>();
                    ArrayList<Candidates> arrayList2 = new ArrayList<Candidates>();
                    arrayList.add(candidates);
                    do {
                        hashMap.clear();
                        candidates = arrayList.size() > 0 ? (Candidates)arrayList.remove(0) : (Candidates)arrayList2.remove(0);
                        resolutionError = candidates.checkSubstitutes(arrayList2);
                        if (resolutionError != null) continue;
                        resolutionError = this.checkConsistency(new DumbExecutor(), resolveSession, arrayList, arrayList2, candidates, new OpenHashMap<Resource, ResolutionError>(hashMap.size()), candidates.getHosts(), true);
                    } while (resolutionError != null && (arrayList.size() > 0 || arrayList2.size() > 0));
                    if (resolutionError != null) {
                        Boolean bl2;
                        Resource resource2;
                        Collection<Requirement> collection = resolutionError.getUnresolvedRequirements();
                        Requirement requirement2 = collection == null || collection.isEmpty() ? null : collection.iterator().next();
                        Resource resource3 = resource2 = requirement2 == null ? null : ResolverImpl.getDeclaredResource(requirement2.getResource());
                        if (requirement2 instanceof WrappedRequirement) {
                            resource2 = ((WrappedRequirement)requirement2).getDeclaredRequirement().getResource();
                        }
                        if ((bl2 = (Boolean)hashMap2.get(resource2)) != null && bl2.booleanValue()) {
                            hashMap2.put(resource2, Boolean.FALSE);
                            bl = true;
                            continue;
                        }
                        throw resolutionError.toException();
                    }
                    if (resolveSession.getMultipleCardCandidates() != null) {
                        candidates = resolveSession.getMultipleCardCandidates();
                    }
                    map = ResolverImpl.populateDynamicWireMap(resolveContext, resource, requirement, map, candidates);
                }
                finally {
                    resolveSession.setMultipleCardCandidates(null);
                }
            } while (bl);
        }
        return map;
    }

    private static List<WireCandidate> getWireCandidates(ResolveSession resolveSession, Candidates candidates, Resource resource) {
        ArrayList<WireCandidate> arrayList = new ArrayList<WireCandidate>(256);
        Wiring wiring = resolveSession.getContext().getWirings().get(resource);
        if (wiring != null) {
            Object object;
            for (Wire object2 : wiring.getRequiredResourceWires(null)) {
                Capability capability;
                object = object2.getRequirement();
                if (!object.getResource().equals(object2.getRequirer()) || Util.isDynamic((Requirement)object)) {
                    object = new WrappedRequirement(object2.getRequirer(), (Requirement)object);
                }
                if (!(capability = object2.getCapability()).getResource().equals(object2.getProvider())) {
                    capability = new WrappedCapability(object2.getProvider(), capability);
                }
                arrayList.add(new WireCandidate((Requirement)object, capability));
            }
            for (Requirement requirement : wiring.getResourceRequirements(null)) {
                if (!Util.isDynamic(requirement) || (object = candidates.getFirstCandidate(requirement)) == null) continue;
                arrayList.add(new WireCandidate(requirement, (Capability)object));
                break;
            }
        } else {
            for (Requirement requirement : resource.getRequirements(null)) {
                Capability capability2;
                List<Capability> list;
                if (Util.isDynamic(requirement) || (list = candidates.getCandidates(requirement)) == null) continue;
                if (Util.isMultiple(requirement)) {
                    for (Capability capability2 : list) {
                        arrayList.add(new WireCandidate(requirement, capability2));
                    }
                    continue;
                }
                capability2 = list.get(0);
                arrayList.add(new WireCandidate(requirement, capability2));
            }
        }
        return arrayList;
    }

    private static Packages getPackages(ResolveSession resolveSession, Candidates candidates, Map<Resource, List<WireCandidate>> map, Map<Resource, Packages> map2, Resource resource, Packages packages) {
        for (WireCandidate wireCandidate : map.get(resource)) {
            String string;
            if (Util.isDynamic(wireCandidate.requirement) && (packages.m_exportedPkgs.containsKey(string = (String)wireCandidate.capability.getAttributes().get("osgi.wiring.package")) || packages.m_importedPkgs.containsKey(string) || packages.m_requiredPkgs.containsKey(string))) {
                throw new IllegalArgumentException("Resource " + resource + " cannot dynamically import package '" + string + "' since it already has access to it.");
            }
            ResolverImpl.mergeCandidatePackages(resolveSession, map2, candidates, packages, wireCandidate.requirement, wireCandidate.capability, new HashSet<Capability>(), new HashSet<Resource>());
        }
        return packages;
    }

    private static void computeUses(ResolveSession resolveSession, Map<Resource, List<WireCandidate>> map, Map<Resource, Packages> map2, Resource resource) {
        boolean bl;
        List<WireCandidate> list = map.get(resource);
        Packages packages = map2.get(resource);
        Wiring wiring = resolveSession.getContext().getWirings().get(resource);
        HashSet<Capability> hashSet = new HashSet<Capability>();
        int n = list.size();
        boolean bl2 = bl = n > 0 && Util.isDynamic(list.get((int)(n - 1)).requirement);
        if (wiring == null || bl) {
            List<Requirement> list2;
            for (WireCandidate object2 : list) {
                Object object = object2.requirement;
                Iterator iterator = object2.capability;
                if (object.getNamespace().equals("osgi.wiring.bundle") || object.getNamespace().equals("osgi.wiring.package")) continue;
                list2 = Collections.singletonList(object);
                ResolverImpl.mergeUses(resolveSession, resource, packages, iterator, list2, iterator, map2, hashSet);
            }
            for (List list3 : packages.m_importedPkgs.values()) {
                for (Object object : list3) {
                    list2 = Collections.singletonList(((Blame)object).m_reqs.get(0));
                    ResolverImpl.mergeUses(resolveSession, resource, packages, ((Blame)object).m_cap, list2, null, map2, hashSet);
                }
            }
            for (List list4 : packages.m_requiredPkgs.values()) {
                for (Object object : list4) {
                    list2 = Collections.singletonList(((Blame)object).m_reqs.get(0));
                    ResolverImpl.mergeUses(resolveSession, resource, packages, ((Blame)object).m_cap, list2, null, map2, hashSet);
                }
            }
        }
    }

    private static void mergeCandidatePackages(ResolveSession resolveSession, Map<Resource, Packages> map, Candidates candidates, Packages packages, Requirement requirement, Capability capability, Set<Capability> set, Set<Resource> set2) {
        block8: {
            Wiring wiring;
            block7: {
                if (!set.add(capability)) {
                    return;
                }
                if (!capability.getNamespace().equals("osgi.wiring.package")) break block7;
                ResolverImpl.mergeCandidatePackage(packages.m_importedPkgs, requirement, capability);
                break block8;
            }
            if (!capability.getNamespace().equals("osgi.wiring.bundle")) break block8;
            if (set2.add(capability.getResource())) {
                for (Blame blame : map.get((Object)capability.getResource()).m_exportedPkgs.values()) {
                    ResolverImpl.mergeCandidatePackage(packages.m_requiredPkgs, requirement, blame.m_cap);
                }
            }
            if ((wiring = resolveSession.getContext().getWirings().get(capability.getResource())) != null) {
                for (Wire wire : wiring.getRequiredResourceWires(null)) {
                    if (!wire.getRequirement().getNamespace().equals("osgi.wiring.bundle") || !Util.isReexport(wire.getRequirement())) continue;
                    ResolverImpl.mergeCandidatePackages(resolveSession, map, candidates, packages, requirement, wire.getCapability(), set, set2);
                }
            } else {
                for (Requirement requirement2 : capability.getResource().getRequirements(null)) {
                    Capability capability2;
                    if (!requirement2.getNamespace().equals("osgi.wiring.bundle") || !Util.isReexport(requirement2) || (capability2 = candidates.getFirstCandidate(requirement2)) == null) continue;
                    ResolverImpl.mergeCandidatePackages(resolveSession, map, candidates, packages, requirement, capability2, set, set2);
                }
            }
        }
    }

    private static void mergeCandidatePackage(OpenHashMap<String, List<Blame>> openHashMap, Requirement requirement, Capability capability) {
        if (capability.getNamespace().equals("osgi.wiring.package")) {
            String string = (String)capability.getAttributes().get("osgi.wiring.package");
            List<Requirement> list = Collections.singletonList(requirement);
            List<Blame> list2 = openHashMap.getOrCompute(string);
            list2.add(new Blame(capability, list));
        }
    }

    private static void mergeUses(ResolveSession resolveSession, Resource resource, Packages packages, Capability capability, List<Requirement> list, Capability capability2, Map<Resource, Packages> map, Set<Capability> set) {
        if (resource.equals(capability.getResource())) {
            return;
        }
        if (!set.add(capability)) {
            return;
        }
        for (Capability capability3 : ResolverImpl.getPackageSources(capability, map)) {
            Object object = capability3.getDirectives().get("uses");
            if (object == null || ((String)object).length() <= 0) continue;
            List<String> list2 = (List<String>)resolveSession.getUsesCache().get(object);
            if (list2 == null) {
                list2 = ResolverImpl.parseUses((String)object);
                resolveSession.getUsesCache().put((String)object, list2);
            }
            object = map.get(capability3.getResource());
            for (String string : list2) {
                List<Blame> list3;
                Blame blame = ((Packages)object).m_exportedPkgs.get(string);
                if (blame != null) {
                    list3 = Collections.singletonList(blame);
                } else {
                    list3 = ((Packages)object).m_requiredPkgs.get(string);
                    if (list3 == null) {
                        list3 = ((Packages)object).m_importedPkgs.get(string);
                    }
                }
                if (list3 == null) continue;
                ArrayMap<Capability, UsedBlames> arrayMap = packages.m_usedPkgs.getOrCompute(string);
                for (Blame blame2 : list3) {
                    if (blame2.m_reqs != null) {
                        ArrayList<Requirement> arrayList = new ArrayList<Requirement>(list.size() + 1);
                        arrayList.addAll(list);
                        arrayList.add(blame2.m_reqs.get(blame2.m_reqs.size() - 1));
                        ResolverImpl.addUsedBlame(arrayMap, blame2.m_cap, arrayList, capability2);
                        ResolverImpl.mergeUses(resolveSession, resource, packages, blame2.m_cap, arrayList, capability2, map, set);
                        continue;
                    }
                    ResolverImpl.addUsedBlame(arrayMap, blame2.m_cap, list, capability2);
                    ResolverImpl.mergeUses(resolveSession, resource, packages, blame2.m_cap, list, capability2, map, set);
                }
            }
        }
    }

    private static Map<Resource, Packages> calculatePackageSpaces(Executor executor, final ResolveSession resolveSession, final Candidates candidates, Collection<Resource> collection) {
        Packages packages;
        Object object;
        EnhancedExecutor enhancedExecutor = new EnhancedExecutor(executor);
        final ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        Map<Resource, Packages> map = new ConcurrentHashMap(candidates.getNbResources());
        for (Resource object2 : collection) {
            class Computer
            implements Runnable {
                final Resource resource;
                private final /* synthetic */ ResolveSession val$session;
                private final /* synthetic */ Candidates val$allCandidates;
                private final /* synthetic */ Map val$allWireCandidates;
                private final /* synthetic */ ConcurrentMap val$tasks;
                private final /* synthetic */ EnhancedExecutor val$executor;

                public Computer(Resource resource, ResolveSession resolveSession, Candidates candidates, Map map, ConcurrentMap concurrentMap, EnhancedExecutor enhancedExecutor) {
                    this.val$session = resolveSession;
                    this.val$allCandidates = candidates;
                    this.val$allWireCandidates = map;
                    this.val$tasks = concurrentMap;
                    this.val$executor = enhancedExecutor;
                    this.resource = resource;
                }

                @Override
                public void run() {
                    List list = ResolverImpl.getWireCandidates(this.val$session, this.val$allCandidates, this.resource);
                    this.val$allWireCandidates.put(this.resource, list);
                    for (WireCandidate wireCandidate : list) {
                        Computer computer;
                        Resource resource = wireCandidate.capability.getResource();
                        if (this.val$tasks.containsKey(resource) || this.val$tasks.putIfAbsent(resource, computer = new Computer(resource, this.val$session, this.val$allCandidates, this.val$allWireCandidates, this.val$tasks, this.val$executor)) != null) continue;
                        this.val$executor.execute(computer);
                    }
                }
            }
            enhancedExecutor.execute(new Computer(object2, resolveSession, candidates, concurrentHashMap, (ConcurrentMap)map, enhancedExecutor));
        }
        enhancedExecutor.await();
        map = new OpenHashMap(candidates.getNbResources());
        for (final Resource resource : concurrentHashMap.keySet()) {
            object = new Packages(resource);
            ((OpenHashMap)map).put(resource, (Packages)object);
            enhancedExecutor.execute(new Runnable((Packages)object){
                private final /* synthetic */ Packages val$packages;
                {
                    this.val$packages = packages;
                }

                @Override
                public void run() {
                    ResolverImpl.calculateExportedPackages(resolveSession, candidates, resource, this.val$packages.m_exportedPkgs);
                }
            });
        }
        enhancedExecutor.await();
        for (Resource resource : concurrentHashMap.keySet()) {
            enhancedExecutor.execute(new Runnable((OpenHashMap)map, resource){
                private final /* synthetic */ OpenHashMap val$allPackages;
                private final /* synthetic */ Resource val$resource;
                {
                    this.val$allPackages = openHashMap;
                    this.val$resource = resource;
                }

                @Override
                public void run() {
                    ResolverImpl.getPackages(resolveSession, candidates, concurrentHashMap, this.val$allPackages, this.val$resource, (Packages)this.val$allPackages.get(this.val$resource));
                }
            });
        }
        enhancedExecutor.await();
        for (Map.Entry entry : ((OpenHashMap)map).fast()) {
            object = (Resource)entry.getKey();
            packages = (Packages)entry.getValue();
            if (packages.m_requiredPkgs.isEmpty()) continue;
            ResolverImpl.getPackageSourcesInternal(resolveSession, map, (Resource)object, packages);
        }
        for (Map.Entry entry : ((OpenHashMap)map).fast()) {
            object = (Resource)entry.getKey();
            packages = (Packages)entry.getValue();
            if (!packages.m_sources.isEmpty()) continue;
            enhancedExecutor.execute(new Runnable((OpenHashMap)map, (Resource)object, packages){
                private final /* synthetic */ OpenHashMap val$allPackages;
                private final /* synthetic */ Resource val$resource;
                private final /* synthetic */ Packages val$packages;
                {
                    this.val$allPackages = openHashMap;
                    this.val$resource = resource;
                    this.val$packages = packages;
                }

                @Override
                public void run() {
                    ResolverImpl.getPackageSourcesInternal(resolveSession, this.val$allPackages, this.val$resource, this.val$packages);
                }
            });
        }
        enhancedExecutor.await();
        for (Resource resource : concurrentHashMap.keySet()) {
            enhancedExecutor.execute(new Runnable((OpenHashMap)map, resource){
                private final /* synthetic */ OpenHashMap val$allPackages;
                private final /* synthetic */ Resource val$resource;
                {
                    this.val$allPackages = openHashMap;
                    this.val$resource = resource;
                }

                @Override
                public void run() {
                    ResolverImpl.computeUses(resolveSession, concurrentHashMap, this.val$allPackages, this.val$resource);
                }
            });
        }
        enhancedExecutor.await();
        return map;
    }

    private static List<String> parseUses(String string) {
        int n = 1;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            if (string.charAt(n3) == ',') {
                ++n;
            }
            ++n3;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n4 = 0;
        while (true) {
            int n5;
            if (n4 < n2) {
                n5 = string.charAt(n4);
                if (n5 == 32 || n5 == 44) {
                    ++n4;
                    continue;
                }
            }
            n5 = n4 + 1;
            while (n5 < n2) {
                char c = string.charAt(n5);
                if (c == ' ' || c == ',') break;
                ++n5;
            }
            if (n4 >= n2) break;
            arrayList.add(string.substring(n4, n5));
            n4 = n5 + 1;
        }
        return arrayList;
    }

    private static void addUsedBlame(ArrayMap<Capability, UsedBlames> arrayMap, Capability capability, List<Requirement> list, Capability capability2) {
        Blame blame = new Blame(capability, list);
        UsedBlames usedBlames = arrayMap.getOrCompute(capability);
        usedBlames.addBlame(blame, capability2);
    }

    /*
     * WARNING - void declaration
     */
    private ResolutionError checkPackageSpaceConsistency(ResolveSession resolveSession, List<Candidates> list, List<Candidates> list2, Resource resource, Candidates candidates, boolean bl, Map<Resource, Packages> map, Map<Resource, Object> map2) {
        void var14_24;
        Object object;
        Object object2;
        Object object3;
        if (!bl && resolveSession.getContext().getWirings().containsKey(resource)) {
            return null;
        }
        Object object6 = map2.get(resource);
        if (object6 != null) {
            return object6 instanceof ResolutionError ? (ResolutionError)object6 : null;
        }
        Packages packages = map.get(resource);
        ResolutionError resolutionError = null;
        Candidates candidates2 = null;
        Set set = null;
        for (Map.Entry<String, List<Blame>> entry : packages.m_importedPkgs.fast()) {
            String string = entry.getKey();
            object3 = entry.getValue();
            if (object3.size() <= 1) continue;
            object2 = null;
            Iterator<Blame> iterator = object3.iterator();
            while (iterator.hasNext()) {
                Blame blame = iterator.next();
                if (object2 == null) {
                    object2 = blame;
                    continue;
                }
                if (((Blame)object2).m_cap.getResource().equals(blame.m_cap.getResource())) continue;
                candidates.permutate(blame.m_reqs.get(0), list2);
                candidates.permutate(((Blame)object2).m_reqs.get(0), list2);
                resolutionError = new UseConstraintError(resolveSession.getContext(), candidates, resource, string, (Blame)object2, blame);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("Candidate permutation failed due to a conflict with a fragment import; will try another if possible. (" + resolutionError.getMessage() + ")");
                }
                return resolutionError;
            }
        }
        for (Map.Entry<String, Blame> entry : packages.m_exportedPkgs.fast()) {
            String string = entry.getKey();
            object3 = entry.getValue();
            object2 = packages.m_usedPkgs.get(string);
            if (object2 == null) continue;
            for (UsedBlames usedBlames : ((ArrayMap)object2).values()) {
                if (ResolverImpl.isCompatible(object3, usedBlames.m_cap, map)) continue;
                block4: for (Blame blame : usedBlames.m_blames) {
                    if (this.checkMultiple(resolveSession, usedBlames, blame, candidates)) continue;
                    Candidates candidates3 = candidates2 = candidates2 != null ? candidates2 : candidates.copy();
                    if (resolutionError == null) {
                        resolutionError = new UseConstraintError(resolveSession.getContext(), candidates, resource, string, blame);
                    }
                    set = set != null ? set : new HashSet();
                    int n = blame.m_reqs.size() - 1;
                    while (n >= 0) {
                        object = blame.m_reqs.get(n);
                        if (!Util.isMultiple((Requirement)object)) {
                            if (set.contains(object)) continue block4;
                            if (candidates2.canRemoveCandidate((Requirement)object)) {
                                candidates2.removeFirstCandidate((Requirement)object);
                                set.add(object);
                                continue block4;
                            }
                        }
                        --n;
                    }
                }
            }
            if (resolutionError == null) continue;
            if (!set.isEmpty()) {
                list.add(candidates2);
            }
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("Candidate permutation failed due to a conflict between an export and import; will try another if possible. (" + resolutionError.getMessage() + ")");
            }
            return resolutionError;
        }
        if (packages.m_requiredPkgs.isEmpty()) {
            OpenHashMap<String, List<Blame>> openHashMap = packages.m_importedPkgs;
        } else {
            OpenHashMap<String, List<Blame>> openHashMap = new OpenHashMap<String, List<Blame>>(packages.m_requiredPkgs.size() + packages.m_importedPkgs.size());
            openHashMap.putAll(packages.m_requiredPkgs);
            openHashMap.putAll(packages.m_importedPkgs);
        }
        for (Map.Entry entry : var14_24.fast()) {
            object3 = (String)entry.getKey();
            object2 = packages.m_usedPkgs.get(object3);
            if (object2 == null) continue;
            List list3 = (List)entry.getValue();
            for (UsedBlames usedBlames : ((ArrayMap)object2).values()) {
                if (!ResolverImpl.isCompatible(list3, usedBlames.m_cap, map)) {
                    Object object4 = (Blame)list3.get(0);
                    block8: for (Blame blame : usedBlames.m_blames) {
                        if (this.checkMultiple(resolveSession, usedBlames, blame, candidates)) continue;
                        Candidates candidates4 = candidates2 = candidates2 != null ? candidates2 : candidates.copy();
                        if (resolutionError == null) {
                            resolutionError = new UseConstraintError(resolveSession.getContext(), candidates, resource, (String)object3, (Blame)object4, blame);
                        }
                        set = set != null ? set : new HashSet();
                        int n = blame.m_reqs.size() - 1;
                        while (n >= 0) {
                            Requirement requirement = blame.m_reqs.get(n);
                            if (!Util.isMultiple(requirement)) {
                                if (set.contains(requirement)) continue block8;
                                if (candidates2.canRemoveCandidate(requirement)) {
                                    candidates2.removeFirstCandidate(requirement);
                                    set.add(requirement);
                                    continue block8;
                                }
                            }
                            --n;
                        }
                    }
                }
                if (resolutionError == null) continue;
                if (!set.isEmpty()) {
                    list.add(candidates2);
                }
                for (Object object4 : list3) {
                    object = ((Blame)object4).m_reqs.get(0);
                    if (set.contains(object)) continue;
                    candidates.permutateIfNeeded((Requirement)object, list2);
                }
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("Candidate permutation failed due to a conflict between imports; will try another if possible. (" + resolutionError.getMessage() + ")");
                }
                return resolutionError;
            }
        }
        map2.put(resource, Boolean.TRUE);
        int n = list.size() + list2.size();
        for (Requirement requirement : resource.getRequirements(null)) {
            object2 = candidates.getFirstCandidate(requirement);
            if (object2 == null || resource.equals(object2.getResource()) || (resolutionError = this.checkPackageSpaceConsistency(resolveSession, list, list2, object2.getResource(), candidates, false, map, map2)) == null) continue;
            if (n == list.size() + list2.size()) {
                candidates.permutate(requirement, list2);
            }
            return resolutionError;
        }
        return null;
    }

    private boolean checkMultiple(ResolveSession resolveSession, UsedBlames usedBlames, Blame blame, Candidates candidates) {
        List<Capability> list = null;
        Requirement requirement = blame.m_reqs.get(0);
        if (Util.isMultiple(requirement)) {
            if (resolveSession.getMultipleCardCandidates() == null) {
                resolveSession.setMultipleCardCandidates(candidates.copy());
            }
            list = resolveSession.getMultipleCardCandidates().clearCandidates(requirement, usedBlames.getRootCauses(requirement));
        }
        return list != null && !list.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private static OpenHashMap<String, Blame> calculateExportedPackages(ResolveSession resolveSession, Candidates candidates, Resource resource, OpenHashMap<String, Blame> openHashMap) {
        Wiring wiring = resolveSession.getContext().getWirings().get(resource);
        List<Capability> list = wiring != null ? wiring.getResourceCapabilities(null) : resource.getCapabilities(null);
        for (Capability capability : list) {
            void object;
            if (!capability.getNamespace().equals("osgi.wiring.package")) continue;
            if (!capability.getResource().equals(resource)) {
                WrappedCapability wrappedCapability = new WrappedCapability(resource, capability);
            }
            openHashMap.put((String)object.getAttributes().get("osgi.wiring.package"), new Blame((Capability)object, null));
        }
        if (!openHashMap.isEmpty() && wiring == null) {
            for (Requirement requirement : resource.getRequirements(null)) {
                Capability capability;
                if (!requirement.getNamespace().equals("osgi.wiring.package") || (capability = candidates.getFirstCandidate(requirement)) == null) continue;
                String string = (String)capability.getAttributes().get("osgi.wiring.package");
                openHashMap.remove(string);
            }
        }
        return openHashMap;
    }

    private static boolean isCompatible(Blame blame, Capability capability, Map<Resource, Packages> map) {
        if (blame.m_cap.equals(capability)) {
            return true;
        }
        Set<Capability> set = ResolverImpl.getPackageSources(capability, map);
        Set<Capability> set2 = ResolverImpl.getPackageSources(blame.m_cap, map);
        return set2.containsAll(set) || set.containsAll(set2);
    }

    private static boolean isCompatible(List<Blame> list, Capability capability, Map<Resource, Packages> map) {
        int n = list.size();
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                return ResolverImpl.isCompatible(list.get(0), capability, map);
            }
        }
        HashSet<Capability> hashSet = new HashSet<Capability>(list.size());
        for (Blame set2 : list) {
            Set<Capability> set = ResolverImpl.getPackageSources(set2.m_cap, map);
            hashSet.addAll(set);
        }
        Set<Capability> set = ResolverImpl.getPackageSources(capability, map);
        return hashSet.containsAll(set) || set.containsAll(hashSet);
    }

    private static Set<Capability> getPackageSources(Capability capability, Map<Resource, Packages> map) {
        Resource resource = capability.getResource();
        if (resource == null) {
            return new HashSet<Capability>();
        }
        OpenHashMap<Capability, Set<Capability>> openHashMap = map.get((Object)resource).m_sources;
        if (openHashMap == null) {
            return new HashSet<Capability>();
        }
        Set<Capability> set = openHashMap.get(capability);
        if (set == null) {
            return new HashSet<Capability>();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private static void getPackageSourcesInternal(ResolveSession resolveSession, Map<Resource, Packages> map, Resource resource, Packages packages) {
        Collection<Object> collection;
        String string;
        Wiring wiring = resolveSession.getContext().getWirings().get(resource);
        List<Capability> list = wiring != null ? wiring.getResourceCapabilities(null) : resource.getCapabilities(null);
        OpenHashMap<String, Set<Capability>> openHashMap = new OpenHashMap<String, Set<Capability>>(list.size()){

            @Override
            public Set<Capability> compute(String string) {
                return new HashSet<Capability>();
            }
        };
        OpenHashMap<Capability, Set<Capability>> openHashMap2 = packages.m_sources;
        for (Capability capability : list) {
            if (capability.getNamespace().equals("osgi.wiring.package")) {
                void object;
                string = (String)capability.getAttributes().get("osgi.wiring.package");
                collection = (Set)openHashMap.getOrCompute(string);
                if (!resource.equals(capability.getResource())) {
                    WrappedCapability wrappedCapability = new WrappedCapability(resource, capability);
                }
                openHashMap2.put((Capability)object, (Set<Capability>)collection);
                collection.add(object);
                continue;
            }
            string = capability.getDirectives().get("uses");
            if (string != null && string.length() > 0) {
                openHashMap2.put(capability, Collections.singleton(capability));
                continue;
            }
            openHashMap2.put(capability, Collections.emptySet());
        }
        for (Map.Entry entry : openHashMap.fast()) {
            string = (String)entry.getKey();
            collection = packages.m_requiredPkgs.get(string);
            if (collection == null) continue;
            Set set = (Set)entry.getValue();
            for (Blame blame : collection) {
                Capability capability = blame.m_cap;
                if (!set.add(capability)) continue;
                Resource resource2 = capability.getResource();
                Packages packages2 = map.get(resource2);
                Set<Capability> set2 = packages2.m_sources.get(capability);
                if (set2 == null) {
                    ResolverImpl.getPackageSourcesInternal(resolveSession, map, resource2, packages2);
                    set2 = packages2.m_sources.get(capability);
                }
                set.addAll(set2);
            }
        }
    }

    private static Resource getDeclaredResource(Resource resource) {
        if (resource instanceof WrappedResource) {
            return ((WrappedResource)resource).getDeclaredResource();
        }
        return resource;
    }

    private static Capability getDeclaredCapability(Capability capability) {
        if (capability instanceof HostedCapability) {
            return ((HostedCapability)capability).getDeclaredCapability();
        }
        return capability;
    }

    private static Requirement getDeclaredRequirement(Requirement requirement) {
        if (requirement instanceof WrappedRequirement) {
            return ((WrappedRequirement)requirement).getDeclaredRequirement();
        }
        return requirement;
    }

    private static Map<Resource, List<Wire>> populateWireMap(ResolveContext resolveContext, Resource resource, Map<Resource, List<Wire>> map, Candidates candidates) {
        Resource resource2 = ResolverImpl.getDeclaredResource(resource);
        if (!resolveContext.getWirings().containsKey(resource2) && !map.containsKey(resource2)) {
            Wire wire;
            map.put(resource2, Collections.emptyList());
            ArrayList<WireImpl> arrayList = new ArrayList<WireImpl>();
            ArrayList<WireImpl> arrayList2 = new ArrayList<WireImpl>();
            ArrayList<WireImpl> arrayList3 = new ArrayList<WireImpl>();
            block0: for (Requirement object : resource.getRequirements(null)) {
                List<Capability> list = candidates.getCandidates(object);
                if (list == null || list.size() <= 0) continue;
                for (Capability capability : list) {
                    if (!capability.getNamespace().startsWith("osgi.wiring.") || !resource.equals(capability.getResource())) {
                        ResolverImpl.populateWireMap(resolveContext, capability.getResource(), map, candidates);
                        Resource resource3 = object.getNamespace().equals("osgi.identity") ? ResolverImpl.getDeclaredCapability(capability).getResource() : ResolverImpl.getDeclaredResource(capability.getResource());
                        wire = new WireImpl(resource2, ResolverImpl.getDeclaredRequirement(object), resource3, ResolverImpl.getDeclaredCapability(capability));
                        if (object.getNamespace().equals("osgi.wiring.package")) {
                            arrayList.add((WireImpl)wire);
                        } else if (object.getNamespace().equals("osgi.wiring.bundle")) {
                            arrayList2.add((WireImpl)wire);
                        } else {
                            arrayList3.add((WireImpl)wire);
                        }
                    }
                    if (!Util.isMultiple(object)) continue block0;
                }
            }
            arrayList.addAll(arrayList2);
            arrayList.addAll(arrayList3);
            map.put(resource2, arrayList);
            if (resource instanceof WrappedResource) {
                List<Resource> list = ((WrappedResource)resource).getFragments();
                for (Object resource4 : list) {
                    ArrayList<WireImpl> arrayList5 = map.get(resource4);
                    arrayList5 = arrayList5 == null ? new ArrayList<WireImpl>() : arrayList5;
                    for (Requirement requirement : resource4.getRequirements(null)) {
                        if (ResolverImpl.isPayload(requirement)) continue;
                        if (requirement.getNamespace().equals("osgi.wiring.host")) {
                            arrayList5.add(new WireImpl(ResolverImpl.getDeclaredResource((Resource)resource4), requirement, resource2, resource2.getCapabilities("osgi.wiring.host").get(0)));
                            continue;
                        }
                        if (resolveContext.getWirings().containsKey(resource4) || map.containsKey(resource4) || (wire = ResolverImpl.createWire(requirement, candidates)) == null) continue;
                        arrayList5.add((WireImpl)wire);
                    }
                    map.put((Resource)resource4, arrayList5);
                }
            }
        }
        return map;
    }

    private static Wire createWire(Requirement requirement, Candidates candidates) {
        Capability capability = candidates.getFirstCandidate(requirement);
        if (capability == null) {
            return null;
        }
        return new WireImpl(ResolverImpl.getDeclaredResource(requirement.getResource()), ResolverImpl.getDeclaredRequirement(requirement), ResolverImpl.getDeclaredResource(capability.getResource()), ResolverImpl.getDeclaredCapability(capability));
    }

    private static boolean isPayload(Requirement requirement) {
        if ("osgi.ee".equals(requirement.getNamespace())) {
            return false;
        }
        return !"osgi.wiring.host".equals(requirement.getNamespace());
    }

    private static Map<Resource, List<Wire>> populateDynamicWireMap(ResolveContext resolveContext, Resource resource, Requirement requirement, Map<Resource, List<Wire>> map, Candidates candidates) {
        map.put(resource, Collections.emptyList());
        ArrayList<WireImpl> arrayList = new ArrayList<WireImpl>();
        Capability capability = candidates.getFirstCandidate(requirement);
        if (!resolveContext.getWirings().containsKey(capability.getResource())) {
            ResolverImpl.populateWireMap(resolveContext, capability.getResource(), map, candidates);
        }
        arrayList.add(new WireImpl(resource, requirement, ResolverImpl.getDeclaredResource(capability.getResource()), ResolverImpl.getDeclaredCapability(capability)));
        map.put(resource, arrayList);
        return map;
    }

    private static void dumpResourcePkgMap(ResolveContext resolveContext, Map<Resource, Packages> map) {
        System.out.println("+++RESOURCE PKG MAP+++");
        for (Map.Entry<Resource, Packages> entry : map.entrySet()) {
            ResolverImpl.dumpResourcePkgs(resolveContext, entry.getKey(), entry.getValue());
        }
    }

    private static void dumpResourcePkgs(ResolveContext resolveContext, Resource resource, Packages packages) {
        Wiring wiring = resolveContext.getWirings().get(resource);
        System.out.println(resource + " (" + (wiring != null ? "RESOLVED)" : "UNRESOLVED)"));
        System.out.println("  EXPORTED");
        for (Map.Entry entry : packages.m_exportedPkgs.entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  IMPORTED");
        for (Map.Entry entry : packages.m_importedPkgs.entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  REQUIRED");
        for (Map.Entry entry : packages.m_requiredPkgs.entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  USED");
        for (Map.Entry entry : packages.m_usedPkgs.entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " - " + ((ArrayMap)entry.getValue()).values());
        }
    }

    private static class Blame {
        public final Capability m_cap;
        public final List<Requirement> m_reqs;

        public Blame(Capability capability, List<Requirement> list) {
            this.m_cap = capability;
            this.m_reqs = list;
        }

        public String toString() {
            return this.m_cap.getResource() + "." + this.m_cap.getAttributes().get("osgi.wiring.package") + (this.m_reqs == null || this.m_reqs.isEmpty() ? " NO BLAME" : " BLAMED ON " + this.m_reqs);
        }

        public boolean equals(Object object) {
            return object instanceof Blame && this.m_reqs.equals(((Blame)object).m_reqs) && this.m_cap.equals(((Blame)object).m_cap);
        }
    }

    static class DumbExecutor
    implements Executor {
        DumbExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    }

    private static class EnhancedExecutor {
        private final Executor executor;
        private final AtomicInteger count = new AtomicInteger();
        private Throwable throwable;

        public EnhancedExecutor(Executor executor) {
            this.executor = executor;
        }

        public void execute(final Runnable runnable) {
            this.count.incrementAndGet();
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block20: {
                        try {
                            try {
                                runnable.run();
                            }
                            catch (Throwable throwable) {
                                AtomicInteger atomicInteger = EnhancedExecutor.this.count;
                                synchronized (atomicInteger) {
                                    if (EnhancedExecutor.this.throwable == null) {
                                        EnhancedExecutor.this.throwable = throwable;
                                    }
                                }
                                if (EnhancedExecutor.this.count.decrementAndGet() != 0) break block20;
                                AtomicInteger atomicInteger2 = EnhancedExecutor.this.count;
                                synchronized (atomicInteger2) {
                                    EnhancedExecutor.this.count.notifyAll();
                                    break block20;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            if (EnhancedExecutor.this.count.decrementAndGet() == 0) {
                                AtomicInteger atomicInteger = EnhancedExecutor.this.count;
                                synchronized (atomicInteger) {
                                    EnhancedExecutor.this.count.notifyAll();
                                }
                            }
                            throw throwable;
                        }
                        if (EnhancedExecutor.this.count.decrementAndGet() == 0) {
                            AtomicInteger atomicInteger = EnhancedExecutor.this.count;
                            synchronized (atomicInteger) {
                                EnhancedExecutor.this.count.notifyAll();
                            }
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await() {
            AtomicInteger atomicInteger = this.count;
            synchronized (atomicInteger) {
                if (this.count.get() > 0) {
                    try {
                        this.count.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IllegalStateException(interruptedException);
                    }
                    if (this.throwable != null) {
                        if (this.throwable instanceof RuntimeException) {
                            throw (RuntimeException)this.throwable;
                        }
                        if (this.throwable instanceof Error) {
                            throw (Error)this.throwable;
                        }
                        throw new RuntimeException(this.throwable);
                    }
                }
            }
        }
    }

    public static class Packages {
        public final OpenHashMap<String, Blame> m_exportedPkgs;
        public final OpenHashMap<String, List<Blame>> m_importedPkgs;
        public final OpenHashMap<String, List<Blame>> m_requiredPkgs;
        public final OpenHashMap<String, ArrayMap<Capability, UsedBlames>> m_usedPkgs;
        public final OpenHashMap<Capability, Set<Capability>> m_sources;

        public Packages(Resource resource) {
            int n = resource.getCapabilities(null).size();
            int n2 = resource.getRequirements(null).size();
            this.m_exportedPkgs = new OpenHashMap(n);
            this.m_importedPkgs = new OpenHashMap<String, List<Blame>>(n2){

                @Override
                public List<Blame> compute(String string) {
                    return new ArrayList<Blame>();
                }
            };
            this.m_requiredPkgs = new OpenHashMap<String, List<Blame>>(n2){

                @Override
                public List<Blame> compute(String string) {
                    return new ArrayList<Blame>();
                }
            };
            this.m_usedPkgs = new OpenHashMap<String, ArrayMap<Capability, UsedBlames>>(128){

                @Override
                protected ArrayMap<Capability, UsedBlames> compute(String string) {
                    return new ArrayMap<Capability, UsedBlames>(){

                        @Override
                        protected UsedBlames compute(Capability capability) {
                            return new UsedBlames(capability);
                        }
                    };
                }
            };
            this.m_sources = new OpenHashMap(n);
        }
    }

    class ResolveSession {
        private final ResolveContext m_resolveContext;
        private final List<Candidates> m_usesPermutations = new ArrayList<Candidates>();
        private final List<Candidates> m_importPermutations = new ArrayList<Candidates>();
        private Candidates m_multipleCardCandidates = null;
        private final ConcurrentMap<String, List<String>> m_usesCache = new ConcurrentHashMap<String, List<String>>();

        ResolveSession(ResolveContext resolveContext) {
            this.m_resolveContext = resolveContext;
        }

        Candidates getMultipleCardCandidates() {
            return this.m_multipleCardCandidates;
        }

        void setMultipleCardCandidates(Candidates candidates) {
            this.m_multipleCardCandidates = candidates;
        }

        ResolveContext getContext() {
            return this.m_resolveContext;
        }

        public ConcurrentMap<String, List<String>> getUsesCache() {
            return this.m_usesCache;
        }
    }

    private static final class UseConstraintError
    extends ResolutionError {
        private final ResolveContext m_context;
        private final Candidates m_allCandidates;
        private final Resource m_resource;
        private final String m_pkgName;
        private final Blame m_blame1;
        private final Blame m_blame2;

        public UseConstraintError(ResolveContext resolveContext, Candidates candidates, Resource resource, String string, Blame blame) {
            this(resolveContext, candidates, resource, string, blame, null);
        }

        public UseConstraintError(ResolveContext resolveContext, Candidates candidates, Resource resource, String string, Blame blame, Blame blame2) {
            this.m_context = resolveContext;
            this.m_allCandidates = candidates;
            this.m_resource = resource;
            this.m_pkgName = string;
            if (blame == null) {
                throw new NullPointerException("First blame cannot be null.");
            }
            this.m_blame1 = blame;
            this.m_blame2 = blame2;
        }

        @Override
        public String getMessage() {
            if (this.m_blame2 == null) {
                return "Uses constraint violation. Unable to resolve resource " + Util.getSymbolicName(this.m_resource) + " [" + this.m_resource + "] because it exports package '" + this.m_pkgName + "' and is also exposed to it from resource " + Util.getSymbolicName(this.m_blame1.m_cap.getResource()) + " [" + this.m_blame1.m_cap.getResource() + "] via the following dependency chain:\n\n" + this.toStringBlame(this.m_blame1);
            }
            return "Uses constraint violation. Unable to resolve resource " + Util.getSymbolicName(this.m_resource) + " [" + this.m_resource + "] because it is exposed to package '" + this.m_pkgName + "' from resources " + Util.getSymbolicName(this.m_blame1.m_cap.getResource()) + " [" + this.m_blame1.m_cap.getResource() + "] and " + Util.getSymbolicName(this.m_blame2.m_cap.getResource()) + " [" + this.m_blame2.m_cap.getResource() + "] via two dependency chains.\n\nChain 1:\n" + this.toStringBlame(this.m_blame1) + "\n\nChain 2:\n" + this.toStringBlame(this.m_blame2);
        }

        @Override
        public Collection<Requirement> getUnresolvedRequirements() {
            if (this.m_blame2 == null) {
                return Collections.singleton(this.m_blame1.m_reqs.get(0));
            }
            return Collections.singleton(this.m_blame2.m_reqs.get(0));
        }

        private String toStringBlame(Blame blame) {
            StringBuilder stringBuilder = new StringBuilder();
            if (blame.m_reqs != null && !blame.m_reqs.isEmpty()) {
                int n = 0;
                while (n < blame.m_reqs.size()) {
                    Object object;
                    Capability capability;
                    Requirement requirement = blame.m_reqs.get(n);
                    stringBuilder.append("  ");
                    stringBuilder.append(Util.getSymbolicName(requirement.getResource()));
                    stringBuilder.append(" [");
                    stringBuilder.append(requirement.getResource().toString());
                    stringBuilder.append("]\n");
                    if (requirement.getNamespace().equals("osgi.wiring.package")) {
                        stringBuilder.append("    import: ");
                    } else {
                        stringBuilder.append("    require: ");
                    }
                    stringBuilder.append(requirement.getDirectives().get("filter"));
                    stringBuilder.append("\n     |");
                    if (requirement.getNamespace().equals("osgi.wiring.package")) {
                        stringBuilder.append("\n    export: ");
                    } else {
                        stringBuilder.append("\n    provide: ");
                    }
                    if (n + 1 < blame.m_reqs.size()) {
                        capability = this.getSatisfyingCapability(blame.m_reqs.get(n));
                        if (capability.getNamespace().equals("osgi.wiring.package")) {
                            stringBuilder.append("osgi.wiring.package");
                            stringBuilder.append("=");
                            stringBuilder.append(capability.getAttributes().get("osgi.wiring.package"));
                            object = this.getSatisfyingCapability(blame.m_reqs.get(n + 1));
                            stringBuilder.append("; uses:=");
                            stringBuilder.append(object.getAttributes().get("osgi.wiring.package"));
                        } else {
                            stringBuilder.append(capability);
                        }
                        stringBuilder.append("\n");
                    } else {
                        capability = this.getSatisfyingCapability(blame.m_reqs.get(n));
                        stringBuilder.append(capability.getNamespace());
                        stringBuilder.append(": ");
                        object = capability.getAttributes().get(capability.getNamespace());
                        if (object != null) {
                            stringBuilder.append(object.toString());
                        } else {
                            for (Map.Entry<String, Object> entry : capability.getAttributes().entrySet()) {
                                stringBuilder.append(entry.getKey()).append('=').append(entry.getValue()).append(';');
                            }
                        }
                        if (capability.getNamespace().equals("osgi.wiring.package") && !capability.getAttributes().get("osgi.wiring.package").equals(blame.m_cap.getAttributes().get("osgi.wiring.package"))) {
                            stringBuilder.append("; uses:=");
                            stringBuilder.append(blame.m_cap.getAttributes().get("osgi.wiring.package"));
                            stringBuilder.append("\n    export: ");
                            stringBuilder.append("osgi.wiring.package");
                            stringBuilder.append("=");
                            stringBuilder.append(blame.m_cap.getAttributes().get("osgi.wiring.package"));
                        }
                        stringBuilder.append("\n  ");
                        stringBuilder.append(Util.getSymbolicName(blame.m_cap.getResource()));
                        stringBuilder.append(" [");
                        stringBuilder.append(blame.m_cap.getResource().toString());
                        stringBuilder.append("]");
                    }
                    ++n;
                }
            } else {
                stringBuilder.append(blame.m_cap.getResource().toString());
            }
            return stringBuilder.toString();
        }

        private Capability getSatisfyingCapability(Requirement requirement) {
            Capability capability = this.m_allCandidates.getFirstCandidate(requirement);
            if (capability == null && this.m_context.getWirings().containsKey(requirement.getResource())) {
                List<Wire> list = this.m_context.getWirings().get(requirement.getResource()).getRequiredResourceWires(null);
                requirement = ResolverImpl.getDeclaredRequirement(requirement);
                for (Wire wire : list) {
                    if (!wire.getRequirement().equals(requirement)) continue;
                    capability = wire.getCapability();
                    break;
                }
            }
            return capability;
        }
    }

    private static class UsedBlames {
        public final Capability m_cap;
        public final List<Blame> m_blames = new ArrayList<Blame>();
        private Map<Requirement, Set<Capability>> m_rootCauses;

        public UsedBlames(Capability capability) {
            this.m_cap = capability;
        }

        public void addBlame(Blame blame, Capability capability) {
            Requirement requirement;
            if (!this.m_cap.equals(blame.m_cap)) {
                throw new IllegalArgumentException("Attempt to add a blame with a different used capability: " + blame.m_cap);
            }
            this.m_blames.add(blame);
            if (capability != null && Util.isMultiple(requirement = blame.m_reqs.get(0))) {
                Set<Capability> set;
                if (this.m_rootCauses == null) {
                    this.m_rootCauses = new HashMap<Requirement, Set<Capability>>();
                }
                if ((set = this.m_rootCauses.get(requirement)) == null) {
                    set = new HashSet<Capability>();
                    this.m_rootCauses.put(requirement, set);
                }
                set.add(capability);
            }
        }

        public Set<Capability> getRootCauses(Requirement requirement) {
            if (this.m_rootCauses == null) {
                return Collections.emptySet();
            }
            Set<Capability> set = this.m_rootCauses.get(requirement);
            return set == null ? Collections.emptySet() : set;
        }

        public String toString() {
            return this.m_blames.toString();
        }
    }

    private static final class WireCandidate {
        public final Requirement requirement;
        public final Capability capability;

        public WireCandidate(Requirement requirement, Capability capability) {
            this.requirement = requirement;
            this.capability = capability;
        }
    }
}

