/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import org.apache.felix.resolver.ResolutionError;
import org.osgi.resource.Resource;

public class Logger {
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    private int m_logLevel = 1;

    public Logger(int n) {
        this.m_logLevel = n;
    }

    public final synchronized void setLogLevel(int n) {
        this.m_logLevel = n;
    }

    public final synchronized int getLogLevel() {
        return this.m_logLevel;
    }

    public final void log(int n, String string) {
        this._log(n, string, null);
    }

    public final void log(int n, String string, Throwable throwable) {
        this._log(n, string, throwable);
    }

    public boolean isDebugEnabled() {
        return this.m_logLevel >= 4;
    }

    public final void debug(String string) {
        this._log(4, string, null);
    }

    protected void doLog(int n, String string, Throwable throwable) {
        if (n > this.m_logLevel) {
            return;
        }
        String string2 = string;
        if (throwable != null) {
            string2 = String.valueOf(string2) + " (" + throwable + ")";
        }
        switch (n) {
            case 4: {
                System.out.println("DEBUG: " + string2);
                break;
            }
            case 1: {
                System.out.println("ERROR: " + string2);
                if (throwable == null) break;
                throwable.printStackTrace();
                break;
            }
            case 3: {
                System.out.println("INFO: " + string2);
                break;
            }
            case 2: {
                System.out.println("WARNING: " + string2);
                break;
            }
            default: {
                System.out.println("UNKNOWN[" + n + "]: " + string2);
            }
        }
    }

    private void _log(int n, String string, Throwable throwable) {
        if (this.m_logLevel >= n) {
            this.doLog(n, string, throwable);
        }
    }

    public void logUsesConstraintViolation(Resource resource, ResolutionError resolutionError) {
    }
}

