/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.resolver.FelixResolveContext;
import org.apache.felix.resolver.ResolutionError;
import org.apache.felix.resolver.SimpleHostedCapability;
import org.apache.felix.resolver.Util;
import org.apache.felix.resolver.WrappedCapability;
import org.apache.felix.resolver.WrappedRequirement;
import org.apache.felix.resolver.WrappedResource;
import org.apache.felix.resolver.util.CopyOnWriteList;
import org.apache.felix.resolver.util.CopyOnWriteSet;
import org.apache.felix.resolver.util.OpenHashMap;
import org.apache.felix.resolver.util.OpenHashMapList;
import org.apache.felix.resolver.util.OpenHashMapSet;
import org.apache.felix.resolver.util.ShadowList;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolveContext;

class Candidates {
    private final Set<Resource> m_mandatoryResources;
    private final OpenHashMapSet<Capability, Requirement> m_dependentMap;
    private final OpenHashMapList<Requirement, Capability> m_candidateMap;
    private final Map<Resource, WrappedResource> m_allWrappedHosts;
    private final OpenHashMap<Resource, PopulateResult> m_populateResultCache;
    private final Map<Resource, Boolean> m_validOnDemandResources;
    private final Map<Capability, Requirement> m_subtitutableMap;
    private final OpenHashMapSet<Requirement, Capability> m_delta;
    private static final int UNPROCESSED = 0;
    private static final int PROCESSING = 1;
    private static final int SUBSTITUTED = 2;
    private static final int EXPORTED = 3;

    private Candidates(Set<Resource> set, OpenHashMapSet<Capability, Requirement> openHashMapSet, OpenHashMapList<Requirement, Capability> openHashMapList, Map<Resource, WrappedResource> map, OpenHashMap<Resource, PopulateResult> openHashMap, Map<Resource, Boolean> map2, Map<Capability, Requirement> map3, OpenHashMapSet<Requirement, Capability> openHashMapSet2) {
        this.m_mandatoryResources = set;
        this.m_dependentMap = openHashMapSet;
        this.m_candidateMap = openHashMapList;
        this.m_allWrappedHosts = map;
        this.m_populateResultCache = openHashMap;
        this.m_validOnDemandResources = map2;
        this.m_subtitutableMap = map3;
        this.m_delta = openHashMapSet2;
    }

    public Candidates(Map<Resource, Boolean> map) {
        this.m_mandatoryResources = new HashSet<Resource>();
        this.m_dependentMap = new OpenHashMapSet();
        this.m_candidateMap = new OpenHashMapList();
        this.m_allWrappedHosts = new HashMap<Resource, WrappedResource>();
        this.m_populateResultCache = new OpenHashMap();
        this.m_validOnDemandResources = map;
        this.m_subtitutableMap = new OpenHashMap<Capability, Requirement>();
        this.m_delta = new OpenHashMapSet(3);
    }

    public int getNbResources() {
        return this.m_populateResultCache.size();
    }

    /*
     * WARNING - void declaration
     */
    public Map<Resource, Resource> getHosts() {
        HashMap<Resource, Resource> hashMap = new HashMap<Resource, Resource>();
        for (Resource resource : this.m_mandatoryResources) {
            void object;
            if (resource instanceof WrappedResource) {
                Resource resource2 = ((WrappedResource)resource).getDeclaredResource();
            }
            if (Util.isFragment((Resource)object)) continue;
            hashMap.put((Resource)object, this.getWrappedHost((Resource)object));
        }
        for (Capability capability : this.m_dependentMap.keySet()) {
            Resource resource = capability.getResource();
            if (resource instanceof WrappedResource) {
                resource = ((WrappedResource)resource).getDeclaredResource();
            }
            if (Util.isFragment(resource)) continue;
            hashMap.put(resource, this.getWrappedHost(resource));
        }
        return hashMap;
    }

    public Object getDelta() {
        return this.m_delta;
    }

    public void addMandatoryResources(Collection<Resource> collection) {
        this.m_mandatoryResources.addAll(collection);
    }

    public ResolutionError populate(ResolveContext resolveContext, Collection<Resource> collection) {
        Object object;
        Object object2;
        HashSet<Resource> hashSet = new HashSet<Resource>();
        LinkedList<Resource> linkedList = new LinkedList<Resource>(collection);
        while (!linkedList.isEmpty()) {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            object2 = linkedList.getFirst();
            object = this.m_populateResultCache.get(object2);
            if (object == null) {
                object = new PopulateResult();
                ((PopulateResult)object).candidates = new OpenHashMap<Requirement, List<Capability>>();
                ((PopulateResult)object).remaining = new ArrayList<Requirement>(object2.getRequirements(null));
                this.m_populateResultCache.put((Resource)object2, (PopulateResult)object);
            }
            if (((PopulateResult)object).success || ((PopulateResult)object).error != null) {
                linkedList.removeFirst();
                continue;
            }
            if (((PopulateResult)object).remaining.isEmpty()) {
                linkedList.removeFirst();
                ((PopulateResult)object).success = true;
                this.addCandidates(((PopulateResult)object).candidates);
                ((PopulateResult)object).candidates = null;
                ((PopulateResult)object).remaining = null;
                if (!(resolveContext instanceof FelixResolveContext) || Util.isFragment((Resource)object2)) continue;
                object6 = ((FelixResolveContext)((Object)resolveContext)).getOndemandResources((Resource)object2);
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    object4 = (Resource)object5.next();
                    object3 = this.m_validOnDemandResources.get(object4);
                    if (object3 == null) {
                        this.m_validOnDemandResources.put((Resource)object4, Boolean.TRUE);
                        object3 = Boolean.TRUE;
                    }
                    if (!((Boolean)object3).booleanValue()) continue;
                    linkedList.addFirst((Resource)object4);
                }
                continue;
            }
            object6 = ((PopulateResult)object).remaining.remove(0);
            if (!this.isEffective(resolveContext, (Requirement)object6)) continue;
            object4 = resolveContext.findProviders((Requirement)object6);
            object5 = new LinkedList<Resource>();
            object3 = this.processCandidates(resolveContext, (LinkedList<Resource>)object5, (Requirement)object6, (List<Capability>)object4);
            if (object4.isEmpty() && !Util.isOptional((Requirement)object6)) {
                if (Util.isFragment((Resource)object2) && resolveContext.getWirings().containsKey(object2)) {
                    ((PopulateResult)object).success = true;
                } else {
                    ((PopulateResult)object).error = new MissingRequirementError((Requirement)object6, (ResolutionError)object3);
                    hashSet.add((Resource)object2);
                }
                linkedList.removeFirst();
                continue;
            }
            if (!object4.isEmpty()) {
                ((PopulateResult)object).candidates.put((Requirement)object6, (List<Capability>)object4);
            }
            if (((AbstractCollection)object5).isEmpty()) continue;
            linkedList.addAll(0, (Collection<Resource>)object5);
        }
        while (!hashSet.isEmpty()) {
            object2 = hashSet.iterator();
            object = (Resource)object2.next();
            object2.remove();
            this.remove((Resource)object, hashSet);
        }
        return null;
    }

    private boolean isEffective(ResolveContext resolveContext, Requirement requirement) {
        if (!resolveContext.isEffective(requirement)) {
            return false;
        }
        String string = requirement.getDirectives().get("resolution");
        return !"dynamic".equals(string);
    }

    private boolean isMandatory(ResolveContext resolveContext, Requirement requirement) {
        if (Util.isOptional(requirement)) {
            return false;
        }
        Resource resource = requirement.getResource();
        return !Util.isFragment(resource) || !resolveContext.getWirings().containsKey(resource);
    }

    private void populateSubstitutables() {
        for (Map.Entry<Resource, PopulateResult> entry : this.m_populateResultCache.fast()) {
            if (!entry.getValue().success) continue;
            this.populateSubstitutables(entry.getKey());
        }
    }

    private void populateSubstitutables(Resource resource) {
        Object object;
        Object object2;
        OpenHashMap<String, List<Capability>> openHashMap = new OpenHashMap<String, List<Capability>>(){

            @Override
            protected List<Capability> compute(String string) {
                return new ArrayList<Capability>(1);
            }
        };
        for (Capability object3 : resource.getCapabilities(null)) {
            if (!"osgi.wiring.package".equals(object3.getNamespace())) continue;
            object2 = (String)object3.getAttributes().get("osgi.wiring.package");
            object = (List)openHashMap.getOrCompute((String)object2);
            object.add(object3);
        }
        if (openHashMap.isEmpty()) {
            return;
        }
        for (Requirement requirement : resource.getRequirements(null)) {
            List list;
            if (!"osgi.wiring.package".equals(requirement.getNamespace()) || (object2 = (List)this.m_candidateMap.get(requirement)) == null || object2.isEmpty() || (list = (List)openHashMap.get(object = (String)((Capability)object2.get(0)).getAttributes().get("osgi.wiring.package"))) == null || list.containsAll((Collection<?>)object2)) continue;
            for (Capability capability : list) {
                this.m_subtitutableMap.put(capability, requirement);
            }
        }
    }

    ResolutionError checkSubstitutes(List<Candidates> list) {
        OpenHashMap<Capability, Integer> openHashMap = new OpenHashMap<Capability, Integer>(this.m_subtitutableMap.size());
        for (Capability object : this.m_subtitutableMap.keySet()) {
            openHashMap.put(object, 0);
        }
        for (Capability capability : this.m_subtitutableMap.keySet()) {
            this.isSubstituted(capability, openHashMap);
        }
        for (Map.Entry entry : openHashMap.fast()) {
            Set set;
            Requirement requirement = this.m_subtitutableMap.get(entry.getKey());
            if (requirement != null) {
                this.permutateIfNeeded(requirement, list);
            }
            if ((set = (Set)this.m_dependentMap.get(entry.getKey())) == null) continue;
            for (Requirement requirement2 : set) {
                List list2 = (List)this.m_candidateMap.get(requirement2);
                if (list2 == null) continue;
                Iterator iterator = list2.iterator();
                block7: while (iterator.hasNext()) {
                    Capability capability = (Capability)iterator.next();
                    Integer n = openHashMap.get(capability);
                    if (n == null) {
                        n = 3;
                    }
                    switch (n) {
                        case 3: {
                            break block7;
                        }
                        default: {
                            iterator.remove();
                        }
                    }
                }
                if (!list2.isEmpty()) continue;
                if (Util.isOptional(requirement2)) {
                    this.m_candidateMap.remove(requirement2);
                    continue;
                }
                return new MissingRequirementError(requirement2);
            }
        }
        return null;
    }

    private boolean isSubstituted(Capability capability, Map<Capability, Integer> map) {
        Integer n = map.get(capability);
        if (n == null) {
            return false;
        }
        switch (n) {
            case 1: {
                map.put(capability, 3);
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        Requirement requirement = this.m_subtitutableMap.get(capability);
        if (requirement == null) {
            return false;
        }
        map.put(capability, 1);
        List list = (List)this.m_candidateMap.get(requirement);
        if (list != null) {
            for (Capability capability2 : list) {
                if (capability2.getResource().equals(capability.getResource())) {
                    map.put(capability, 3);
                    return false;
                }
                if (this.isSubstituted(capability2, map)) continue;
                map.put(capability, 2);
                return true;
            }
        }
        map.put(capability, 3);
        return false;
    }

    public ResolutionError populateDynamic(ResolveContext resolveContext, Resource resource, Requirement requirement, List<Capability> list) {
        this.m_mandatoryResources.add(resource);
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        ResolutionError resolutionError = this.processCandidates(resolveContext, linkedList, requirement, list);
        this.addCandidates(requirement, list);
        this.populate(resolveContext, linkedList);
        CopyOnWriteList copyOnWriteList = (CopyOnWriteList)this.m_candidateMap.get(requirement);
        if (copyOnWriteList != null) {
            list.retainAll(copyOnWriteList);
        } else {
            list.clear();
        }
        if (list.isEmpty()) {
            if (resolutionError == null) {
                resolutionError = new DynamicImportFailed(requirement);
            }
            return resolutionError;
        }
        PopulateResult populateResult = new PopulateResult();
        populateResult.success = true;
        this.m_populateResultCache.put(resource, populateResult);
        return null;
    }

    private ResolutionError processCandidates(ResolveContext resolveContext, LinkedList<Resource> linkedList, Requirement requirement, List<Capability> list) {
        Object object;
        ResolutionError resolutionError = null;
        HashSet<Object> hashSet = null;
        Object object22 = list.iterator();
        while (object22.hasNext()) {
            Capability capability = object22.next();
            boolean bl = Util.isFragment(capability.getResource());
            if (bl) {
                if (hashSet == null) {
                    hashSet = new HashSet<Object>();
                }
                hashSet.add(capability);
            }
            if (!bl && resolveContext.getWirings().containsKey(capability.getResource()) || capability.getResource().equals(requirement.getResource())) continue;
            object = this.m_populateResultCache.get(capability.getResource());
            if (object != null) {
                if (((PopulateResult)object).error != null) {
                    if (resolutionError == null) {
                        resolutionError = ((PopulateResult)object).error;
                    }
                    object22.remove();
                    continue;
                }
                if (((PopulateResult)object).success) continue;
                linkedList.add(capability.getResource());
                continue;
            }
            linkedList.add(capability.getResource());
        }
        if (hashSet != null) {
            for (Object object22 : hashSet) {
                String string = object22.getNamespace();
                if ("osgi.identity".equals(string) || (object = resolveContext.getWirings().get(object22.getResource())) == null) continue;
                for (Wire wire : object.getRequiredResourceWires("osgi.wiring.host")) {
                    if (string.equals("osgi.wiring.package") && !resolveContext.getWirings().get(wire.getProvider()).getResourceCapabilities(null).contains(object22)) continue;
                    list.remove(object22);
                    resolveContext.insertHostedCapability(list, new WrappedCapability(wire.getCapability().getResource(), (Capability)object22));
                }
            }
        }
        return resolutionError;
    }

    public boolean isPopulated(Resource resource) {
        PopulateResult populateResult = this.m_populateResultCache.get(resource);
        return populateResult != null && populateResult.success;
    }

    public ResolutionError getResolutionError(Resource resource) {
        PopulateResult populateResult = this.m_populateResultCache.get(resource);
        return populateResult != null ? populateResult.error : null;
    }

    private void addCandidates(Requirement requirement, List<Capability> list) {
        this.m_candidateMap.put(requirement, (Capability)((Object)new CopyOnWriteList<Capability>(list)));
        for (Capability capability : list) {
            ((CopyOnWriteSet)this.m_dependentMap.getOrCompute(capability)).add(requirement);
        }
    }

    private void addCandidates(Map<Requirement, List<Capability>> map) {
        for (Map.Entry<Requirement, List<Capability>> entry : map.entrySet()) {
            this.addCandidates(entry.getKey(), entry.getValue());
        }
    }

    public Resource getWrappedHost(Resource resource) {
        Resource resource2 = this.m_allWrappedHosts.get(resource);
        return resource2 == null ? resource : resource2;
    }

    public List<Capability> getCandidates(Requirement requirement) {
        List list = (List)this.m_candidateMap.get(requirement);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return null;
    }

    public Capability getFirstCandidate(Requirement requirement) {
        List list = (List)this.m_candidateMap.get(requirement);
        if (list != null && !list.isEmpty()) {
            return (Capability)list.get(0);
        }
        return null;
    }

    public void removeFirstCandidate(Requirement requirement) {
        List list = (List)this.m_candidateMap.get(requirement);
        Capability capability = (Capability)list.remove(0);
        if (list.isEmpty()) {
            this.m_candidateMap.remove(requirement);
        }
        CopyOnWriteSet copyOnWriteSet = (CopyOnWriteSet)this.m_delta.getOrCompute(requirement);
        copyOnWriteSet.add(capability);
    }

    public List<Capability> clearCandidates(Requirement requirement, Collection<Capability> collection) {
        List list = (List)this.m_candidateMap.get(requirement);
        list.removeAll(collection);
        CopyOnWriteSet copyOnWriteSet = (CopyOnWriteSet)this.m_delta.getOrCompute(requirement);
        copyOnWriteSet.addAll(collection);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public ResolutionError prepare(ResolveContext resolveContext) {
        Object object;
        Map<Capability, Map<String, Map<Version, List<Requirement>>>> map = this.getHostFragments();
        ArrayList<WrappedResource> arrayList = new ArrayList<WrappedResource>();
        ArrayList<Resource> arrayList2 = new ArrayList<Resource>();
        for (Map.Entry<Capability, Map<String, Map<Version, List<Requirement>>>> object2 : map.entrySet()) {
            Capability capability = object2.getKey();
            Iterator<Requirement> iterator = object2.getValue();
            object = new ArrayList<Resource>();
            for (Map.Entry<String, Map<Version, List<Requirement>>> entry : iterator.entrySet()) {
                boolean bl = true;
                for (Map.Entry<Version, List<Requirement>> entry2 : entry.getValue().entrySet()) {
                    for (Requirement requirement : entry2.getValue()) {
                        if (bl) {
                            object.add(requirement.getResource());
                            bl = false;
                            continue;
                        }
                        ((CopyOnWriteSet)this.m_dependentMap.get(capability)).remove(requirement);
                        List list = (List)this.m_candidateMap.get(requirement);
                        list.remove(capability);
                        if (!list.isEmpty()) continue;
                        arrayList2.add(requirement.getResource());
                    }
                }
            }
            WrappedResource wrappedResource = new WrappedResource(capability.getResource(), (List<Resource>)object);
            arrayList.add(wrappedResource);
            this.m_allWrappedHosts.put(capability.getResource(), wrappedResource);
        }
        for (Resource resource : arrayList2) {
            this.removeResource(resource, new FragmentNotSelectedError(resource));
        }
        for (WrappedResource wrappedResource : arrayList) {
            for (Capability capability : wrappedResource.getCapabilities(null)) {
                CopyOnWriteSet copyOnWriteSet;
                if (capability.getNamespace().equals("osgi.wiring.host") || (copyOnWriteSet = (CopyOnWriteSet)this.m_dependentMap.get(object = ((HostedCapability)capability).getDeclaredCapability())) == null) continue;
                CopyOnWriteSet copyOnWriteSet2 = new CopyOnWriteSet(copyOnWriteSet);
                this.m_dependentMap.put(capability, (Requirement)((Object)copyOnWriteSet2));
                for (Object object2 : copyOnWriteSet2) {
                    void var13_35;
                    List list = (List)this.m_candidateMap.get(object2);
                    if (!(list instanceof ShadowList)) {
                        ShadowList shadowList = new ShadowList(list);
                        this.m_candidateMap.put((Requirement)object2, (Capability)((Object)shadowList));
                        ShadowList shadowList2 = shadowList;
                    }
                    if (!object.getResource().equals(wrappedResource.getDeclaredResource())) {
                        List<Capability> list2 = ((ShadowList)var13_35).getOriginal();
                        int n = list2.indexOf(object);
                        if (n != -1) {
                            list2.remove(n);
                            var13_35.remove(n);
                        }
                        int n2 = resolveContext.insertHostedCapability(list2, new SimpleHostedCapability(wrappedResource.getDeclaredResource(), (Capability)object));
                        var13_35.add(n2, capability);
                        continue;
                    }
                    int n = var13_35.indexOf(object);
                    var13_35.set(n, capability);
                }
            }
            for (Requirement requirement : wrappedResource.getRequirements(null)) {
                object = ((WrappedRequirement)requirement).getDeclaredRequirement();
                List list = (List)this.m_candidateMap.get(object);
                if (list == null) continue;
                this.m_candidateMap.put(requirement, (Capability)((Object)new CopyOnWriteList(list)));
                for (Object object2 : list) {
                    Set set = (Set)this.m_dependentMap.get(object2);
                    set.remove(object);
                    set.add(requirement);
                }
            }
        }
        for (Resource resource : this.m_mandatoryResources) {
            if (this.isPopulated(resource)) continue;
            return this.getResolutionError(resource);
        }
        this.populateSubstitutables();
        this.m_candidateMap.trim();
        this.m_dependentMap.trim();
        return null;
    }

    private Map<Capability, Map<String, Map<Version, List<Requirement>>>> getHostFragments() {
        HashMap<Capability, Map<String, Map<Version, List<Requirement>>>> hashMap = new HashMap<Capability, Map<String, Map<Version, List<Requirement>>>>();
        for (Map.Entry entry : this.m_candidateMap.fast()) {
            Requirement requirement = (Requirement)entry.getKey();
            List list = (List)entry.getValue();
            for (Capability capability : list) {
                ArrayList<Requirement> arrayList;
                TreeMap treeMap;
                if (!requirement.getNamespace().equals("osgi.wiring.host")) continue;
                String string = Util.getSymbolicName(requirement.getResource());
                Version version = Util.getVersion(requirement.getResource());
                HashMap hashMap2 = (HashMap)hashMap.get(capability);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                    hashMap.put(capability, hashMap2);
                }
                if ((treeMap = (TreeMap)hashMap2.get(string)) == null) {
                    treeMap = new TreeMap(Collections.reverseOrder());
                    hashMap2.put(string, treeMap);
                }
                if ((arrayList = (ArrayList<Requirement>)treeMap.get(version)) == null) {
                    arrayList = new ArrayList<Requirement>();
                    if (version == null) {
                        version = new Version(0, 0, 0);
                    }
                    treeMap.put(version, arrayList);
                }
                arrayList.add(requirement);
            }
        }
        return hashMap;
    }

    private void removeResource(Resource resource, ResolutionError resolutionError) {
        PopulateResult populateResult = this.m_populateResultCache.get(resource);
        populateResult.success = false;
        populateResult.error = resolutionError;
        HashSet<Resource> hashSet = new HashSet<Resource>();
        this.remove(resource, hashSet);
        while (!hashSet.isEmpty()) {
            Iterator iterator = hashSet.iterator();
            resource = (Resource)iterator.next();
            iterator.remove();
            this.remove(resource, hashSet);
        }
    }

    private void remove(Resource resource, Set<Resource> set) {
        for (Requirement object : resource.getRequirements(null)) {
            this.remove(object);
        }
        for (Capability capability : resource.getCapabilities(null)) {
            this.remove(capability, set);
        }
    }

    private void remove(Requirement requirement) {
        List list = (List)this.m_candidateMap.remove(requirement);
        if (list != null) {
            for (Capability capability : list) {
                Set set = (Set)this.m_dependentMap.get(capability);
                if (set == null) continue;
                set.remove(requirement);
            }
        }
    }

    private void remove(Capability capability, Set<Resource> set) {
        Set set2 = (Set)this.m_dependentMap.remove(capability);
        if (set2 != null) {
            for (Requirement requirement : set2) {
                List list = (List)this.m_candidateMap.get(requirement);
                list.remove(capability);
                if (!list.isEmpty()) continue;
                this.m_candidateMap.remove(requirement);
                if (Util.isOptional(requirement)) continue;
                PopulateResult populateResult = this.m_populateResultCache.get(requirement.getResource());
                if (populateResult != null) {
                    populateResult.success = false;
                    populateResult.error = new MissingRequirementError(requirement, this.m_populateResultCache.get((Object)capability.getResource()).error);
                }
                set.add(requirement.getResource());
            }
        }
    }

    public Candidates copy() {
        return new Candidates(this.m_mandatoryResources, this.m_dependentMap.deepClone(), this.m_candidateMap.deepClone(), this.m_allWrappedHosts, this.m_populateResultCache, this.m_validOnDemandResources, this.m_subtitutableMap, this.m_delta.deepClone());
    }

    public void dump(ResolveContext resolveContext) {
        CopyOnWriteSet<Resource> copyOnWriteSet = new CopyOnWriteSet<Resource>();
        for (Map.Entry object : this.m_candidateMap.entrySet()) {
            copyOnWriteSet.add(((Requirement)object.getKey()).getResource());
        }
        System.out.println("=== BEGIN CANDIDATE MAP ===");
        for (Resource resource : copyOnWriteSet) {
            List list;
            Wiring wiring = resolveContext.getWirings().get(resource);
            System.out.println("  " + resource + " (" + (wiring != null ? "RESOLVED)" : "UNRESOLVED)"));
            List<Requirement> list2 = wiring != null ? wiring.getResourceRequirements(null) : resource.getRequirements(null);
            for (Requirement requirement : list2) {
                list = (List)this.m_candidateMap.get(requirement);
                if (list == null || list.size() <= 0) continue;
                System.out.println("    " + requirement + ": " + list);
            }
            list2 = wiring != null ? Util.getDynamicRequirements(wiring.getResourceRequirements(null)) : Util.getDynamicRequirements(resource.getRequirements(null));
            for (Requirement requirement : list2) {
                list = (List)this.m_candidateMap.get(requirement);
                if (list == null || list.size() <= 0) continue;
                System.out.println("    " + requirement + ": " + list);
            }
        }
        System.out.println("=== END CANDIDATE MAP ===");
    }

    public void permutate(Requirement requirement, List<Candidates> list) {
        if (!Util.isMultiple(requirement) && this.canRemoveCandidate(requirement)) {
            Candidates candidates = this.copy();
            candidates.removeFirstCandidate(requirement);
            list.add(candidates);
        }
    }

    public boolean canRemoveCandidate(Requirement requirement) {
        List list = (List)this.m_candidateMap.get(requirement);
        return list != null && (list.size() > 1 || Util.isOptional(requirement));
    }

    public void permutateIfNeeded(Requirement requirement, List<Candidates> list) {
        List list2 = (List)this.m_candidateMap.get(requirement);
        if (list2 != null && list2.size() > 1) {
            boolean bl = false;
            for (Candidates candidates : list) {
                List list3 = (List)candidates.m_candidateMap.get(requirement);
                if (list3 == null || ((Capability)list3.get(0)).equals(list2.get(0))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.permutate(requirement, list);
            }
        }
    }

    static class DynamicImportFailed
    extends ResolutionError {
        private final Requirement requirement;

        public DynamicImportFailed(Requirement requirement) {
            this.requirement = requirement;
        }

        @Override
        public String getMessage() {
            return "Dynamic import failed.";
        }

        @Override
        public Collection<Requirement> getUnresolvedRequirements() {
            return Collections.singleton(this.requirement);
        }
    }

    static class FragmentNotSelectedError
    extends ResolutionError {
        private final Resource resource;

        public FragmentNotSelectedError(Resource resource) {
            this.resource = resource;
        }

        @Override
        public String getMessage() {
            return "Fragment was not selected for attachment: " + this.resource;
        }
    }

    static class MissingRequirementError
    extends ResolutionError {
        private final Requirement requirement;
        private final ResolutionError cause;

        public MissingRequirementError(Requirement requirement) {
            this(requirement, null);
        }

        public MissingRequirementError(Requirement requirement, ResolutionError resolutionError) {
            this.requirement = requirement;
            this.cause = resolutionError;
        }

        @Override
        public String getMessage() {
            String string = "Unable to resolve " + this.requirement.getResource() + ": missing requirement " + this.requirement;
            if (this.cause != null) {
                string = String.valueOf(string) + " [caused by: " + this.cause.getMessage() + "]";
            }
            return string;
        }

        @Override
        public Collection<Requirement> getUnresolvedRequirements() {
            return Collections.singleton(this.requirement);
        }
    }

    static class PopulateResult {
        boolean success;
        ResolutionError error;
        List<Requirement> remaining;
        Map<Requirement, List<Capability>> candidates;

        PopulateResult() {
        }

        public String toString() {
            return this.success ? "true" : (this.error != null ? this.error.getMessage() : "???");
        }
    }
}

