/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.main;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.felix.deploymentadmin.Activator;
import org.apache.felix.main.AutoProcessor;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.SystemInfo;
import org.yaoqiang.asaf.Utils;
import org.yaoqiang.asaf.splash.SplashScreen;

public class Main {
    private static Framework framework = null;
    private static TrayIcon trayIcon = null;
    private static org.yaoqiang.asaf.Activator asaf = null;
    private static String checkVersionURL = null;
    private static String projectURL = null;
    private static String downloadURL = null;
    private static List<File> updates = new ArrayList<File>();

    public static void start(final String string, String[] stringArray) throws Exception {
        Object object;
        Object object2;
        File file;
        System.setProperty("asaf.standalone", "true");
        if (stringArray.length == 4 && stringArray[0].equals("--bootstrap")) {
            System.setProperty("asaf.p2p.super.id", stringArray[1]);
            System.setProperty("asaf.p2p.super.ip", stringArray[2]);
            System.setProperty("asaf.p2p.super.port", stringArray[3]);
        }
        if (SystemInfo.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        SplashScreen.showSplash();
        File file2 = new File(ASAF.CACHE_DIR);
        if (file2.isDirectory() && Arrays.asList(stringArray).contains("-clean")) {
            new File(ASAF.PERSPECTIVES_FILE).delete();
            Utils.deleteDirectory(file2);
        }
        if ((file = new File(ASAF.UPDATE_DIR)).exists()) {
            object2 = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(".update") || string.endsWith(".pkg");
                }
            });
            int n = ((File[])object2).length;
            int n2 = 0;
            while (n2 < n) {
                object = object2[n2];
                updates.add((File)object);
                ++n2;
            }
        } else {
            try {
                file.mkdir();
            }
            catch (Exception exception) {}
        }
        Runtime.getRuntime().addShutdownHook(new Thread("Felix Shutdown Hook"){

            @Override
            public void run() {
                try {
                    if (framework != null) {
                        System.setProperty("asaf.shutdown.mode", Integer.toString(0));
                        asaf.stop(framework.getBundleContext());
                        framework.stop();
                        framework.waitForStop(0L);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Error stopping framework: " + exception);
                }
            }
        });
        try {
            String string2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            object = ServiceLoader.load(FrameworkFactory.class);
            FrameworkFactory frameworkFactory = ((ServiceLoader)object).iterator().next();
            framework = frameworkFactory.newFramework(null);
            framework.init();
            SplashScreen.increaseProgress();
            AutoProcessor.processAutoDeploy(framework.getBundleContext());
            new org.fife.Activator().start(framework.getBundleContext());
            SplashScreen.increaseProgress();
            new Activator().start(framework.getBundleContext());
            SplashScreen.increaseProgress();
            asaf = new org.yaoqiang.asaf.Activator();
            asaf.start(framework.getBundleContext());
            DeploymentAdmin deploymentAdmin = Utils.getService(framework.getBundleContext(), DeploymentAdmin.class);
            object2 = new HashMap();
            HashMap<String, InputStream> hashMap = new HashMap<String, InputStream>();
            if (Boolean.getBoolean("asaf.test")) {
                hashMap.put(string, new FileInputStream("packages/" + string + ".pkg"));
            } else {
                URL object82 = Main.class.getClassLoader().getResource("META-INF/packages");
                if (object82 != null && (object7 = object82.openConnection()) instanceof JarURLConnection) {
                    object6 = (JarURLConnection)object7;
                    object5 = ((JarURLConnection)object6).getJarFile();
                    object4 = ((JarFile)object5).entries();
                    while (object4.hasMoreElements()) {
                        object3 = object4.nextElement();
                        string2 = ((ZipEntry)object3).getName();
                        if (!string2.startsWith("META-INF/packages/") || !string2.endsWith(".pkg")) continue;
                        hashMap.put(string2.substring(18, string2.length() - 4), ((JarFile)object5).getInputStream((ZipEntry)object3));
                        object2.put(string2, object5);
                    }
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                object6 = deploymentAdmin.getDeploymentPackage((String)entry.getKey());
                if (object6 == null) {
                    object6 = deploymentAdmin.installDeploymentPackage((InputStream)entry.getValue());
                    System.out.println("Installed package '" + (String)entry.getKey() + "', version=" + object6.getVersion());
                    continue;
                }
                if (Boolean.getBoolean("asaf.test")) {
                    object5 = object6.getVersion().toString();
                    object6 = deploymentAdmin.installDeploymentPackage((InputStream)entry.getValue());
                    object4 = object6.getVersion().toString();
                    System.out.println("Updated package '" + (String)entry.getKey() + "' from " + (String)object5 + " to " + (String)object4);
                    continue;
                }
                object5 = null;
                try {
                    try {
                        object4 = (InputStream)entry.getValue();
                        object5 = new JarInputStream((InputStream)object4);
                        object3 = ((JarInputStream)object5).getManifest().getMainAttributes().getValue("DeploymentPackage-Version");
                        if (Version.parseVersion((String)object3).compareTo(object6.getVersion()) > 0) {
                            string2 = object6.getVersion().toString();
                            String string3 = "META-INF/packages/" + (String)entry.getKey() + ".pkg";
                            object6 = deploymentAdmin.installDeploymentPackage(((JarFile)object2.get(string3)).getInputStream(((JarFile)object2.get(string3)).getEntry(string3)));
                            System.out.println("Updated package '" + (String)entry.getKey() + "' from " + string2 + " to " + (String)object3);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (object5 == null) continue;
                        try {
                            ((ZipInputStream)object5).close();
                        }
                        catch (Exception exception2) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (object5 != null) {
                        try {
                            ((ZipInputStream)object5).close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (object5 == null) continue;
                try {
                    ((ZipInputStream)object5).close();
                }
                catch (Exception exception) {}
            }
            object7 = updates.iterator();
            while (object7.hasNext()) {
                File file3 = object7.next();
                Main.installUpdates(deploymentAdmin, file3);
                file3.delete();
            }
            SplashScreen.increaseProgress();
            DeploymentPackage deploymentPackage = deploymentAdmin.getDeploymentPackage(string);
            if (deploymentPackage != null) {
                ASAF.setVersion(deploymentPackage.getVersion().toString());
            }
            if (checkVersionURL != null) {
                new Thread("Check New Version"){

                    @Override
                    public void run() {
                        Main.checkNewVersion(string);
                    }
                }.start();
            }
            SplashScreen.increaseProgress();
            if (SystemTray.isSupported()) {
                Main.initSystemTray(string);
            }
            SplashScreen.increaseProgress();
            do {
                framework.start();
                SplashScreen.setProgress(100);
                ASAF.showFrame();
            } while (((FrameworkEvent)(object7 = framework.waitForStop(0L))).getType() == 128);
            if (trayIcon != null) {
                SystemTray.getSystemTray().remove(trayIcon);
            }
            System.exit(0);
        }
        catch (Exception exception) {
            System.err.println("Could not create framework: " + exception);
            exception.printStackTrace();
            System.exit(0);
        }
    }

    private static void installUpdates(DeploymentAdmin deploymentAdmin, File file) {
        block17: {
            String string = file.getName();
            int n = string.lastIndexOf(45);
            string = n > 0 ? string.substring(0, n) : string.substring(0, string.lastIndexOf(46));
            DeploymentPackage deploymentPackage = deploymentAdmin.getDeploymentPackage(string);
            String string2 = null;
            if (deploymentPackage != null) {
                string2 = deploymentPackage.getVersion().toString();
            }
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    deploymentPackage = deploymentAdmin.installDeploymentPackage(fileInputStream);
                    String string3 = deploymentPackage.getVersion().toString();
                    if (string2 == null) {
                        System.out.println("Installed package '" + string + "', version=" + string3);
                    } else {
                        System.out.println("Updated package '" + string + "' from " + string2 + " to " + string3);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void setCheckVersionURL(String string) {
        checkVersionURL = string;
    }

    public static void setProjectURL(String string) {
        projectURL = string;
    }

    public static void setDownloadURL(String string) {
        downloadURL = string;
    }

    private static void initSystemTray(String string) {
        SystemTray systemTray = SystemTray.getSystemTray();
        Image image = null;
        image = SystemInfo.isWindows() ? ASAF.getLogo().getScaledInstance(16, 16, 4) : ASAF.getLogo().getScaledInstance(24, 24, 4);
        trayIcon = new TrayIcon(image, string.equals("asaf") ? "ASAF-2.0.0" : String.valueOf(string.toUpperCase()) + "-" + ASAF.getVersion(), null);
        trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(ASAF.getAction("exit"));
                    if (SystemInfo.isMacOS()) {
                        double d = MouseInfo.getPointerInfo().getLocation().getX();
                        double d2 = MouseInfo.getPointerInfo().getLocation().getY();
                        jPopupMenu.setLocation((int)d, (int)d2);
                    } else {
                        jPopupMenu.setLocation(mouseEvent.getX(), mouseEvent.getY());
                    }
                    jPopupMenu.setInvoker(jPopupMenu);
                    jPopupMenu.setVisible(true);
                    mouseEvent.consume();
                } else {
                    JFrame jFrame = ASAF.getMainFrame();
                    if (jFrame != null) {
                        if (jFrame.isVisible()) {
                            jFrame.setVisible(false);
                        } else {
                            jFrame.setVisible(true);
                            jFrame.toFront();
                        }
                    }
                }
            }
        });
        try {
            systemTray.add(trayIcon);
        }
        catch (AWTException aWTException) {
            System.err.println(aWTException);
        }
    }

    public static boolean invalidJRE() {
        Double d = Double.valueOf(System.getProperty("java.specification.version"));
        if (d < 1.6) {
            JOptionPane.showMessageDialog(null, "The current Java version is not supported. ASAF should be running under JDK 1.6 (at least)", "Java Version Not Supported", 2);
            return true;
        }
        int n = 1;
        String string = System.getProperty("java.runtime.name", "");
        if (string.startsWith("OpenJDK")) {
            n = JOptionPane.showConfirmDialog(null, "An incompatible Java version has been detected which has been reported to cause strange bugs.\nPlease install the latest release of the Oracle Java SE Runtime Environment (JRE) from:\nhttp://java.oracle.com or if it is already installed, make sure it is used.\nAborting now?", "Java Version Incompatible", 0);
        }
        return n == 0;
    }

    public static boolean isRunning() {
        boolean bl = false;
        File file = new File(ASAF.PEER_ID);
        if (file.isFile()) {
            String string;
            String[] stringArray = Main.readPeerInfo();
            int n = Integer.parseInt(stringArray[1]);
            if (Main.isPortInUse(n) && ((string = Main.getPeerResponse(n)).equals("no") || string.equals(stringArray[0]))) {
                JOptionPane.showMessageDialog(null, "Another instance of the application is already running.", "Application already running", 2);
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private static String getPeerResponse(int n) {
        String string = "";
        DatagramSocket datagramSocket = null;
        try {
            try {
                datagramSocket = new DatagramSocket();
                datagramSocket.setSoTimeout(6000);
                datagramSocket.send(new DatagramPacket(new byte[1], 1, InetAddress.getLocalHost(), n));
                DatagramPacket datagramPacket = new DatagramPacket(new byte[64], 64);
                datagramSocket.receive(datagramPacket);
                string = new String(datagramPacket.getData(), 0, datagramPacket.getLength());
            }
            catch (Exception exception) {
                string = "no";
                datagramSocket.close();
            }
        }
        finally {
            datagramSocket.close();
        }
        return string;
    }

    private static String[] readPeerInfo() {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(ASAF.PEER_ID));
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static boolean isPortInUse(int n) {
        ServerSocket serverSocket = null;
        DatagramSocket datagramSocket = null;
        try {
            try {
                serverSocket = new ServerSocket(n);
                datagramSocket = new DatagramSocket(n);
            }
            catch (IOException iOException) {
                if (datagramSocket != null) {
                    datagramSocket.close();
                }
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException iOException2) {}
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (datagramSocket != null) {
            datagramSocket.close();
        }
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private static void checkNewVersion(String string) {
        Object object;
        Object object2;
        Object object3;
        String string2;
        block21: {
            string2 = null;
            try {
                object3 = new URL(String.valueOf(checkVersionURL) + ASAF.getVersion());
                object2 = (HttpURLConnection)((URL)object3).openConnection();
                Utils.setProxyAuth((URLConnection)object2);
                if (((HttpURLConnection)object2).getResponseCode() != 200) break block21;
                object = null;
                try {
                    try {
                        object = ((URLConnection)object2).getInputStream();
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                        string2 = bufferedReader.readLine();
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (IOException iOException2) {}
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
            }
            catch (Exception exception) {}
        }
        object3 = null;
        try {
            object3 = Version.parseVersion(string2);
        }
        catch (Exception exception) {
            string2 = "OK";
        }
        if (string2 != null && !"OK".equals(string2)) {
            if (((Version)object3).getMicro() == 0) {
                JOptionPane.showMessageDialog(null, ResourceMap.getString("newVersion.text", string2), ResourceMap.getString("newVersion.Dialog.title", new String[0]), 2);
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URL(projectURL).toURI());
                    }
                    catch (Exception exception) {}
                }
            } else {
                object2 = String.valueOf(string) + "-" + string2 + ".update";
                object = String.valueOf(ASAF.UPDATE_DIR) + (String)object2;
                boolean bl = Utils.download(String.valueOf(downloadURL) + string2 + ".update", (String)object);
                if (bl) {
                    System.out.println(String.valueOf(object2) + " downloaded.");
                    JOptionPane.showMessageDialog(null, ResourceMap.getString("newUpdate.text", string2), ResourceMap.getString("newUpdate.Dialog.title", new String[0]), 1);
                }
            }
        }
    }
}

