/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.wiring;

import java.util.Collections;
import java.util.Map;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.util.ImmutableMap;
import org.apache.felix.framework.wiring.BundleCapabilityImpl;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

public class BundleRequirementImpl
implements BundleRequirement {
    private final BundleRevision m_revision;
    private final String m_namespace;
    private final SimpleFilter m_filter;
    private final boolean m_optional;
    private final Map<String, String> m_dirs;
    private final Map<String, Object> m_attrs;

    public BundleRequirementImpl(BundleRevision bundleRevision, String string, Map<String, String> map, Map<String, Object> map2, SimpleFilter simpleFilter) {
        this.m_revision = bundleRevision;
        this.m_namespace = string;
        this.m_dirs = ImmutableMap.newInstance(map);
        this.m_attrs = ImmutableMap.newInstance(map2);
        this.m_filter = simpleFilter;
        boolean bl = false;
        if (this.m_dirs.containsKey("resolution") && this.m_dirs.get("resolution").equals("optional")) {
            bl = true;
        }
        this.m_optional = bl;
    }

    public BundleRequirementImpl(BundleRevision bundleRevision, String string, Map<String, String> map, Map<String, Object> map2) {
        this(bundleRevision, string, map, Collections.EMPTY_MAP, SimpleFilter.convert(map2));
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.m_dirs;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.m_attrs;
    }

    @Override
    public BundleRevision getResource() {
        return this.m_revision;
    }

    @Override
    public BundleRevision getRevision() {
        return this.m_revision;
    }

    @Override
    public boolean matches(BundleCapability bundleCapability) {
        return CapabilitySet.matches((BundleCapabilityImpl)bundleCapability, this.getFilter());
    }

    public boolean isOptional() {
        return this.m_optional;
    }

    public SimpleFilter getFilter() {
        return this.m_filter;
    }

    public String toString() {
        return "[" + this.m_revision + "] " + this.m_namespace + "; " + this.getFilter().toString();
    }
}

