/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.wiring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.util.ImmutableMap;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

public class BundleCapabilityImpl
implements BundleCapability {
    public static final String VERSION_ATTR = "version";
    private final BundleRevision m_revision;
    private final String m_namespace;
    private final Map<String, String> m_dirs;
    private final Map<String, Object> m_attrs;
    private final List<String> m_uses;
    private final List<List<String>> m_includeFilter;
    private final List<List<String>> m_excludeFilter;
    private final Set<String> m_mandatory;

    public BundleCapabilityImpl(BundleRevision bundleRevision, String string, Map<String, String> map, Map<String, Object> map2) {
        int n;
        Collection<String> collection;
        this.m_namespace = string;
        this.m_revision = bundleRevision;
        this.m_dirs = ImmutableMap.newInstance(map);
        this.m_attrs = ImmutableMap.newInstance(map2);
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        String string2 = this.m_dirs.get("uses");
        if (string2 != null) {
            collection = new StringTokenizer(string2, ",");
            arrayList = new ArrayList<String>(((StringTokenizer)((Object)collection)).countTokens());
            while (((StringTokenizer)((Object)collection)).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)((Object)collection)).nextToken().trim());
            }
        }
        this.m_uses = arrayList;
        string2 = this.m_dirs.get("include");
        if (string2 != null) {
            collection = ManifestParser.parseDelimitedString(string2, ",");
            this.m_includeFilter = new ArrayList<List<String>>(collection.size());
            n = 0;
            while (n < collection.size()) {
                List<String> object2 = SimpleFilter.parseSubstring((String)collection.get(n));
                this.m_includeFilter.add(object2);
                ++n;
            }
        } else {
            this.m_includeFilter = null;
        }
        string2 = this.m_dirs.get("exclude");
        if (string2 != null) {
            collection = ManifestParser.parseDelimitedString(string2, ",");
            this.m_excludeFilter = new ArrayList<List<String>>(collection.size());
            n = 0;
            while (n < collection.size()) {
                List<String> list = SimpleFilter.parseSubstring((String)collection.get(n));
                this.m_excludeFilter.add(list);
                ++n;
            }
        } else {
            this.m_excludeFilter = null;
        }
        collection = Collections.EMPTY_SET;
        string2 = this.m_dirs.get("mandatory");
        if (string2 != null) {
            List<String> list = ManifestParser.parseDelimitedString(string2, ",");
            collection = new HashSet(list.size());
            for (String string3 : list) {
                if (this.m_attrs.containsKey(string3)) {
                    collection.add(string3);
                    continue;
                }
                throw new IllegalArgumentException("Mandatory attribute '" + string3 + "' does not exist.");
            }
        }
        this.m_mandatory = collection;
    }

    @Override
    public BundleRevision getResource() {
        return this.m_revision;
    }

    @Override
    public BundleRevision getRevision() {
        return this.m_revision;
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.m_dirs;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.m_attrs;
    }

    public boolean isAttributeMandatory(String string) {
        return !this.m_mandatory.isEmpty() && this.m_mandatory.contains(string);
    }

    public List<String> getUses() {
        return this.m_uses;
    }

    public boolean isIncluded(String string) {
        if (this.m_includeFilter == null && this.m_excludeFilter == null) {
            return true;
        }
        String string2 = Util.getClassName(string);
        boolean bl = this.m_includeFilter == null;
        int n = 0;
        while (!bl && this.m_includeFilter != null && n < this.m_includeFilter.size()) {
            bl = SimpleFilter.compareSubstring(this.m_includeFilter.get(n), string2);
            ++n;
        }
        n = 0;
        int n2 = 0;
        while (n == 0 && this.m_excludeFilter != null && n2 < this.m_excludeFilter.size()) {
            n = SimpleFilter.compareSubstring(this.m_excludeFilter.get(n2), string2) ? 1 : 0;
            ++n2;
        }
        return bl && n == 0;
    }

    public String toString() {
        if (this.m_revision == null) {
            return this.m_attrs.toString();
        }
        return "[" + this.m_revision + "] " + this.m_namespace + "; " + this.m_attrs;
    }
}

