/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.util.VersionRange;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public class NativeLibraryClause {
    private static final String OS_AIX = "aix";
    private static final String OS_DIGITALUNIX = "digitalunix";
    private static final String OS_EPOC = "epoc32";
    private static final String OS_HPUX = "hpux";
    private static final String OS_IRIX = "irix";
    private static final String OS_LINUX = "linux";
    private static final String OS_MACOS = "macos";
    private static final String OS_MACOSX = "macosx";
    private static final String OS_NETBSD = "netbsd";
    private static final String OS_NETWARE = "netware";
    private static final String OS_OPENBSD = "openbsd";
    private static final String OS_OS2 = "os2";
    private static final String OS_QNX = "qnx";
    private static final String OS_SOLARIS = "solaris";
    private static final String OS_SUNOS = "sunos";
    private static final String OS_VXWORKS = "vxworks";
    private static final String OS_WINDOWS_2000 = "windows2000";
    private static final String OS_WINDOWS_2003 = "windows2003";
    private static final String OS_WINDOWS_7 = "windows7";
    private static final String OS_WINDOWS_8 = "windows8";
    private static final String OS_WINDOWS_9 = "windows9";
    private static final String OS_WINDOWS_10 = "windows10";
    private static final String OS_WINDOWS_95 = "windows95";
    private static final String OS_WINDOWS_98 = "windows98";
    private static final String OS_WINDOWS_CE = "windowsce";
    private static final String OS_WINDOWS_NT = "windowsnt";
    private static final String OS_WINDOWS_SERVER_2008 = "windowsserver2008";
    private static final String OS_WINDOWS_SERVER_2012 = "windowsserver2012";
    private static final String OS_WINDOWS_VISTA = "windowsvista";
    private static final String OS_WINDOWS_XP = "windowsxp";
    private static final String OS_WIN_32 = "win32";
    private static final String PROC_X86_64 = "x86-64";
    private static final String PROC_X86 = "x86";
    private static final String PROC_68K = "68k";
    private static final String PROC_ARM_LE = "arm_le";
    private static final String PROC_ARM_BE = "arm_be";
    private static final String PROC_ARM = "arm";
    private static final String PROC_ALPHA = "alpha";
    private static final String PROC_IGNITE = "ignite";
    private static final String PROC_MIPS = "mips";
    private static final String PROC_PARISC = "parisc";
    private static final String PROC_POWER_PC = "powerpc";
    private static final String PROC_SPARC = "sparc";
    private static final Map<String, List<String>> OS_ALIASES = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> PROC_ALIASES = new HashMap<String, List<String>>();
    private final String[] m_libraryEntries;
    private final String[] m_osnames;
    private final String[] m_processors;
    private final String[] m_osversions;
    private final String[] m_languages;
    private final String m_selectionFilter;

    public NativeLibraryClause(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String string) {
        this.m_libraryEntries = stringArray;
        this.m_osnames = stringArray2;
        this.m_processors = stringArray3;
        this.m_osversions = stringArray4;
        this.m_languages = stringArray5;
        this.m_selectionFilter = string;
    }

    public NativeLibraryClause(NativeLibraryClause nativeLibraryClause) {
        this(nativeLibraryClause.m_libraryEntries, nativeLibraryClause.m_osnames, nativeLibraryClause.m_osversions, nativeLibraryClause.m_processors, nativeLibraryClause.m_languages, nativeLibraryClause.m_selectionFilter);
    }

    public static synchronized void initializeNativeAliases(Map map) {
        Map<String, String> map2 = NativeLibraryClause.getAllKeysWithPrefix("felix.native.osname.alias", map);
        Map<String, String> map3 = NativeLibraryClause.getAllKeysWithPrefix("felix.native.processor.alias", map);
        NativeLibraryClause.parseNativeAliases(map2, OS_ALIASES);
        NativeLibraryClause.parseNativeAliases(map3, PROC_ALIASES);
    }

    private static void parseNativeAliases(Map<String, String> map, Map<String, List<String>> map2) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Object object;
            String string = entry.getKey();
            String string2 = string.substring(string.lastIndexOf(".") + 1);
            String string3 = entry.getValue();
            if (string3 != null) {
                object = string3.split(",");
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                arrayList.addAll(Arrays.asList(object));
                map2.put(string2, arrayList);
                Object object2 = object;
                int n = ((Object)object2).length;
                int n2 = 0;
                while (n2 < n) {
                    Object object3 = object2[n2];
                    List<String> list = map2.get(object3);
                    if (list == null) {
                        map2.put((String)object3, arrayList);
                    } else {
                        Object object4 = object;
                        int n3 = ((Object)object4).length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object object5 = object4[n4];
                            if (!list.contains(object5)) {
                                list.add((String)object5);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                continue;
            }
            object = map2.get(string2);
            if (object == null) {
                map2.put(string2, new ArrayList<String>(Collections.singletonList(string2)));
                continue;
            }
            object.add(0, string2);
        }
    }

    private static Map<String, String> getAllKeysWithPrefix(String string, Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith(string)) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    public String[] getLibraryEntries() {
        return this.m_libraryEntries;
    }

    public String[] getOSNames() {
        return this.m_osnames;
    }

    public String[] getProcessors() {
        return this.m_processors;
    }

    public String[] getOSVersions() {
        return this.m_osversions;
    }

    public String[] getLanguages() {
        return this.m_languages;
    }

    public String getSelectionFilter() {
        return this.m_selectionFilter;
    }

    public boolean match(Map map) throws BundleException {
        String string = (String)map.get("org.osgi.framework.os.name");
        String string2 = (String)map.get("org.osgi.framework.processor");
        String string3 = (String)map.get("org.osgi.framework.os.version");
        String string4 = (String)map.get("org.osgi.framework.language");
        if (!this.checkOSNames(string, this.getOSNames())) {
            return false;
        }
        if (!this.checkProcessors(string2, this.getProcessors())) {
            return false;
        }
        if (this.getOSVersions() != null && this.getOSVersions().length > 0 && !this.checkOSVersions(string3, this.getOSVersions())) {
            return false;
        }
        if (this.getLanguages() != null && this.getLanguages().length > 0 && !this.checkLanguages(string4, this.getLanguages())) {
            return false;
        }
        return this.getSelectionFilter() == null || this.getSelectionFilter().length() < 0 || this.checkSelectionFilter(map, this.getSelectionFilter());
    }

    private boolean checkOSNames(String string, String[] stringArray) {
        List<String> list = NativeLibraryClause.getOsNameWithAliases(string);
        if (list != null && stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (list.contains(string2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean checkProcessors(String string, String[] stringArray) {
        List<String> list = NativeLibraryClause.getProcessorWithAliases(string);
        if (list != null && stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (list.contains(string2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean checkOSVersions(String string, String[] stringArray) throws BundleException {
        Version version = Version.parseVersion(NativeLibraryClause.formatOSVersion(string));
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            try {
                VersionRange versionRange = VersionRange.parse(stringArray[n]);
                if (versionRange.isInRange(version)) {
                    return true;
                }
            }
            catch (Exception exception) {
                throw new BundleException("Error evaluating osversion: " + stringArray[n], exception);
            }
            ++n;
        }
        return false;
    }

    private boolean checkLanguages(String string, String[] stringArray) {
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean checkSelectionFilter(Map map, String string) throws BundleException {
        Hashtable hashtable = new Hashtable();
        for (Object k : map.keySet()) {
            ((Dictionary)hashtable).put(k, map.get(k));
        }
        try {
            Filter filter = FrameworkUtil.createFilter(string);
            return filter.match(hashtable);
        }
        catch (Exception exception) {
            throw new BundleException("Error evaluating filter expression: " + string, exception);
        }
    }

    public static NativeLibraryClause parse(Logger logger, String string) {
        String[] stringArray;
        int n;
        String string2;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3;
        ArrayList<String> arrayList4;
        String[] stringArray2;
        block15: {
            block14: {
                if (string != null && string.length() != 0) break block14;
                return null;
            }
            try {
                string = string.trim();
                if (string.equals("*")) {
                    return new NativeLibraryClause(null, null, null, null, null, null);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                stringArray2 = new String[stringTokenizer.countTokens()];
                arrayList4 = new ArrayList<String>();
                arrayList3 = new ArrayList<String>();
                arrayList2 = new ArrayList<String>();
                arrayList = new ArrayList<String>();
                string2 = null;
                n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray = stringTokenizer.nextToken().trim();
                    if (stringArray.indexOf(61) < 0) {
                        stringArray2[n] = stringArray.charAt(0) == '/' ? stringArray.substring(1) : stringArray;
                        ++n;
                        continue;
                    }
                    String string3 = null;
                    String string4 = null;
                    if (stringArray.indexOf("=") <= 1) {
                        throw new IllegalArgumentException("Bundle manifest native library entry malformed: " + (String)stringArray);
                    }
                    string3 = stringArray.substring(0, stringArray.indexOf("=")).trim().toLowerCase();
                    string4 = stringArray.substring(stringArray.indexOf("=") + 1, stringArray.length()).trim();
                    if (string4.charAt(0) == '\"') {
                        string4 = string4.charAt(string4.length() - 1) == '\"' ? string4.substring(1, string4.length() - 1) : string4.substring(1);
                    }
                    if (string4 != null) {
                        string4 = string4.toLowerCase();
                    }
                    if (string3.equals("osname")) {
                        arrayList4.add(string4);
                        continue;
                    }
                    if (string3.equals("osversion")) {
                        arrayList3.add(NativeLibraryClause.normalizeOSVersion(string4));
                        continue;
                    }
                    if (string3.equals("processor")) {
                        arrayList2.add(string4);
                        continue;
                    }
                    if (string3.equals("language")) {
                        arrayList.add(string4);
                        continue;
                    }
                    if (!string3.equals("selection-filter")) continue;
                    string2 = string4;
                }
                if (n != 0) break block15;
                return null;
            }
            catch (RuntimeException runtimeException) {
                logger.log(1, "Error parsing native library header.", runtimeException);
                throw runtimeException;
            }
        }
        stringArray = new String[n];
        System.arraycopy(stringArray2, 0, stringArray, 0, n);
        return new NativeLibraryClause(stringArray, arrayList4.toArray(new String[arrayList4.size()]), arrayList2.toArray(new String[arrayList2.size()]), arrayList3.toArray(new String[arrayList3.size()]), arrayList.toArray(new String[arrayList.size()]), string2);
    }

    public static String formatOSVersion(String string) {
        try {
            Pattern pattern = Pattern.compile("\\d+\\.?\\d*\\.?\\d*");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                string = matcher.group();
            }
            return Version.parseVersion(string).toString();
        }
        catch (Exception exception) {
            return Version.emptyVersion.toString();
        }
    }

    public static List<String> getOsNameWithAliases(String string) {
        List<String> list = OS_ALIASES.get(string = NativeLibraryClause.normalizeOSName(string));
        if (list == null) {
            list = Collections.singletonList(string);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<String> getProcessorWithAliases(String string) {
        List<String> list = PROC_ALIASES.get(string = NativeLibraryClause.normalizeProcessor(string));
        if (list == null) {
            list = Collections.singletonList(string);
        }
        return Collections.unmodifiableList(list);
    }

    public static String normalizeOSName(String string) {
        if (OS_ALIASES.containsKey(string = string.toLowerCase())) {
            return OS_ALIASES.get(string).get(0);
        }
        if (string.startsWith("win")) {
            String string2 = "win";
            if (string.indexOf("32") >= 0 || string.indexOf("*") >= 0) {
                string2 = OS_WIN_32;
            } else if (string.indexOf("95") >= 0) {
                string2 = OS_WINDOWS_95;
            } else if (string.indexOf("98") >= 0) {
                string2 = OS_WINDOWS_98;
            } else if (string.indexOf("nt") >= 0) {
                string2 = OS_WINDOWS_NT;
            } else if (string.indexOf("2000") >= 0) {
                string2 = OS_WINDOWS_2000;
            } else if (string.indexOf("2003") >= 0) {
                string2 = OS_WINDOWS_2003;
            } else if (string.indexOf("2008") >= 0) {
                string2 = OS_WINDOWS_SERVER_2008;
            } else if (string.indexOf("2012") >= 0) {
                string2 = OS_WINDOWS_SERVER_2012;
            } else if (string.indexOf("xp") >= 0) {
                string2 = OS_WINDOWS_XP;
            } else if (string.indexOf("ce") >= 0) {
                string2 = OS_WINDOWS_CE;
            } else if (string.indexOf("vista") >= 0) {
                string2 = OS_WINDOWS_VISTA;
            } else if (string.indexOf(" 7") >= 0 || string.startsWith(OS_WINDOWS_7) || string.equals("win7")) {
                string2 = OS_WINDOWS_7;
            } else if (string.indexOf(" 8") >= 0 || string.startsWith(OS_WINDOWS_8) || string.equals("win8")) {
                string2 = OS_WINDOWS_8;
            } else if (string.indexOf(" 9") >= 0 || string.startsWith(OS_WINDOWS_9) || string.equals("win9")) {
                string2 = OS_WINDOWS_9;
            } else if (string.indexOf(" 10") >= 0 || string.startsWith(OS_WINDOWS_10) || string.equals("win10")) {
                string2 = OS_WINDOWS_10;
            }
            return string2;
        }
        if (string.startsWith(OS_LINUX)) {
            return OS_LINUX;
        }
        if (string.startsWith(OS_AIX)) {
            return OS_AIX;
        }
        if (string.startsWith(OS_DIGITALUNIX)) {
            return OS_DIGITALUNIX;
        }
        if (string.startsWith(OS_HPUX)) {
            return OS_HPUX;
        }
        if (string.startsWith(OS_IRIX)) {
            return OS_IRIX;
        }
        if (string.startsWith(OS_MACOSX) || string.startsWith("mac os x")) {
            return OS_MACOSX;
        }
        if (string.startsWith(OS_MACOS) || string.startsWith("mac os")) {
            return OS_MACOS;
        }
        if (string.startsWith(OS_NETWARE)) {
            return OS_NETWARE;
        }
        if (string.startsWith(OS_OPENBSD)) {
            return OS_OPENBSD;
        }
        if (string.startsWith(OS_NETBSD)) {
            return OS_NETBSD;
        }
        if (string.startsWith(OS_OS2) || string.startsWith("os/2")) {
            return OS_OS2;
        }
        if (string.startsWith(OS_QNX) || string.startsWith("procnto")) {
            return OS_QNX;
        }
        if (string.startsWith(OS_SOLARIS)) {
            return OS_SOLARIS;
        }
        if (string.startsWith(OS_SUNOS)) {
            return OS_SUNOS;
        }
        if (string.startsWith(OS_VXWORKS)) {
            return OS_VXWORKS;
        }
        return string;
    }

    public static String normalizeProcessor(String string) {
        if (PROC_ALIASES.containsKey(string = string.toLowerCase())) {
            return PROC_ALIASES.get(string).get(0);
        }
        if (string.startsWith(PROC_X86_64) || string.startsWith("amd64") || string.startsWith("em64") || string.startsWith("x86_64")) {
            return PROC_X86_64;
        }
        if (string.startsWith(PROC_X86) || string.startsWith("pentium") || string.startsWith("i386") || string.startsWith("i486") || string.startsWith("i586") || string.startsWith("i686")) {
            return PROC_X86;
        }
        if (string.startsWith(PROC_68K)) {
            return PROC_68K;
        }
        if (string.startsWith(PROC_ARM_LE)) {
            return PROC_ARM_LE;
        }
        if (string.startsWith(PROC_ARM_BE)) {
            return PROC_ARM_BE;
        }
        if (string.startsWith(PROC_ARM)) {
            return PROC_ARM;
        }
        if (string.startsWith(PROC_ALPHA)) {
            return PROC_ALPHA;
        }
        if (string.startsWith(PROC_IGNITE) || string.startsWith("psc1k")) {
            return PROC_IGNITE;
        }
        if (string.startsWith(PROC_MIPS)) {
            return PROC_MIPS;
        }
        if (string.startsWith(PROC_PARISC)) {
            return PROC_PARISC;
        }
        if (string.startsWith(PROC_POWER_PC) || string.startsWith("power") || string.startsWith("ppc")) {
            return PROC_POWER_PC;
        }
        if (string.startsWith(PROC_SPARC)) {
            return PROC_SPARC;
        }
        return string;
    }

    public static String normalizeOSVersion(String string) {
        try {
            return VersionRange.parse(string).toString();
        }
        catch (Exception exception) {
            return Version.emptyVersion.toString();
        }
    }
}

