/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.util.manifestparser.ManifestParser;

public class NativeLibrary {
    private String m_libraryFile;
    private String[] m_osnames;
    private String[] m_processors;
    private String[] m_osversions;
    private String[] m_languages;
    private String m_selectionFilter;

    public NativeLibrary(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string2) throws Exception {
        this.m_libraryFile = string;
        this.m_osnames = stringArray;
        this.m_processors = stringArray2;
        this.m_osversions = stringArray3;
        this.m_languages = stringArray4;
        this.m_selectionFilter = string2;
    }

    public String getEntryName() {
        return this.m_libraryFile;
    }

    public String[] getOSNames() {
        return this.m_osnames;
    }

    public String[] getProcessors() {
        return this.m_processors;
    }

    public String[] getOSVersions() {
        return this.m_osversions;
    }

    public String[] getLanguages() {
        return this.m_languages;
    }

    public String getSelectionFilter() {
        return this.m_selectionFilter;
    }

    public boolean match(Map map, String string) {
        boolean bl = false;
        if (this.m_libraryFile.equals(string) || this.m_libraryFile.endsWith("/" + string)) {
            bl = true;
        }
        String string2 = System.mapLibraryName(string);
        List<String> list = ManifestParser.parseDelimitedString((String)map.get("org.osgi.framework.library.extensions"), ",");
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (string2.endsWith(".jnilib") && this.m_libraryFile.endsWith(".dylib")) {
            list.add("dylib");
        }
        if (string2.endsWith(".dylib") && this.m_libraryFile.endsWith(".jnilib")) {
            list.add("jnilib");
        }
        int n = -1;
        while (!bl && n < list.size()) {
            if (this.m_libraryFile.equals(string2) || this.m_libraryFile.endsWith("/" + string2)) {
                bl = true;
            }
            if (bl || ++n >= list.size()) continue;
            int n2 = string2.lastIndexOf(".");
            String string3 = string2 = n2 < 0 ? String.valueOf(string2) + "." + list.get(n) : String.valueOf(string2.substring(0, n2 + 1)) + list.get(n);
        }
        return bl;
    }

    public String toString() {
        if (this.m_libraryFile != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_libraryFile);
            int n = 0;
            while (this.m_osnames != null && n < this.m_osnames.length) {
                stringBuffer.append(';');
                stringBuffer.append("osname");
                stringBuffer.append('=');
                stringBuffer.append(this.m_osnames[n]);
                ++n;
            }
            n = 0;
            while (this.m_processors != null && n < this.m_processors.length) {
                stringBuffer.append(';');
                stringBuffer.append("processor");
                stringBuffer.append('=');
                stringBuffer.append(this.m_processors[n]);
                ++n;
            }
            n = 0;
            while (this.m_osversions != null && n < this.m_osversions.length) {
                stringBuffer.append(';');
                stringBuffer.append("osversion");
                stringBuffer.append('=');
                stringBuffer.append(this.m_osversions[n]);
                ++n;
            }
            n = 0;
            while (this.m_languages != null && n < this.m_languages.length) {
                stringBuffer.append(';');
                stringBuffer.append("language");
                stringBuffer.append('=');
                stringBuffer.append(this.m_languages[n]);
                ++n;
            }
            if (this.m_selectionFilter != null) {
                stringBuffer.append(';');
                stringBuffer.append("selection-filter");
                stringBuffer.append('=');
                stringBuffer.append('\'');
                stringBuffer.append(this.m_selectionFilter);
            }
            return stringBuffer.toString();
        }
        return "*";
    }
}

