/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.util.VersionRange;
import org.apache.felix.framework.util.manifestparser.NativeLibrary;
import org.apache.felix.framework.util.manifestparser.NativeLibraryClause;
import org.apache.felix.framework.util.manifestparser.ParsedHeaderClause;
import org.apache.felix.framework.wiring.BundleCapabilityImpl;
import org.apache.felix.framework.wiring.BundleRequirementImpl;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

public class ManifestParser {
    private static final String BUNDLE_LICENSE_HEADER = "Bundle-License";
    private final Logger m_logger;
    private final Map m_configMap;
    private final Map m_headerMap;
    private volatile int m_activationPolicy = 0;
    private volatile String m_activationIncludeDir;
    private volatile String m_activationExcludeDir;
    private volatile boolean m_isExtension = false;
    private volatile String m_bundleSymbolicName;
    private volatile Version m_bundleVersion;
    private volatile List<BundleCapability> m_capabilities;
    private volatile List<BundleRequirement> m_requirements;
    private volatile List<NativeLibraryClause> m_libraryClauses;
    private volatile boolean m_libraryHeadersOptional = false;
    private static final char EOF = '\uffff';
    private static final int CLAUSE_START = 0;
    private static final int PARAMETER_START = 1;
    private static final int KEY = 2;
    private static final int DIRECTIVE_OR_TYPEDATTRIBUTE = 4;
    private static final int ARGUMENT = 8;
    private static final int VALUE = 16;

    public ManifestParser(Logger logger, Map map, BundleRevision bundleRevision, Map map2) throws BundleException {
        List<Object> list;
        List<BundleRequirementImpl> list2;
        Object object;
        Object object2;
        BundleCapabilityImpl bundleCapabilityImpl;
        this.m_logger = logger;
        this.m_configMap = map;
        this.m_headerMap = map2;
        String string = ManifestParser.getManifestVersion(this.m_headerMap);
        if (string != null && !string.equals("2")) {
            throw new BundleException("Unknown 'Bundle-ManifestVersion' value: " + string);
        }
        ArrayList<BundleCapabilityImpl> arrayList = new ArrayList<BundleCapabilityImpl>();
        this.m_bundleVersion = Version.emptyVersion;
        if (map2.get("Bundle-Version") != null) {
            try {
                this.m_bundleVersion = Version.parseVersion((String)map2.get("Bundle-Version"));
            }
            catch (RuntimeException runtimeException) {
                if (this.getManifestVersion().equals("2")) {
                    throw runtimeException;
                }
                this.m_bundleVersion = Version.emptyVersion;
            }
        }
        if ((bundleCapabilityImpl = ManifestParser.parseBundleSymbolicName(bundleRevision, this.m_headerMap)) != null) {
            this.m_bundleSymbolicName = (String)bundleCapabilityImpl.getAttributes().get("osgi.wiring.bundle");
            if (map2.get("Fragment-Host") == null) {
                arrayList.add(bundleCapabilityImpl);
                object2 = bundleCapabilityImpl.getDirectives().get("fragment-attachment");
                Object object3 = object2 = object2 == null ? "resolve-time" : object2;
                if (!((String)object2).equalsIgnoreCase("never")) {
                    object = new HashMap<String, Object>(bundleCapabilityImpl.getAttributes());
                    list2 = object.remove("osgi.wiring.bundle");
                    object.put("osgi.wiring.host", list2);
                    arrayList.add(new BundleCapabilityImpl(bundleRevision, "osgi.wiring.host", bundleCapabilityImpl.getDirectives(), (Map<String, Object>)object));
                }
            }
            arrayList.add(ManifestParser.addIdentityCapability(bundleRevision, map2, bundleCapabilityImpl));
        }
        if (this.getManifestVersion().equals("2") && this.m_bundleSymbolicName == null) {
            throw new BundleException("R4 bundle manifests must include bundle symbolic name.");
        }
        object2 = ManifestParser.parseFragmentHost(this.m_logger, bundleRevision, this.m_headerMap);
        object = ManifestParser.parseStandardHeader((String)map2.get("Require-Bundle"));
        object = ManifestParser.normalizeRequireClauses(this.m_logger, object, this.getManifestVersion());
        list2 = ManifestParser.convertRequires(object, bundleRevision);
        List<ParsedHeaderClause> list3 = ManifestParser.parseStandardHeader((String)map2.get("Import-Package"));
        list3 = ManifestParser.normalizeImportClauses(this.m_logger, list3, this.getManifestVersion());
        List<BundleRequirement> list4 = ManifestParser.convertImports(list3, bundleRevision);
        List<ParsedHeaderClause> list5 = ManifestParser.parseStandardHeader((String)map2.get("DynamicImport-Package"));
        list5 = ManifestParser.normalizeDynamicImportClauses(this.m_logger, list5, this.getManifestVersion());
        List<BundleRequirement> list6 = ManifestParser.convertImports(list5, bundleRevision);
        List<ParsedHeaderClause> list7 = ManifestParser.parseStandardHeader((String)map2.get("Require-Capability"));
        list3 = ManifestParser.normalizeRequireCapabilityClauses(this.m_logger, list7, this.getManifestVersion());
        List<BundleRequirement> list8 = ManifestParser.convertRequireCapabilities(list3, bundleRevision);
        List<BundleRequirement> list9 = ManifestParser.parseBreeHeader((String)map2.get("Bundle-RequiredExecutionEnvironment"), bundleRevision);
        List<ParsedHeaderClause> list10 = ManifestParser.parseStandardHeader((String)map2.get("Export-Package"));
        list10 = ManifestParser.normalizeExportClauses(logger, list10, this.getManifestVersion(), this.m_bundleSymbolicName, this.m_bundleVersion);
        List<BundleCapability> list11 = ManifestParser.convertExports(list10, bundleRevision);
        List<ParsedHeaderClause> list12 = ManifestParser.parseStandardHeader((String)map2.get("Provide-Capability"));
        list10 = ManifestParser.normalizeProvideCapabilityClauses(logger, list12, this.getManifestVersion());
        List<BundleCapability> list13 = ManifestParser.convertProvideCapabilities(list12, bundleRevision);
        if (!this.getManifestVersion().equals("2")) {
            list = ManifestParser.calculateImplicitImports(list11, list3);
            list4.addAll(ManifestParser.convertImports(list, bundleRevision));
            ArrayList<ParsedHeaderClause> arrayList2 = new ArrayList<ParsedHeaderClause>(list.size() + list3.size());
            arrayList2.addAll(list3);
            arrayList2.addAll(list);
            list11 = ManifestParser.calculateImplicitUses(list11, arrayList2);
        }
        this.m_libraryClauses = ManifestParser.parseLibraryStrings(this.m_logger, ManifestParser.parseDelimitedString((String)this.m_headerMap.get("Bundle-NativeCode"), ","));
        if (!this.m_libraryClauses.isEmpty() && this.m_libraryClauses.get(this.m_libraryClauses.size() - 1).getLibraryEntries() == null) {
            this.m_libraryHeadersOptional = true;
            this.m_libraryClauses.remove(this.m_libraryClauses.size() - 1);
        }
        list = ManifestParser.convertNativeCode(bundleRevision, this.m_libraryClauses, this.m_libraryHeadersOptional);
        this.m_requirements = new ArrayList<BundleRequirement>(object2.size() + list4.size() + list2.size() + list8.size() + list6.size() + list9.size());
        this.m_requirements.addAll((Collection<BundleRequirement>)object2);
        this.m_requirements.addAll(list4);
        this.m_requirements.addAll(list2);
        this.m_requirements.addAll(list8);
        this.m_requirements.addAll(list6);
        this.m_requirements.addAll(list9);
        this.m_requirements.addAll(list);
        this.m_capabilities = new ArrayList<BundleCapability>(arrayList.size() + list11.size() + list13.size());
        this.m_capabilities.addAll(arrayList);
        this.m_capabilities.addAll(list11);
        this.m_capabilities.addAll(list13);
        this.parseActivationPolicy(map2);
        this.m_isExtension = ManifestParser.checkExtensionBundle(map2);
    }

    private static List<ParsedHeaderClause> normalizeImportClauses(Logger logger, List<ParsedHeaderClause> list, String string) throws BundleException {
        HashSet<String> hashSet = new HashSet<String>();
        for (ParsedHeaderClause parsedHeaderClause : list) {
            Object object2 = parsedHeaderClause.m_attrs.get("version");
            Object object3 = parsedHeaderClause.m_attrs.get("specification-version");
            if (object2 != null && object3 != null && !((String)object2).trim().equals(((String)object3).trim())) {
                throw new IllegalArgumentException("Both version and specification-version are specified, but they are not equal.");
            }
            if (object2 != null || object3 != null) {
                parsedHeaderClause.m_attrs.remove("specification-version");
                object2 = object2 == null ? object3 : object2;
                parsedHeaderClause.m_attrs.put("version", VersionRange.parse(object2.toString()));
            }
            if ((object2 = parsedHeaderClause.m_attrs.get("bundle-version")) != null) {
                parsedHeaderClause.m_attrs.put("bundle-version", VersionRange.parse(object2.toString()));
            }
            for (String string2 : parsedHeaderClause.m_paths) {
                if (!hashSet.contains(string2)) {
                    if (string2.startsWith("java.")) {
                        throw new BundleException("Importing java.* packages not allowed: " + string2);
                    }
                    if (string2.equals(".")) {
                        throw new BundleException("Imporing '.' is invalid.");
                    }
                    if (string2.length() == 0) {
                        throw new BundleException("Imported package names cannot be zero length.");
                    }
                    hashSet.add(string2);
                    continue;
                }
                throw new BundleException("Duplicate import: " + string2);
            }
            if (string.equals("2")) continue;
            if (!parsedHeaderClause.m_dirs.isEmpty()) {
                throw new BundleException("R3 imports cannot contain directives.");
            }
            if (parsedHeaderClause.m_attrs.isEmpty()) continue;
            Object object4 = parsedHeaderClause.m_attrs.get("version");
            object4 = object4 == null ? new VersionRange(Version.emptyVersion, true, null, true) : object4;
            for (Map.Entry<String, Object> entry : parsedHeaderClause.m_attrs.entrySet()) {
                if (((String)entry.getKey()).equals("version")) continue;
                logger.log(2, "Unknown R3 import attribute: " + (String)entry.getKey());
            }
            parsedHeaderClause.m_attrs.clear();
            parsedHeaderClause.m_attrs.put("version", object4);
        }
        return list;
    }

    public static List<BundleRequirement> parseDynamicImportHeader(Logger logger, BundleRevision bundleRevision, String string) throws BundleException {
        List<ParsedHeaderClause> list = ManifestParser.parseStandardHeader(string);
        list = ManifestParser.normalizeDynamicImportClauses(logger, list, "2");
        List<BundleRequirement> list2 = ManifestParser.convertImports(list, bundleRevision);
        return list2;
    }

    private static List<BundleRequirement> convertImports(List<ParsedHeaderClause> list, BundleRevision bundleRevision) {
        ArrayList<BundleRequirement> arrayList = new ArrayList<BundleRequirement>();
        for (ParsedHeaderClause parsedHeaderClause : list) {
            for (String string : parsedHeaderClause.m_paths) {
                Map<String, Object> map = parsedHeaderClause.m_attrs;
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(map.size() + 1);
                linkedHashMap.put("osgi.wiring.package", string);
                linkedHashMap.putAll(map);
                linkedHashMap.put("osgi.wiring.package", string);
                SimpleFilter simpleFilter = SimpleFilter.convert(linkedHashMap);
                Map<String, String> map2 = parsedHeaderClause.m_dirs;
                HashMap<String, String> hashMap = new HashMap<String, String>(map2.size() + 1);
                hashMap.putAll(map2);
                hashMap.put("filter", simpleFilter.toString());
                arrayList.add(new BundleRequirementImpl(bundleRevision, "osgi.wiring.package", hashMap, Collections.EMPTY_MAP, simpleFilter));
            }
        }
        return arrayList;
    }

    private static List<ParsedHeaderClause> normalizeDynamicImportClauses(Logger logger, List<ParsedHeaderClause> list, String string) throws BundleException {
        for (ParsedHeaderClause parsedHeaderClause : list) {
            if (!string.equals("2") && !parsedHeaderClause.m_dirs.isEmpty()) {
                throw new BundleException("R3 imports cannot contain directives.");
            }
            parsedHeaderClause.m_dirs.put("resolution", "dynamic");
            Object object = parsedHeaderClause.m_attrs.get("version");
            Object object2 = parsedHeaderClause.m_attrs.get("specification-version");
            if (object != null && object2 != null && !((String)object).trim().equals(((String)object2).trim())) {
                throw new IllegalArgumentException("Both version and specification-version are specified, but they are not equal.");
            }
            if (object != null || object2 != null) {
                parsedHeaderClause.m_attrs.remove("specification-version");
                object = object == null ? object2 : object;
                parsedHeaderClause.m_attrs.put("version", VersionRange.parse(object.toString()));
            }
            if ((object = parsedHeaderClause.m_attrs.get("bundle-version")) != null) {
                parsedHeaderClause.m_attrs.put("bundle-version", VersionRange.parse(object.toString()));
            }
            for (String string2 : parsedHeaderClause.m_paths) {
                if (string2.startsWith("java.")) {
                    throw new BundleException("Dynamically importing java.* packages not allowed: " + string2);
                }
                if (string2.equals("*") || !string2.endsWith("*") || string2.endsWith(".*")) continue;
                throw new BundleException("Partial package name wild carding is not allowed: " + string2);
            }
        }
        return list;
    }

    private static List<ParsedHeaderClause> normalizeRequireCapabilityClauses(Logger logger, List<ParsedHeaderClause> list, String string) throws BundleException {
        if (!string.equals("2")) {
            list.isEmpty();
        }
        return list;
    }

    private static List<BundleRequirement> convertRequireCapabilities(List<ParsedHeaderClause> list, BundleRevision bundleRevision) throws BundleException {
        ArrayList<BundleRequirement> arrayList = new ArrayList<BundleRequirement>();
        for (ParsedHeaderClause parsedHeaderClause : list) {
            try {
                String string = parsedHeaderClause.m_dirs.get("filter");
                SimpleFilter simpleFilter = string != null ? SimpleFilter.parse(string) : new SimpleFilter(null, null, 0);
                for (String string2 : parsedHeaderClause.m_paths) {
                    if (string2.startsWith("osgi.wiring.")) {
                        throw new BundleException("Manifest cannot use Require-Capability for '" + string2 + "' namespace.");
                    }
                    arrayList.add(new BundleRequirementImpl(bundleRevision, string2, parsedHeaderClause.m_dirs, parsedHeaderClause.m_attrs, simpleFilter));
                }
            }
            catch (Exception exception) {
                throw new BundleException("Error creating requirement: " + exception);
            }
        }
        return arrayList;
    }

    static List<BundleRequirement> convertNativeCode(BundleRevision bundleRevision, List<NativeLibraryClause> list, boolean bl) {
        ArrayList<BundleRequirement> arrayList = new ArrayList<BundleRequirement>();
        ArrayList<SimpleFilter> arrayList2 = new ArrayList<SimpleFilter>();
        if (list != null && !list.isEmpty()) {
            for (NativeLibraryClause object2 : list) {
                String[] stringArray = object2.getOSNames();
                String[] stringArray2 = object2.getOSVersions();
                String[] stringArray3 = object2.getProcessors();
                String[] stringArray4 = object2.getLanguages();
                String string = object2.getSelectionFilter();
                ArrayList<SimpleFilter> arrayList3 = new ArrayList<SimpleFilter>();
                if (stringArray != null && stringArray.length > 0) {
                    arrayList3.add(ManifestParser.buildFilterFromArray("osgi.native.osname", stringArray, 9));
                }
                if (stringArray2 != null && stringArray2.length > 0) {
                    arrayList3.add(ManifestParser.buildFilterFromArray("osgi.native.osversion", stringArray2, 4));
                }
                if (stringArray3 != null && stringArray3.length > 0) {
                    arrayList3.add(ManifestParser.buildFilterFromArray("osgi.native.processor", stringArray3, 9));
                }
                if (stringArray4 != null && stringArray4.length > 0) {
                    arrayList3.add(ManifestParser.buildFilterFromArray("osgi.native.language", stringArray4, 9));
                }
                if (string != null) {
                    arrayList3.add(SimpleFilter.parse(string));
                }
                if (arrayList3.isEmpty()) continue;
                SimpleFilter simpleFilter = new SimpleFilter(null, arrayList3, 1);
                arrayList2.add(simpleFilter);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Object object3 = null;
            if (bl) {
                hashMap.put("resolution", "optional");
            }
            if (arrayList2.size() > 1) {
                object3 = new SimpleFilter(null, arrayList2, 2);
                hashMap.put("filter", ((SimpleFilter)object3).toString());
            } else if (arrayList2.size() == 1) {
                object3 = (SimpleFilter)arrayList2.get(0);
                hashMap.put("filter", ((SimpleFilter)object3).toString());
            }
            if (hashMap.size() > 0) {
                arrayList.add(new BundleRequirementImpl(bundleRevision, "osgi.native", hashMap, Collections.<String, Object>emptyMap(), (SimpleFilter)object3));
            }
        }
        return arrayList;
    }

    private static SimpleFilter buildFilterFromArray(String string, String[] stringArray, int n) {
        SimpleFilter simpleFilter = null;
        ArrayList<SimpleFilter> arrayList = new ArrayList<SimpleFilter>();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray2[n3];
                arrayList.add(new SimpleFilter(string, string2.toLowerCase(), n));
                ++n3;
            }
            simpleFilter = arrayList.size() == 1 ? (SimpleFilter)arrayList.get(0) : new SimpleFilter(null, arrayList, 2);
        }
        return simpleFilter;
    }

    private static void addStringArrayToSet(String[] stringArray, Set<String> set) {
        if (stringArray != null) {
            set.addAll(Arrays.asList(stringArray));
        }
    }

    private static List<ParsedHeaderClause> normalizeProvideCapabilityClauses(Logger logger, List<ParsedHeaderClause> list, String string) throws BundleException {
        if (!string.equals("2")) {
            list.isEmpty();
        }
        for (ParsedHeaderClause parsedHeaderClause : list) {
            for (Map.Entry<String, String> entry : parsedHeaderClause.m_types.entrySet()) {
                String string2 = entry.getValue();
                if (string2.equals("String")) continue;
                if (string2.equals("Double")) {
                    parsedHeaderClause.m_attrs.put(entry.getKey(), new Double(parsedHeaderClause.m_attrs.get(entry.getKey()).toString().trim()));
                    continue;
                }
                if (string2.equals("Version")) {
                    parsedHeaderClause.m_attrs.put(entry.getKey(), new Version(parsedHeaderClause.m_attrs.get(entry.getKey()).toString().trim()));
                    continue;
                }
                if (string2.equals("Long")) {
                    parsedHeaderClause.m_attrs.put(entry.getKey(), new Long(parsedHeaderClause.m_attrs.get(entry.getKey()).toString().trim()));
                    continue;
                }
                if (string2.startsWith("List")) {
                    int n = string2.indexOf(60);
                    int n2 = string2.indexOf(62);
                    if (n > 0 && n2 <= n || n < 0 && n2 > 0) {
                        throw new BundleException("Invalid Provide-Capability attribute list type for '" + entry.getKey() + "' : " + string2);
                    }
                    String string3 = "String";
                    if (n2 > n) {
                        string3 = string2.substring(n + 1, n2).trim();
                    }
                    List<String> list2 = ManifestParser.parseDelimitedString(parsedHeaderClause.m_attrs.get(entry.getKey()).toString(), ",", false);
                    ArrayList<Object> arrayList = new ArrayList<Object>(list2.size());
                    for (String string4 : list2) {
                        if (string3.equals("String")) {
                            arrayList.add(string4);
                            continue;
                        }
                        if (string3.equals("Double")) {
                            arrayList.add(new Double(string4.trim()));
                            continue;
                        }
                        if (string3.equals("Version")) {
                            arrayList.add(new Version(string4.trim()));
                            continue;
                        }
                        if (string3.equals("Long")) {
                            arrayList.add(new Long(string4.trim()));
                            continue;
                        }
                        throw new BundleException("Unknown Provide-Capability attribute list type for '" + entry.getKey() + "' : " + string2);
                    }
                    parsedHeaderClause.m_attrs.put(entry.getKey(), arrayList);
                    continue;
                }
                throw new BundleException("Unknown Provide-Capability attribute type for '" + entry.getKey() + "' : " + string2);
            }
        }
        return list;
    }

    private static List<BundleCapability> convertProvideCapabilities(List<ParsedHeaderClause> list, BundleRevision bundleRevision) throws BundleException {
        ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>();
        for (ParsedHeaderClause parsedHeaderClause : list) {
            for (String string : parsedHeaderClause.m_paths) {
                if (string.startsWith("osgi.wiring.")) {
                    throw new BundleException("Manifest cannot use Provide-Capability for '" + string + "' namespace.");
                }
                if (string.startsWith("osgi.native") && (bundleRevision == null || !"org.apache.felix.framework".equals(bundleRevision.getSymbolicName()))) {
                    throw new BundleException("Only System Bundle can use Provide-Capability for '" + string + "' namespace.", 3);
                }
                arrayList.add(new BundleCapabilityImpl(bundleRevision, string, parsedHeaderClause.m_dirs, parsedHeaderClause.m_attrs));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private static List<ParsedHeaderClause> normalizeExportClauses(Logger logger, List<ParsedHeaderClause> list, String string, String string2, Version version) throws BundleException {
        for (ParsedHeaderClause parsedHeaderClause : list) {
            void var7_12;
            for (String string3 : parsedHeaderClause.m_paths) {
                if (string3.startsWith("java.")) {
                    throw new BundleException("Exporting java.* packages not allowed: " + string3);
                }
                if (string3.equals(".")) {
                    throw new BundleException("Exporing '.' is invalid.");
                }
                if (string3.length() != 0) continue;
                throw new BundleException("Exported package names cannot be zero length.");
            }
            Object object = parsedHeaderClause.m_attrs.get("version");
            Object object2 = parsedHeaderClause.m_attrs.get("specification-version");
            if (object != null && object2 != null && !((String)object).trim().equals(((String)object2).trim())) {
                throw new IllegalArgumentException("Both version and specification-version are specified, but they are not equal.");
            }
            if (object == null && object2 == null) {
                Version version2 = Version.emptyVersion;
            }
            if (var7_12 != null || object2 != null) {
                parsedHeaderClause.m_attrs.remove("specification-version");
                Object object3 = var7_12 == null ? object2 : var7_12;
                parsedHeaderClause.m_attrs.put("version", Version.parseVersion(object3.toString()));
            }
            if (string.equals("2")) {
                if (parsedHeaderClause.m_attrs.containsKey("bundle-version") || parsedHeaderClause.m_attrs.containsKey("bundle-symbolic-name")) {
                    throw new BundleException("Exports must not specify bundle symbolic name or bundle version.");
                }
                parsedHeaderClause.m_attrs.put("bundle-symbolic-name", string2);
                parsedHeaderClause.m_attrs.put("bundle-version", version);
                continue;
            }
            if (string.equals("2")) continue;
            if (!parsedHeaderClause.m_dirs.isEmpty()) {
                throw new BundleException("R3 exports cannot contain directives.");
            }
            if (parsedHeaderClause.m_attrs.isEmpty()) continue;
            Object object4 = parsedHeaderClause.m_attrs.get("version");
            object4 = object4 == null ? Version.emptyVersion : object4;
            for (Map.Entry<String, Object> entry : parsedHeaderClause.m_attrs.entrySet()) {
                if (entry.getKey().equals("version")) continue;
                logger.log(2, "Unknown R3 export attribute: " + entry.getKey());
            }
            parsedHeaderClause.m_attrs.clear();
            parsedHeaderClause.m_attrs.put("version", object4);
        }
        return list;
    }

    private static List<BundleCapability> convertExports(List<ParsedHeaderClause> list, BundleRevision bundleRevision) {
        ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>();
        for (ParsedHeaderClause parsedHeaderClause : list) {
            for (String string : parsedHeaderClause.m_paths) {
                Map<String, Object> map = parsedHeaderClause.m_attrs;
                HashMap<String, Object> hashMap = new HashMap<String, Object>(map.size() + 1);
                hashMap.putAll(map);
                hashMap.put("osgi.wiring.package", string);
                arrayList.add(new BundleCapabilityImpl(bundleRevision, "osgi.wiring.package", parsedHeaderClause.m_dirs, hashMap));
            }
        }
        return arrayList;
    }

    public String getManifestVersion() {
        String string = ManifestParser.getManifestVersion(this.m_headerMap);
        return string == null ? "1" : string;
    }

    private static String getManifestVersion(Map map) {
        String string = (String)map.get("Bundle-ManifestVersion");
        return string == null ? null : string.trim();
    }

    public int getActivationPolicy() {
        return this.m_activationPolicy;
    }

    public String getActivationIncludeDirective() {
        return this.m_activationIncludeDir;
    }

    public String getActivationExcludeDirective() {
        return this.m_activationExcludeDir;
    }

    public boolean isExtension() {
        return this.m_isExtension;
    }

    public String getSymbolicName() {
        return this.m_bundleSymbolicName;
    }

    public Version getBundleVersion() {
        return this.m_bundleVersion;
    }

    public List<BundleCapability> getCapabilities() {
        return this.m_capabilities;
    }

    public List<BundleRequirement> getRequirements() {
        return this.m_requirements;
    }

    public List<NativeLibraryClause> getLibraryClauses() {
        return this.m_libraryClauses;
    }

    public List<NativeLibrary> getLibraries() {
        ArrayList<NativeLibrary> arrayList = null;
        try {
            NativeLibraryClause nativeLibraryClause = this.getSelectedLibraryClause();
            if (nativeLibraryClause != null) {
                String[] stringArray = nativeLibraryClause.getLibraryEntries();
                arrayList = new ArrayList(stringArray.length);
                int n = 0;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string = this.getName(stringArray[n2]);
                    boolean bl = false;
                    int n3 = 0;
                    while (!bl && n3 < n) {
                        bl = this.getName(stringArray[n3]).equals(string);
                        ++n3;
                    }
                    if (!bl) {
                        arrayList.add(new NativeLibrary(nativeLibraryClause.getLibraryEntries()[n2], nativeLibraryClause.getOSNames(), nativeLibraryClause.getProcessors(), nativeLibraryClause.getOSVersions(), nativeLibraryClause.getLanguages(), nativeLibraryClause.getSelectionFilter()));
                    }
                    ++n2;
                }
                arrayList.trimToSize();
            }
        }
        catch (Exception exception) {
            arrayList = new ArrayList<NativeLibrary>(0);
        }
        return arrayList;
    }

    private String getName(String string) {
        int n = string.lastIndexOf(47);
        if (n > -1) {
            return string.substring(n);
        }
        return string;
    }

    private NativeLibraryClause getSelectedLibraryClause() throws BundleException {
        if (this.m_libraryClauses != null && this.m_libraryClauses.size() > 0) {
            ArrayList<NativeLibraryClause> arrayList = new ArrayList<NativeLibraryClause>();
            for (NativeLibraryClause nativeLibraryClause : this.m_libraryClauses) {
                if (!nativeLibraryClause.match(this.m_configMap)) continue;
                arrayList.add(nativeLibraryClause);
            }
            int n = 0;
            if (arrayList.isEmpty()) {
                if (this.m_libraryHeadersOptional) {
                    return null;
                }
                throw new BundleException("Unable to select a native library clause.");
            }
            if (arrayList.size() == 1) {
                n = 0;
            } else if (arrayList.size() > 1) {
                n = this.firstSortedClause(arrayList);
            }
            return (NativeLibraryClause)arrayList.get(n);
        }
        return null;
    }

    private int firstSortedClause(List<NativeLibraryClause> list) {
        VersionRange versionRange;
        int n;
        String[] stringArray;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n3 = 0;
        while (n3 < list.size()) {
            arrayList.add("" + n3);
            ++n3;
        }
        Version version = new Version(0, 0, 0);
        int n4 = 0;
        while (n4 < arrayList.size()) {
            n2 = Integer.parseInt(arrayList.get(n4).toString());
            stringArray = list.get(n2).getOSVersions();
            if (stringArray != null) {
                arrayList2.add("" + arrayList.get(n4));
            }
            n = 0;
            while (stringArray != null && n < stringArray.length) {
                versionRange = VersionRange.parse(stringArray[n]);
                if (versionRange.getFloor().compareTo(version) >= 0) {
                    version = versionRange.getFloor();
                }
                ++n;
            }
            ++n4;
        }
        if (arrayList2.size() == 1) {
            return Integer.parseInt(arrayList2.get(0).toString());
        }
        if (arrayList2.size() > 1) {
            arrayList = arrayList2;
            arrayList2 = new ArrayList();
            n4 = 0;
            while (n4 < arrayList.size()) {
                n2 = Integer.parseInt(arrayList.get(n4).toString());
                stringArray = list.get(n2).getOSVersions();
                n = 0;
                while (n < stringArray.length) {
                    versionRange = VersionRange.parse(stringArray[n]);
                    if (versionRange.getFloor().compareTo(version) >= 0) {
                        arrayList2.add("" + arrayList.get(n4));
                    }
                    ++n;
                }
                ++n4;
            }
        }
        if (arrayList2.isEmpty()) {
            arrayList2.clear();
            arrayList.clear();
            n4 = 0;
            while (n4 < list.size()) {
                arrayList.add("" + n4);
                ++n4;
            }
        } else {
            if (arrayList2.size() == 1) {
                return Integer.parseInt(arrayList2.get(0).toString());
            }
            arrayList = arrayList2;
            arrayList2.clear();
        }
        n4 = 0;
        while (n4 < arrayList.size()) {
            n2 = Integer.parseInt(arrayList.get(n4).toString());
            if (list.get(n2).getLanguages() != null) {
                arrayList2.add("" + arrayList.get(n4));
            }
            ++n4;
        }
        if (arrayList2.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(arrayList2.get(0).toString());
    }

    private static List<ParsedHeaderClause> calculateImplicitImports(List<BundleCapability> list, List<ParsedHeaderClause> list2) throws BundleException {
        ArrayList<ParsedHeaderClause> arrayList = new ArrayList<ParsedHeaderClause>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < list2.size()) {
            int n2 = 0;
            while (n2 < list2.get((int)n).m_paths.size()) {
                hashMap.put(list2.get((int)n).m_paths.get(n2), list2.get((int)n).m_paths.get(n2));
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < list.size()) {
            if (hashMap.get(list.get(n).getAttributes().get("osgi.wiring.package")) == null) {
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                Object object = list.get(n).getAttributes().get("version");
                if (object != null) {
                    hashMap2.put("version", VersionRange.parse(object.toString()));
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add((String)list.get(n).getAttributes().get("osgi.wiring.package"));
                arrayList.add(new ParsedHeaderClause(arrayList2, Collections.EMPTY_MAP, hashMap2, Collections.EMPTY_MAP));
            }
            ++n;
        }
        return arrayList;
    }

    private static List<BundleCapability> calculateImplicitUses(List<BundleCapability> list, List<ParsedHeaderClause> list2) throws BundleException {
        String string = "";
        int n = 0;
        while (n < list2.size()) {
            int n2 = 0;
            while (n2 < list2.get((int)n).m_paths.size()) {
                string = String.valueOf(string) + (string.length() > 0 ? "," : "") + list2.get((int)n).m_paths.get(n2);
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < list.size()) {
            HashMap<String, String> hashMap = new HashMap<String, String>(1);
            hashMap.put("uses", string);
            list.set(n, new BundleCapabilityImpl(list.get(n).getRevision(), "osgi.wiring.package", hashMap, list.get(n).getAttributes()));
            ++n;
        }
        return list;
    }

    private static boolean checkExtensionBundle(Map map) throws BundleException {
        String string = ManifestParser.parseExtensionBundleHeader((String)map.get("Fragment-Host"));
        if (string != null) {
            if (!"framework".equals(string) && !"bootclasspath".equals(string)) {
                throw new BundleException("Extension bundle must have either 'extension:=framework' or 'extension:=bootclasspath'");
            }
            if (map.containsKey("Import-Package") || map.containsKey("Require-Bundle") || map.containsKey("Bundle-NativeCode") || map.containsKey("DynamicImport-Package") || map.containsKey("Bundle-Activator")) {
                throw new BundleException("Invalid extension bundle manifest");
            }
            return true;
        }
        return false;
    }

    private static BundleCapabilityImpl parseBundleSymbolicName(BundleRevision bundleRevision, Map map) throws BundleException {
        List<ParsedHeaderClause> list = ManifestParser.parseStandardHeader((String)map.get("Bundle-SymbolicName"));
        if (list.size() > 0) {
            if (list.size() > 1) {
                throw new BundleException("Cannot have multiple symbolic names: " + map.get("Bundle-SymbolicName"));
            }
            if (list.get((int)0).m_paths.size() > 1) {
                throw new BundleException("Cannot have multiple symbolic names: " + map.get("Bundle-SymbolicName"));
            }
            Version version = Version.emptyVersion;
            if (map.get("Bundle-Version") != null) {
                try {
                    version = Version.parseVersion((String)map.get("Bundle-Version"));
                }
                catch (RuntimeException runtimeException) {
                    String string = ManifestParser.getManifestVersion(map);
                    if (string != null) {
                        throw runtimeException;
                    }
                    version = Version.emptyVersion;
                }
            }
            String string = list.get((int)0).m_paths.get(0);
            list.get((int)0).m_attrs.put("osgi.wiring.bundle", string);
            list.get((int)0).m_attrs.put("bundle-version", version);
            return new BundleCapabilityImpl(bundleRevision, "osgi.wiring.bundle", list.get((int)0).m_dirs, list.get((int)0).m_attrs);
        }
        return null;
    }

    private static BundleCapabilityImpl addIdentityCapability(BundleRevision bundleRevision, Map map, BundleCapabilityImpl bundleCapabilityImpl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("osgi.identity", bundleCapabilityImpl.getAttributes().get("osgi.wiring.bundle"));
        hashMap.put("type", map.get("Fragment-Host") == null ? "osgi.bundle" : "osgi.fragment");
        hashMap.put("version", bundleCapabilityImpl.getAttributes().get("bundle-version"));
        if (map.get("Bundle-Copyright") != null) {
            hashMap.put("copyright", map.get("Bundle-Copyright"));
        }
        if (map.get("Bundle-Description") != null) {
            hashMap.put("description", map.get("Bundle-Description"));
        }
        if (map.get("Bundle-DocURL") != null) {
            hashMap.put("documentation", map.get("Bundle-DocURL"));
        }
        if (map.get(BUNDLE_LICENSE_HEADER) != null) {
            hashMap.put("license", map.get(BUNDLE_LICENSE_HEADER));
        }
        Map<String, String> map2 = bundleCapabilityImpl.getDirectives().get("singleton") != null ? Collections.singletonMap("singleton", bundleCapabilityImpl.getDirectives().get("singleton")) : Collections.emptyMap();
        return new BundleCapabilityImpl(bundleRevision, "osgi.identity", map2, hashMap);
    }

    private static List<BundleRequirementImpl> parseFragmentHost(Logger logger, BundleRevision bundleRevision, Map map) throws BundleException {
        ArrayList<BundleRequirementImpl> arrayList = new ArrayList<BundleRequirementImpl>();
        String string = ManifestParser.getManifestVersion(map);
        if (string != null && string.equals("2")) {
            List<ParsedHeaderClause> list = ManifestParser.parseStandardHeader((String)map.get("Fragment-Host"));
            if (list.size() > 0) {
                if (list.size() > 1) {
                    throw new BundleException("Fragments cannot have multiple hosts: " + map.get("Fragment-Host"));
                }
                if (list.get((int)0).m_paths.size() > 1) {
                    throw new BundleException("Fragments cannot have multiple hosts: " + map.get("Fragment-Host"));
                }
                Object object = list.get((int)0).m_attrs.get("bundle-version");
                Object object2 = object = object == null ? "0.0.0" : object;
                if (object != null) {
                    list.get((int)0).m_attrs.put("bundle-version", VersionRange.parse(object.toString()));
                }
                Map<String, Object> map2 = list.get((int)0).m_attrs;
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(map2.size() + 1);
                linkedHashMap.put("osgi.wiring.host", list.get((int)0).m_paths.get(0));
                linkedHashMap.putAll(map2);
                linkedHashMap.put("osgi.wiring.host", list.get((int)0).m_paths.get(0));
                SimpleFilter simpleFilter = SimpleFilter.convert(linkedHashMap);
                Map<String, String> map3 = list.get((int)0).m_dirs;
                HashMap<String, String> hashMap = new HashMap<String, String>(map3.size() + 1);
                hashMap.putAll(map3);
                hashMap.put("filter", simpleFilter.toString());
                arrayList.add(new BundleRequirementImpl(bundleRevision, "osgi.wiring.host", hashMap, linkedHashMap));
            }
        } else if (map.get("Fragment-Host") != null) {
            String string2 = (String)map.get("Bundle-SymbolicName");
            string2 = string2 == null ? (String)map.get("Bundle-Name") : string2;
            string2 = string2 == null ? map.toString() : string2;
            logger.log(2, "Only R4 bundles can be fragments: " + string2);
        }
        return arrayList;
    }

    public static List<BundleCapability> parseExportHeader(Logger logger, BundleRevision bundleRevision, String string, String string2, Version version) {
        List<BundleCapability> list = null;
        try {
            List<ParsedHeaderClause> list2 = ManifestParser.parseStandardHeader(string);
            list2 = ManifestParser.normalizeExportClauses(logger, list2, "2", string2, version);
            list = ManifestParser.convertExports(list2, bundleRevision);
        }
        catch (BundleException bundleException) {
            list = null;
        }
        return list;
    }

    private static List<BundleRequirement> parseBreeHeader(String string, BundleRevision bundleRevision) {
        Object object;
        String string222;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string222 : ManifestParser.parseDelimitedString(string, ",")) {
            Object object2;
            Version version;
            List<String> object3 = ManifestParser.parseDelimitedString(string222, "/");
            List<String> list = ManifestParser.parseDelimitedString(object3.get(0), "-");
            String string2 = (String)list.get(0);
            try {
                version = Version.parseVersion((String)list.get(1));
            }
            catch (Exception exception) {
                string2 = object3.get(0);
                version = null;
            }
            String string3 = null;
            Version version2 = null;
            if (object3.size() > 1) {
                object2 = ManifestParser.parseDelimitedString(object3.get(1), "-");
                string3 = (String)object2.get(0);
                try {
                    version2 = Version.parseVersion((String)object2.get(1));
                }
                catch (Exception exception) {
                    string3 = object3.get(1);
                    version2 = null;
                }
            }
            if (version != null) {
                if (version2 != null && !version2.equals(version)) {
                    string2 = object3.get(0);
                    string3 = object3.get(1);
                    object2 = null;
                } else {
                    object2 = ManifestParser.getBreeVersionClause(version);
                }
            } else {
                object2 = ManifestParser.getBreeVersionClause(version2);
            }
            if ("J2SE".equals(string2)) {
                string2 = "JavaSE";
            }
            String string4 = string3 != null ? "(osgi.ee=" + string2 + "/" + string3 + ")" : "(osgi.ee=" + string2 + ")";
            String string5 = object2 != null ? "(&" + string4 + (String)object2 + ")" : string4;
            arrayList.add(string5);
        }
        if (arrayList.size() == 0) {
            return Collections.emptyList();
        }
        if (arrayList.size() == 1) {
            string222 = (String)arrayList.get(0);
        } else {
            object = new StringBuilder("(|");
            for (String string6 : arrayList) {
                ((StringBuilder)object).append(string6);
            }
            ((StringBuilder)object).append(")");
            string222 = ((StringBuilder)object).toString();
        }
        object = SimpleFilter.parse(string222);
        return Collections.singletonList(new BundleRequirementImpl(bundleRevision, "osgi.ee", Collections.singletonMap("filter", string222), Collections.<String, Object>emptyMap(), (SimpleFilter)object));
    }

    private static String getBreeVersionClause(Version version) {
        if (version == null) {
            return null;
        }
        return "(version=" + version + ")";
    }

    private static List<ParsedHeaderClause> normalizeRequireClauses(Logger logger, List<ParsedHeaderClause> list, String string) {
        if (!string.equals("2")) {
            list.clear();
        } else {
            for (ParsedHeaderClause parsedHeaderClause : list) {
                Object object = parsedHeaderClause.m_attrs.get("bundle-version");
                if (object == null) continue;
                parsedHeaderClause.m_attrs.put("bundle-version", VersionRange.parse(object.toString()));
            }
        }
        return list;
    }

    private static List<BundleRequirementImpl> convertRequires(List<ParsedHeaderClause> list, BundleRevision bundleRevision) {
        ArrayList<BundleRequirementImpl> arrayList = new ArrayList<BundleRequirementImpl>();
        for (ParsedHeaderClause parsedHeaderClause : list) {
            for (String string : parsedHeaderClause.m_paths) {
                Map<String, Object> map = parsedHeaderClause.m_attrs;
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(map.size() + 1);
                linkedHashMap.put("osgi.wiring.bundle", string);
                linkedHashMap.putAll(map);
                linkedHashMap.put("osgi.wiring.bundle", string);
                SimpleFilter simpleFilter = SimpleFilter.convert(linkedHashMap);
                Map<String, String> map2 = parsedHeaderClause.m_dirs;
                HashMap<String, String> hashMap = new HashMap<String, String>(map2.size() + 1);
                hashMap.putAll(map2);
                hashMap.put("filter", simpleFilter.toString());
                arrayList.add(new BundleRequirementImpl(bundleRevision, "osgi.wiring.bundle", hashMap, linkedHashMap));
            }
        }
        return arrayList;
    }

    public static String parseExtensionBundleHeader(String string) throws BundleException {
        List<ParsedHeaderClause> list = ManifestParser.parseStandardHeader(string);
        String string2 = null;
        if (list.size() == 1) {
            for (Map.Entry<String, String> entry : list.get((int)0).m_dirs.entrySet()) {
                if (!"extension".equals(entry.getKey())) continue;
                string2 = entry.getValue();
            }
            if ("org.apache.felix.framework".equals(list.get((int)0).m_paths.get(0)) || "system.bundle".equals(list.get((int)0).m_paths.get(0))) {
                string2 = string2 == null ? "framework" : string2;
            } else if (string2 != null) {
                throw new BundleException("Only the system bundle can have extension bundles.");
            }
        }
        return string2;
    }

    private void parseActivationPolicy(Map map) {
        this.m_activationPolicy = 0;
        List<ParsedHeaderClause> list = ManifestParser.parseStandardHeader((String)map.get("Bundle-ActivationPolicy"));
        if (list.size() > 0) {
            for (String string : list.get((int)0).m_paths) {
                if (!string.equals("lazy")) continue;
                this.m_activationPolicy = 1;
                for (Map.Entry<String, String> entry : list.get((int)0).m_dirs.entrySet()) {
                    if (entry.getKey().equalsIgnoreCase("include")) {
                        this.m_activationIncludeDir = entry.getValue();
                        continue;
                    }
                    if (!entry.getKey().equalsIgnoreCase("exclude")) continue;
                    this.m_activationExcludeDir = entry.getValue();
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        if (string != null) {
            if (string.length() == 0) {
                throw new IllegalArgumentException("A header cannot be an empty string.");
            }
            List<ParsedHeaderClause> list = ManifestParser.parseStandardHeader(string);
            for (ParsedHeaderClause parsedHeaderClause : list) {
                System.out.println("PATHS " + parsedHeaderClause.m_paths);
                System.out.println("    DIRS  " + parsedHeaderClause.m_dirs);
                System.out.println("    ATTRS " + parsedHeaderClause.m_attrs);
                System.out.println("    TYPES " + parsedHeaderClause.m_types);
            }
        }
    }

    private static char charAt(int n, String string, int n2) {
        if (n >= n2) {
            return '\uffff';
        }
        return string.charAt(n);
    }

    private static List<ParsedHeaderClause> parseStandardHeader(String string) {
        ArrayList<ParsedHeaderClause> arrayList = new ArrayList<ParsedHeaderClause>();
        if (string == null) {
            return arrayList;
        }
        ParsedHeaderClause parsedHeaderClause = null;
        String string2 = null;
        Map<String, Object> map = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        char c = '\uffff';
        do {
            c = ManifestParser.charAt(n2, string, n4);
            switch (n) {
                case 0: {
                    parsedHeaderClause = new ParsedHeaderClause(new ArrayList<String>(), new HashMap<String, String>(), new HashMap<String, Object>(), new HashMap<String, String>());
                    arrayList.add(parsedHeaderClause);
                    n = 1;
                }
                case 1: {
                    n3 = n2;
                    n = 2;
                }
                case 2: {
                    switch (c) {
                        case ':': 
                        case '=': {
                            string2 = string.substring(n3, n2).trim();
                            n3 = n2 + 1;
                            map = parsedHeaderClause.m_attrs;
                            n = c == ':' ? 4 : 8;
                            break;
                        }
                        case ',': 
                        case ';': 
                        case '\uffff': {
                            parsedHeaderClause.m_paths.add(string.substring(n3, n2).trim());
                            n = c == ',' ? 0 : 1;
                            break;
                        }
                    }
                    ++n2;
                    break;
                }
                case 4: {
                    switch (c) {
                        case '=': {
                            if (n3 != n2) {
                                parsedHeaderClause.m_types.put(string2, string.substring(n3, n2).trim());
                            } else {
                                map = parsedHeaderClause.m_dirs;
                            }
                            n = 8;
                            n3 = n2 + 1;
                            break;
                        }
                    }
                    ++n2;
                    break;
                }
                case 8: {
                    if (c == '\"') {
                        bl = true;
                        ++n2;
                    } else {
                        bl = false;
                    }
                    if (!Character.isWhitespace(c)) {
                        n = 16;
                        break;
                    }
                    ++n2;
                    break;
                }
                case 16: {
                    if (bl2) {
                        bl2 = false;
                    } else if (c == '\\') {
                        bl2 = true;
                    } else if (bl && c == '\"') {
                        bl = false;
                    } else if (!bl) {
                        String string3 = null;
                        switch (c) {
                            case ',': 
                            case ';': 
                            case '\uffff': {
                                string3 = string.substring(n3, n2).trim();
                                if (string3.startsWith("\"") && string3.endsWith("\"")) {
                                    string3 = string3.substring(1, string3.length() - 1);
                                }
                                if (map.put(string2, string3) != null) {
                                    throw new IllegalArgumentException("Duplicate '" + string2 + "' in: " + string);
                                }
                                n = c == ';' ? 1 : 0;
                                break;
                            }
                        }
                    }
                    ++n2;
                    break;
                }
            }
        } while (c != 65535);
        if (n > 1) {
            throw new IllegalArgumentException("Unable to parse header: " + string);
        }
        return arrayList;
    }

    public static List<String> parseDelimitedString(String string, String string2) {
        return ManifestParser.parseDelimitedString(string, string2, true);
    }

    public static List<String> parseDelimitedString(String string, String string2, boolean bl) {
        if (string == null) {
            string = "";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        int n2 = 2;
        int n3 = 4;
        int n4 = 8;
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = n | n2 | n3;
        boolean bl2 = false;
        int n6 = 0;
        while (n6 < string.length()) {
            boolean bl3;
            char c = string.charAt(n6);
            boolean bl4 = bl3 = string2.indexOf(c) >= 0;
            if (!bl2 && c == '\\') {
                bl2 = true;
            } else {
                if (bl2) {
                    stringBuffer.append(c);
                } else if (bl3 && (n5 & n2) > 0) {
                    if (bl) {
                        arrayList.add(stringBuffer.toString().trim());
                    } else {
                        arrayList.add(stringBuffer.toString());
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    n5 = n | n2 | n3;
                } else if (c == '\"' && (n5 & n3) > 0) {
                    stringBuffer.append(c);
                    n5 = n | n4;
                } else if (c == '\"' && (n5 & n4) > 0) {
                    stringBuffer.append(c);
                    n5 = n | n3 | n2;
                } else if ((n5 & n) > 0) {
                    stringBuffer.append(c);
                } else {
                    throw new IllegalArgumentException("Invalid delimited string: " + string);
                }
                bl2 = false;
            }
            ++n6;
        }
        if (stringBuffer.length() > 0) {
            if (bl) {
                arrayList.add(stringBuffer.toString().trim());
            } else {
                arrayList.add(stringBuffer.toString());
            }
        }
        return arrayList;
    }

    private static List<NativeLibraryClause> parseLibraryStrings(Logger logger, List<String> list) throws IllegalArgumentException {
        if (list == null) {
            return new ArrayList<NativeLibraryClause>(0);
        }
        ArrayList<NativeLibraryClause> arrayList = new ArrayList<NativeLibraryClause>(list.size());
        int n = 0;
        while (n < list.size()) {
            NativeLibraryClause nativeLibraryClause = NativeLibraryClause.parse(logger, list.get(n));
            arrayList.add(nativeLibraryClause);
            ++n;
        }
        return arrayList;
    }
}

