/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.felix.framework.util.Mutex;
import org.apache.felix.framework.util.SecureAction;

public class WeakZipFileFactory {
    private static final int WEAKLY_CLOSED = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    private static final SecureAction m_secureAction = new SecureAction();
    private final List<WeakZipFile> m_zipFiles = new ArrayList<WeakZipFile>();
    private final List<WeakZipFile> m_openFiles = new ArrayList<WeakZipFile>();
    private final Mutex m_globalMutex = new Mutex();
    private final int m_limit;

    public WeakZipFileFactory(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Limit must be non-negative.");
        }
        this.m_limit = n;
    }

    public WeakZipFile create(File file) throws IOException {
        WeakZipFile weakZipFile = new WeakZipFile(file);
        if (this.m_limit > 0) {
            try {
                this.m_globalMutex.down();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while acquiring global zip file mutex.");
            }
            try {
                this.m_zipFiles.add(weakZipFile);
                this.m_openFiles.add(weakZipFile);
                if (this.m_openFiles.size() > this.m_limit) {
                    WeakZipFile weakZipFile2 = this.m_openFiles.get(0);
                    for (WeakZipFile weakZipFile3 : this.m_openFiles) {
                        if (weakZipFile2.m_timestamp <= weakZipFile3.m_timestamp) continue;
                        weakZipFile2 = weakZipFile3;
                    }
                    weakZipFile2._closeWeakly();
                }
            }
            finally {
                this.m_globalMutex.up();
            }
        }
        return weakZipFile;
    }

    List<WeakZipFile> getZipZiles() {
        try {
            this.m_globalMutex.down();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return Collections.EMPTY_LIST;
        }
        try {
            List<WeakZipFile> list = this.m_zipFiles;
            return list;
        }
        finally {
            this.m_globalMutex.up();
        }
    }

    List<WeakZipFile> getOpenZipZiles() {
        try {
            this.m_globalMutex.down();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return Collections.EMPTY_LIST;
        }
        try {
            List<WeakZipFile> list = this.m_openFiles;
            return list;
        }
        finally {
            this.m_globalMutex.up();
        }
    }

    public class WeakZipFile {
        private final File m_file;
        private final Mutex m_localMutex = new Mutex();
        private ZipFile m_zipFile;
        private int m_status = 1;
        private long m_timestamp;
        private volatile SoftReference<List<ZipEntry>> m_entries;

        private WeakZipFile(File file) throws IOException {
            this.m_file = file;
            this.m_zipFile = m_secureAction.openZipFile(this.m_file);
            this.m_timestamp = System.currentTimeMillis();
        }

        public ZipEntry getEntry(String string) {
            this.ensureZipFileIsOpen();
            try {
                ZipEntry zipEntry;
                ZipEntry zipEntry2 = null;
                zipEntry2 = this.m_zipFile.getEntry(string);
                if (zipEntry2 != null && zipEntry2.getSize() == 0L && !zipEntry2.isDirectory() && (zipEntry = this.m_zipFile.getEntry(String.valueOf(string) + '/')) != null) {
                    zipEntry2 = zipEntry;
                }
                ZipEntry zipEntry3 = zipEntry2;
                return zipEntry3;
            }
            finally {
                this.m_localMutex.up();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration<ZipEntry> entries() {
            this.ensureZipFileIsOpen();
            try {
                List<ZipEntry> list = null;
                if (this.m_entries != null) {
                    list = this.m_entries.get();
                }
                if (list == null) {
                    WeakZipFile weakZipFile = this;
                    synchronized (weakZipFile) {
                        if (this.m_entries != null) {
                            list = this.m_entries.get();
                        }
                        if (list == null) {
                            Enumeration<? extends ZipEntry> enumeration = this.m_zipFile.entries();
                            list = new ArrayList<ZipEntry>();
                            while (enumeration.hasMoreElements()) {
                                list.add(enumeration.nextElement());
                            }
                            this.m_entries = new SoftReference<List<ZipEntry>>(list);
                        }
                    }
                }
                Enumeration<ZipEntry> enumeration = Collections.enumeration(list);
                return enumeration;
            }
            finally {
                this.m_localMutex.up();
            }
        }

        public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
            this.ensureZipFileIsOpen();
            try {
                InputStream inputStream = this.m_zipFile.getInputStream(zipEntry);
                WeakZipInputStream weakZipInputStream = new WeakZipInputStream(zipEntry.getName(), inputStream);
                return weakZipInputStream;
            }
            finally {
                this.m_localMutex.up();
            }
        }

        void closeWeakly() {
            try {
                WeakZipFileFactory.this.m_globalMutex.down();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while acquiring global zip file mutex.");
            }
            try {
                this._closeWeakly();
            }
            finally {
                WeakZipFileFactory.this.m_globalMutex.up();
            }
        }

        private void _closeWeakly() {
            try {
                this.m_localMutex.down();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while acquiring local zip file mutex.");
            }
            try {
                if (this.m_status == 1) {
                    try {
                        this.m_status = 0;
                        if (this.m_zipFile != null) {
                            this.m_zipFile.close();
                            this.m_zipFile = null;
                        }
                        WeakZipFileFactory.this.m_openFiles.remove(this);
                    }
                    catch (IOException iOException) {
                        this.__close();
                    }
                }
            }
            finally {
                this.m_localMutex.up();
            }
        }

        public void close() throws IOException {
            if (WeakZipFileFactory.this.m_limit > 0) {
                try {
                    WeakZipFileFactory.this.m_globalMutex.down();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Interrupted while acquiring global zip file mutex.");
                }
                try {
                    this.m_localMutex.down();
                }
                catch (InterruptedException interruptedException) {
                    WeakZipFileFactory.this.m_globalMutex.up();
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Interrupted while acquiring local zip file mutex.");
                }
            }
            try {
                ZipFile zipFile = this.m_zipFile;
                this.__close();
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            finally {
                this.m_localMutex.up();
                WeakZipFileFactory.this.m_globalMutex.up();
            }
        }

        private void __close() {
            this.m_status = 2;
            this.m_zipFile = null;
            WeakZipFileFactory.this.m_zipFiles.remove(this);
            WeakZipFileFactory.this.m_openFiles.remove(this);
        }

        private void ensureZipFileIsOpen() {
            if (WeakZipFileFactory.this.m_limit == 0) {
                return;
            }
            try {
                this.m_localMutex.down();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while acquiring local zip file mutex.");
            }
            if (this.m_status == 2) {
                this.m_localMutex.up();
                throw new IllegalStateException("Zip file is closed: " + this.m_file);
            }
            IOException iOException = null;
            if (this.m_status == 0) {
                this.m_localMutex.up();
                try {
                    WeakZipFileFactory.this.m_globalMutex.down();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Interrupted while acquiring global zip file mutex.");
                }
                try {
                    this.m_localMutex.down();
                }
                catch (InterruptedException interruptedException) {
                    WeakZipFileFactory.this.m_globalMutex.up();
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Interrupted while acquiring local zip file mutex.");
                }
                if (this.m_status == 2) {
                    this.m_localMutex.up();
                    WeakZipFileFactory.this.m_globalMutex.up();
                    throw new IllegalStateException("Zip file is closed: " + this.m_file);
                }
                if (this.m_status == 0) {
                    try {
                        this.__reopenZipFile();
                    }
                    catch (IOException iOException2) {
                        iOException = iOException2;
                    }
                }
                WeakZipFileFactory.this.m_globalMutex.up();
            }
            if (this.m_zipFile == null) {
                this.m_localMutex.up();
                IllegalStateException illegalStateException = new IllegalStateException("Zip file is closed: " + this.m_file);
                if (iOException != null) {
                    illegalStateException.initCause(iOException);
                }
                throw illegalStateException;
            }
        }

        private void __reopenZipFile() throws IOException {
            if (this.m_status == 0) {
                try {
                    this.m_zipFile = m_secureAction.openZipFile(this.m_file);
                    this.m_status = 1;
                    this.m_timestamp = System.currentTimeMillis();
                }
                catch (IOException iOException) {
                    this.__close();
                    throw iOException;
                }
                if (this.m_zipFile != null) {
                    WeakZipFileFactory.this.m_openFiles.add(this);
                    if (WeakZipFileFactory.this.m_openFiles.size() > WeakZipFileFactory.this.m_limit) {
                        WeakZipFile weakZipFile = (WeakZipFile)WeakZipFileFactory.this.m_openFiles.get(0);
                        for (WeakZipFile weakZipFile2 : WeakZipFileFactory.this.m_openFiles) {
                            if (weakZipFile.m_timestamp <= weakZipFile2.m_timestamp) continue;
                            weakZipFile = weakZipFile2;
                        }
                        weakZipFile._closeWeakly();
                    }
                }
            }
        }

        class WeakZipInputStream
        extends InputStream {
            private final String m_entryName;
            private InputStream m_is;
            private int m_currentPos = 0;
            private ZipFile m_zipFileSnapshot;

            WeakZipInputStream(String string, InputStream inputStream) {
                this.m_entryName = string;
                this.m_is = inputStream;
                this.m_zipFileSnapshot = WeakZipFile.this.m_zipFile;
            }

            private void ensureInputStreamIsValid() throws IOException {
                if (WeakZipFileFactory.this.m_limit == 0) {
                    return;
                }
                WeakZipFile.this.ensureZipFileIsOpen();
                if (this.m_zipFileSnapshot != WeakZipFile.this.m_zipFile) {
                    this.m_zipFileSnapshot = WeakZipFile.this.m_zipFile;
                    if (this.m_is != null) {
                        try {
                            this.m_is.close();
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        this.m_is = WeakZipFile.this.m_zipFile.getInputStream(WeakZipFile.this.m_zipFile.getEntry(this.m_entryName));
                        this.m_is.skip(this.m_currentPos);
                    }
                    catch (IOException iOException) {
                        WeakZipFile.this.m_localMutex.up();
                        throw iOException;
                    }
                }
            }

            @Override
            public int available() throws IOException {
                this.ensureInputStreamIsValid();
                try {
                    int n = this.m_is.available();
                    return n;
                }
                finally {
                    WeakZipFile.this.m_localMutex.up();
                }
            }

            @Override
            public void close() throws IOException {
                this.ensureInputStreamIsValid();
                try {
                    InputStream inputStream = this.m_is;
                    this.m_is = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                finally {
                    WeakZipFile.this.m_localMutex.up();
                }
            }

            @Override
            public void mark(int n) {
            }

            @Override
            public boolean markSupported() {
                return false;
            }

            @Override
            public int read() throws IOException {
                this.ensureInputStreamIsValid();
                try {
                    int n = this.m_is.read();
                    if (n > 0) {
                        ++this.m_currentPos;
                    }
                    int n2 = n;
                    return n2;
                }
                finally {
                    WeakZipFile.this.m_localMutex.up();
                }
            }

            @Override
            public int read(byte[] byArray) throws IOException {
                this.ensureInputStreamIsValid();
                try {
                    int n = this.m_is.read(byArray);
                    if (n > 0) {
                        this.m_currentPos += n;
                    }
                    int n2 = n;
                    return n2;
                }
                finally {
                    WeakZipFile.this.m_localMutex.up();
                }
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                this.ensureInputStreamIsValid();
                try {
                    int n3 = this.m_is.read(byArray, n, n2);
                    if (n3 > 0) {
                        this.m_currentPos += n3;
                    }
                    int n4 = n3;
                    return n4;
                }
                finally {
                    WeakZipFile.this.m_localMutex.up();
                }
            }

            @Override
            public void reset() throws IOException {
                throw new IOException("Unsupported operation");
            }

            @Override
            public long skip(long l) throws IOException {
                this.ensureInputStreamIsValid();
                try {
                    long l2 = this.m_is.skip(l);
                    if (l2 > 0L) {
                        this.m_currentPos = (int)((long)this.m_currentPos + l2);
                    }
                    long l3 = l2;
                    return l3;
                }
                finally {
                    WeakZipFile.this.m_localMutex.up();
                }
            }
        }
    }
}

