/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import org.osgi.framework.Version;

public class VersionRange {
    private final Version m_floor;
    private final boolean m_isFloorInclusive;
    private final Version m_ceiling;
    private final boolean m_isCeilingInclusive;
    public static final VersionRange infiniteRange = new VersionRange(Version.emptyVersion, true, null, true);

    public VersionRange(Version version, boolean bl, Version version2, boolean bl2) {
        this.m_floor = version;
        this.m_isFloorInclusive = bl;
        this.m_ceiling = version2;
        this.m_isCeilingInclusive = bl2;
    }

    public Version getFloor() {
        return this.m_floor;
    }

    public boolean isFloorInclusive() {
        return this.m_isFloorInclusive;
    }

    public Version getCeiling() {
        return this.m_ceiling;
    }

    public boolean isCeilingInclusive() {
        return this.m_isCeilingInclusive;
    }

    public boolean isInRange(Version version) {
        if (this.m_ceiling == null) {
            return version.compareTo(this.m_floor) >= 0;
        }
        if (this.isFloorInclusive() && this.isCeilingInclusive()) {
            return version.compareTo(this.m_floor) >= 0 && version.compareTo(this.m_ceiling) <= 0;
        }
        if (this.isCeilingInclusive()) {
            return version.compareTo(this.m_floor) > 0 && version.compareTo(this.m_ceiling) <= 0;
        }
        if (this.isFloorInclusive()) {
            return version.compareTo(this.m_floor) >= 0 && version.compareTo(this.m_ceiling) < 0;
        }
        return version.compareTo(this.m_floor) > 0 && version.compareTo(this.m_ceiling) < 0;
    }

    public static VersionRange parse(String string) {
        if (string.indexOf(44) >= 0) {
            String string2 = string.substring(1, string.length() - 1);
            String string3 = string2.substring(0, string2.indexOf(44)).trim();
            String string4 = string2.substring(string2.indexOf(44) + 1, string2.length()).trim();
            return new VersionRange(new Version(string3), string.charAt(0) == '[', new Version(string4), string.charAt(string.length() - 1) == ']');
        }
        return new VersionRange(new Version(string), true, null, false);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VersionRange versionRange = (VersionRange)object;
        if (!(this.m_floor == versionRange.m_floor || this.m_floor != null && this.m_floor.equals(versionRange.m_floor))) {
            return false;
        }
        if (this.m_isFloorInclusive != versionRange.m_isFloorInclusive) {
            return false;
        }
        if (!(this.m_ceiling == versionRange.m_ceiling || this.m_ceiling != null && this.m_ceiling.equals(versionRange.m_ceiling))) {
            return false;
        }
        return this.m_isCeilingInclusive == versionRange.m_isCeilingInclusive;
    }

    public int hashCode() {
        int n = 5;
        n = 97 * n + (this.m_floor != null ? this.m_floor.hashCode() : 0);
        n = 97 * n + (this.m_isFloorInclusive ? 1 : 0);
        n = 97 * n + (this.m_ceiling != null ? this.m_ceiling.hashCode() : 0);
        n = 97 * n + (this.m_isCeilingInclusive ? 1 : 0);
        return n;
    }

    public String toString() {
        if (this.m_ceiling != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_isFloorInclusive ? (char)'[' : '(');
            stringBuffer.append(this.m_floor.toString());
            stringBuffer.append(',');
            stringBuffer.append(this.m_ceiling.toString());
            stringBuffer.append(this.m_isCeilingInclusive ? (char)']' : ')');
            return stringBuffer.toString();
        }
        return this.m_floor.toString();
    }
}

