/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.util.SecureAction;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Resource;

public class Util {
    private static final String DEFAULT_PROPERTIES_FILE = "META-INF/default.properties";
    private static final byte[] encTab = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] decTab;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    static {
        byte[] byArray = new byte[128];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = 62;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -1;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[94] = -1;
        byArray[95] = -1;
        byArray[96] = -1;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        byArray[123] = -1;
        byArray[124] = -1;
        byArray[125] = -1;
        byArray[126] = -1;
        byArray[127] = -1;
        decTab = byArray;
    }

    public static Properties loadDefaultProperties(Logger logger) {
        Properties properties = new Properties();
        URL uRL = Util.class.getClassLoader().getResource(DEFAULT_PROPERTIES_FILE);
        if (uRL != null) {
            InputStream inputStream = null;
            try {
                inputStream = uRL.openConnection().getInputStream();
                properties.load(inputStream);
                inputStream.close();
            }
            catch (Exception exception) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                logger.log(1, "Unable to load any configuration properties.", exception);
            }
        }
        return properties;
    }

    public static String getDefaultProperty(Logger logger, String string) {
        Properties properties = Util.loadDefaultProperties(logger);
        return Util.getPropertyWithSubs(properties, string);
    }

    public static String getPropertyWithSubs(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        string2 = string2 != null ? Util.substVars(string2, string, null, properties) : null;
        return string2;
    }

    public static Map<String, String> getDefaultPropertiesWithPrefix(Logger logger, String string) {
        Properties properties = Util.loadDefaultProperties(logger);
        return Util.getDefaultPropertiesWithPrefix(properties, string);
    }

    public static Map<String, String> getDefaultPropertiesWithPrefix(Properties properties, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set<String> set = properties.stringPropertyNames();
        for (String string2 : set) {
            if (!string2.startsWith(string)) continue;
            String string3 = properties.getProperty(string2);
            string3 = string3 != null ? Util.substVars(string3, string2, null, properties) : null;
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    public static long getBundleIdFromRevisionId(String string) {
        try {
            String string2 = string.indexOf(46) >= 0 ? string.substring(0, string.indexOf(46)) : string;
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static int getModuleRevisionFromModuleId(String string) {
        try {
            int n = string.indexOf(46);
            if (n >= 0) {
                return Integer.parseInt(string.substring(n + 1));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return -1;
    }

    public static String getClassName(String string) {
        if (string == null) {
            string = "";
        }
        return string.lastIndexOf(46) < 0 ? "" : string.substring(string.lastIndexOf(46) + 1);
    }

    public static String getClassPackage(String string) {
        if (string == null) {
            string = "";
        }
        return string.lastIndexOf(46) < 0 ? "" : string.substring(0, string.lastIndexOf(46));
    }

    public static String getResourcePackage(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = string.startsWith("/") ? string.substring(1) : string;
        string2 = string2.lastIndexOf(47) < 0 ? "" : string2.substring(0, string2.lastIndexOf(47));
        string2 = string2.replace('/', '.');
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    public static Class loadClassUsingClass(Class var0, String var1_1, SecureAction var2_2) {
        var3_3 = null;
        while (var0 != null) {
            var4_4 = var2_2.getClassLoader(var0);
            var4_4 = var4_4 == null ? var2_2.getSystemClassLoader() : var4_4;
            try {
                return var4_4.loadClass(var1_1);
            }
            catch (ClassNotFoundException v0) {
                var5_5 = var0.getInterfaces();
                var6_6 = 0;
                ** while (var6_6 < var5_5.length)
            }
lbl-1000:
            // 1 sources

            {
                var3_3 = Util.loadClassUsingClass(var5_5[var6_6], var1_1, var2_2);
                if (var3_3 != null) {
                    return var3_3;
                }
                ++var6_6;
                continue;
            }
lbl16:
            // 1 sources

            var0 = var0.getSuperclass();
        }
        return null;
    }

    public static boolean isServiceAssignable(Bundle bundle, ServiceReference serviceReference) {
        boolean bl = true;
        String[] stringArray = (String[])serviceReference.getProperty("objectClass");
        int n = 0;
        while (bl && n < stringArray.length) {
            if (!serviceReference.isAssignableTo(bundle, stringArray[n])) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public static List<BundleCapability> getCapabilityByNamespace(BundleRevision bundleRevision, String string) {
        List<BundleCapability> list;
        ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>();
        List<BundleCapability> list2 = list = bundleRevision.getWiring() != null ? bundleRevision.getWiring().getCapabilities(null) : bundleRevision.getDeclaredCapabilities(null);
        if (list != null) {
            for (BundleCapability bundleCapability : list) {
                if (!bundleCapability.getNamespace().equals(string)) continue;
                arrayList.add(bundleCapability);
            }
        }
        return arrayList;
    }

    public static List<BundleRequirement> getDynamicRequirements(List<BundleRequirement> list) {
        ArrayList<BundleRequirement> arrayList = new ArrayList<BundleRequirement>();
        if (list != null) {
            for (BundleRequirement bundleRequirement : list) {
                String string = bundleRequirement.getDirectives().get("resolution");
                if (string == null || !string.equals("dynamic")) continue;
                arrayList.add(bundleRequirement);
            }
        }
        return arrayList;
    }

    public static BundleWire getWire(BundleRevision bundleRevision, String string) {
        List<BundleWire> list;
        if (bundleRevision.getWiring() != null && (list = bundleRevision.getWiring().getRequiredWires(null)) != null) {
            for (BundleWire bundleWire : list) {
                if (!bundleWire.getCapability().getNamespace().equals("osgi.wiring.package") || !bundleWire.getCapability().getAttributes().get("osgi.wiring.package").equals(string)) continue;
                return bundleWire;
            }
        }
        return null;
    }

    public static BundleCapability getPackageCapability(BundleRevision bundleRevision, String string) {
        List<BundleCapability> list;
        if (bundleRevision.getWiring() != null && (list = bundleRevision.getWiring().getCapabilities(null)) != null) {
            for (BundleCapability bundleCapability : list) {
                if (!bundleCapability.getNamespace().equals("osgi.wiring.package") || !bundleCapability.getAttributes().get("osgi.wiring.package").equals(string)) continue;
                return bundleCapability;
            }
        }
        return null;
    }

    public static String base64Encode(String string) throws IOException {
        return Util.encode(string.getBytes(), 0);
    }

    public static String encode(byte[] byArray, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            Util.encode(byteArrayInputStream, byteArrayOutputStream, n);
            String string = new String(byteArrayOutputStream.toByteArray());
            return string;
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
        }
    }

    public static void encode(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        if (n % 4 != 0) {
            throw new IllegalArgumentException("Length must be a multiple of 4");
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while ((n2 = inputStream.read()) != -1) {
            n3 = n3 << 8 | n2;
            n4 += 8;
            while (n4 >= 6) {
                outputStream.write(encTab[0x3F & n3 >> (n4 -= 6)]);
                if (n == 0 || ++n5 < n) continue;
                outputStream.write(13);
                outputStream.write(10);
                n5 -= n;
            }
        }
        switch (n4) {
            case 2: {
                outputStream.write(encTab[0x3F & n3 << 4]);
                outputStream.write(61);
                outputStream.write(61);
                break;
            }
            case 4: {
                outputStream.write(encTab[0x3F & n3 << 2]);
                outputStream.write(61);
            }
        }
        if (n != 0) {
            if (n5 != 0) {
                outputStream.write(13);
                outputStream.write(10);
            }
            outputStream.write(13);
            outputStream.write(10);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String substVars(String var0, String var1_1, Map var2_2, Properties var3_3) throws IllegalArgumentException {
        if (var2_2 == null) {
            var2_2 = new HashMap<String, String>();
        }
        var2_2.put(var1_1, var1_1);
        var4_4 = -1;
        var5_5 = -1;
        do {
            if ((var4_4 = var0.indexOf("}", var4_4 + 1)) < 0) {
                return var0;
            }
            var5_5 = var0.indexOf("${");
            if (var5_5 >= 0) ** GOTO lbl16
            return var0;
            while ((var6_6 = var0.indexOf("${", var5_5 + "${".length())) >= 0 && var6_6 <= var4_4) {
                if (var6_6 < var4_4) {
                    var5_5 = var6_6;
                }
lbl16:
                // 4 sources

                if (var4_4 >= 0) continue;
            }
        } while (var5_5 > var4_4 && var4_4 >= 0);
        var6_7 = var0.substring(var5_5 + "${".length(), var4_4);
        if (var2_2.get(var6_7) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + var6_7);
        }
        v0 = var7_8 = var3_3 != null ? var3_3.getProperty(var6_7, null) : null;
        if (var7_8 == null) {
            var7_8 = System.getProperty(var6_7, "");
        }
        var2_2.remove(var6_7);
        var0 = String.valueOf(var0.substring(0, var5_5)) + var7_8 + var0.substring(var4_4 + "}".length(), var0.length());
        var0 = Util.substVars(var0, var1_1, var2_2, var3_3);
        return var0;
    }

    public static boolean isSingleton(BundleRevision bundleRevision) {
        List<BundleCapability> list = bundleRevision.getDeclaredCapabilities(null);
        for (BundleCapability bundleCapability : list) {
            if (!bundleCapability.getNamespace().equals("osgi.wiring.bundle")) continue;
            for (Map.Entry<String, String> entry : bundleCapability.getDirectives().entrySet()) {
                if (!entry.getKey().equalsIgnoreCase("singleton")) continue;
                return Boolean.valueOf(entry.getValue());
            }
        }
        return false;
    }

    public static boolean isFragment(BundleRevision bundleRevision) {
        return (bundleRevision.getTypes() & 1) > 0;
    }

    public static boolean isFragment(Resource resource) {
        if (resource instanceof BundleRevision) {
            return Util.isFragment((BundleRevision)resource);
        }
        return false;
    }

    public static List<BundleRevision> getFragments(BundleWiring bundleWiring) {
        List<BundleWire> list;
        ArrayList<BundleRevision> arrayList = Collections.EMPTY_LIST;
        if (bundleWiring != null && (list = bundleWiring.getProvidedWires(null)) != null) {
            for (BundleWire bundleWire : list) {
                if (!bundleWire.getCapability().getNamespace().equals("osgi.wiring.host")) continue;
                if (arrayList.isEmpty()) {
                    arrayList = new ArrayList<BundleRevision>();
                }
                arrayList.add(bundleWire.getRequirerWiring().getRevision());
            }
        }
        return arrayList;
    }

    public static String randomUUID() {
        int n;
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        long l = ((long)byArray[0] & 0xFFL) << 56;
        l |= ((long)byArray[1] & 0xFFL) << 48;
        l |= ((long)byArray[2] & 0xFFL) << 40;
        l |= ((long)byArray[3] & 0xFFL) << 32;
        l |= ((long)byArray[4] & 0xFFL) << 24;
        l |= ((long)byArray[5] & 0xFFL) << 16;
        l |= ((long)byArray[6] & 0xFL) << 8;
        l |= 0x4000L;
        l |= (long)byArray[7] & 0xFFL;
        long l2 = ((long)byArray[8] & 0x3FL) << 56;
        l2 |= Long.MIN_VALUE;
        l2 |= ((long)byArray[9] & 0xFFL) << 48;
        l2 |= ((long)byArray[10] & 0xFFL) << 40;
        l2 |= ((long)byArray[11] & 0xFFL) << 32;
        l2 |= ((long)byArray[12] & 0xFFL) << 24;
        l2 |= ((long)byArray[13] & 0xFFL) << 16;
        l2 |= ((long)byArray[14] & 0xFFL) << 8;
        int n2 = (int)(l ^ l >>> 32);
        int n3 = (int)((l2 |= (long)byArray[15] & 0xFFL) ^ l2 >>> 32);
        int cfr_ignored_0 = n2 ^ n3;
        int n4 = (l2 & Long.MIN_VALUE) == 0L ? 0 : ((l2 & 0x4000000000000000L) != 0L ? (int)((l2 & 0xE000000000000000L) >>> 61) : 2);
        int n5 = (int)((l & 0xF000L) >>> 12);
        if (n4 == 2 || n5 == 1) {
            long l3 = (l & 0xFFFFFFFF00000000L) >>> 32;
            long l4 = (l & 0xFFFF0000L) << 16;
            long l5 = (l & 0xFFFL) << 48;
            long cfr_ignored_1 = l3 | l4 | l5;
            int cfr_ignored_2 = (int)((l2 & 0x3FFF000000000000L) >>> 48);
            long cfr_ignored_3 = l2 & 0xFFFFFFFFFFFFL;
        }
        StringBuffer stringBuffer = new StringBuffer(36);
        String string = Long.toHexString(l);
        if (string.length() < 16) {
            int n6 = 16 - string.length();
            n = 0;
            while (n < n6) {
                stringBuffer.append('0');
                ++n;
            }
        }
        stringBuffer.append(string);
        stringBuffer.insert(8, '-');
        stringBuffer.insert(13, '-');
        stringBuffer.append('-');
        String string2 = Long.toHexString(l2);
        if (string2.length() < 16) {
            n = 16 - string2.length();
            int n7 = 0;
            while (n7 < n) {
                stringBuffer.append('0');
                ++n7;
            }
        }
        stringBuffer.append(string2);
        stringBuffer.insert(23, '-');
        return stringBuffer.toString();
    }
}

