/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.bundle.FindHook;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.hooks.weaving.WovenClassListener;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

public class SecureAction {
    private static final ThreadLocal m_actions = new ThreadLocal(){

        public Object initialValue() {
            return new Actions();
        }
    };
    protected static transient int BUFSIZE = 4096;
    private AccessControlContext m_acc = null;

    public SecureAction() {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(0, null);
                this.m_acc = (AccessControlContext)AccessController.doPrivileged(actions);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        } else {
            this.m_acc = AccessController.getContext();
        }
    }

    public String getSystemProperty(String string, String string2) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(20, string, string2);
                return (String)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return System.getProperty(string, string2);
    }

    public ClassLoader getParentClassLoader(ClassLoader classLoader) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(21, classLoader);
                return (ClassLoader)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return classLoader.getParent();
    }

    public ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(22);
                return (ClassLoader)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return ClassLoader.getSystemClassLoader();
    }

    public ClassLoader getClassLoader(Class clazz) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(39, clazz);
                return (ClassLoader)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return clazz.getClassLoader();
    }

    public Class forName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(9, string, classLoader);
                return (Class)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)privilegedActionException.getException();
                }
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        if (classLoader != null) {
            return Class.forName(string, true, classLoader);
        }
        return Class.forName(string);
    }

    public URL createURL(String string, String string2, int n, String string3, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(3, string, string2, new Integer(n), string3, uRLStreamHandler);
                return (URL)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof MalformedURLException) {
                    throw (MalformedURLException)privilegedActionException.getException();
                }
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return new URL(string, string2, n, string3, uRLStreamHandler);
    }

    public URL createURL(URL uRL, String string, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(4, uRL, string, uRLStreamHandler);
                return (URL)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof MalformedURLException) {
                    throw (MalformedURLException)privilegedActionException.getException();
                }
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return new URL(uRL, string, uRLStreamHandler);
    }

    public Process exec(String string) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(6, string);
                return (Process)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return Runtime.getRuntime().exec(string);
    }

    public String getAbsolutePath(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(10, file);
                return (String)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return file.getAbsolutePath();
    }

    public boolean fileExists(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(7, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return file.exists();
    }

    public boolean isFileDirectory(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(8, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return file.isDirectory();
    }

    public boolean mkdir(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(29, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return file.mkdir();
    }

    public boolean mkdirs(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(28, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return file.mkdirs();
    }

    public File[] listDirectory(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(27, file);
                return (File[])AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return file.listFiles();
    }

    public boolean renameFile(File file, File file2) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(32, file, file2);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return file.renameTo(file2);
    }

    public FileInputStream getFileInputStream(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(15, file);
                return (FileInputStream)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return new FileInputStream(file);
    }

    public FileOutputStream getFileOutputStream(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(16, file);
                return (FileOutputStream)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return new FileOutputStream(file);
    }

    public URI toURI(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(17, file);
                return (URI)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return file.toURI();
    }

    public InputStream getURLConnectionInputStream(URLConnection uRLConnection) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(23, uRLConnection);
                return (InputStream)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return uRLConnection.getInputStream();
    }

    public boolean deleteFile(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(5, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return file.delete();
    }

    public File createTempFile(String string, String string2, File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(2, string, string2, file);
                return (File)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return File.createTempFile(string, string2, file);
    }

    public void deleteFileOnExit(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(55, file);
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                throw (RuntimeException)privilegedActionException.getException();
            }
        } else {
            file.deleteOnExit();
        }
    }

    public URLConnection openURLConnection(URL uRL) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(31, uRL);
                return (URLConnection)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return uRL.openConnection();
    }

    public ZipFile openZipFile(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(30, file);
                return (ZipFile)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return new ZipFile(file);
    }

    public JarFile openJarFile(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(54, file);
                return (JarFile)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return new JarFile(file);
    }

    public void startActivator(BundleActivator bundleActivator, BundleContext bundleContext) throws Exception {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(34, bundleActivator, bundleContext);
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            bundleActivator.start(bundleContext);
        }
    }

    public void stopActivator(BundleActivator bundleActivator, BundleContext bundleContext) throws Exception {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(35, bundleActivator, bundleContext);
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            bundleActivator.stop(bundleContext);
        }
    }

    public Policy getPolicy() {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(19, null);
                return (Policy)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        }
        return Policy.getPolicy();
    }

    public void addURLToURLClassLoader(URL uRL, ClassLoader classLoader) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(1, uRL, classLoader);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, uRL);
        }
    }

    public Constructor getConstructor(Class clazz, Class[] classArray) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(11, clazz, classArray);
            try {
                return (Constructor)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        return clazz.getConstructor(classArray);
    }

    public Constructor getDeclaredConstructor(Class clazz, Class[] classArray) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(12, clazz, classArray);
            try {
                return (Constructor)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        return clazz.getDeclaredConstructor(classArray);
    }

    public Method getMethod(Class clazz, String string, Class[] classArray) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(18, clazz, string, classArray);
            try {
                return (Method)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        return clazz.getMethod(string, classArray);
    }

    public Method getDeclaredMethod(Class clazz, String string, Class[] classArray) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(13, clazz, string, classArray);
            try {
                return (Method)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        return clazz.getDeclaredMethod(string, classArray);
    }

    public void setAccesssible(AccessibleObject accessibleObject) {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(33, accessibleObject);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
        } else {
            accessibleObject.setAccessible(true);
        }
    }

    public Object invoke(Method method, Object object, Object[] objectArray) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(26, method, object, objectArray);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        method.setAccessible(true);
        return method.invoke(object, objectArray);
    }

    public Object invokeDirect(Method method, Object object, Object[] objectArray) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(25, method, object, objectArray);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        return method.invoke(object, objectArray);
    }

    public Object invoke(Constructor constructor, Object[] objectArray) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(24, constructor, objectArray);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        return constructor.newInstance(objectArray);
    }

    public Object getDeclaredField(Class clazz, String string, Object object) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(14, clazz, string, object);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        Field field = clazz.getDeclaredField(string);
        field.setAccessible(true);
        return field.get(object);
    }

    public Object swapStaticFieldIfNotClass(Class clazz, Class clazz2, Class clazz3, String string) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(36, clazz, clazz2, clazz3, string);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        return SecureAction._swapStaticFieldIfNotClass(clazz, clazz2, clazz3, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object _swapStaticFieldIfNotClass(Class clazz, Class clazz2, Class clazz3, String string) throws Exception {
        AnnotatedElement annotatedElement;
        Object object = null;
        if (string != null) {
            try {
                annotatedElement = clazz.getDeclaredField(string);
                ((Field)annotatedElement).setAccessible(true);
                object = ((Field)annotatedElement).get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        if (object == null) {
            object = clazz;
        }
        annotatedElement = object;
        synchronized (annotatedElement) {
            Field[] fieldArray = clazz.getDeclaredFields();
            Object object2 = null;
            int n = 0;
            while (n < fieldArray.length && object2 == null) {
                if (Modifier.isStatic(fieldArray[n].getModifiers()) && fieldArray[n].getType() == clazz2) {
                    fieldArray[n].setAccessible(true);
                    object2 = fieldArray[n].get(null);
                    if (!(object2 == null || clazz3 != null && object2.getClass().getName().equals(clazz3.getName()))) {
                        fieldArray[n].set(null, null);
                    }
                }
                ++n;
            }
            if (object2 != null) {
                if (clazz3 == null || !object2.getClass().getName().equals(clazz3.getName())) {
                    n = 0;
                    while (n < fieldArray.length) {
                        if (Modifier.isStatic(fieldArray[n].getModifiers()) && fieldArray[n].getType() == Hashtable.class) {
                            fieldArray[n].setAccessible(true);
                            Hashtable hashtable = (Hashtable)fieldArray[n].get(null);
                            if (hashtable != null) {
                                hashtable.clear();
                            }
                        }
                        ++n;
                    }
                }
                return object2;
            }
        }
        return null;
    }

    public void flush(Class clazz, Object object) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(38, clazz, object);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            SecureAction._flush(clazz, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _flush(Class clazz, Object object) throws Exception {
        Object object2 = object;
        synchronized (object2) {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = 0;
            while (n < fieldArray.length) {
                if (Modifier.isStatic(fieldArray[n].getModifiers()) && (fieldArray[n].getType() == Hashtable.class || fieldArray[n].getType() == HashMap.class)) {
                    Map map;
                    fieldArray[n].setAccessible(true);
                    if (fieldArray[n].getType() == Hashtable.class) {
                        map = (Hashtable)fieldArray[n].get(null);
                        if (map != null) {
                            ((Hashtable)map).clear();
                        }
                    } else {
                        map = (HashMap)fieldArray[n].get(null);
                        if (map != null) {
                            ((HashMap)map).clear();
                        }
                    }
                }
                ++n;
            }
        }
    }

    public void invokeBundleCollisionHook(CollisionHook collisionHook, int n, Bundle bundle, Collection<Bundle> collection) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(53, collisionHook, n, bundle, collection);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            collisionHook.filterCollisions(n, bundle, collection);
        }
    }

    public void invokeBundleFindHook(FindHook findHook, BundleContext bundleContext, Collection<Bundle> collection) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(40, findHook, bundleContext, collection);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            findHook.find(bundleContext, collection);
        }
    }

    public void invokeBundleEventHook(EventHook eventHook, BundleEvent bundleEvent, Collection<BundleContext> collection) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(41, eventHook, bundleEvent, collection);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            eventHook.event(bundleEvent, collection);
        }
    }

    public void invokeWeavingHook(WeavingHook weavingHook, WovenClass wovenClass) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(42, weavingHook, wovenClass);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            weavingHook.weave(wovenClass);
        }
    }

    public void invokeServiceEventHook(org.osgi.framework.hooks.service.EventHook eventHook, ServiceEvent serviceEvent, Collection<BundleContext> collection) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(43, eventHook, serviceEvent, collection);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            eventHook.event(serviceEvent, collection);
        }
    }

    public void invokeServiceFindHook(org.osgi.framework.hooks.service.FindHook findHook, BundleContext bundleContext, String string, String string2, boolean bl, Collection<ServiceReference<?>> collection) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(44, findHook, bundleContext, string, string2, bl ? Boolean.TRUE : Boolean.FALSE, collection);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            findHook.find(bundleContext, string, string2, bl, collection);
        }
    }

    public void invokeServiceListenerHookAdded(ListenerHook listenerHook, Collection<ListenerHook.ListenerInfo> collection) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(45, listenerHook, collection);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            listenerHook.added(collection);
        }
    }

    public void invokeServiceListenerHookRemoved(ListenerHook listenerHook, Collection<ListenerHook.ListenerInfo> collection) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(46, listenerHook, collection);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            listenerHook.removed(collection);
        }
    }

    public void invokeServiceEventListenerHook(EventListenerHook eventListenerHook, ServiceEvent serviceEvent, Map<BundleContext, Collection<ListenerHook.ListenerInfo>> map) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(47, eventListenerHook, serviceEvent, map);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            eventListenerHook.event(serviceEvent, map);
        }
    }

    public ResolverHook invokeResolverHookFactory(ResolverHookFactory resolverHookFactory, Collection<BundleRevision> collection) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(48, resolverHookFactory, collection);
            try {
                return (ResolverHook)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        return resolverHookFactory.begin(collection);
    }

    public void invokeResolverHookResolvable(ResolverHook resolverHook, Collection<BundleRevision> collection) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(49, resolverHook, collection);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            resolverHook.filterResolvable(collection);
        }
    }

    public void invokeResolverHookSingleton(ResolverHook resolverHook, BundleCapability bundleCapability, Collection<BundleCapability> collection) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(50, resolverHook, bundleCapability, collection);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            resolverHook.filterSingletonCollisions(bundleCapability, collection);
        }
    }

    public void invokeResolverHookMatches(ResolverHook resolverHook, BundleRequirement bundleRequirement, Collection<BundleCapability> collection) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(51, resolverHook, bundleRequirement, collection);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            resolverHook.filterMatches(bundleRequirement, collection);
        }
    }

    public void invokeResolverHookEnd(ResolverHook resolverHook) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(52, resolverHook);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            resolverHook.end();
        }
    }

    public void invokeWovenClassListener(WovenClassListener wovenClassListener, WovenClass wovenClass) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(56, wovenClassListener, wovenClass);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        } else {
            wovenClassListener.modified(wovenClass);
        }
    }

    private static class Actions
    implements PrivilegedExceptionAction {
        public static final int INITIALIZE_CONTEXT_ACTION = 0;
        public static final int ADD_EXTENSION_URL_ACTION = 1;
        public static final int CREATE_TMPFILE_ACTION = 2;
        public static final int CREATE_URL_ACTION = 3;
        public static final int CREATE_URL_WITH_CONTEXT_ACTION = 4;
        public static final int DELETE_FILE_ACTION = 5;
        public static final int EXEC_ACTION = 6;
        public static final int FILE_EXISTS_ACTION = 7;
        public static final int FILE_IS_DIRECTORY_ACTION = 8;
        public static final int FOR_NAME_ACTION = 9;
        public static final int GET_ABSOLUTE_PATH_ACTION = 10;
        public static final int GET_CONSTRUCTOR_ACTION = 11;
        public static final int GET_DECLARED_CONSTRUCTOR_ACTION = 12;
        public static final int GET_DECLARED_METHOD_ACTION = 13;
        public static final int GET_FIELD_ACTION = 14;
        public static final int GET_FILE_INPUT_ACTION = 15;
        public static final int GET_FILE_OUTPUT_ACTION = 16;
        public static final int TO_URI_ACTION = 17;
        public static final int GET_METHOD_ACTION = 18;
        public static final int GET_POLICY_ACTION = 19;
        public static final int GET_PROPERTY_ACTION = 20;
        public static final int GET_PARENT_CLASS_LOADER_ACTION = 21;
        public static final int GET_SYSTEM_CLASS_LOADER_ACTION = 22;
        public static final int GET_URL_INPUT_ACTION = 23;
        public static final int INVOKE_CONSTRUCTOR_ACTION = 24;
        public static final int INVOKE_DIRECTMETHOD_ACTION = 25;
        public static final int INVOKE_METHOD_ACTION = 26;
        public static final int LIST_DIRECTORY_ACTION = 27;
        public static final int MAKE_DIRECTORIES_ACTION = 28;
        public static final int MAKE_DIRECTORY_ACTION = 29;
        public static final int OPEN_ZIPFILE_ACTION = 30;
        public static final int OPEN_URLCONNECTION_ACTION = 31;
        public static final int RENAME_FILE_ACTION = 32;
        public static final int SET_ACCESSIBLE_ACTION = 33;
        public static final int START_ACTIVATOR_ACTION = 34;
        public static final int STOP_ACTIVATOR_ACTION = 35;
        public static final int SWAP_FIELD_ACTION = 36;
        public static final int SYSTEM_EXIT_ACTION = 37;
        public static final int FLUSH_FIELD_ACTION = 38;
        public static final int GET_CLASS_LOADER_ACTION = 39;
        public static final int INVOKE_BUNDLE_FIND_HOOK = 40;
        public static final int INVOKE_BUNDLE_EVENT_HOOK = 41;
        public static final int INVOKE_WEAVING_HOOK = 42;
        public static final int INVOKE_SERVICE_EVENT_HOOK = 43;
        public static final int INVOKE_SERVICE_FIND_HOOK = 44;
        public static final int INVOKE_SERVICE_LISTENER_HOOK_ADDED = 45;
        public static final int INVOKE_SERVICE_LISTENER_HOOK_REMOVED = 46;
        public static final int INVOKE_SERVICE_EVENT_LISTENER_HOOK = 47;
        public static final int INVOKE_RESOLVER_HOOK_FACTORY = 48;
        public static final int INVOKE_RESOLVER_HOOK_RESOLVABLE = 49;
        public static final int INVOKE_RESOLVER_HOOK_SINGLETON = 50;
        public static final int INVOKE_RESOLVER_HOOK_MATCHES = 51;
        public static final int INVOKE_RESOLVER_HOOK_END = 52;
        public static final int INVOKE_BUNDLE_COLLISION_HOOK = 53;
        public static final int OPEN_JARFILE_ACTION = 54;
        public static final int DELETE_FILEONEXIT_ACTION = 55;
        public static final int INVOKE_WOVEN_CLASS_LISTENER = 56;
        private int m_action = -1;
        private Object m_arg1 = null;
        private Object m_arg2 = null;
        private Object m_arg3 = null;
        private Object m_arg4 = null;
        private Object m_arg5 = null;
        private Object m_arg6 = null;

        private Actions() {
        }

        public void set(int n) {
            this.m_action = n;
        }

        public void set(int n, Object object) {
            this.m_action = n;
            this.m_arg1 = object;
        }

        public void set(int n, Object object, Object object2) {
            this.m_action = n;
            this.m_arg1 = object;
            this.m_arg2 = object2;
        }

        public void set(int n, Object object, Object object2, Object object3) {
            this.m_action = n;
            this.m_arg1 = object;
            this.m_arg2 = object2;
            this.m_arg3 = object3;
        }

        public void set(int n, Object object, Object object2, Object object3, Object object4) {
            this.m_action = n;
            this.m_arg1 = object;
            this.m_arg2 = object2;
            this.m_arg3 = object3;
            this.m_arg4 = object4;
        }

        public void set(int n, Object object, Object object2, Object object3, Object object4, Object object5) {
            this.m_action = n;
            this.m_arg1 = object;
            this.m_arg2 = object2;
            this.m_arg3 = object3;
            this.m_arg4 = object4;
            this.m_arg5 = object5;
        }

        public void set(int n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
            this.m_action = n;
            this.m_arg1 = object;
            this.m_arg2 = object2;
            this.m_arg3 = object3;
            this.m_arg4 = object4;
            this.m_arg5 = object5;
            this.m_arg6 = object6;
        }

        private void unset() {
            this.m_action = -1;
            this.m_arg1 = null;
            this.m_arg2 = null;
            this.m_arg3 = null;
            this.m_arg4 = null;
            this.m_arg5 = null;
            this.m_arg6 = null;
        }

        public Object run() throws Exception {
            int n = this.m_action;
            Object object = this.m_arg1;
            Object object2 = this.m_arg2;
            Object object3 = this.m_arg3;
            Object object4 = this.m_arg4;
            Object object5 = this.m_arg5;
            Object object6 = this.m_arg6;
            this.unset();
            switch (n) {
                case 0: {
                    return AccessController.getContext();
                }
                case 1: {
                    Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                    method.setAccessible(true);
                    method.invoke(object2, object);
                    return null;
                }
                case 2: {
                    return File.createTempFile((String)object, (String)object2, (File)object3);
                }
                case 3: {
                    return new URL((String)object, (String)object2, (Integer)object3, (String)object4, (URLStreamHandler)object5);
                }
                case 4: {
                    return new URL((URL)object, (String)object2, (URLStreamHandler)object3);
                }
                case 5: {
                    return ((File)object).delete() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 6: {
                    return Runtime.getRuntime().exec((String)object);
                }
                case 7: {
                    return ((File)object).exists() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 8: {
                    return ((File)object).isDirectory() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 9: {
                    return object2 == null ? Class.forName((String)object) : Class.forName((String)object, true, (ClassLoader)object2);
                }
                case 10: {
                    return ((File)object).getAbsolutePath();
                }
                case 11: {
                    return ((Class)object).getConstructor((Class[])object2);
                }
                case 12: {
                    return ((Class)object).getDeclaredConstructor((Class[])object2);
                }
                case 13: {
                    return ((Class)object).getDeclaredMethod((String)object2, (Class[])object3);
                }
                case 14: {
                    Field field = ((Class)object).getDeclaredField((String)object2);
                    field.setAccessible(true);
                    return field.get(object3);
                }
                case 15: {
                    return new FileInputStream((File)object);
                }
                case 16: {
                    return new FileOutputStream((File)object);
                }
                case 17: {
                    return ((File)object).toURI();
                }
                case 18: {
                    return ((Class)object).getMethod((String)object2, (Class[])object3);
                }
                case 19: {
                    return Policy.getPolicy();
                }
                case 20: {
                    return System.getProperty((String)object, (String)object2);
                }
                case 21: {
                    return ((ClassLoader)object).getParent();
                }
                case 22: {
                    return ClassLoader.getSystemClassLoader();
                }
                case 23: {
                    return ((URLConnection)object).getInputStream();
                }
                case 24: {
                    return ((Constructor)object).newInstance((Object[])object2);
                }
                case 25: {
                    return ((Method)object).invoke(object2, (Object[])object3);
                }
                case 26: {
                    ((Method)object).setAccessible(true);
                    return ((Method)object).invoke(object2, (Object[])object3);
                }
                case 27: {
                    return ((File)object).listFiles();
                }
                case 28: {
                    return ((File)object).mkdirs() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 29: {
                    return ((File)object).mkdir() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 30: {
                    return new ZipFile((File)object);
                }
                case 31: {
                    return ((URL)object).openConnection();
                }
                case 32: {
                    return ((File)object).renameTo((File)object2) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 33: {
                    ((AccessibleObject)object).setAccessible(true);
                    return null;
                }
                case 34: {
                    ((BundleActivator)object).start((BundleContext)object2);
                    return null;
                }
                case 35: {
                    ((BundleActivator)object).stop((BundleContext)object2);
                    return null;
                }
                case 36: {
                    return SecureAction._swapStaticFieldIfNotClass((Class)object, (Class)object2, (Class)object3, (String)object4);
                }
                case 37: {
                    System.exit((Integer)object);
                }
                case 38: {
                    SecureAction._flush((Class)object, object2);
                    return null;
                }
                case 39: {
                    return ((Class)object).getClassLoader();
                }
                case 40: {
                    ((FindHook)object).find((BundleContext)object2, (Collection)object3);
                    return null;
                }
                case 41: {
                    ((EventHook)object).event((BundleEvent)object2, (Collection)object3);
                    return null;
                }
                case 42: {
                    ((WeavingHook)object).weave((WovenClass)object2);
                    return null;
                }
                case 43: {
                    ((org.osgi.framework.hooks.service.EventHook)object).event((ServiceEvent)object2, (Collection)object3);
                    return null;
                }
                case 44: {
                    ((org.osgi.framework.hooks.service.FindHook)object).find((BundleContext)object2, (String)object3, (String)object4, (Boolean)object5, (Collection)object6);
                    return null;
                }
                case 45: {
                    ((ListenerHook)object).added((Collection)object2);
                    return null;
                }
                case 46: {
                    ((ListenerHook)object).removed((Collection)object2);
                    return null;
                }
                case 47: {
                    ((EventListenerHook)object).event((ServiceEvent)object2, (Map)object3);
                    return null;
                }
                case 48: {
                    return ((ResolverHookFactory)object).begin((Collection)object2);
                }
                case 49: {
                    ((ResolverHook)object).filterResolvable((Collection)object2);
                    return null;
                }
                case 50: {
                    ((ResolverHook)object).filterSingletonCollisions((BundleCapability)object2, (Collection)object3);
                    return null;
                }
                case 51: {
                    ((ResolverHook)object).filterMatches((BundleRequirement)object2, (Collection)object3);
                    return null;
                }
                case 52: {
                    ((ResolverHook)object).end();
                    return null;
                }
                case 53: {
                    ((CollisionHook)object).filterCollisions((Integer)object2, (Bundle)object3, (Collection)object4);
                    return null;
                }
                case 54: {
                    return new JarFile((File)object);
                }
                case 55: {
                    ((File)object).deleteOnExit();
                    return null;
                }
                case 56: {
                    ((WovenClassListener)object).modified((WovenClass)object2);
                    return null;
                }
            }
            return null;
        }
    }
}

