/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ImmutableMap<K, V>
extends AbstractMap<K, V> {
    final Map.Entry<K, V>[] entries;

    public static <K, V> ImmutableMap<K, V> newInstance(Map.Entry<K, V> ... entryArray) {
        return new ImmutableMap<K, V>(entryArray);
    }

    public static <K, V> ImmutableMap<K, V> newInstance(Map<K, V> map) {
        if (map instanceof ImmutableMap) {
            return (ImmutableMap)map;
        }
        return new ImmutableMap<K, V>(map);
    }

    protected ImmutableMap(Map.Entry<K, V>[] entryArray) {
        this.entries = (Map.Entry[])entryArray.clone();
    }

    protected ImmutableMap(Map<K, V> map) {
        this.entries = map.entrySet().toArray(new Map.Entry[map.size()]);
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            int n = 0;
            while (n < this.entries.length) {
                if (this.entries[n].getKey() == null) {
                    return this.entries[n].getValue();
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.entries.length) {
                if (object.equals(this.entries[n].getKey())) {
                    return this.entries[n].getValue();
                }
                ++n;
            }
        }
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private class EntryItr
    implements Iterator<Map.Entry<K, V>> {
        int cursor;

        private EntryItr(int n) {
            this.cursor = n;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ImmutableMap.this.size();
        }

        @Override
        public Map.Entry<K, V> next() {
            return ImmutableMap.this.entries[this.cursor++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryItr(0);
        }

        @Override
        public int size() {
            return ImmutableMap.this.entries.length;
        }
    }
}

