/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.RandomAccess;

public class ImmutableList<E>
extends AbstractList<E>
implements RandomAccess {
    final Object[] elements;

    public static <E> ImmutableList<E> newInstance(E ... EArray) {
        return new ImmutableList<E>(EArray);
    }

    public static <E> ImmutableList<E> newInstance(Collection<? extends E> collection) {
        if (collection instanceof ImmutableList) {
            return (ImmutableList)collection;
        }
        return new ImmutableList<E>(collection);
    }

    protected ImmutableList(E ... EArray) {
        this.elements = (Object[])EArray.clone();
    }

    protected ImmutableList(Collection<? extends E> collection) {
        this.elements = collection.toArray();
    }

    @Override
    public E get(int n) {
        return (E)this.elements[n];
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new ListItr(n);
    }

    private class ListItr
    implements ListIterator<E> {
        int cursor;

        private ListItr(int n) {
            this.cursor = n;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ImmutableList.this.size();
        }

        @Override
        public E next() {
            return ImmutableList.this.elements[this.cursor++];
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            return ImmutableList.this.elements[--this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

