/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ServiceRegistry;
import org.apache.felix.framework.util.ListenerInfo;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.ShrinkableCollection;
import org.apache.felix.framework.util.ShrinkableMap;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.UnfilteredServiceListener;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.launch.Framework;

public class EventDispatcher {
    private final Logger m_logger;
    private final ServiceRegistry m_registry;
    private Map<BundleContext, List<ListenerInfo>> m_fwkListeners = Collections.EMPTY_MAP;
    private Map<BundleContext, List<ListenerInfo>> m_bndlListeners = Collections.EMPTY_MAP;
    private Map<BundleContext, List<ListenerInfo>> m_syncBndlListeners = Collections.EMPTY_MAP;
    private Map<BundleContext, List<ListenerInfo>> m_svcListeners = Collections.EMPTY_MAP;
    private static Thread m_thread = null;
    private static final String m_threadLock = new String("thread lock");
    private static int m_references = 0;
    private static volatile boolean m_stopping = false;
    private static final List<Request> m_requestList = new ArrayList<Request>();
    private static final List<Request> m_requestPool = new ArrayList<Request>();
    private static final SecureAction m_secureAction = new SecureAction();

    public EventDispatcher(Logger logger, ServiceRegistry serviceRegistry) {
        this.m_logger = logger;
        this.m_registry = serviceRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDispatching() {
        String string = m_threadLock;
        synchronized (string) {
            if (m_thread == null || !m_thread.isAlive()) {
                m_stopping = false;
                m_thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            EventDispatcher.run();
                        }
                        catch (Throwable throwable) {
                            String string = m_threadLock;
                            synchronized (string) {
                                m_thread = null;
                                m_stopping = false;
                                m_references = 0;
                                m_threadLock.notifyAll();
                            }
                            throw throwable;
                        }
                        String string = m_threadLock;
                        synchronized (string) {
                            m_thread = null;
                            m_stopping = false;
                            m_references = 0;
                            m_threadLock.notifyAll();
                        }
                    }
                }, "FelixDispatchQueue");
                m_thread.start();
            }
            ++m_references;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopDispatching() {
        Object object = m_threadLock;
        synchronized (object) {
            if (m_thread == null) return;
            if (m_stopping) {
                return;
            }
            if (--m_references > 0) {
                return;
            }
            m_stopping = true;
        }
        object = m_requestList;
        synchronized (object) {
            m_requestList.notify();
        }
        object = m_threadLock;
        synchronized (object) {
            while (true) {
                if (m_thread == null) {
                    return;
                }
                try {
                    m_threadLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter addListener(BundleContext bundleContext, Class clazz, EventListener eventListener, Filter filter) {
        if (eventListener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener not of type " + clazz.getName());
        }
        Filter filter2 = this.updateListener(bundleContext, clazz, eventListener, filter);
        if (filter2 != null) {
            return filter2;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            Object object;
            try {
                bundleContext.getBundle();
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
            Map<BundleContext, List<ListenerInfo>> map = null;
            Object object2 = null;
            if (clazz == FrameworkListener.class) {
                map = this.m_fwkListeners;
            } else if (clazz == BundleListener.class) {
                map = SynchronousBundleListener.class.isInstance(eventListener) ? this.m_syncBndlListeners : this.m_bndlListeners;
            } else if (clazz == ServiceListener.class) {
                object = System.getSecurityManager();
                if (object != null) {
                    object2 = ((SecurityManager)object).getSecurityContext();
                }
                map = this.m_svcListeners;
            } else {
                throw new IllegalArgumentException("Unknown listener: " + eventListener.getClass());
            }
            object = new ListenerInfo(bundleContext.getBundle(), bundleContext, clazz, eventListener, filter, object2, false);
            map = EventDispatcher.addListenerInfo(map, (ListenerInfo)object);
            if (clazz == FrameworkListener.class) {
                this.m_fwkListeners = map;
            } else if (clazz == BundleListener.class) {
                if (SynchronousBundleListener.class.isInstance(eventListener)) {
                    this.m_syncBndlListeners = map;
                } else {
                    this.m_bndlListeners = map;
                }
            } else if (clazz == ServiceListener.class) {
                this.m_svcListeners = map;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenerHook.ListenerInfo removeListener(BundleContext bundleContext, Class clazz, EventListener eventListener) {
        ListenerInfo listenerInfo = null;
        if (eventListener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener not of type " + clazz.getName());
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            Map<BundleContext, List<ListenerInfo>> map = null;
            if (clazz == FrameworkListener.class) {
                map = this.m_fwkListeners;
            } else if (clazz == BundleListener.class) {
                map = SynchronousBundleListener.class.isInstance(eventListener) ? this.m_syncBndlListeners : this.m_bndlListeners;
            } else if (clazz == ServiceListener.class) {
                map = this.m_svcListeners;
            } else {
                throw new IllegalArgumentException("Unknown listener: " + eventListener.getClass());
            }
            int n = -1;
            block3: for (Map.Entry<BundleContext, List<ListenerInfo>> entry : map.entrySet()) {
                List<ListenerInfo> list = entry.getValue();
                int n2 = 0;
                while (n2 < list.size()) {
                    ListenerInfo listenerInfo2 = list.get(n2);
                    if (listenerInfo2.getBundleContext().equals(bundleContext) && listenerInfo2.getListenerClass() == clazz && listenerInfo2.getListener() == eventListener) {
                        if (ServiceListener.class == clazz) {
                            listenerInfo = new ListenerInfo(list.get(n2), true);
                        }
                        n = n2;
                        continue block3;
                    }
                    ++n2;
                }
            }
            if (n >= 0) {
                map = EventDispatcher.removeListenerInfo(map, bundleContext, n);
            }
            if (clazz == FrameworkListener.class) {
                this.m_fwkListeners = map;
            } else if (clazz == BundleListener.class) {
                if (SynchronousBundleListener.class.isInstance(eventListener)) {
                    this.m_syncBndlListeners = map;
                } else {
                    this.m_bndlListeners = map;
                }
            } else if (clazz == ServiceListener.class) {
                this.m_svcListeners = map;
            }
        }
        return listenerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            this.m_fwkListeners = EventDispatcher.removeListenerInfos(this.m_fwkListeners, bundleContext);
            this.m_bndlListeners = EventDispatcher.removeListenerInfos(this.m_bndlListeners, bundleContext);
            this.m_syncBndlListeners = EventDispatcher.removeListenerInfos(this.m_syncBndlListeners, bundleContext);
            this.m_svcListeners = EventDispatcher.removeListenerInfos(this.m_svcListeners, bundleContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter updateListener(BundleContext bundleContext, Class clazz, EventListener eventListener, Filter filter) {
        if (clazz == ServiceListener.class) {
            EventDispatcher eventDispatcher = this;
            synchronized (eventDispatcher) {
                try {
                    bundleContext.getBundle();
                }
                catch (IllegalStateException illegalStateException) {}
                List<ListenerInfo> list = this.m_svcListeners.get(bundleContext);
                int n = 0;
                while (list != null && n < list.size()) {
                    ListenerInfo listenerInfo = list.get(n);
                    if (listenerInfo.getBundleContext().equals(bundleContext) && listenerInfo.getListenerClass() == clazz && listenerInfo.getListener() == eventListener) {
                        Filter filter2 = listenerInfo.getParsedFilter();
                        ListenerInfo listenerInfo2 = new ListenerInfo(listenerInfo.getBundle(), listenerInfo.getBundleContext(), listenerInfo.getListenerClass(), listenerInfo.getListener(), filter, listenerInfo.getSecurityContext(), listenerInfo.isRemoved());
                        this.m_svcListeners = EventDispatcher.updateListenerInfo(this.m_svcListeners, n, listenerInfo2);
                        return filter2;
                    }
                    ++n;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ListenerHook.ListenerInfo> getAllServiceListeners() {
        ArrayList<ListenerHook.ListenerInfo> arrayList = new ArrayList<ListenerHook.ListenerInfo>();
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            for (Map.Entry<BundleContext, List<ListenerInfo>> entry : this.m_svcListeners.entrySet()) {
                arrayList.addAll((Collection<ListenerHook.ListenerInfo>)entry.getValue());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFrameworkEvent(FrameworkEvent frameworkEvent) {
        Map<BundleContext, List<ListenerInfo>> map = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            map = this.m_fwkListeners;
        }
        EventDispatcher.fireEventAsynchronously(this, 0, map, frameworkEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBundleEvent(BundleEvent bundleEvent, Framework framework) {
        Map<BundleContext, List<ListenerInfo>> map = null;
        Map<BundleContext, List<ListenerInfo>> map2 = null;
        Object object = this;
        synchronized (object) {
            map = this.m_bndlListeners;
            map2 = this.m_syncBndlListeners;
        }
        object = this.createWhitelistFromHooks(bundleEvent, framework, map, map2, EventHook.class);
        if (object != null) {
            List<ListenerInfo> list;
            BundleContext bundleContext;
            HashMap<BundleContext, List<ListenerInfo>> hashMap = new HashMap<BundleContext, List<ListenerInfo>>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                bundleContext = (BundleContext)iterator.next();
                list = map.get(bundleContext);
                if (list == null) continue;
                hashMap.put(bundleContext, list);
            }
            map = hashMap;
            hashMap = new HashMap();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                bundleContext = (BundleContext)iterator.next();
                list = map2.get(bundleContext);
                if (list == null) continue;
                hashMap.put(bundleContext, list);
            }
            map2 = hashMap;
        }
        EventDispatcher.fireEventImmediately(this, 1, map2, bundleEvent, null);
        if (bundleEvent.getType() != 128 && bundleEvent.getType() != 256 && bundleEvent.getType() != 512) {
            EventDispatcher.fireEventAsynchronously(this, 1, map, bundleEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireServiceEvent(ServiceEvent serviceEvent, Dictionary dictionary, Framework framework) {
        Map<BundleContext, List<ListenerInfo>> map = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            map = this.m_svcListeners;
        }
        map = this.filterListenersUsingHooks(serviceEvent, framework, map);
        EventDispatcher.fireEventImmediately(this, 2, map, serviceEvent, dictionary);
    }

    private Map<BundleContext, List<ListenerInfo>> filterListenersUsingHooks(ServiceEvent serviceEvent, Framework framework, Map<BundleContext, List<ListenerInfo>> object) {
        Cloneable cloneable;
        Set<Object> set;
        Set<ServiceReference<org.osgi.framework.hooks.service.EventHook>> set2 = this.m_registry.getHookRegistry().getHooks(org.osgi.framework.hooks.service.EventHook.class);
        if (!set2.isEmpty() && (set = this.createWhitelistFromHooks(serviceEvent, framework, (Map<BundleContext, List<ListenerInfo>>)object, null, org.osgi.framework.hooks.service.EventHook.class)) != null) {
            cloneable = new HashMap<Object, List>();
            for (Object object22 : set) {
                cloneable.put(object22, (List)object.get(object22));
            }
            object = cloneable;
        }
        if (!(set = this.m_registry.getHookRegistry().getHooks(EventListenerHook.class)).isEmpty()) {
            Object object2;
            Object object22;
            cloneable = null;
            object22 = new HashMap();
            ShrinkableMap<BundleContext, Collection<ListenerHook.ListenerInfo>> shrinkableMap = new HashMap();
            for (Map.Entry entry : object.entrySet()) {
                object2 = (BundleContext)entry.getKey();
                ArrayList arrayList = new ArrayList((Collection)entry.getValue());
                object22.put(object2, arrayList);
                ArrayList arrayList2 = arrayList;
                ShrinkableCollection shrinkableCollection = new ShrinkableCollection(arrayList2);
                shrinkableMap.put((BundleContext)object2, shrinkableCollection);
                if (object2 != framework.getBundleContext()) continue;
                cloneable = new ArrayList((Collection)entry.getValue());
            }
            shrinkableMap = new ShrinkableMap<BundleContext, Collection<ListenerHook.ListenerInfo>>(shrinkableMap);
            for (ServiceReference serviceReference : set) {
                if (framework == null) continue;
                object2 = null;
                try {
                    object2 = (EventListenerHook)this.m_registry.getService(framework, serviceReference, false);
                }
                catch (Exception exception) {}
                if (object2 == null) continue;
                try {
                    try {
                        m_secureAction.invokeServiceEventListenerHook((EventListenerHook)object2, serviceEvent, shrinkableMap);
                    }
                    catch (Throwable throwable) {
                        this.m_logger.log(serviceReference, 2, "Problem invoking event hook", throwable);
                        this.m_registry.ungetService(framework, serviceReference, null);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.m_registry.ungetService(framework, serviceReference, null);
                    throw throwable;
                }
                this.m_registry.ungetService(framework, serviceReference, null);
            }
            HashMap<BundleContext, Object> hashMap = new HashMap<BundleContext, Object>();
            for (Map.Entry entry : shrinkableMap.entrySet()) {
                if (((Collection)entry.getValue()).isEmpty()) continue;
                hashMap.put((BundleContext)entry.getKey(), (List)object22.get(entry.getKey()));
            }
            if (cloneable != null) {
                hashMap.put(framework.getBundleContext(), cloneable);
            }
            object = hashMap;
        }
        return object;
    }

    private <T> Set<BundleContext> createWhitelistFromHooks(EventObject eventObject, Framework framework, Map<BundleContext, List<ListenerInfo>> map, Map<BundleContext, List<ListenerInfo>> map2, Class<T> clazz) {
        HashSet<BundleContext> hashSet = null;
        Set<ServiceReference<T>> set = this.m_registry.getHookRegistry().getHooks(clazz);
        if (!set.isEmpty()) {
            boolean bl = false;
            BundleContext bundleContext = framework.getBundleContext();
            hashSet = new HashSet<BundleContext>();
            for (Map.Entry<BundleContext, List<ListenerInfo>> entry : map.entrySet()) {
                hashSet.add(entry.getKey());
                if (entry.getKey() != bundleContext) continue;
                bl = true;
            }
            if (map2 != null) {
                for (Map.Entry entry : map2.entrySet()) {
                    hashSet.add((BundleContext)entry.getKey());
                    if (entry.getKey() != bundleContext) continue;
                    bl = true;
                }
            }
            int n = hashSet.size();
            ShrinkableCollection shrinkableCollection = new ShrinkableCollection(hashSet);
            for (ServiceReference<T> serviceReference : set) {
                if (framework == null) continue;
                Object var14_17 = null;
                try {
                    var14_17 = this.m_registry.getService(framework, serviceReference, false);
                }
                catch (Exception exception) {}
                if (var14_17 == null) continue;
                try {
                    try {
                        if (var14_17 instanceof org.osgi.framework.hooks.service.EventHook) {
                            m_secureAction.invokeServiceEventHook(var14_17, (ServiceEvent)eventObject, shrinkableCollection);
                        } else if (var14_17 instanceof EventHook) {
                            m_secureAction.invokeBundleEventHook(var14_17, (BundleEvent)eventObject, shrinkableCollection);
                        }
                    }
                    catch (Throwable throwable) {
                        this.m_logger.log(serviceReference, 2, "Problem invoking event hook", throwable);
                        this.m_registry.ungetService(framework, serviceReference, null);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.m_registry.ungetService(framework, serviceReference, null);
                    throw throwable;
                }
                this.m_registry.ungetService(framework, serviceReference, null);
            }
            if (bl && !hashSet.contains(bundleContext)) {
                hashSet.add(bundleContext);
            }
            if (n == hashSet.size()) {
                hashSet = null;
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireEventAsynchronously(EventDispatcher eventDispatcher, int n, Map<BundleContext, List<ListenerInfo>> map, EventObject eventObject) {
        if (m_stopping || m_thread == null) {
            return;
        }
        Request request = null;
        List<Request> list = m_requestPool;
        synchronized (list) {
            request = m_requestPool.size() > 0 ? m_requestPool.remove(0) : new Request();
        }
        request.m_dispatcher = eventDispatcher;
        request.m_type = n;
        request.m_listeners = map;
        request.m_event = eventObject;
        list = m_requestList;
        synchronized (list) {
            m_requestList.add(request);
            m_requestList.notify();
        }
    }

    private static void fireEventImmediately(EventDispatcher eventDispatcher, int n, Map<BundleContext, List<ListenerInfo>> map, EventObject eventObject, Dictionary dictionary) {
        if (!map.isEmpty()) {
            for (Map.Entry<BundleContext, List<ListenerInfo>> entry : map.entrySet()) {
                for (ListenerInfo listenerInfo : entry.getValue()) {
                    Bundle bundle = listenerInfo.getBundle();
                    EventListener eventListener = listenerInfo.getListener();
                    Filter filter = listenerInfo.getParsedFilter();
                    Object object = listenerInfo.getSecurityContext();
                    try {
                        if (n == 0) {
                            EventDispatcher.invokeFrameworkListenerCallback(bundle, eventListener, eventObject);
                            continue;
                        }
                        if (n == 1) {
                            EventDispatcher.invokeBundleListenerCallback(bundle, eventListener, eventObject);
                            continue;
                        }
                        if (n != 2) continue;
                        EventDispatcher.invokeServiceListenerCallback(bundle, eventListener, filter, object, eventObject, dictionary);
                    }
                    catch (Throwable throwable) {
                        if (n == 0 && ((FrameworkEvent)eventObject).getType() == 2) continue;
                        eventDispatcher.m_logger.log(bundle, 1, "EventDispatcher: Error during dispatch.", throwable);
                        eventDispatcher.fireFrameworkEvent(new FrameworkEvent(2, bundle, throwable));
                    }
                }
            }
        }
    }

    private static void invokeFrameworkListenerCallback(Bundle bundle, final EventListener eventListener, final EventObject eventObject) {
        if (bundle.getState() == 8 || bundle.getState() == 32) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ((FrameworkListener)eventListener).frameworkEvent((FrameworkEvent)eventObject);
                        return null;
                    }
                });
            } else {
                ((FrameworkListener)eventListener).frameworkEvent((FrameworkEvent)eventObject);
            }
        }
    }

    private static void invokeBundleListenerCallback(Bundle bundle, final EventListener eventListener, final EventObject eventObject) {
        if (SynchronousBundleListener.class.isAssignableFrom(eventListener.getClass()) && (bundle.getState() == 8 || bundle.getState() == 16 || bundle.getState() == 32) || bundle.getState() == 8 || bundle.getState() == 32) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ((BundleListener)eventListener).bundleChanged((BundleEvent)eventObject);
                        return null;
                    }
                });
            } else {
                ((BundleListener)eventListener).bundleChanged((BundleEvent)eventObject);
            }
        }
    }

    private static void invokeServiceListenerCallback(Bundle bundle, final EventListener eventListener, Filter filter, Object object, final EventObject eventObject, Dictionary dictionary) {
        if (bundle.getState() != 8 && bundle.getState() != 16 && bundle.getState() != 32) {
            return;
        }
        ServiceReference<?> serviceReference = ((ServiceEvent)eventObject).getServiceReference();
        boolean bl = true;
        SecurityManager securityManager = System.getSecurityManager();
        if (object != null && securityManager != null) {
            try {
                ServicePermission servicePermission = new ServicePermission(serviceReference, "get");
                securityManager.checkPermission(servicePermission, object);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (bl) {
            boolean bl2;
            if (eventListener instanceof UnfilteredServiceListener) {
                bl2 = true;
            } else {
                boolean bl3 = bl2 = filter == null || filter.match(((ServiceEvent)eventObject).getServiceReference());
            }
            if (bl2) {
                if (eventListener instanceof AllServiceListener || Util.isServiceAssignable(bundle, ((ServiceEvent)eventObject).getServiceReference())) {
                    if (System.getSecurityManager() != null) {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                ((ServiceListener)eventListener).serviceChanged((ServiceEvent)eventObject);
                                return null;
                            }
                        });
                    } else {
                        ((ServiceListener)eventListener).serviceChanged((ServiceEvent)eventObject);
                    }
                }
            } else if (((ServiceEvent)eventObject).getType() == 2 && filter.match(dictionary)) {
                final ServiceEvent serviceEvent = new ServiceEvent(8, ((ServiceEvent)eventObject).getServiceReference());
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            ((ServiceListener)eventListener).serviceChanged(serviceEvent);
                            return null;
                        }
                    });
                } else {
                    ((ServiceListener)eventListener).serviceChanged(serviceEvent);
                }
            }
        }
    }

    private static Map<BundleContext, List<ListenerInfo>> addListenerInfo(Map<BundleContext, List<ListenerInfo>> map, ListenerInfo listenerInfo) {
        HashMap<BundleContext, List<ListenerInfo>> hashMap = new HashMap<BundleContext, List<ListenerInfo>>(map);
        ArrayList<ListenerInfo> arrayList = (ArrayList<ListenerInfo>)hashMap.remove(listenerInfo.getBundleContext());
        arrayList = arrayList == null ? new ArrayList<ListenerInfo>() : new ArrayList(arrayList);
        arrayList.add(listenerInfo);
        hashMap.put(listenerInfo.getBundleContext(), arrayList);
        return hashMap;
    }

    private static Map<BundleContext, List<ListenerInfo>> updateListenerInfo(Map<BundleContext, List<ListenerInfo>> map, int n, ListenerInfo listenerInfo) {
        HashMap<BundleContext, List<ListenerInfo>> hashMap = new HashMap<BundleContext, List<ListenerInfo>>(map);
        ArrayList<ListenerInfo> arrayList = (ArrayList<ListenerInfo>)hashMap.remove(listenerInfo.getBundleContext());
        if (arrayList != null) {
            arrayList = new ArrayList<ListenerInfo>(arrayList);
            arrayList.set(n, listenerInfo);
            hashMap.put(listenerInfo.getBundleContext(), arrayList);
            return hashMap;
        }
        return map;
    }

    private static Map<BundleContext, List<ListenerInfo>> removeListenerInfo(Map<BundleContext, List<ListenerInfo>> map, BundleContext bundleContext, int n) {
        HashMap<BundleContext, List<ListenerInfo>> hashMap = new HashMap<BundleContext, List<ListenerInfo>>(map);
        ArrayList arrayList = (ArrayList)hashMap.remove(bundleContext);
        if (arrayList != null) {
            arrayList = new ArrayList(arrayList);
            arrayList.remove(n);
            if (!arrayList.isEmpty()) {
                hashMap.put(bundleContext, arrayList);
            }
            return hashMap;
        }
        return map;
    }

    private static Map<BundleContext, List<ListenerInfo>> removeListenerInfos(Map<BundleContext, List<ListenerInfo>> map, BundleContext bundleContext) {
        HashMap<BundleContext, List<ListenerInfo>> hashMap = new HashMap<BundleContext, List<ListenerInfo>>(map);
        hashMap.remove(bundleContext);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void run() {
        Request request = null;
        while (true) {
            List<Request> list = m_requestList;
            synchronized (list) {
                while (true) {
                    if (!m_requestList.isEmpty() || m_stopping) {
                        if (!m_requestList.isEmpty() || !m_stopping) break;
                        return;
                    }
                    try {
                        m_requestList.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                request = m_requestList.remove(0);
            }
            EventDispatcher.fireEventImmediately(request.m_dispatcher, request.m_type, request.m_listeners, request.m_event, null);
            list = m_requestPool;
            synchronized (list) {
                request.m_dispatcher = null;
                request.m_type = -1;
                request.m_listeners = null;
                request.m_event = null;
                m_requestPool.add(request);
            }
        }
    }

    private static class Request {
        public static final int FRAMEWORK_EVENT = 0;
        public static final int BUNDLE_EVENT = 1;
        public static final int SERVICE_EVENT = 2;
        public EventDispatcher m_dispatcher = null;
        public int m_type = -1;
        public Map<BundleContext, List<ListenerInfo>> m_listeners = null;
        public EventObject m_event = null;

        private Request() {
        }
    }
}

