/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CompoundEnumeration
implements Enumeration {
    private Enumeration[] m_enums = null;
    private int index = 0;

    public CompoundEnumeration(Enumeration[] enumerationArray) {
        this.m_enums = enumerationArray;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.currentEnumeration() == null) {
            return false;
        }
        return this.currentEnumeration().hasMoreElements();
    }

    private Enumeration findNextEnumeration(boolean bl) {
        return this.findNextEnumeration(this.index, bl);
    }

    private Enumeration findNextEnumeration(int n, boolean bl) {
        int n2 = n + 1;
        if (n2 < this.m_enums.length) {
            if (this.m_enums[n2] != null && this.m_enums[n2].hasMoreElements()) {
                if (bl) {
                    this.index = n2;
                }
                return this.m_enums[n2];
            }
            return this.findNextEnumeration(n2, bl);
        }
        return null;
    }

    public Object nextElement() {
        if (this.currentEnumeration() != null) {
            return this.currentEnumeration().nextElement();
        }
        throw new NoSuchElementException("No more elements");
    }

    private Enumeration currentEnumeration() {
        if (this.m_enums != null && this.index < this.m_enums.length) {
            Enumeration enumeration = this.m_enums[this.index];
            if (enumeration == null || !enumeration.hasMoreElements()) {
                enumeration = this.findNextEnumeration(true);
            }
            return enumeration;
        }
        return null;
    }
}

