/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.capabilityset;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.util.VersionRange;

public class SimpleFilter {
    public static final int MATCH_ALL = 0;
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int NOT = 3;
    public static final int EQ = 4;
    public static final int LTE = 5;
    public static final int GTE = 6;
    public static final int SUBSTRING = 7;
    public static final int PRESENT = 8;
    public static final int APPROX = 9;
    private final String m_name;
    private final Object m_value;
    private final int m_op;

    public SimpleFilter(String string, Object object, int n) {
        this.m_name = string;
        this.m_value = object;
        this.m_op = n;
    }

    public String getName() {
        return this.m_name;
    }

    public Object getValue() {
        return this.m_value;
    }

    public int getOperation() {
        return this.m_op;
    }

    public String toString() {
        String string = null;
        switch (this.m_op) {
            case 1: {
                string = "(&" + SimpleFilter.toString((List)this.m_value) + ")";
                break;
            }
            case 2: {
                string = "(|" + SimpleFilter.toString((List)this.m_value) + ")";
                break;
            }
            case 3: {
                string = "(!" + SimpleFilter.toString((List)this.m_value) + ")";
                break;
            }
            case 4: {
                string = "(" + this.m_name + "=" + SimpleFilter.toEncodedString(this.m_value) + ")";
                break;
            }
            case 5: {
                string = "(" + this.m_name + "<=" + SimpleFilter.toEncodedString(this.m_value) + ")";
                break;
            }
            case 6: {
                string = "(" + this.m_name + ">=" + SimpleFilter.toEncodedString(this.m_value) + ")";
                break;
            }
            case 7: {
                string = "(" + this.m_name + "=" + SimpleFilter.unparseSubstring((List)this.m_value) + ")";
                break;
            }
            case 8: {
                string = "(" + this.m_name + "=*)";
                break;
            }
            case 9: {
                string = "(" + this.m_name + "~=" + SimpleFilter.toEncodedString(this.m_value) + ")";
                break;
            }
            case 0: {
                string = "(*)";
            }
        }
        return string;
    }

    private static String toString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < list.size()) {
            stringBuffer.append(list.get(n).toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String toDecodedString(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2 - n) {
            char c = string.charAt(n + n3);
            if (!bl && c == '\\') {
                bl = true;
            } else {
                bl = false;
                stringBuffer.append(c);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static String toEncodedString(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\\' || c == '(' || c == ')' || c == '*') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                ++n;
            }
            object = stringBuffer.toString();
        }
        return object.toString();
    }

    public static SimpleFilter parse(String string) {
        int n = SimpleFilter.skipWhitespace(string, 0);
        if (string == null || string.length() == 0 || n >= string.length()) {
            throw new IllegalArgumentException("Null or empty filter.");
        }
        if (string.charAt(n) != '(') {
            throw new IllegalArgumentException("Missing opening parenthesis: " + string);
        }
        SimpleFilter simpleFilter = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        while (n < string.length()) {
            if (simpleFilter != null) {
                throw new IllegalArgumentException("Only one top-level operation allowed: " + string);
            }
            if (!bl && string.charAt(n) == '(') {
                if (string.charAt(n = SimpleFilter.skipWhitespace(string, n + 1)) == '&') {
                    int n2 = SimpleFilter.skipWhitespace(string, n + 1);
                    if (string.charAt(n2) == '(') {
                        n = n2 - 1;
                        arrayList.add(0, new SimpleFilter(null, new ArrayList(), 1));
                    } else {
                        arrayList.add(0, new Integer(n));
                    }
                } else if (string.charAt(n) == '|') {
                    int n3 = SimpleFilter.skipWhitespace(string, n + 1);
                    if (string.charAt(n3) == '(') {
                        n = n3 - 1;
                        arrayList.add(0, new SimpleFilter(null, new ArrayList(), 2));
                    } else {
                        arrayList.add(0, new Integer(n));
                    }
                } else if (string.charAt(n) == '!') {
                    int n4 = SimpleFilter.skipWhitespace(string, n + 1);
                    if (string.charAt(n4) == '(') {
                        n = n4 - 1;
                        arrayList.add(0, new SimpleFilter(null, new ArrayList(), 3));
                    } else {
                        arrayList.add(0, new Integer(n));
                    }
                } else {
                    arrayList.add(0, new Integer(n));
                }
            } else if (!bl && string.charAt(n) == ')') {
                Object e = arrayList.remove(0);
                if (e instanceof SimpleFilter) {
                    if (!arrayList.isEmpty() && arrayList.get(0) instanceof SimpleFilter) {
                        ((List)((SimpleFilter)arrayList.get((int)0)).m_value).add(e);
                    } else {
                        simpleFilter = (SimpleFilter)e;
                    }
                } else if (!arrayList.isEmpty() && arrayList.get(0) instanceof SimpleFilter) {
                    ((List)((SimpleFilter)arrayList.get((int)0)).m_value).add(SimpleFilter.subfilter(string, (Integer)e, n));
                } else {
                    simpleFilter = SimpleFilter.subfilter(string, (Integer)e, n);
                }
            } else {
                bl = !bl && string.charAt(n) == '\\';
            }
            n = SimpleFilter.skipWhitespace(string, n + 1);
        }
        if (simpleFilter == null) {
            throw new IllegalArgumentException("Missing closing parenthesis: " + string);
        }
        return simpleFilter;
    }

    private static SimpleFilter subfilter(String string, int n, int n2) {
        int n3;
        int n4 = n;
        int n5 = 0;
        while (n5 < n2 - n) {
            n3 = string.charAt(n + n5);
            if ("=<>~".indexOf(n3) >= 0) break;
            if (!Character.isWhitespace((char)n3)) {
                n4 = n + n5 + 1;
            }
            ++n5;
        }
        if (n4 == n) {
            throw new IllegalArgumentException("Missing attribute name: " + string.substring(n, n2));
        }
        String string2 = string.substring(n, n4);
        n = SimpleFilter.skipWhitespace(string, n4);
        n3 = -1;
        switch (string.charAt(n)) {
            case '=': {
                n3 = 4;
                ++n;
                break;
            }
            case '<': {
                if (string.charAt(n + 1) != '=') {
                    throw new IllegalArgumentException("Unknown operator: " + string.substring(n, n2));
                }
                n3 = 5;
                n += 2;
                break;
            }
            case '>': {
                if (string.charAt(n + 1) != '=') {
                    throw new IllegalArgumentException("Unknown operator: " + string.substring(n, n2));
                }
                n3 = 6;
                n += 2;
                break;
            }
            case '~': {
                if (string.charAt(n + 1) != '=') {
                    throw new IllegalArgumentException("Unknown operator: " + string.substring(n, n2));
                }
                n3 = 9;
                n += 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + string.substring(n, n2));
            }
        }
        Object object = SimpleFilter.toDecodedString(string, n, n2);
        if (n3 == 4) {
            String string3 = string.substring(n, n2);
            List<String> list = SimpleFilter.parseSubstring(string3);
            if (list.size() == 2 && list.get(0).length() == 0 && list.get(1).length() == 0) {
                n3 = 8;
            } else if (list.size() > 1) {
                n3 = 7;
                object = list;
            }
        }
        return new SimpleFilter(string2, object, n3);
    }

    public static List<String> parseSubstring(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        boolean bl4 = false;
        while (true) {
            if (n >= string.length()) {
                if (bl) {
                    bl3 = true;
                    break;
                }
                arrayList.add(stringBuffer.toString());
                break;
            }
            char c = string.charAt(n++);
            if (!bl4 && c == '*') {
                if (bl) continue;
                if (stringBuffer.length() > 0) {
                    arrayList.add(stringBuffer.toString());
                }
                stringBuffer.setLength(0);
                if (arrayList.isEmpty()) {
                    bl2 = true;
                }
                bl = true;
                continue;
            }
            if (!bl4 && c == '\\') {
                bl4 = true;
                continue;
            }
            bl4 = false;
            bl = false;
            stringBuffer.append(c);
        }
        stringBuffer.setLength(0);
        if (bl2 || bl3 || arrayList.size() > 1) {
            if (bl3) {
                arrayList.add("");
            }
            if (bl2) {
                arrayList.add(0, "");
            }
        }
        return arrayList;
    }

    public static String unparseSubstring(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < list.size()) {
            if (n > 0) {
                stringBuffer.append("*");
            }
            stringBuffer.append(SimpleFilter.toEncodedString(list.get(n)));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean compareSubstring(List<String> list, String string) {
        boolean bl = true;
        int n = list.size();
        if (n == 1) {
            return string.equals(list.get(0));
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string2 = list.get(n3);
            if (n3 == 0 && !string.startsWith(string2)) {
                bl = false;
                break;
            }
            if (n3 == n - 1) {
                if (string.endsWith(string2) && string.length() >= n2 + string2.length()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            if (n3 > 0 && n3 < n - 1 && (n2 = string.indexOf(string2, n2)) < 0) {
                bl = false;
                break;
            }
            n2 += string2.length();
            ++n3;
        }
        return bl;
    }

    private static int skipWhitespace(String string, int n) {
        int n2 = string.length();
        while (n < n2 && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    public static SimpleFilter convert(Map<String, Object> map) {
        Map.Entry<String, Object> entry2;
        ArrayList<SimpleFilter> arrayList = new ArrayList<SimpleFilter>();
        for (Map.Entry<String, Object> entry2 : map.entrySet()) {
            List<String> list;
            if (entry2.getValue() instanceof VersionRange) {
                SimpleFilter simpleFilter;
                list = (VersionRange)entry2.getValue();
                if (((VersionRange)((Object)list)).isFloorInclusive()) {
                    arrayList.add(new SimpleFilter((String)entry2.getKey(), ((VersionRange)((Object)list)).getFloor().toString(), 6));
                } else {
                    simpleFilter = new SimpleFilter(null, new ArrayList(), 3);
                    ((List)simpleFilter.getValue()).add(new SimpleFilter((String)entry2.getKey(), ((VersionRange)((Object)list)).getFloor().toString(), 5));
                    arrayList.add(simpleFilter);
                }
                if (((VersionRange)((Object)list)).getCeiling() == null) continue;
                if (((VersionRange)((Object)list)).isCeilingInclusive()) {
                    arrayList.add(new SimpleFilter((String)entry2.getKey(), ((VersionRange)((Object)list)).getCeiling().toString(), 5));
                    continue;
                }
                simpleFilter = new SimpleFilter(null, new ArrayList(), 3);
                ((List)simpleFilter.getValue()).add(new SimpleFilter((String)entry2.getKey(), ((VersionRange)((Object)list)).getCeiling().toString(), 6));
                arrayList.add(simpleFilter);
                continue;
            }
            list = SimpleFilter.parseSubstring(entry2.getValue().toString());
            if (list.size() > 1) {
                arrayList.add(new SimpleFilter((String)entry2.getKey(), list, 7));
                continue;
            }
            arrayList.add(new SimpleFilter((String)entry2.getKey(), list.get(0), 4));
        }
        entry2 = null;
        if (arrayList.size() == 1) {
            entry2 = (SimpleFilter)arrayList.get(0);
        } else if (map.size() > 1) {
            entry2 = new SimpleFilter(null, arrayList, 1);
        } else if (arrayList.isEmpty()) {
            entry2 = new SimpleFilter(null, null, 0);
        }
        return entry2;
    }
}

