/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.capabilityset;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.StringComparator;
import org.apache.felix.framework.util.VersionRange;
import org.apache.felix.framework.wiring.BundleCapabilityImpl;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.resource.Capability;

public class CapabilitySet {
    private final SortedMap<String, Map<Object, Set<BundleCapability>>> m_indices;
    private final Set<Capability> m_capSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final SecureAction m_secureAction = new SecureAction();
    private static final Class<?>[] STRING_CLASS = new Class[]{String.class};
    private static final String VALUE_OF_METHOD_NAME = "valueOf";

    public void dump() {
        for (Map.Entry<String, Map<Object, Set<BundleCapability>>> entry : this.m_indices.entrySet()) {
            boolean bl = false;
            for (Map.Entry<Object, Set<BundleCapability>> entry2 : entry.getValue().entrySet()) {
                boolean bl2 = false;
                for (BundleCapability bundleCapability : entry2.getValue()) {
                    if (bundleCapability.getRevision().getBundle().getBundleId() == 0L) continue;
                    if (!bl) {
                        System.out.println(String.valueOf(entry.getKey()) + ":");
                        bl = true;
                    }
                    if (!bl2) {
                        System.out.println("   " + entry2.getKey());
                        bl2 = true;
                    }
                    System.out.println("      " + bundleCapability);
                }
            }
        }
    }

    public CapabilitySet(List<String> list, boolean bl) {
        this.m_indices = bl ? new ConcurrentSkipListMap<String, Map<Object, Set<BundleCapability>>>() : new ConcurrentSkipListMap(StringComparator.COMPARATOR);
        int n = 0;
        while (list != null && n < list.size()) {
            this.m_indices.put(list.get(n), new ConcurrentHashMap());
            ++n;
        }
    }

    public void addCapability(BundleCapability bundleCapability) {
        this.m_capSet.add(bundleCapability);
        for (Map.Entry<String, Map<Object, Set<BundleCapability>>> entry : this.m_indices.entrySet()) {
            Object object = bundleCapability.getAttributes().get(entry.getKey());
            if (object == null) continue;
            if (object.getClass().isArray()) {
                object = CapabilitySet.convertArrayToList(object);
            }
            ConcurrentMap concurrentMap = (ConcurrentMap)entry.getValue();
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                for (Object e : collection) {
                    this.indexCapability(concurrentMap, bundleCapability, e);
                }
                continue;
            }
            this.indexCapability(concurrentMap, bundleCapability, object);
        }
    }

    private void indexCapability(ConcurrentMap<Object, Set<BundleCapability>> concurrentMap, BundleCapability bundleCapability, Object object) {
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Set set2 = concurrentMap.putIfAbsent(object, set);
        if (set2 != null) {
            set = set2;
        }
        set.add(bundleCapability);
    }

    public void removeCapability(BundleCapability bundleCapability) {
        if (this.m_capSet.remove(bundleCapability)) {
            for (Map.Entry<String, Map<Object, Set<BundleCapability>>> entry : this.m_indices.entrySet()) {
                Object object = bundleCapability.getAttributes().get(entry.getKey());
                if (object == null) continue;
                if (object.getClass().isArray()) {
                    object = CapabilitySet.convertArrayToList(object);
                }
                Map<Object, Set<BundleCapability>> map = entry.getValue();
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    for (Object e : collection) {
                        this.deindexCapability(map, bundleCapability, e);
                    }
                    continue;
                }
                this.deindexCapability(map, bundleCapability, object);
            }
        }
    }

    private void deindexCapability(Map<Object, Set<BundleCapability>> map, BundleCapability bundleCapability, Object object) {
        Set<BundleCapability> set = map.get(object);
        if (set != null) {
            set.remove(bundleCapability);
            if (set.isEmpty()) {
                map.remove(object);
            }
        }
    }

    public Set<Capability> match(SimpleFilter simpleFilter, boolean bl) {
        Set<Capability> set = this.match(this.m_capSet, simpleFilter);
        return bl ? CapabilitySet.matchMandatory(set, simpleFilter) : set;
    }

    private Set<Capability> match(Set<Capability> set, SimpleFilter simpleFilter) {
        Set<Capability> set2;
        block5: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                set2 = Collections.newSetFromMap(new ConcurrentHashMap());
                                if (simpleFilter.getOperation() != 0) break block4;
                                set2.addAll(set);
                                break block5;
                            }
                            if (simpleFilter.getOperation() != 1) break block6;
                            List list = (List)simpleFilter.getValue();
                            int n = 0;
                            while (set.size() > 0 && n < list.size()) {
                                set2 = this.match(set, (SimpleFilter)list.get(n));
                                set = set2;
                                ++n;
                            }
                            break block5;
                        }
                        if (simpleFilter.getOperation() != 2) break block7;
                        List list = (List)simpleFilter.getValue();
                        int n = 0;
                        while (n < list.size()) {
                            set2.addAll(this.match(set, (SimpleFilter)list.get(n)));
                            ++n;
                        }
                        break block5;
                    }
                    if (simpleFilter.getOperation() != 3) break block8;
                    set2.addAll(set);
                    List list = (List)simpleFilter.getValue();
                    int n = 0;
                    while (n < list.size()) {
                        set2.removeAll(this.match(set, (SimpleFilter)list.get(n)));
                        ++n;
                    }
                    break block5;
                }
                Map map = (Map)this.m_indices.get(simpleFilter.getName());
                if (simpleFilter.getOperation() != 4 || map == null) break block9;
                Set set3 = (Set)map.get(simpleFilter.getValue());
                if (set3 == null) break block5;
                set2.addAll(set3);
                if (set == this.m_capSet) break block5;
                set2.retainAll(set);
                break block5;
            }
            for (Capability capability : set) {
                Object object = capability.getAttributes().get(simpleFilter.getName());
                if (object == null || !CapabilitySet.compare(object, simpleFilter.getValue(), simpleFilter.getOperation())) continue;
                set2.add(capability);
            }
        }
        return set2;
    }

    public static boolean matches(Capability capability, SimpleFilter simpleFilter) {
        return CapabilitySet.matchesInternal(capability, simpleFilter) && CapabilitySet.matchMandatory(capability, simpleFilter);
    }

    private static boolean matchesInternal(Capability capability, SimpleFilter simpleFilter) {
        boolean bl = true;
        if (simpleFilter.getOperation() == 0) {
            bl = true;
        } else if (simpleFilter.getOperation() == 1) {
            List list = (List)simpleFilter.getValue();
            int n = 0;
            while (bl && n < list.size()) {
                bl = CapabilitySet.matchesInternal(capability, (SimpleFilter)list.get(n));
                ++n;
            }
        } else if (simpleFilter.getOperation() == 2) {
            bl = false;
            List list = (List)simpleFilter.getValue();
            int n = 0;
            while (!bl && n < list.size()) {
                bl = CapabilitySet.matchesInternal(capability, (SimpleFilter)list.get(n));
                ++n;
            }
        } else if (simpleFilter.getOperation() == 3) {
            List list = (List)simpleFilter.getValue();
            int n = 0;
            while (n < list.size()) {
                bl = !CapabilitySet.matchesInternal(capability, (SimpleFilter)list.get(n));
                ++n;
            }
        } else {
            bl = false;
            Object object = capability.getAttributes().get(simpleFilter.getName());
            if (object != null) {
                bl = CapabilitySet.compare(object, simpleFilter.getValue(), simpleFilter.getOperation());
            }
        }
        return bl;
    }

    private static Set<Capability> matchMandatory(Set<Capability> set, SimpleFilter simpleFilter) {
        Iterator<Capability> iterator = set.iterator();
        while (iterator.hasNext()) {
            Capability capability = iterator.next();
            if (CapabilitySet.matchMandatory(capability, simpleFilter)) continue;
            iterator.remove();
        }
        return set;
    }

    private static boolean matchMandatory(Capability capability, SimpleFilter simpleFilter) {
        Map<String, Object> map = capability.getAttributes();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!((BundleCapabilityImpl)capability).isAttributeMandatory(entry.getKey()) || CapabilitySet.matchMandatoryAttrbute(entry.getKey(), simpleFilter)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchMandatoryAttrbute(String string, SimpleFilter simpleFilter) {
        if (simpleFilter.getName() != null && simpleFilter.getName().equals(string)) {
            return true;
        }
        if (simpleFilter.getOperation() == 1) {
            List list = (List)simpleFilter.getValue();
            int n = 0;
            while (n < list.size()) {
                SimpleFilter simpleFilter2 = (SimpleFilter)list.get(n);
                if (simpleFilter2.getName() != null && simpleFilter2.getName().equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private static boolean compare(Object object, Object object2, int n) {
        Iterator iterator;
        if (object == null) {
            return false;
        }
        if (n == 8) {
            return true;
        }
        if (object instanceof Version && n == 4) {
            iterator = null;
            try {
                iterator = CapabilitySet.coerceType(object, (String)object2);
            }
            catch (Exception exception) {}
            if (iterator != null && iterator instanceof VersionRange) {
                return ((VersionRange)((Object)iterator)).isInRange((Version)object);
            }
        }
        if (object instanceof Comparable) {
            if (n == 7 && !(object instanceof String)) {
                return false;
            }
            if (n == 7) {
                iterator = object2;
            } else {
                try {
                    iterator = CapabilitySet.coerceType(object, (String)object2);
                }
                catch (Exception exception) {
                    return false;
                }
            }
            switch (n) {
                case 4: {
                    try {
                        return ((Comparable)object).compareTo(iterator) == 0;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                case 6: {
                    try {
                        return ((Comparable)object).compareTo(iterator) >= 0;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                case 5: {
                    try {
                        return ((Comparable)object).compareTo(iterator) <= 0;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                case 9: {
                    return CapabilitySet.compareApproximate(object, iterator);
                }
                case 7: {
                    return SimpleFilter.compareSubstring((List)((Object)iterator), (String)object);
                }
            }
            throw new RuntimeException("Unknown comparison operator: " + n);
        }
        if (object instanceof Boolean) {
            try {
                iterator = CapabilitySet.coerceType(object, (String)object2);
            }
            catch (Exception exception) {
                return false;
            }
            switch (n) {
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    return object.equals(iterator);
                }
            }
            throw new RuntimeException("Unknown comparison operator: " + n);
        }
        if (object.getClass().isArray()) {
            object = CapabilitySet.convertArrayToList(object);
        }
        if (object instanceof Collection) {
            iterator = ((Collection)object).iterator();
            while (iterator.hasNext()) {
                if (!CapabilitySet.compare(iterator.next(), object2, n)) continue;
                return true;
            }
            return false;
        }
        if (n == 7 && !(object instanceof String)) {
            return false;
        }
        try {
            return object.equals(CapabilitySet.coerceType(object, (String)object2));
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean compareApproximate(Object object, Object object2) {
        if (object2 instanceof String) {
            return CapabilitySet.removeWhitespace((String)object).equalsIgnoreCase(CapabilitySet.removeWhitespace((String)object2));
        }
        if (object2 instanceof Character) {
            return Character.toLowerCase(((Character)object).charValue()) == Character.toLowerCase(((Character)object2).charValue());
        }
        return object.equals(object2);
    }

    private static String removeWhitespace(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            if (!Character.isWhitespace(string.charAt(n))) {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static Object coerceType(Object object, String string) throws Exception {
        Object object2;
        block10: {
            if (object.getClass() == string.getClass()) {
                return string;
            }
            object2 = null;
            try {
                Executable executable;
                if (object instanceof Character) {
                    object2 = new Character(string.charAt(0));
                    break block10;
                }
                if (object instanceof Version && string.indexOf(44) >= 0) {
                    object2 = VersionRange.parse(string);
                    break block10;
                }
                if (object instanceof Number || object instanceof Boolean) {
                    string = string.trim();
                }
                try {
                    executable = m_secureAction.getDeclaredMethod(object.getClass(), VALUE_OF_METHOD_NAME, STRING_CLASS);
                    if (((Method)executable).getReturnType().isAssignableFrom(object.getClass()) && (((Method)executable).getModifiers() & 8) > 0) {
                        m_secureAction.setAccesssible(executable);
                        object2 = ((Method)executable).invoke(null, string);
                    }
                }
                catch (Exception exception) {}
                if (object2 == null) {
                    executable = m_secureAction.getConstructor(object.getClass(), STRING_CLASS);
                    m_secureAction.setAccesssible(executable);
                    object2 = ((Constructor)executable).newInstance(string);
                }
            }
            catch (Exception exception) {
                throw new Exception("Could not instantiate class " + object.getClass().getName() + " from string constructor with argument '" + string + "' because " + exception);
            }
        }
        return object2;
    }

    private static List convertArrayToList(Object object) {
        int n = Array.getLength(object);
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(Array.get(object, n2));
            ++n2;
        }
        return arrayList;
    }
}

