/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleArchiveRevision;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.cache.JarContent;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.WeakZipFileFactory;

class JarRevision
extends BundleArchiveRevision {
    private static final transient String BUNDLE_JAR_FILE = "bundle.jar";
    private final WeakZipFileFactory m_zipFactory;
    private final File m_bundleFile;
    private final WeakZipFileFactory.WeakZipFile m_zipFile;
    private static final ThreadLocal m_defaultBuffer = new ThreadLocal();
    private static final int DEFAULT_BUFFER = 65536;

    public JarRevision(Logger logger, Map map, WeakZipFileFactory weakZipFileFactory, File file, String string, boolean bl, InputStream inputStream) throws Exception {
        super(logger, map, file, string);
        this.m_zipFactory = weakZipFileFactory;
        this.m_bundleFile = bl ? new File(string.substring(string.indexOf("file:") + "file:".length())) : new File(this.getRevisionRootDir(), BUNDLE_JAR_FILE);
        this.initialize(bl, inputStream);
        WeakZipFileFactory.WeakZipFile weakZipFile = null;
        try {
            weakZipFile = this.m_zipFactory.create(this.m_bundleFile);
            if (weakZipFile == null) {
                throw new IOException("No JAR file found.");
            }
            this.m_zipFile = weakZipFile;
        }
        catch (Exception exception) {
            if (weakZipFile != null) {
                weakZipFile.close();
            }
            throw exception;
        }
    }

    @Override
    public Map getManifestHeader() throws Exception {
        StringMap stringMap = new StringMap();
        JarRevision.getMainAttributes(stringMap, this.m_zipFile);
        return stringMap;
    }

    @Override
    public synchronized Content getContent() throws Exception {
        return new JarContent(this.getLogger(), this.getConfig(), this.m_zipFactory, this, this.getRevisionRootDir(), this.m_bundleFile, this.m_zipFile);
    }

    @Override
    protected void close() throws Exception {
        this.m_zipFile.close();
    }

    private void initialize(boolean bl, InputStream inputStream) throws Exception {
        block11: {
            try {
                if (BundleCache.getSecureAction().fileExists(this.getRevisionRootDir())) break block11;
                if (!BundleCache.getSecureAction().mkdir(this.getRevisionRootDir())) {
                    this.getLogger().log(1, String.valueOf(this.getClass().getName()) + ": Unable to create revision directory.");
                    throw new IOException("Unable to create archive directory.");
                }
                if (bl) break block11;
                URLConnection uRLConnection = null;
                try {
                    if (inputStream == null) {
                        URL uRL = BundleCache.getSecureAction().createURL(null, this.getLocation(), null);
                        uRLConnection = uRL.openConnection();
                        String string = BundleCache.getSecureAction().getSystemProperty("http.proxyAuth", null);
                        if (string != null && string.length() > 0 && ("http".equals(uRL.getProtocol()) || "https".equals(uRL.getProtocol()))) {
                            String string2 = Util.base64Encode(string);
                            uRLConnection.setRequestProperty("Proxy-Authorization", "Basic " + string2);
                        }
                        inputStream = BundleCache.getSecureAction().getURLConnectionInputStream(uRLConnection);
                    }
                    BundleCache.copyStreamToFile(inputStream, this.m_bundleFile);
                }
                finally {
                    if (uRLConnection != null && uRLConnection instanceof HttpURLConnection) {
                        ((HttpURLConnection)uRLConnection).disconnect();
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void getMainAttributes(Map map, WeakZipFileFactory.WeakZipFile weakZipFile) throws Exception {
        ZipEntry zipEntry = weakZipFile.getEntry("META-INF/MANIFEST.MF");
        SoftReference softReference = (SoftReference)m_defaultBuffer.get();
        byte[] byArray = null;
        if (softReference != null) {
            byArray = (byte[])softReference.get();
        }
        int n = (int)zipEntry.getSize();
        if (byArray == null) {
            byArray = new byte[n > 65536 ? n : 65536];
            m_defaultBuffer.set(new SoftReference<byte[]>(byArray));
        } else if (n > byArray.length) {
            byArray = new byte[n];
            m_defaultBuffer.set(new SoftReference<byte[]>(byArray));
        }
        InputStream inputStream = null;
        try {
            inputStream = weakZipFile.getInputStream(zipEntry);
            int n2 = inputStream.read(byArray);
            while (n2 < n) {
                n2 += inputStream.read(byArray, n2, byArray.length - n2);
            }
        }
        finally {
            inputStream.close();
        }
        String string = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            if (byArray[n5] != 13 || n5 + 1 >= n || byArray[n5 + 1] != 10) {
                if (byArray[n5] == 10 && n5 + 1 < n && byArray[n5 + 1] == 32) {
                    ++n5;
                } else if (string == null && byArray[n5] == 58) {
                    string = new String(byArray, n3, n4 - n3, "UTF-8");
                    if (n5 + 1 >= n || byArray[n5 + 1] != 32) throw new Exception("Manifest error: Missing space separator - " + string);
                    n3 = n4 + 1;
                } else if (byArray[n5] == 10) {
                    if (n3 == n4 && string == null) return;
                    String string2 = new String(byArray, n3, n4 - n3, "UTF-8");
                    if (string == null) {
                        throw new Exception("Manifst error: Missing attribute name - " + string2);
                    }
                    if (map.put(string, string2) != null) {
                        throw new Exception("Manifst error: Duplicate attribute name - " + string);
                    }
                    n3 = n4;
                    string = null;
                } else {
                    byArray[n4++] = byArray[n5];
                }
            }
            ++n5;
        }
    }
}

