/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.cache.ContentDirectoryContent;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.WeakZipFileFactory;

public class JarContent
implements Content {
    private static final int BUFSIZE = 4096;
    private static final transient String EMBEDDED_DIRECTORY = "-embedded";
    private static final transient String LIBRARY_DIRECTORY = "-lib";
    private final Logger m_logger;
    private final Map m_configMap;
    private final WeakZipFileFactory m_zipFactory;
    private final Object m_revisionLock;
    private final File m_rootDir;
    private final File m_file;
    private final WeakZipFileFactory.WeakZipFile m_zipFile;
    private final boolean m_isZipFileOwner;
    private Map m_nativeLibMap;

    public JarContent(Logger logger, Map map, WeakZipFileFactory weakZipFileFactory, Object object, File file, File file2, WeakZipFileFactory.WeakZipFile weakZipFile) {
        this.m_logger = logger;
        this.m_configMap = map;
        this.m_zipFactory = weakZipFileFactory;
        this.m_revisionLock = object;
        this.m_rootDir = file;
        this.m_file = file2;
        if (weakZipFile == null) {
            try {
                this.m_zipFile = this.m_zipFactory.create(this.m_file);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to open JAR file, probably deleted: " + iOException.getMessage());
            }
        } else {
            this.m_zipFile = weakZipFile;
        }
        this.m_isZipFileOwner = weakZipFile == null;
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public void close() {
        try {
            if (this.m_isZipFileOwner) {
                this.m_zipFile.close();
            }
        }
        catch (Exception exception) {
            this.m_logger.log(1, "JarContent: Unable to close JAR file.", exception);
        }
    }

    @Override
    public boolean hasEntry(String string) throws IllegalStateException {
        try {
            ZipEntry zipEntry = this.m_zipFile.getEntry(string);
            return zipEntry != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public Enumeration<String> getEntries() {
        EntriesEnumeration entriesEnumeration = new EntriesEnumeration(this.m_zipFile.entries());
        return entriesEnumeration.hasMoreElements() ? entriesEnumeration : null;
    }

    /*
     * Loose catch block
     */
    @Override
    public byte[] getEntryAsBytes(String string) throws IllegalStateException {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        block38: {
            ZipEntry zipEntry;
            block37: {
                inputStream = null;
                byteArrayOutputStream = null;
                zipEntry = this.m_zipFile.getEntry(string);
                if (zipEntry != null) break block37;
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
                return null;
            }
            inputStream = this.m_zipFile.getInputStream(zipEntry);
            if (inputStream != null) break block38;
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            return null;
        }
        byteArrayOutputStream = new ByteArrayOutputStream(4096);
        byte[] byArray = new byte[4096];
        int n = 0;
        while ((n = inputStream.read(byArray, 0, byArray.length)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        try {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        return byArray2;
        catch (Exception exception) {
            try {
                this.m_logger.log(1, "JarContent: Unable to read bytes for file " + string + " in ZIP file " + this.m_file.getAbsolutePath(), exception);
            }
            catch (Throwable throwable) {
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                }
                catch (Exception exception2) {}
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception3) {}
                throw throwable;
            }
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (Exception exception4) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception5) {}
            return null;
        }
    }

    @Override
    public InputStream getEntryAsStream(String string) throws IllegalStateException, IOException {
        ZipEntry zipEntry;
        InputStream inputStream;
        block4: {
            inputStream = null;
            try {
                zipEntry = this.m_zipFile.getEntry(string);
                if (zipEntry != null) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        inputStream = this.m_zipFile.getInputStream(zipEntry);
        if (inputStream == null) {
            return null;
        }
        return inputStream;
    }

    @Override
    public URL getEntryAsURL(String string) {
        try {
            return new URL("jar:" + this.m_file.toURI().toURL().toExternalForm() + "!/" + string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Content getEntryAsContent(String string) {
        if (string.equals(".")) {
            return new JarContent(this.m_logger, this.m_configMap, this.m_zipFactory, this.m_revisionLock, this.m_rootDir, this.m_file, this.m_zipFile);
        }
        string = string.startsWith("/") ? string.substring(1) : string;
        File file = new File(this.m_rootDir, String.valueOf(this.m_file.getName()) + EMBEDDED_DIRECTORY);
        ZipEntry zipEntry = this.m_zipFile.getEntry(string);
        if (zipEntry != null && zipEntry.isDirectory()) {
            File file2 = new File(file, string);
            Object object = this.m_revisionLock;
            synchronized (object) {
                if (!BundleCache.getSecureAction().fileExists(file2) && !BundleCache.getSecureAction().mkdirs(file2)) {
                    this.m_logger.log(1, "Unable to extract embedded directory.");
                }
            }
            return new ContentDirectoryContent(this, string);
        }
        if (zipEntry != null && zipEntry.getName().endsWith(".jar")) {
            File file3 = new File(file, string);
            Object object = this.m_revisionLock;
            synchronized (object) {
                try {
                    this.extractEmbeddedJar(string);
                }
                catch (Exception exception) {
                    this.m_logger.log(1, "Unable to extract embedded JAR file.", exception);
                }
            }
            return new JarContent(this.m_logger, this.m_configMap, this.m_zipFactory, this.m_revisionLock, file3.getParentFile(), file3, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEntryAsNativeLibrary(String string) {
        String string2 = null;
        string = string.startsWith("/") ? string.substring(1) : string;
        File file = new File(this.m_rootDir, String.valueOf(this.m_file.getName()) + LIBRARY_DIRECTORY);
        ZipEntry zipEntry = this.m_zipFile.getEntry(string);
        if (zipEntry != null && !zipEntry.isDirectory()) {
            Object object = this.m_revisionLock;
            synchronized (object) {
                block25: {
                    Integer n;
                    if (this.m_nativeLibMap == null) {
                        this.m_nativeLibMap = new HashMap();
                    }
                    n = (n = (Integer)this.m_nativeLibMap.get(string)) == null ? new Integer(0) : new Integer(n + 1);
                    this.m_nativeLibMap.put(string, n);
                    File file2 = new File(file, String.valueOf(n.toString()) + File.separatorChar + string);
                    if (!BundleCache.getSecureAction().fileExists(file2)) {
                        if (!BundleCache.getSecureAction().fileExists(file2.getParentFile()) && !BundleCache.getSecureAction().mkdirs(file2.getParentFile())) {
                            this.m_logger.log(1, "Unable to create library directory.");
                        } else {
                            InputStream inputStream = null;
                            try {
                                try {
                                    inputStream = new BufferedInputStream(this.m_zipFile.getInputStream(zipEntry), BundleCache.BUFSIZE);
                                    if (inputStream == null) {
                                        throw new IOException("No input stream: " + string);
                                    }
                                    BundleCache.copyStreamToFile(inputStream, file2);
                                    String string3 = (String)this.m_configMap.get("org.osgi.framework.command.execpermission");
                                    if (string3 != null) {
                                        Properties properties = new Properties();
                                        properties.setProperty("abspath", file2.toString());
                                        string3 = Util.substVars(string3, "command", null, properties);
                                        Process process = BundleCache.getSecureAction().exec(string3);
                                        Thread thread = new Thread(new DevNullRunnable(process.getInputStream()));
                                        Thread thread2 = new Thread(new DevNullRunnable(process.getErrorStream()));
                                        thread.setDaemon(true);
                                        thread2.setDaemon(true);
                                        thread.start();
                                        thread2.start();
                                        process.waitFor();
                                        thread.join();
                                        thread2.join();
                                    }
                                    string2 = BundleCache.getSecureAction().getAbsolutePath(file2);
                                }
                                catch (Exception exception) {
                                    this.m_logger.log(1, "Extracting native library.", exception);
                                    try {
                                        if (inputStream != null) {
                                            inputStream.close();
                                        }
                                        break block25;
                                    }
                                    catch (IOException iOException) {}
                                    break block25;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                    } else {
                        string2 = BundleCache.getSecureAction().getAbsolutePath(file2);
                    }
                }
            }
        }
        return string2;
    }

    public String toString() {
        return "JAR " + this.m_file.getPath();
    }

    public File getFile() {
        return this.m_file;
    }

    private void extractEmbeddedJar(String string) throws Exception {
        string = string.length() > 0 && string.charAt(0) == '/' ? string.substring(1) : string;
        File file = new File(this.m_rootDir, String.valueOf(this.m_file.getName()) + EMBEDDED_DIRECTORY);
        File file2 = new File(file, string);
        if (!BundleCache.getSecureAction().fileExists(file2)) {
            InputStream inputStream = null;
            try {
                ZipEntry zipEntry = this.m_zipFile.getEntry(string);
                if (zipEntry == null) {
                    return;
                }
                if (!zipEntry.isDirectory()) {
                    File file3 = file2.getParentFile();
                    if (!BundleCache.getSecureAction().fileExists(file3) && !BundleCache.getSecureAction().mkdirs(file3)) {
                        throw new IOException("Unable to create embedded JAR directory.");
                    }
                    inputStream = new BufferedInputStream(this.m_zipFile.getInputStream(zipEntry), BundleCache.BUFSIZE);
                    if (inputStream == null) {
                        throw new IOException("No input stream: " + string);
                    }
                    BundleCache.copyStreamToFile(inputStream, file2);
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    private static class DevNullRunnable
    implements Runnable {
        private final InputStream m_in;

        public DevNullRunnable(InputStream inputStream) {
            this.m_in = inputStream;
        }

        @Override
        public void run() {
            try {
                try {
                    while (this.m_in.read() != -1) {
                    }
                }
                finally {
                    this.m_in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static class EntriesEnumeration
    implements Enumeration<String> {
        private final Enumeration m_enumeration;

        public EntriesEnumeration(Enumeration enumeration) {
            this.m_enumeration = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_enumeration.hasMoreElements();
        }

        @Override
        public String nextElement() {
            return ((ZipEntry)this.m_enumeration.nextElement()).getName();
        }
    }
}

