/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleArchiveRevision;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.cache.DirectoryContent;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.WeakZipFileFactory;

class DirectoryRevision
extends BundleArchiveRevision {
    private final WeakZipFileFactory m_zipFactory;
    private final File m_refDir;

    public DirectoryRevision(Logger logger, Map map, WeakZipFileFactory weakZipFileFactory, File file, String string) throws Exception {
        super(logger, map, file, string);
        this.m_zipFactory = weakZipFileFactory;
        this.m_refDir = new File(string.substring(string.indexOf("file:") + "file:".length()));
        if (BundleCache.getSecureAction().fileExists(this.getRevisionRootDir())) {
            return;
        }
        if (!BundleCache.getSecureAction().mkdir(this.getRevisionRootDir())) {
            this.getLogger().log(1, String.valueOf(this.getClass().getName()) + ": Unable to create revision directory.");
            throw new IOException("Unable to create archive directory.");
        }
    }

    @Override
    public synchronized Map getManifestHeader() throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = BundleCache.getSecureAction().getFileInputStream(new File(this.m_refDir, "META-INF/MANIFEST.MF"));
            if (inputStream == null) {
                throw new IOException("No manifest file found.");
            }
            Manifest manifest = new Manifest(inputStream);
            StringMap stringMap = new StringMap((Map<?, ?>)manifest.getMainAttributes());
            return stringMap;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public synchronized Content getContent() throws Exception {
        return new DirectoryContent(this.getLogger(), this.getConfig(), this.m_zipFactory, this, this.getRevisionRootDir(), this.m_refDir);
    }

    @Override
    protected void close() throws Exception {
    }
}

