/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.cache.JarContent;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.WeakZipFileFactory;

public class DirectoryContent
implements Content {
    private static final int BUFSIZE = 4096;
    private static final transient String EMBEDDED_DIRECTORY = "-embedded";
    private static final transient String LIBRARY_DIRECTORY = "-lib";
    private final Logger m_logger;
    private final Map m_configMap;
    private final WeakZipFileFactory m_zipFactory;
    private final Object m_revisionLock;
    private final File m_rootDir;
    private final File m_dir;
    private Map m_nativeLibMap;

    public DirectoryContent(Logger logger, Map map, WeakZipFileFactory weakZipFileFactory, Object object, File file, File file2) {
        this.m_logger = logger;
        this.m_configMap = map;
        this.m_zipFactory = weakZipFileFactory;
        this.m_revisionLock = object;
        this.m_rootDir = file;
        this.m_dir = file2;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasEntry(String string) throws IllegalStateException {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        File file = new File(this.m_dir, string);
        return BundleCache.getSecureAction().fileExists(file) && (!string.endsWith("/") || BundleCache.getSecureAction().isFileDirectory(file));
    }

    @Override
    public Enumeration<String> getEntries() {
        EntriesEnumeration entriesEnumeration = new EntriesEnumeration(this.m_dir);
        return entriesEnumeration.hasMoreElements() ? entriesEnumeration : null;
    }

    /*
     * Loose catch block
     */
    @Override
    public byte[] getEntryAsBytes(String string) throws IllegalStateException {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        inputStream = new BufferedInputStream(BundleCache.getSecureAction().getFileInputStream(new File(this.m_dir, string)));
        byteArrayOutputStream = new ByteArrayOutputStream(4096);
        byte[] byArray = new byte[4096];
        int n = 0;
        while ((n = inputStream.read(byArray, 0, byArray.length)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        try {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        return byArray2;
        catch (Exception exception) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                }
                catch (Exception exception2) {}
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception3) {}
                throw throwable;
            }
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (Exception exception4) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception5) {}
            return null;
        }
    }

    @Override
    public InputStream getEntryAsStream(String string) throws IllegalStateException, IOException {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return BundleCache.getSecureAction().getFileInputStream(new File(this.m_dir, string));
    }

    @Override
    public URL getEntryAsURL(String string) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        try {
            return BundleCache.getSecureAction().toURI(new File(this.m_dir, string)).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Content getEntryAsContent(String string) {
        if (string.equals(".")) {
            return new DirectoryContent(this.m_logger, this.m_configMap, this.m_zipFactory, this.m_revisionLock, this.m_rootDir, this.m_dir);
        }
        string = string.startsWith("/") ? string.substring(1) : string;
        File file = new File(this.m_rootDir, String.valueOf(this.m_dir.getName()) + EMBEDDED_DIRECTORY);
        File file2 = new File(this.m_dir, string);
        if (BundleCache.getSecureAction().isFileDirectory(file2)) {
            return new DirectoryContent(this.m_logger, this.m_configMap, this.m_zipFactory, this.m_revisionLock, this.m_rootDir, file2);
        }
        if (BundleCache.getSecureAction().fileExists(file2) && string.endsWith(".jar")) {
            File file3 = new File(file, string.lastIndexOf(47) >= 0 ? string.substring(0, string.lastIndexOf(47)) : string);
            Object object = this.m_revisionLock;
            synchronized (object) {
                if (!BundleCache.getSecureAction().fileExists(file3) && !BundleCache.getSecureAction().mkdirs(file3)) {
                    this.m_logger.log(1, "Unable to extract embedded directory.");
                }
            }
            return new JarContent(this.m_logger, this.m_configMap, this.m_zipFactory, this.m_revisionLock, file3, file2, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEntryAsNativeLibrary(String string) {
        String string2 = null;
        string = string.startsWith("/") ? string.substring(1) : string;
        File file = new File(this.m_rootDir, String.valueOf(this.m_dir.getName()) + LIBRARY_DIRECTORY);
        File file2 = new File(this.m_dir, string);
        if (BundleCache.getSecureAction().fileExists(file2) && !BundleCache.getSecureAction().isFileDirectory(file2)) {
            Object object = this.m_revisionLock;
            synchronized (object) {
                block25: {
                    Integer n;
                    if (this.m_nativeLibMap == null) {
                        this.m_nativeLibMap = new HashMap();
                    }
                    n = (n = (Integer)this.m_nativeLibMap.get(string)) == null ? new Integer(0) : new Integer(n + 1);
                    this.m_nativeLibMap.put(string, n);
                    File file3 = new File(file, String.valueOf(n.toString()) + File.separatorChar + string);
                    if (!BundleCache.getSecureAction().fileExists(file3)) {
                        if (!BundleCache.getSecureAction().fileExists(file3.getParentFile()) && !BundleCache.getSecureAction().mkdirs(file3.getParentFile())) {
                            this.m_logger.log(1, "Unable to create library directory.");
                        } else {
                            InputStream inputStream = null;
                            try {
                                try {
                                    inputStream = new BufferedInputStream(BundleCache.getSecureAction().getFileInputStream(file2), BundleCache.BUFSIZE);
                                    if (inputStream == null) {
                                        throw new IOException("No input stream: " + string);
                                    }
                                    BundleCache.copyStreamToFile(inputStream, file3);
                                    String string3 = (String)this.m_configMap.get("org.osgi.framework.command.execpermission");
                                    if (string3 != null) {
                                        Properties properties = new Properties();
                                        properties.setProperty("abspath", file3.toString());
                                        string3 = Util.substVars(string3, "command", null, properties);
                                        Process process = BundleCache.getSecureAction().exec(string3);
                                        process.waitFor();
                                    }
                                    string2 = BundleCache.getSecureAction().getAbsolutePath(file3);
                                }
                                catch (Exception exception) {
                                    this.m_logger.log(1, "Extracting native library.", exception);
                                    try {
                                        if (inputStream != null) {
                                            inputStream.close();
                                        }
                                        break block25;
                                    }
                                    catch (IOException iOException) {}
                                    break block25;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                    } else {
                        string2 = BundleCache.getSecureAction().getAbsolutePath(file3);
                    }
                }
            }
        }
        return string2;
    }

    public String toString() {
        return "DIRECTORY " + this.m_dir;
    }

    private static class EntriesEnumeration
    implements Enumeration {
        private final File m_dir;
        private final File[] m_children;
        private int m_counter = 0;

        public EntriesEnumeration(File file) {
            this.m_dir = file;
            this.m_children = this.listFilesRecursive(this.m_dir);
        }

        @Override
        public synchronized boolean hasMoreElements() {
            return this.m_children != null && this.m_counter < this.m_children.length;
        }

        public synchronized Object nextElement() {
            if (this.m_children == null || this.m_counter >= this.m_children.length) {
                throw new NoSuchElementException("No more entry paths.");
            }
            String string = BundleCache.getSecureAction().getAbsolutePath(this.m_children[this.m_counter]).replace(File.separatorChar, '/');
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.delete(0, BundleCache.getSecureAction().getAbsolutePath(this.m_dir).length() + 1);
            if (BundleCache.getSecureAction().isFileDirectory(this.m_children[this.m_counter])) {
                stringBuffer.append('/');
            }
            ++this.m_counter;
            return stringBuffer.toString();
        }

        private File[] listFilesRecursive(File file) {
            File[] fileArray;
            File[] fileArray2 = fileArray = BundleCache.getSecureAction().listDirectory(file);
            int n = 0;
            while (n < fileArray.length) {
                File[] fileArray3;
                if (BundleCache.getSecureAction().isFileDirectory(fileArray[n]) && (fileArray3 = this.listFilesRecursive(fileArray[n])).length > 0) {
                    File[] fileArray4 = new File[fileArray2.length + fileArray3.length];
                    System.arraycopy(fileArray2, 0, fileArray4, 0, fileArray2.length);
                    System.arraycopy(fileArray3, 0, fileArray4, fileArray2.length, fileArray3.length);
                    fileArray2 = fileArray4;
                }
                ++n;
            }
            return fileArray2;
        }
    }
}

