/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.felix.framework.cache.Content;

public class ContentDirectoryContent
implements Content {
    private final Content m_content;
    private final String m_rootPath;

    public ContentDirectoryContent(Content content, String string) {
        this.m_content = content;
        this.m_rootPath = string.length() > 0 && string.charAt(string.length() - 1) != '/' ? String.valueOf(string) + "/" : string;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasEntry(String string) throws IllegalStateException {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return this.m_content.hasEntry(String.valueOf(this.m_rootPath) + string);
    }

    @Override
    public Enumeration<String> getEntries() {
        return new EntriesEnumeration(this.m_content.getEntries(), this.m_rootPath);
    }

    @Override
    public byte[] getEntryAsBytes(String string) throws IllegalStateException {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return this.m_content.getEntryAsBytes(String.valueOf(this.m_rootPath) + string);
    }

    @Override
    public InputStream getEntryAsStream(String string) throws IllegalStateException, IOException {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return this.m_content.getEntryAsStream(String.valueOf(this.m_rootPath) + string);
    }

    @Override
    public URL getEntryAsURL(String string) {
        return this.m_content.getEntryAsURL(String.valueOf(this.m_rootPath) + string);
    }

    @Override
    public Content getEntryAsContent(String string) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return this.m_content.getEntryAsContent(String.valueOf(this.m_rootPath) + string);
    }

    @Override
    public String getEntryAsNativeLibrary(String string) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return this.m_content.getEntryAsNativeLibrary(String.valueOf(this.m_rootPath) + string);
    }

    public String toString() {
        return "CONTENT DIR " + this.m_rootPath + " (" + this.m_content + ")";
    }

    private static class EntriesEnumeration
    implements Enumeration {
        private final Enumeration m_enumeration;
        private final String m_rootPath;
        private String m_nextEntry = null;

        public EntriesEnumeration(Enumeration enumeration, String string) {
            this.m_enumeration = enumeration;
            this.m_rootPath = string;
            this.m_nextEntry = this.findNextEntry();
        }

        @Override
        public synchronized boolean hasMoreElements() {
            return this.m_nextEntry != null;
        }

        public synchronized Object nextElement() {
            if (this.m_nextEntry == null) {
                throw new NoSuchElementException("No more elements.");
            }
            String string = this.m_nextEntry;
            this.m_nextEntry = this.findNextEntry();
            return string;
        }

        private String findNextEntry() {
            while (this.m_enumeration.hasMoreElements()) {
                String string = (String)this.m_enumeration.nextElement();
                if (!string.startsWith(this.m_rootPath) || string.equals(this.m_rootPath)) continue;
                return string.substring(this.m_rootPath.length());
            }
            return null;
        }
    }
}

