/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Map;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleArchive;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.WeakZipFileFactory;

public class BundleCache {
    public static final String CACHE_BUFSIZE_PROP = "felix.cache.bufsize";
    public static final String CACHE_ROOTDIR_PROP = "felix.cache.rootdir";
    public static final String CACHE_LOCKING_PROP = "felix.cache.locking";
    public static final String CACHE_FILELIMIT_PROP = "felix.cache.filelimit";
    public static final String CACHE_SINGLEBUNDLEFILE_PROP = "felix.cache.singlebundlefile";
    protected static transient int BUFSIZE = 4096;
    private static final transient String CACHE_DIR_NAME = ".asaf-cache";
    private static final transient String CACHE_ROOTDIR_DEFAULT = String.valueOf(System.getProperty("user.home")) + File.separator + ".asaf";
    private static final transient String CACHE_LOCK_NAME = "cache.lock";
    static final transient String BUNDLE_DIR_PREFIX = "bundle";
    private static final SecureAction m_secureAction = new SecureAction();
    private final Logger m_logger;
    private final Map m_configMap;
    private final WeakZipFileFactory m_zipFactory;
    private final Object m_lock;

    public BundleCache(Logger logger, Map map) throws Exception {
        this.m_logger = logger;
        this.m_configMap = map;
        int n = 0;
        String string = (String)this.m_configMap.get(CACHE_FILELIMIT_PROP);
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        this.m_zipFactory = new WeakZipFileFactory(n);
        File file = BundleCache.determineCacheDir(this.m_configMap);
        if (!BundleCache.getSecureAction().fileExists(file) && !BundleCache.getSecureAction().mkdirs(file)) {
            this.m_logger.log(1, "Unable to create cache directory: " + file);
            throw new RuntimeException("Unable to create cache directory.");
        }
        Object object = this.m_configMap.get(CACHE_LOCKING_PROP);
        String string2 = object = object == null ? Boolean.TRUE.toString() : object.toString().toLowerCase();
        if (((String)object).equals(Boolean.TRUE.toString())) {
            File file2 = new File(file, CACHE_LOCK_NAME);
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            FileOutputStream fileOutputStream = null;
            try {
                if (!BundleCache.getSecureAction().fileExists(file2)) {
                    fileOutputStream = BundleCache.getSecureAction().getFileOutputStream(file2);
                    abstractInterruptibleChannel = fileOutputStream.getChannel();
                } else {
                    fileOutputStream = BundleCache.getSecureAction().getFileOutputStream(file2);
                    abstractInterruptibleChannel = fileOutputStream.getChannel();
                }
            }
            catch (Exception exception) {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (abstractInterruptibleChannel != null) {
                        abstractInterruptibleChannel.close();
                    }
                }
                catch (Exception exception2) {}
                throw new Exception("Unable to create bundle cache lock file: " + exception);
            }
            try {
                this.m_lock = ((FileChannel)abstractInterruptibleChannel).tryLock();
            }
            catch (Exception exception) {
                throw new Exception("Unable to lock bundle cache: " + exception);
            }
        }
        this.m_lock = null;
    }

    public synchronized void release() {
        if (this.m_lock != null) {
            try {
                ((FileLock)this.m_lock).release();
                ((FileLock)this.m_lock).channel().close();
            }
            catch (Exception exception) {
                this.m_logger.log(2, "Exception releasing bundle cache.", exception);
            }
        }
    }

    static SecureAction getSecureAction() {
        return m_secureAction;
    }

    public synchronized void delete() throws Exception {
        File file = BundleCache.determineCacheDir(this.m_configMap);
        BundleCache.deleteDirectoryTree(file);
    }

    public BundleArchive[] getArchives() throws Exception {
        Object object;
        try {
            object = (String)this.m_configMap.get(CACHE_BUFSIZE_PROP);
            if (object != null) {
                BUFSIZE = Integer.parseInt((String)object);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        object = BundleCache.determineCacheDir(this.m_configMap);
        ArrayList<BundleArchive> arrayList = new ArrayList<BundleArchive>();
        File[] fileArray = BundleCache.getSecureAction().listDirectory((File)object);
        int n = 0;
        while (fileArray != null && n < fileArray.length) {
            if (fileArray[n].getName().startsWith(BUNDLE_DIR_PREFIX) && !fileArray[n].getName().equals(BUNDLE_DIR_PREFIX + Long.toString(0L))) {
                try {
                    arrayList.add(new BundleArchive(this.m_logger, this.m_configMap, this.m_zipFactory, fileArray[n]));
                }
                catch (Exception exception) {
                    this.m_logger.log(1, "Error reloading cached bundle, removing it: " + fileArray[n], exception);
                    BundleCache.deleteDirectoryTree(fileArray[n]);
                }
            }
            ++n;
        }
        return arrayList.toArray(new BundleArchive[arrayList.size()]);
    }

    public BundleArchive create(long l, int n, String string, InputStream inputStream) throws Exception {
        File file = BundleCache.determineCacheDir(this.m_configMap);
        File file2 = new File(file, BUNDLE_DIR_PREFIX + Long.toString(l));
        try {
            BundleArchive bundleArchive = new BundleArchive(this.m_logger, this.m_configMap, this.m_zipFactory, file2, l, n, string, inputStream);
            return bundleArchive;
        }
        catch (Exception exception) {
            if (m_secureAction.fileExists(file2) && !BundleCache.deleteDirectoryTree(file2)) {
                this.m_logger.log(1, "Unable to delete the archive directory: " + file2);
            }
            throw exception;
        }
    }

    public File getSystemBundleDataFile(String string) throws Exception {
        File file = new File(BundleCache.determineCacheDir(this.m_configMap), BUNDLE_DIR_PREFIX + Long.toString(0L));
        if (!BundleCache.getSecureAction().fileExists(file) && !BundleCache.getSecureAction().mkdirs(file)) {
            this.m_logger.log(1, "Unable to create system bundle directory.");
            throw new IOException("Unable to create system bundle directory.");
        }
        if (string.length() > 0 && string.charAt(0) == File.separatorChar) {
            throw new IllegalArgumentException("The data file path must be relative, not absolute.");
        }
        if (string.indexOf("..") >= 0) {
            throw new IllegalArgumentException("The data file path cannot contain a reference to the \"..\" directory.");
        }
        return new File(file, string);
    }

    static void copyStreamToFile(InputStream inputStream, File file) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = BundleCache.getSecureAction().getFileOutputStream(file);
            outputStream = new BufferedOutputStream(outputStream, BUFSIZE);
            byte[] byArray = new byte[BUFSIZE];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    static boolean deleteDirectoryTree(File file) {
        if (!BundleCache.deleteDirectoryTreeRecursive(file)) {
            System.gc();
            System.gc();
            return BundleCache.deleteDirectoryTreeRecursive(file);
        }
        return true;
    }

    private static File determineCacheDir(Map map) {
        File file;
        String string = (String)map.get("org.osgi.framework.storage");
        String string2 = (String)map.get(CACHE_ROOTDIR_PROP);
        String string3 = string2 = string2 == null ? CACHE_ROOTDIR_DEFAULT : string2;
        if (string != null) {
            file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(string2, string);
            }
        } else {
            file = new File(string2, CACHE_DIR_NAME);
        }
        return file;
    }

    private static boolean deleteDirectoryTreeRecursive(File file) {
        File[] fileArray;
        if (!BundleCache.getSecureAction().fileExists(file)) {
            return true;
        }
        if (BundleCache.getSecureAction().isFileDirectory(file) && (fileArray = BundleCache.getSecureAction().listDirectory(file)) != null) {
            int n = 0;
            while (n < fileArray.length) {
                BundleCache.deleteDirectoryTreeRecursive(fileArray[n]);
                ++n;
            }
        }
        return BundleCache.getSecureAction().deleteFile(file);
    }
}

