/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleArchiveRevision;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.DirectoryRevision;
import org.apache.felix.framework.cache.JarRevision;
import org.apache.felix.framework.util.WeakZipFileFactory;

public class BundleArchive {
    public static final transient String FILE_PROTOCOL = "file:";
    public static final transient String REFERENCE_PROTOCOL = "reference:";
    public static final transient String INPUTSTREAM_PROTOCOL = "inputstream:";
    private static final transient String BUNDLE_INFO_FILE = "bundle.info";
    private static final transient String REVISION_LOCATION_FILE = "revision.location";
    private static final transient String REVISION_DIRECTORY = "version";
    private static final transient String DATA_DIRECTORY = "data";
    private final Logger m_logger;
    private final Map m_configMap;
    private final WeakZipFileFactory m_zipFactory;
    private final File m_archiveRootDir;
    private final boolean m_isSingleBundleFile;
    private long m_id = -1L;
    private String m_originalLocation = null;
    private int m_persistentState = -1;
    private int m_startLevel = -1;
    private long m_lastModified = -1L;
    private long m_refreshCount = -1L;
    private final SortedMap<Long, BundleArchiveRevision> m_revisions = new TreeMap<Long, BundleArchiveRevision>();
    private static final transient String BUNDLE_ID_FILE = "bundle.id";
    private static final transient String BUNDLE_LOCATION_FILE = "bundle.location";
    private static final transient String BUNDLE_STATE_FILE = "bundle.state";
    private static final transient String BUNDLE_START_LEVEL_FILE = "bundle.startlevel";
    private static final transient String BUNDLE_LASTMODIFIED_FILE = "bundle.lastmodified";
    private static final transient String REFRESH_COUNTER_FILE = "refresh.counter";
    private static final transient String ACTIVE_STATE = "active";
    private static final transient String STARTING_STATE = "starting";
    private static final transient String INSTALLED_STATE = "installed";
    private static final transient String UNINSTALLED_STATE = "uninstalled";

    public BundleArchive(Logger logger, Map map, WeakZipFileFactory weakZipFileFactory, File file, long l, int n, String string, InputStream inputStream) throws Exception {
        this.m_logger = logger;
        this.m_configMap = map;
        this.m_zipFactory = weakZipFileFactory;
        this.m_archiveRootDir = file;
        this.m_id = l;
        if (this.m_id <= 0L) {
            throw new IllegalArgumentException("Bundle ID cannot be less than or equal to zero.");
        }
        this.m_originalLocation = string;
        this.m_persistentState = 2;
        this.m_startLevel = n;
        this.m_lastModified = System.currentTimeMillis();
        this.m_refreshCount = 0L;
        String string2 = (String)this.m_configMap.get("felix.cache.singlebundlefile");
        this.m_isSingleBundleFile = string2 == null || string2.equalsIgnoreCase("true");
        this.initialize();
        this.reviseInternal(false, new Long(0L), this.m_originalLocation, inputStream);
    }

    public BundleArchive(Logger logger, Map map, WeakZipFileFactory weakZipFileFactory, File file) throws Exception {
        Comparable<File> comparable;
        File[] fileArray;
        this.m_logger = logger;
        this.m_configMap = map;
        this.m_zipFactory = weakZipFileFactory;
        this.m_archiveRootDir = file;
        String string = (String)this.m_configMap.get("felix.cache.singlebundlefile");
        boolean bl = this.m_isSingleBundleFile = string == null || string.equalsIgnoreCase("true");
        if (this.m_isSingleBundleFile) {
            this.readBundleInfo();
        }
        File[] fileArray2 = fileArray = this.m_archiveRootDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            comparable = fileArray2[n2];
            if (((File)comparable).getName().startsWith(REVISION_DIRECTORY) && ((File)comparable).isDirectory() && (n3 = ((File)comparable).getName().lastIndexOf(46)) > 0) {
                Long l = Long.decode(((File)comparable).getName().substring(n3 + 1));
                this.m_revisions.put(l, null);
            }
            ++n2;
        }
        if (this.m_revisions.isEmpty()) {
            throw new Exception("No valid revisions in bundle archive directory: " + file);
        }
        comparable = this.m_revisions.lastKey();
        this.m_revisions.remove(comparable);
        this.reviseInternal(true, (Long)comparable, this.getRevisionLocation((Long)comparable), null);
    }

    public synchronized long getId() throws Exception {
        if (this.m_id <= 0L) {
            this.m_id = this.readId();
        }
        return this.m_id;
    }

    public synchronized String getLocation() throws Exception {
        if (this.m_originalLocation == null) {
            this.m_originalLocation = this.readLocation();
        }
        return this.m_originalLocation;
    }

    public synchronized int getPersistentState() throws Exception {
        if (this.m_persistentState < 0) {
            this.m_persistentState = this.readPersistentState();
        }
        return this.m_persistentState;
    }

    public synchronized void setPersistentState(int n) throws Exception {
        if (this.m_persistentState != n) {
            this.m_persistentState = n;
            if (this.m_isSingleBundleFile) {
                this.writeBundleInfo();
            } else {
                this.writePersistentState();
            }
        }
    }

    public synchronized int getStartLevel() throws Exception {
        if (this.m_startLevel < 0) {
            this.m_startLevel = this.readStartLevel();
        }
        return this.m_startLevel;
    }

    public synchronized void setStartLevel(int n) throws Exception {
        if (this.m_startLevel != n) {
            this.m_startLevel = n;
            if (this.m_isSingleBundleFile) {
                this.writeBundleInfo();
            } else {
                this.writeStartLevel();
            }
        }
    }

    public synchronized long getLastModified() throws Exception {
        if (this.m_lastModified < 0L) {
            this.m_lastModified = this.readLastModified();
        }
        return this.m_lastModified;
    }

    public synchronized void setLastModified(long l) throws Exception {
        if (this.m_lastModified != l) {
            this.m_lastModified = l;
            if (this.m_isSingleBundleFile) {
                this.writeBundleInfo();
            } else {
                this.writeLastModified();
            }
        }
    }

    private long getRefreshCount() throws Exception {
        if (this.m_refreshCount < 0L) {
            this.m_refreshCount = this.readRefreshCount();
        }
        return this.m_refreshCount;
    }

    private void setRefreshCount(long l) throws Exception {
        if (this.m_refreshCount != l) {
            this.m_refreshCount = l;
            if (this.m_isSingleBundleFile) {
                this.writeBundleInfo();
            } else {
                this.writeRefreshCount();
            }
        }
    }

    public synchronized File getDataFile(String string) throws Exception {
        if (string.length() > 0 && string.charAt(0) == File.separatorChar) {
            throw new IllegalArgumentException("The data file path must be relative, not absolute.");
        }
        if (string.indexOf("..") >= 0) {
            throw new IllegalArgumentException("The data file path cannot contain a reference to the \"..\" directory.");
        }
        File file = new File(this.m_archiveRootDir, DATA_DIRECTORY);
        if (!BundleCache.getSecureAction().fileExists(file) && !BundleCache.getSecureAction().mkdir(file)) {
            throw new IOException("Unable to create bundle data directory.");
        }
        return new File(file, string);
    }

    public synchronized Long getCurrentRevisionNumber() {
        return this.m_revisions.isEmpty() ? null : this.m_revisions.lastKey();
    }

    public synchronized BundleArchiveRevision getCurrentRevision() {
        return this.m_revisions.isEmpty() ? null : (BundleArchiveRevision)this.m_revisions.get(this.m_revisions.lastKey());
    }

    public synchronized boolean isRemovalPending() {
        return this.m_revisions.size() > 1;
    }

    public synchronized void revise(String string, InputStream inputStream) throws Exception {
        Long l = this.m_revisions.isEmpty() ? new Long(0L) : new Long(this.m_revisions.lastKey() + 1L);
        this.reviseInternal(false, l, string, inputStream);
    }

    private void reviseInternal(boolean bl, Long l, String string, InputStream inputStream) throws Exception {
        BundleArchiveRevision bundleArchiveRevision;
        if (inputStream != null) {
            string = INPUTSTREAM_PROTOCOL;
        }
        if ((bundleArchiveRevision = this.createRevisionFromLocation(string, inputStream, l)) == null) {
            throw new Exception("Unable to revise archive.");
        }
        if (!bl) {
            this.setRevisionLocation(string, l);
        }
        this.m_revisions.put(l, bundleArchiveRevision);
    }

    public synchronized boolean rollbackRevise() throws Exception {
        if (this.m_revisions.size() <= 1) {
            return false;
        }
        Long l = this.m_revisions.lastKey();
        BundleArchiveRevision bundleArchiveRevision = (BundleArchiveRevision)this.m_revisions.remove(l);
        try {
            bundleArchiveRevision.close();
        }
        catch (Exception exception) {
            this.m_logger.log(1, String.valueOf(this.getClass().getName()) + ": Unable to dispose latest revision", exception);
        }
        File file = new File(this.m_archiveRootDir, REVISION_DIRECTORY + this.getRefreshCount() + "." + l.toString());
        if (BundleCache.getSecureAction().fileExists(file)) {
            BundleCache.deleteDirectoryTree(file);
        }
        return true;
    }

    private synchronized String getRevisionLocation(Long l) throws Exception {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            inputStream = BundleCache.getSecureAction().getFileInputStream(new File(new File(this.m_archiveRootDir, REVISION_DIRECTORY + this.getRefreshCount() + "." + l.toString()), REVISION_LOCATION_FILE));
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            return string;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private synchronized void setRevisionLocation(String string, Long l) throws Exception {
        OutputStream outputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            outputStream = BundleCache.getSecureAction().getFileOutputStream(new File(new File(this.m_archiveRootDir, REVISION_DIRECTORY + this.getRefreshCount() + "." + l.toString()), REVISION_LOCATION_FILE));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            bufferedWriter.write(string, 0, string.length());
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public synchronized void close() {
        for (BundleArchiveRevision bundleArchiveRevision : this.m_revisions.values()) {
            if (bundleArchiveRevision == null) continue;
            try {
                bundleArchiveRevision.close();
            }
            catch (Exception exception) {
                this.m_logger.log(1, "Unable to close revision - " + bundleArchiveRevision.getRevisionRootDir(), exception);
            }
        }
    }

    public synchronized void closeAndDelete() {
        this.close();
        if (!BundleCache.deleteDirectoryTree(this.m_archiveRootDir)) {
            this.m_logger.log(1, "Unable to delete archive directory - " + this.m_archiveRootDir);
        }
    }

    public synchronized void purge() throws Exception {
        Long l = this.getCurrentRevisionNumber();
        boolean bl = this.getCurrentRevision().getManifestHeader().containsKey("Bundle-NativeCode");
        this.close();
        long l2 = this.getRefreshCount();
        for (Long object2 : this.m_revisions.keySet()) {
            if (object2.equals(l)) continue;
            File file = new File(this.m_archiveRootDir, REVISION_DIRECTORY + l2 + "." + object2.toString());
            if (!BundleCache.getSecureAction().fileExists(file)) continue;
            BundleCache.deleteDirectoryTree(file);
        }
        if (bl) {
            this.setRefreshCount(l2 + 1L);
            File file = new File(this.m_archiveRootDir, REVISION_DIRECTORY + (l2 + 1L) + "." + l.toString());
            File file2 = new File(this.m_archiveRootDir, REVISION_DIRECTORY + l2 + "." + l.toString());
            BundleCache.getSecureAction().renameFile(file2, file);
        }
        this.m_revisions.clear();
        BundleArchiveRevision bundleArchiveRevision = this.createRevisionFromLocation(this.getRevisionLocation(l), null, l);
        this.m_revisions.put(l, bundleArchiveRevision);
    }

    private void initialize() throws Exception {
        OutputStream outputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            if (BundleCache.getSecureAction().fileExists(this.m_archiveRootDir)) {
                return;
            }
            if (!BundleCache.getSecureAction().mkdir(this.m_archiveRootDir)) {
                this.m_logger.log(1, String.valueOf(this.getClass().getName()) + ": Unable to create archive directory.");
                throw new IOException("Unable to create archive directory.");
            }
            if (this.m_isSingleBundleFile) {
                this.writeBundleInfo();
            } else {
                this.writeId();
                this.writeLocation();
                this.writePersistentState();
                this.writeStartLevel();
                this.writeLastModified();
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private BundleArchiveRevision createRevisionFromLocation(String string, InputStream inputStream, Long l) throws Exception {
        File file = new File(this.m_archiveRootDir, REVISION_DIRECTORY + this.getRefreshCount() + "." + l.toString());
        BundleArchiveRevision bundleArchiveRevision = null;
        try {
            if (string != null && string.startsWith(REFERENCE_PROTOCOL)) {
                if (!(string = string.substring(REFERENCE_PROTOCOL.length())).startsWith(FILE_PROTOCOL)) {
                    throw new IOException("Reference URLs can only be files: " + string);
                }
                string = BundleArchive.decode(string);
                File file2 = new File(string.substring(FILE_PROTOCOL.length()));
                if (!BundleCache.getSecureAction().fileExists(file2)) {
                    throw new IOException("Referenced file does not exist: " + file2);
                }
                bundleArchiveRevision = BundleCache.getSecureAction().isFileDirectory(file2) ? new DirectoryRevision(this.m_logger, this.m_configMap, this.m_zipFactory, file, string) : new JarRevision(this.m_logger, this.m_configMap, this.m_zipFactory, file, string, true, null);
            } else {
                bundleArchiveRevision = string.startsWith(INPUTSTREAM_PROTOCOL) ? new JarRevision(this.m_logger, this.m_configMap, this.m_zipFactory, file, string, false, inputStream) : new JarRevision(this.m_logger, this.m_configMap, this.m_zipFactory, file, string, false, null);
            }
        }
        catch (Exception exception) {
            if (BundleCache.getSecureAction().fileExists(file) && !BundleCache.deleteDirectoryTree(file)) {
                this.m_logger.log(1, String.valueOf(this.getClass().getName()) + ": Unable to delete revision directory - " + file);
            }
            throw exception;
        }
        return bundleArchiveRevision;
    }

    private static String decode(String string) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '%') {
                byteArrayOutputStream.reset();
                do {
                    if (n + 2 >= string.length()) {
                        throw new IllegalArgumentException("Incomplete % sequence at: " + n);
                    }
                    int n2 = Character.digit(string.charAt(n + 1), 16);
                    int n3 = Character.digit(string.charAt(n + 2), 16);
                    if (n2 == -1 || n3 == -1) {
                        throw new IllegalArgumentException("Invalid % sequence (" + string.substring(n, n + 3) + ") at: " + String.valueOf(n));
                    }
                    byteArrayOutputStream.write((byte)((n2 << 4) + n3));
                } while ((n += 3) < string.length() && string.charAt(n) == '%');
                stringBuffer.append(byteArrayOutputStream.toString("UTF-8"));
                continue;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private void readBundleInfo() throws Exception {
        File file = new File(this.m_archiveRootDir, BUNDLE_INFO_FILE);
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                fileInputStream = BundleCache.getSecureAction().getFileInputStream(file);
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                this.m_id = Long.parseLong(bufferedReader.readLine());
                this.m_originalLocation = bufferedReader.readLine();
                this.m_persistentState = Integer.parseInt(bufferedReader.readLine());
                this.m_startLevel = Integer.parseInt(bufferedReader.readLine());
                this.m_lastModified = Long.parseLong(bufferedReader.readLine());
                this.m_refreshCount = Long.parseLong(bufferedReader.readLine());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.m_id = this.readId();
                this.m_originalLocation = this.readLocation();
                this.m_persistentState = this.readPersistentState();
                this.m_startLevel = this.readStartLevel();
                this.m_lastModified = this.readLastModified();
                this.m_refreshCount = this.readRefreshCount();
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    private void writeBundleInfo() throws Exception {
        OutputStream outputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                outputStream = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_INFO_FILE));
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                String string = Long.toString(this.m_id);
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
                string = this.m_originalLocation == null ? "" : this.m_originalLocation;
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
                string = Integer.toString(this.m_persistentState);
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
                string = Integer.toString(this.m_startLevel);
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
                string = Long.toString(this.m_lastModified);
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
                string = Long.toString(this.m_refreshCount);
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                this.m_logger.log(1, String.valueOf(this.getClass().getName()) + ": Unable to cache bundle info - " + iOException);
                throw iOException;
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private void writeId() throws Exception {
        FileOutputStream fileOutputStream = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_ID_FILE));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        bufferedWriter.write(Long.toString(this.m_id), 0, Long.toString(this.m_id).length());
        bufferedWriter.close();
        ((OutputStream)fileOutputStream).close();
    }

    private long readId() throws Exception {
        long l;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                inputStream = BundleCache.getSecureAction().getFileInputStream(new File(this.m_archiveRootDir, BUNDLE_ID_FILE));
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                l = Long.parseLong(bufferedReader.readLine());
            }
            catch (FileNotFoundException fileNotFoundException) {
                l = Long.parseLong(this.m_archiveRootDir.getName().substring("bundle".length()));
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return l;
    }

    private void writeLocation() throws Exception {
        FileOutputStream fileOutputStream = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_LOCATION_FILE));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        bufferedWriter.write(this.m_originalLocation, 0, this.m_originalLocation.length());
        bufferedWriter.close();
        ((OutputStream)fileOutputStream).close();
    }

    private String readLocation() throws Exception {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            inputStream = BundleCache.getSecureAction().getFileInputStream(new File(this.m_archiveRootDir, BUNDLE_LOCATION_FILE));
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            return string;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void writePersistentState() throws Exception {
        OutputStream outputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                outputStream = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_STATE_FILE));
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                String string = null;
                switch (this.m_persistentState) {
                    case 32: {
                        string = ACTIVE_STATE;
                        break;
                    }
                    case 8: {
                        string = STARTING_STATE;
                        break;
                    }
                    case 1: {
                        string = UNINSTALLED_STATE;
                        break;
                    }
                    default: {
                        string = INSTALLED_STATE;
                    }
                }
                bufferedWriter.write(string, 0, string.length());
            }
            catch (IOException iOException) {
                this.m_logger.log(1, String.valueOf(this.getClass().getName()) + ": Unable to record state - " + iOException);
                throw iOException;
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private int readPersistentState() throws Exception {
        int n;
        block13: {
            n = 2;
            File file = new File(this.m_archiveRootDir, BUNDLE_STATE_FILE);
            if (BundleCache.getSecureAction().fileExists(file)) {
                FileInputStream fileInputStream = null;
                BufferedReader bufferedReader = null;
                try {
                    try {
                        fileInputStream = BundleCache.getSecureAction().getFileInputStream(file);
                        bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                        String string = bufferedReader.readLine();
                        if (string != null && string.equals(ACTIVE_STATE)) {
                            n = 32;
                            break block13;
                        }
                        if (string != null && string.equals(STARTING_STATE)) {
                            n = 8;
                            break block13;
                        }
                        if (string != null && string.equals(UNINSTALLED_STATE)) {
                            n = 1;
                            break block13;
                        }
                        n = 2;
                    }
                    catch (Exception exception) {
                        n = 2;
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (fileInputStream != null) {
                            ((InputStream)fileInputStream).close();
                        }
                    }
                }
                finally {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                }
            }
        }
        return n;
    }

    private void writeStartLevel() throws Exception {
        OutputStream outputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                outputStream = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_START_LEVEL_FILE));
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                String string = Integer.toString(this.m_startLevel);
                bufferedWriter.write(string, 0, string.length());
            }
            catch (IOException iOException) {
                this.m_logger.log(1, String.valueOf(this.getClass().getName()) + ": Unable to record start level - " + iOException);
                throw iOException;
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private int readStartLevel() throws Exception {
        int n = -1;
        File file = new File(this.m_archiveRootDir, BUNDLE_START_LEVEL_FILE);
        if (!BundleCache.getSecureAction().fileExists(file)) {
            n = -1;
        } else {
            FileInputStream fileInputStream = null;
            BufferedReader bufferedReader = null;
            try {
                fileInputStream = BundleCache.getSecureAction().getFileInputStream(file);
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                n = Integer.parseInt(bufferedReader.readLine());
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
        }
        return n;
    }

    private void writeLastModified() throws Exception {
        OutputStream outputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                outputStream = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_LASTMODIFIED_FILE));
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                String string = Long.toString(this.m_lastModified);
                bufferedWriter.write(string, 0, string.length());
            }
            catch (IOException iOException) {
                this.m_logger.log(1, String.valueOf(this.getClass().getName()) + ": Unable to record start level - " + iOException);
                throw iOException;
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private long readLastModified() throws Exception {
        long l = 0L;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                inputStream = BundleCache.getSecureAction().getFileInputStream(new File(this.m_archiveRootDir, BUNDLE_LASTMODIFIED_FILE));
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                l = Long.parseLong(bufferedReader.readLine());
            }
            catch (Exception exception) {
                l = 0L;
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return l;
    }

    private void writeRefreshCount() throws Exception {
        OutputStream outputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                outputStream = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, REFRESH_COUNTER_FILE));
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                String string = Long.toString(this.m_refreshCount);
                bufferedWriter.write(string, 0, string.length());
            }
            catch (IOException iOException) {
                this.m_logger.log(1, String.valueOf(this.getClass().getName()) + ": Unable to write refresh count: " + iOException);
                throw iOException;
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private long readRefreshCount() throws Exception {
        long l = 0L;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                inputStream = BundleCache.getSecureAction().getFileInputStream(new File(this.m_archiveRootDir, REFRESH_COUNTER_FILE));
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                l = Long.parseLong(bufferedReader.readLine());
            }
            catch (Exception exception) {
                l = 0L;
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return l;
    }
}

