/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.util.ImmutableList;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleWiring;

class WovenClassImpl
implements WovenClass,
List<String> {
    private final String m_className;
    private final BundleWiring m_wiring;
    private byte[] m_bytes;
    private List<String> m_imports = new ArrayList<String>();
    private Class m_definedClass = null;
    private boolean m_isComplete = false;
    private int m_state;

    WovenClassImpl(String string, BundleWiring bundleWiring, byte[] byArray) {
        this.m_className = string;
        this.m_wiring = bundleWiring;
        this.m_bytes = byArray;
        this.m_state = 1;
    }

    synchronized void complete(Class clazz, byte[] byArray, List<String> list) {
        this.completeDefine(clazz);
        this.m_bytes = byArray == null ? this.m_bytes : byArray;
        this.completeImports(list);
    }

    synchronized void completeImports(List<String> list) {
        this.m_imports = list == null ? ImmutableList.newInstance(this.m_imports) : ImmutableList.newInstance(list);
    }

    synchronized void completeDefine(Class clazz) {
        this.m_definedClass = clazz;
    }

    @Override
    public synchronized byte[] getBytes() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_wiring.getBundle(), "weave"));
        }
        byte[] byArray = this.m_bytes;
        if (this.m_isComplete) {
            byArray = new byte[this.m_bytes.length];
            System.arraycopy(this.m_bytes, 0, byArray, 0, this.m_bytes.length);
        }
        return byArray;
    }

    @Override
    public synchronized void setBytes(byte[] byArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_wiring.getBundle(), "weave"));
        }
        if (this.m_state >= 2) {
            throw new IllegalStateException("Cannot change bytes after class weaving is completed.");
        }
        this.m_bytes = byArray;
    }

    synchronized List<String> getDynamicImportsInternal() {
        return this.m_imports;
    }

    @Override
    public synchronized List<String> getDynamicImports() {
        return this;
    }

    @Override
    public synchronized boolean isWeavingComplete() {
        return this.m_isComplete;
    }

    @Override
    public String getClassName() {
        return this.m_className;
    }

    @Override
    public ProtectionDomain getProtectionDomain() {
        return ((BundleImpl)this.m_wiring.getRevision().getBundle()).getProtectionDomain();
    }

    @Override
    public synchronized Class<?> getDefinedClass() {
        return this.m_definedClass;
    }

    @Override
    public BundleWiring getBundleWiring() {
        return this.m_wiring;
    }

    @Override
    public synchronized int size() {
        return this.m_imports.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.m_imports.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object object) {
        return this.m_imports.contains(object);
    }

    @Override
    public synchronized Iterator<String> iterator() {
        return this.m_imports.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.m_imports.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] TArray) {
        return this.m_imports.toArray(TArray);
    }

    @Override
    public synchronized boolean add(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_wiring.getBundle(), "weave"));
        }
        if (string != null) {
            try {
                ManifestParser.parseDynamicImportHeader(null, null, string);
            }
            catch (Exception exception) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unable to parse dynamic import.");
                illegalArgumentException.initCause(exception);
                throw illegalArgumentException;
            }
            this.checkImport(string);
            return this.m_imports.add(string);
        }
        return false;
    }

    private void checkImport(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PackagePermission(string, "import"));
        }
    }

    @Override
    public synchronized boolean remove(Object object) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_wiring.getBundle(), "weave"));
        }
        return this.m_imports.remove(object);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> collection) {
        return this.m_imports.containsAll(collection);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends String> collection) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_wiring.getBundle(), "weave"));
        }
        for (String string : collection) {
            try {
                ManifestParser.parseDynamicImportHeader(null, null, string);
            }
            catch (Exception exception) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unable to parse dynamic import.");
                illegalArgumentException.initCause(exception);
                throw illegalArgumentException;
            }
            this.checkImport(string);
        }
        return this.m_imports.addAll(collection);
    }

    @Override
    public synchronized boolean addAll(int n, Collection<? extends String> collection) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_wiring.getBundle(), "weave"));
        }
        for (String string : collection) {
            try {
                ManifestParser.parseDynamicImportHeader(null, null, string);
            }
            catch (Exception exception) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unable to parse dynamic import.");
                illegalArgumentException.initCause(exception);
                throw illegalArgumentException;
            }
            this.checkImport(string);
        }
        return this.m_imports.addAll(n, collection);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_wiring.getBundle(), "weave"));
        }
        return this.m_imports.removeAll(collection);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_wiring.getBundle(), "weave"));
        }
        return this.m_imports.retainAll(collection);
    }

    @Override
    public synchronized void clear() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_wiring.getBundle(), "weave"));
        }
        this.m_imports.clear();
    }

    @Override
    public synchronized String get(int n) {
        return this.m_imports.get(n);
    }

    @Override
    public synchronized String set(int n, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_wiring.getBundle(), "weave"));
        }
        try {
            ManifestParser.parseDynamicImportHeader(null, null, string);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unable to parse dynamic import.");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        this.checkImport(string);
        return this.m_imports.set(n, string);
    }

    @Override
    public synchronized void add(int n, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_wiring.getBundle(), "weave"));
        }
        try {
            ManifestParser.parseDynamicImportHeader(null, null, string);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unable to parse dynamic import.");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        this.checkImport(string);
        this.m_imports.add(n, string);
    }

    @Override
    public synchronized String remove(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this.m_wiring.getBundle(), "weave"));
        }
        return this.m_imports.remove(n);
    }

    @Override
    public synchronized int indexOf(Object object) {
        return this.m_imports.indexOf(object);
    }

    @Override
    public synchronized int lastIndexOf(Object object) {
        return this.m_imports.lastIndexOf(object);
    }

    @Override
    public synchronized ListIterator<String> listIterator() {
        return this.m_imports.listIterator();
    }

    @Override
    public synchronized ListIterator<String> listIterator(int n) {
        return this.m_imports.listIterator(n);
    }

    @Override
    public synchronized List<String> subList(int n, int n2) {
        return this.m_imports.subList(n, n2);
    }

    byte[] _getBytes() {
        byte[] byArray = this.m_bytes;
        if (this.m_isComplete) {
            byArray = new byte[this.m_bytes.length];
            System.arraycopy(this.m_bytes, 0, byArray, 0, this.m_bytes.length);
        }
        return byArray;
    }

    @Override
    public synchronized int getState() {
        return this.m_state;
    }

    public synchronized void setState(int n) {
        if (!(this.m_isComplete || n != 4 && n != 16 && n != 8)) {
            this.m_isComplete = true;
            if (n == 4 || n == 16) {
                BundleProtectionDomain bundleProtectionDomain = (BundleProtectionDomain)((BundleRevisionImpl)this.m_wiring.getRevision()).getProtectionDomain();
                for (String string : this.m_imports) {
                    bundleProtectionDomain.addWoven(string);
                }
            }
        }
        if (n == 2) {
            this.completeImports(null);
        }
        this.m_state = n;
    }
}

