/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.felix.framework.ExtensionManager;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.util.SecureAction;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;

public class URLHandlersStreamHandlerProxy
extends URLStreamHandler
implements URLStreamHandlerSetter,
InvocationHandler {
    private static final Class[] URL_PROXY_CLASS;
    private static final Class[] STRING_TYPES;
    private static final Method EQUALS;
    private static final Method GET_DEFAULT_PORT;
    private static final Method GET_HOST_ADDRESS;
    private static final Method HASH_CODE;
    private static final Method HOSTS_EQUAL;
    private static final Method OPEN_CONNECTION;
    private static final Method OPEN_CONNECTION_PROXY;
    private static final Method SAME_FILE;
    private static final Method TO_EXTERNAL_FORM;
    private final Object m_service;
    private final SecureAction m_action;
    private final URLStreamHandler m_builtIn;
    private final URL m_builtInURL;
    private final String m_protocol;
    private static final ThreadLocal m_loopCheck;

    static {
        STRING_TYPES = new Class[]{String.class};
        SecureAction secureAction = new SecureAction();
        try {
            EQUALS = URLStreamHandler.class.getDeclaredMethod("equals", URL.class, URL.class);
            secureAction.setAccesssible(EQUALS);
            GET_DEFAULT_PORT = URLStreamHandler.class.getDeclaredMethod("getDefaultPort", null);
            secureAction.setAccesssible(GET_DEFAULT_PORT);
            GET_HOST_ADDRESS = URLStreamHandler.class.getDeclaredMethod("getHostAddress", URL.class);
            secureAction.setAccesssible(GET_HOST_ADDRESS);
            HASH_CODE = URLStreamHandler.class.getDeclaredMethod("hashCode", URL.class);
            secureAction.setAccesssible(HASH_CODE);
            HOSTS_EQUAL = URLStreamHandler.class.getDeclaredMethod("hostsEqual", URL.class, URL.class);
            secureAction.setAccesssible(HOSTS_EQUAL);
            OPEN_CONNECTION = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
            secureAction.setAccesssible(OPEN_CONNECTION);
            SAME_FILE = URLStreamHandler.class.getDeclaredMethod("sameFile", URL.class, URL.class);
            secureAction.setAccesssible(SAME_FILE);
            TO_EXTERNAL_FORM = URLStreamHandler.class.getDeclaredMethod("toExternalForm", URL.class);
            secureAction.setAccesssible(TO_EXTERNAL_FORM);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        Method method = null;
        Class[] classArray = null;
        try {
            classArray = new Class[]{URL.class, java.net.Proxy.class};
            method = URLStreamHandler.class.getDeclaredMethod("openConnection", classArray);
            secureAction.setAccesssible(method);
        }
        catch (Throwable throwable) {
            method = null;
            classArray = null;
        }
        OPEN_CONNECTION_PROXY = method;
        URL_PROXY_CLASS = classArray;
        m_loopCheck = new ThreadLocal();
    }

    public URLHandlersStreamHandlerProxy(String string, SecureAction secureAction, URLStreamHandler uRLStreamHandler, URL uRL) {
        this.m_protocol = string;
        this.m_service = null;
        this.m_action = secureAction;
        this.m_builtIn = uRLStreamHandler;
        this.m_builtInURL = uRL;
    }

    private URLHandlersStreamHandlerProxy(Object object, SecureAction secureAction) {
        this.m_protocol = null;
        this.m_service = object;
        this.m_action = secureAction;
        this.m_builtIn = null;
        this.m_builtInURL = null;
    }

    @Override
    protected boolean equals(URL uRL, URL uRL2) {
        Object object = this.getStreamHandlerService();
        if (object == null) {
            throw new IllegalStateException("Unknown protocol: " + uRL.getProtocol());
        }
        if (object instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)object).equals(uRL, uRL2);
        }
        try {
            return (Boolean)EQUALS.invoke(object, uRL, uRL2);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Stream handler unavailable due to: " + exception.getMessage());
        }
    }

    @Override
    protected int getDefaultPort() {
        Object object = this.getStreamHandlerService();
        if (object == null) {
            throw new IllegalStateException("Stream handler unavailable.");
        }
        if (object instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)object).getDefaultPort();
        }
        try {
            return (Integer)GET_DEFAULT_PORT.invoke(object, null);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Stream handler unavailable due to: " + exception.getMessage());
        }
    }

    @Override
    protected InetAddress getHostAddress(URL uRL) {
        Object object = this.getStreamHandlerService();
        if (object == null) {
            throw new IllegalStateException("Unknown protocol: " + uRL.getProtocol());
        }
        if (object instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)object).getHostAddress(uRL);
        }
        try {
            return (InetAddress)GET_HOST_ADDRESS.invoke(object, uRL);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Stream handler unavailable due to: " + exception.getMessage());
        }
    }

    @Override
    protected int hashCode(URL uRL) {
        Object object = this.getStreamHandlerService();
        if (object == null) {
            throw new IllegalStateException("Unknown protocol: " + uRL.getProtocol());
        }
        if (object instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)object).hashCode(uRL);
        }
        try {
            return (Integer)HASH_CODE.invoke(object, uRL);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Stream handler unavailable due to: " + exception.getMessage());
        }
    }

    @Override
    protected boolean hostsEqual(URL uRL, URL uRL2) {
        Object object = this.getStreamHandlerService();
        if (object == null) {
            throw new IllegalStateException("Unknown protocol: " + uRL.getProtocol());
        }
        if (object instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)object).hostsEqual(uRL, uRL2);
        }
        try {
            return (Boolean)HOSTS_EQUAL.invoke(object, uRL, uRL2);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Stream handler unavailable due to: " + exception.getMessage());
        }
    }

    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        Object object = this.getStreamHandlerService();
        if (object == null) {
            throw new MalformedURLException("Unknown protocol: " + uRL.toString());
        }
        if (object instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)object).openConnection(uRL);
        }
        try {
            if ("http".equals(uRL.getProtocol()) && "felix.extensions".equals(uRL.getHost()) && 9 == uRL.getPort()) {
                try {
                    Object object2 = this.m_action.getDeclaredField(ExtensionManager.class, "m_extensionManager", null);
                    if (object2 != null) {
                        return (URLConnection)this.m_action.invoke(this.m_action.getMethod(object2.getClass(), "openConnection", new Class[]{URL.class}), object2, new Object[]{uRL});
                    }
                    throw new IOException("Extensions not supported or ambiguous context.");
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
            return (URLConnection)OPEN_CONNECTION.invoke(object, uRL);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Stream handler unavailable due to: " + exception.getMessage());
        }
    }

    @Override
    protected URLConnection openConnection(URL uRL, java.net.Proxy proxy) throws IOException {
        Object object = this.getStreamHandlerService();
        if (object == null) {
            throw new MalformedURLException("Unknown protocol: " + uRL.toString());
        }
        if (object instanceof URLStreamHandlerService) {
            Method method;
            try {
                method = object.getClass().getMethod("openConnection", URL_PROXY_CLASS);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(noSuchMethodException.getMessage());
                unsupportedOperationException.initCause(noSuchMethodException);
                throw unsupportedOperationException;
            }
            try {
                this.m_action.setAccesssible(method);
                return (URLConnection)method.invoke(object, uRL, proxy);
            }
            catch (Exception exception) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(exception.getMessage());
            }
        }
        try {
            return (URLConnection)OPEN_CONNECTION_PROXY.invoke(object, uRL, proxy);
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IllegalStateException("Stream handler unavailable due to: " + exception.getMessage());
        }
    }

    @Override
    protected void parseURL(URL uRL, String string, int n, int n2) {
        Object object = this.getStreamHandlerService();
        if (object == null) {
            throw new IllegalStateException("Unknown protocol: " + uRL.getProtocol());
        }
        if (object instanceof URLStreamHandlerService) {
            ((URLStreamHandlerService)object).parseURL(this, uRL, string, n, n2);
        } else {
            try {
                URL uRL2 = null;
                if (this.m_builtInURL != null) {
                    if (m_loopCheck.get() != null) {
                        uRL2 = new URL(new URL(this.m_builtInURL, uRL.toExternalForm()), string, (URLStreamHandler)object);
                    } else {
                        m_loopCheck.set(Thread.currentThread());
                        try {
                            uRL2 = new URL(new URL(this.m_builtInURL, uRL.toExternalForm()), string);
                        }
                        finally {
                            m_loopCheck.set(null);
                        }
                    }
                } else {
                    uRL2 = this.m_action.createURL(uRL, string, (URLStreamHandler)object);
                }
                super.setURL(uRL, uRL2.getProtocol(), uRL2.getHost(), uRL2.getPort(), uRL2.getAuthority(), uRL2.getUserInfo(), uRL2.getPath(), uRL2.getQuery(), uRL2.getRef());
            }
            catch (Exception exception) {
                throw new IllegalStateException("Stream handler unavailable due to: " + exception.getMessage());
            }
        }
    }

    @Override
    protected boolean sameFile(URL uRL, URL uRL2) {
        Object object = this.getStreamHandlerService();
        if (object == null) {
            throw new IllegalStateException("Unknown protocol: " + uRL.getProtocol());
        }
        if (object instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)object).sameFile(uRL, uRL2);
        }
        try {
            return (Boolean)SAME_FILE.invoke(object, uRL, uRL2);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Stream handler unavailable due to: " + exception.getMessage());
        }
    }

    @Override
    public void setURL(URL uRL, String string, String string2, int n, String string3, String string4, String string5, String string6, String string7) {
        super.setURL(uRL, string, string2, n, string3, string4, string5, string6, string7);
    }

    @Override
    public void setURL(URL uRL, String string, String string2, int n, String string3, String string4) {
        super.setURL(uRL, string, string2, n, string3, string4);
    }

    @Override
    protected String toExternalForm(URL uRL) {
        return this.toExternalForm(uRL, this.getStreamHandlerService());
    }

    private String toExternalForm(URL uRL, Object object) {
        if (object == null) {
            throw new IllegalStateException("Unknown protocol: " + uRL.getProtocol());
        }
        if (object instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)object).toExternalForm(uRL);
        }
        try {
            try {
                String string = (String)TO_EXTERNAL_FORM.invoke(object, uRL);
                if (string != null && string.equals(String.valueOf(uRL.getProtocol()) + "://null")) {
                    string = String.valueOf(uRL.getProtocol()) + ":";
                }
                return string;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new IllegalStateException("Unknown throwable: " + throwable);
            }
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(uRL.getProtocol());
            stringBuffer.append(':');
            String string = uRL.getAuthority();
            if (string != null && string.length() > 0) {
                stringBuffer.append("//");
                stringBuffer.append(uRL.getAuthority());
            }
            String string2 = uRL.getFile();
            String string3 = uRL.getRef();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (string3 != null) {
                stringBuffer.append('#');
                stringBuffer.append(string3);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Stream handler unavailable due to: " + exception.getMessage());
        }
    }

    private Object getStreamHandlerService() {
        try {
            Object object = URLHandlers.getFrameworkFromContext();
            if (object == null) {
                return this.m_builtIn;
            }
            Object object2 = null;
            object2 = object instanceof Felix ? ((Felix)object).getStreamHandlerService(this.m_protocol) : this.m_action.invoke(this.m_action.getDeclaredMethod(object.getClass(), "getStreamHandlerService", STRING_TYPES), object, new Object[]{this.m_protocol});
            if (object2 == null) {
                return this.m_builtIn;
            }
            if (object2 instanceof URLStreamHandlerService) {
                return (URLStreamHandlerService)object2;
            }
            return (URLStreamHandlerService)Proxy.newProxyInstance(URLStreamHandlerService.class.getClassLoader(), new Class[]{URLStreamHandlerService.class}, (InvocationHandler)new URLHandlersStreamHandlerProxy(object2, this.m_action));
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return this.m_builtIn;
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Class[] classArray = method.getParameterTypes();
        if (this.m_service == null) {
            return this.m_action.invoke(this.m_action.getMethod(this.getClass(), method.getName(), classArray), this, objectArray);
        }
        if ("parseURL".equals(method.getName())) {
            classArray[0] = this.m_service.getClass().getClassLoader().loadClass(URLStreamHandlerSetter.class.getName());
            objectArray[0] = Proxy.newProxyInstance(this.m_service.getClass().getClassLoader(), new Class[]{classArray[0]}, (InvocationHandler)((URLHandlersStreamHandlerProxy)objectArray[0]));
        }
        return this.m_action.invokeDirect(this.m_action.getDeclaredMethod(this.m_service.getClass(), method.getName(), classArray), this.m_service, objectArray);
    }
}

