/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.util.SecureAction;

class URLHandlersContentHandlerProxy
extends ContentHandler {
    private static final Class[] STRING_TYPES = new Class[]{String.class};
    private static final String CONTENT_HANDLER_PACKAGE_PROP = "java.content.handler.pkgs";
    private static final String DEFAULT_CONTENT_HANDLER_PACKAGE = "sun.net.www.content|com.ibm.oti.net.www.content|gnu.java.net.content|org.apache.harmony.luni.internal.net.www.content|COM.newmonics.www.content";
    private static final Map m_builtIn = new HashMap();
    private static final String m_pkgs;
    private final ContentHandlerFactory m_factory;
    private final String m_mimeType;
    private final SecureAction m_action;

    static {
        String string = new SecureAction().getSystemProperty(CONTENT_HANDLER_PACKAGE_PROP, "");
        m_pkgs = string.equals("") ? DEFAULT_CONTENT_HANDLER_PACKAGE : String.valueOf(string) + "|" + DEFAULT_CONTENT_HANDLER_PACKAGE;
    }

    public URLHandlersContentHandlerProxy(String string, SecureAction secureAction, ContentHandlerFactory contentHandlerFactory) {
        this.m_mimeType = string;
        this.m_action = secureAction;
        this.m_factory = contentHandlerFactory;
    }

    @Override
    public Object getContent(URLConnection uRLConnection) throws IOException {
        ContentHandler contentHandler = this.getContentHandlerService();
        if (contentHandler == null) {
            return uRLConnection.getInputStream();
        }
        return contentHandler.getContent(uRLConnection);
    }

    private ContentHandler getContentHandlerService() {
        Object object = URLHandlers.getFrameworkFromContext();
        if (object == null) {
            return this.getBuiltIn();
        }
        try {
            ContentHandler contentHandler = object instanceof Felix ? (ContentHandler)((Felix)object).getContentHandlerService(this.m_mimeType) : (ContentHandler)this.m_action.invoke(this.m_action.getDeclaredMethod(object.getClass(), "getContentHandlerService", STRING_TYPES), object, new Object[]{this.m_mimeType});
            return contentHandler == null ? this.getBuiltIn() : contentHandler;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentHandler getBuiltIn() {
        Object object = m_builtIn;
        synchronized (object) {
            if (m_builtIn.containsKey(this.m_mimeType)) {
                return (ContentHandler)m_builtIn.get(this.m_mimeType);
            }
        }
        if (this.m_factory != null && (object = this.m_factory.createContentHandler(this.m_mimeType)) != null) {
            return this.addToCache(this.m_mimeType, (ContentHandler)object);
        }
        object = this.m_mimeType.replace('.', '_').replace('/', '.').replace('-', '_');
        StringTokenizer stringTokenizer = new StringTokenizer(m_pkgs, "| ");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            String string2 = String.valueOf(string) + "." + (String)object;
            try {
                Class clazz = this.m_action.forName(string2, null);
                if (clazz == null) continue;
                return this.addToCache(this.m_mimeType, (ContentHandler)clazz.newInstance());
            }
            catch (Exception exception) {}
        }
        return this.addToCache(this.m_mimeType, null);
    }

    private synchronized ContentHandler addToCache(String string, ContentHandler contentHandler) {
        if (!m_builtIn.containsKey(string)) {
            m_builtIn.put(string, contentHandler);
            return contentHandler;
        }
        return (ContentHandler)m_builtIn.get(string);
    }
}

