/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWiring;

class URLHandlersBundleURLConnection
extends URLConnection {
    private Felix m_framework;
    private BundleRevision m_targetRevision;
    private int m_classPathIdx = -1;
    private int m_contentLength;
    private long m_contentTime;
    private String m_contentType;
    private InputStream m_is;

    public URLHandlersBundleURLConnection(URL uRL) {
        super(uRL);
    }

    public URLHandlersBundleURLConnection(URL uRL, Felix felix) throws IOException {
        super(uRL);
        Object object;
        String string = uRL.getPath();
        if (string == null || string.length() == 0 || string.equals("/")) {
            throw new IOException("Resource does not exist: " + uRL);
        }
        this.m_framework = felix;
        if (this.m_framework == null && (object = URLHandlers.getFrameworkFromContext()) instanceof Felix) {
            this.m_framework = (Felix)object;
        }
        if (this.m_framework == null) {
            throw new IOException("Unable to find framework for URL: " + uRL);
        }
        long l = Util.getBundleIdFromRevisionId(uRL.getHost());
        Bundle bundle = this.m_framework.getBundle(l);
        if (bundle == null) {
            throw new IOException("No bundle associated with resource: " + uRL);
        }
        this.m_contentTime = bundle.getLastModified();
        BundleRevisions bundleRevisions = bundle.adapt(BundleRevisions.class);
        if (bundleRevisions == null || bundleRevisions.getRevisions().isEmpty()) {
            throw new IOException("Resource does not exist: " + uRL);
        }
        for (BundleRevision bundleReference : bundleRevisions.getRevisions()) {
            if (!((BundleRevisionImpl)bundleReference).getId().equals(uRL.getHost())) continue;
            this.m_targetRevision = bundleReference;
            break;
        }
        if (this.m_targetRevision == null) {
            this.m_targetRevision = bundleRevisions.getRevisions().get(0);
        }
        this.m_classPathIdx = uRL.getPort();
        if (this.m_classPathIdx < 0) {
            this.m_classPathIdx = 0;
        }
        if (!((BundleRevisionImpl)this.m_targetRevision).hasInputStream(this.m_classPathIdx, uRL.getPath())) {
            URL uRL2;
            BundleWiring bundleWiring = this.m_targetRevision.getWiring();
            ClassLoader classLoader = bundleWiring != null ? bundleWiring.getClassLoader() : null;
            URL uRL3 = uRL2 = classLoader != null ? classLoader.getResource(uRL.getPath()) : null;
            if (uRL2 == null) {
                throw new IOException("Resource does not exist: " + uRL);
            }
            this.m_classPathIdx = uRL2.getPort();
        }
    }

    @Override
    public synchronized void connect() throws IOException {
        if (!this.connected) {
            if (this.m_targetRevision == null || this.m_classPathIdx < 0) {
                throw new IOException("Resource does not exist: " + this.url);
            }
            this.m_is = ((BundleRevisionImpl)this.m_targetRevision).getInputStream(this.m_classPathIdx, this.url.getPath());
            this.m_contentLength = this.m_is == null ? 0 : this.m_is.available();
            this.m_contentType = URLConnection.guessContentTypeFromName(this.url.getFile());
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.m_is;
    }

    @Override
    public int getContentLength() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            return -1;
        }
        return this.m_contentLength;
    }

    @Override
    public long getContentLengthLong() {
        return this.getContentLength();
    }

    @Override
    public long getLastModified() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            return 0L;
        }
        if (this.m_contentTime != -1L) {
            return this.m_contentTime;
        }
        return 0L;
    }

    @Override
    public String getContentType() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            return null;
        }
        return this.m_contentType;
    }

    @Override
    public Permission getPermission() {
        return null;
    }

    URL getLocalURL() {
        if (this.m_targetRevision == null || this.m_classPathIdx < 0) {
            return this.url;
        }
        return ((BundleRevisionImpl)this.m_targetRevision).getLocalURL(this.m_classPathIdx, this.url.getPath());
    }
}

