/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.URLHandlersBundleURLConnection;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;

class URLHandlersBundleStreamHandler
extends URLStreamHandler {
    private final Felix m_framework;
    private final SecureAction m_action;

    public URLHandlersBundleStreamHandler(Felix felix) {
        this.m_framework = felix;
        this.m_action = null;
    }

    public URLHandlersBundleStreamHandler(SecureAction secureAction) {
        this.m_framework = null;
        this.m_action = secureAction;
    }

    @Override
    protected synchronized URLConnection openConnection(URL uRL) throws IOException {
        if (!"felix".equals(uRL.getAuthority())) {
            this.checkPermission(uRL);
        }
        if (this.m_framework != null) {
            return new URLHandlersBundleURLConnection(uRL, this.m_framework);
        }
        Object object = URLHandlers.getFrameworkFromContext();
        if (object != null) {
            if (object instanceof Felix) {
                return new URLHandlersBundleURLConnection(uRL, (Felix)object);
            }
            try {
                Class<?> clazz = object.getClass().getClassLoader().loadClass(URLHandlersBundleURLConnection.class.getName());
                Constructor constructor = this.m_action.getConstructor(clazz, new Class[]{URL.class, object.getClass().getClassLoader().loadClass(Felix.class.getName())});
                this.m_action.setAccesssible(constructor);
                return (URLConnection)this.m_action.invoke(constructor, new Object[]{uRL, object});
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        throw new IOException("No framework context found");
    }

    @Override
    protected void parseURL(URL uRL, String string, int n, int n2) {
        super.parseURL(uRL, string, n, n2);
        if (this.checkPermission(uRL)) {
            super.setURL(uRL, uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "felix", uRL.getUserInfo(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
        }
    }

    @Override
    protected String toExternalForm(URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append("://");
        stringBuffer.append(uRL.getHost());
        stringBuffer.append(':');
        stringBuffer.append(uRL.getPort());
        if (uRL.getPath() != null) {
            stringBuffer.append(uRL.getPath());
        }
        if (uRL.getQuery() != null) {
            stringBuffer.append('?');
            stringBuffer.append(uRL.getQuery());
        }
        if (uRL.getRef() != null) {
            stringBuffer.append("#");
            stringBuffer.append(uRL.getRef());
        }
        return stringBuffer.toString();
    }

    @Override
    protected InetAddress getHostAddress(URL uRL) {
        return null;
    }

    private boolean checkPermission(URL uRL) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Object object = this.m_framework;
            if (object == null && !((object = URLHandlers.getFrameworkFromContext()) instanceof Felix)) {
                return false;
            }
            Object object2 = object;
            long l = Util.getBundleIdFromRevisionId(uRL.getHost());
            Bundle bundle = ((Felix)object2).getBundle(l);
            if (bundle != null) {
                securityManager.checkPermission(new AdminPermission(bundle, "resource"));
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

