/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.framework.URLHandlersBundleStreamHandler;
import org.apache.felix.framework.URLHandlersContentHandlerProxy;
import org.apache.felix.framework.URLHandlersStreamHandlerProxy;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.SecurityManagerEx;
import org.osgi.service.url.URLStreamHandlerService;

class URLHandlers
implements URLStreamHandlerFactory,
ContentHandlerFactory {
    private static final Class[] CLASS_TYPE = new Class[]{Class.class};
    private static final Class URLHANDLERS_CLASS = URLHandlers.class;
    private static final SecureAction m_secureAction = new SecureAction();
    private static volatile SecurityManagerEx m_sm = null;
    private static volatile URLHandlers m_handler = null;
    private static final Map m_classloaderToFrameworkLists = new HashMap();
    private static final List m_frameworks = new ArrayList();
    private static int m_counter = 0;
    private static Map m_contentHandlerCache = null;
    private static Map m_streamHandlerCache = null;
    private static URLStreamHandlerFactory m_streamHandlerFactory;
    private static ContentHandlerFactory m_contentHandlerFactory;
    private static final String STREAM_HANDLER_PACKAGE_PROP = "java.protocol.handler.pkgs";
    private static final String DEFAULT_STREAM_HANDLER_PACKAGE = "sun.net.www.protocol|com.ibm.oti.net.www.protocol|gnu.java.net.protocol|wonka.net|com.acunia.wonka.net|org.apache.harmony.luni.internal.net.www.protocol|weblogic.utils|weblogic.net|javax.net.ssl|COM.newmonics.www.protocols";
    private static Object m_rootURLHandlers;
    private static final String m_streamPkgs;
    private static final Map m_builtIn;
    private static final boolean m_loaded;
    private static final Map m_handlerToURL;

    static {
        m_builtIn = new HashMap();
        String string = new SecureAction().getSystemProperty(STREAM_HANDLER_PACKAGE_PROP, "");
        m_streamPkgs = string.equals("") ? DEFAULT_STREAM_HANDLER_PACKAGE : String.valueOf(string) + "|" + DEFAULT_STREAM_HANDLER_PACKAGE;
        m_loaded = URLHandlersStreamHandlerProxy.class != null && URLHandlersContentHandlerProxy.class != null && URLStreamHandlerService.class != null;
        m_handlerToURL = new HashMap();
    }

    private void init(String string, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        try {
            URLStreamHandler uRLStreamHandler = this.getBuiltInStreamHandler(string, uRLStreamHandlerFactory);
            if (uRLStreamHandler != null) {
                URL uRL = new URL(string, null, -1, "", uRLStreamHandler);
                m_handlerToURL.put(uRLStreamHandler, uRL);
            }
        }
        catch (Throwable throwable) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLHandlers() {
        m_sm = new SecurityManagerEx();
        Class<URL> clazz = URL.class;
        synchronized (URL.class) {
            block29: {
                URLStreamHandlerFactory uRLStreamHandlerFactory = null;
                try {
                    uRLStreamHandlerFactory = (URLStreamHandlerFactory)m_secureAction.swapStaticFieldIfNotClass(URL.class, URLStreamHandlerFactory.class, URLHANDLERS_CLASS, "streamHandlerLock");
                }
                catch (Throwable throwable) {}
                this.init("file", uRLStreamHandlerFactory);
                this.init("ftp", uRLStreamHandlerFactory);
                this.init("http", uRLStreamHandlerFactory);
                this.init("https", uRLStreamHandlerFactory);
                try {
                    this.getBuiltInStreamHandler("jar", uRLStreamHandlerFactory);
                }
                catch (Throwable throwable) {}
                if (uRLStreamHandlerFactory != null) {
                    try {
                        URL.setURLStreamHandlerFactory(uRLStreamHandlerFactory);
                    }
                    catch (Throwable throwable) {}
                }
                try {
                    URL.setURLStreamHandlerFactory(this);
                    m_streamHandlerFactory = this;
                    m_rootURLHandlers = this;
                    try {
                        m_secureAction.flush(URL.class, URL.class);
                    }
                    catch (Throwable throwable) {}
                }
                catch (Error error) {
                    try {
                        m_streamHandlerFactory = (URLStreamHandlerFactory)m_secureAction.swapStaticFieldIfNotClass(URL.class, URLStreamHandlerFactory.class, URLHANDLERS_CLASS, "streamHandlerLock");
                        if (m_streamHandlerFactory == null) {
                            throw error;
                        }
                        if (!m_streamHandlerFactory.getClass().getName().equals(URLHANDLERS_CLASS.getName())) {
                            URL.setURLStreamHandlerFactory(this);
                            m_rootURLHandlers = this;
                        }
                        if (URLHANDLERS_CLASS == m_streamHandlerFactory.getClass()) break block29;
                        try {
                            m_secureAction.invoke(m_secureAction.getDeclaredMethod(m_streamHandlerFactory.getClass(), "registerFrameworkListsForContextSearch", new Class[]{ClassLoader.class, List.class}), m_streamHandlerFactory, new Object[]{URLHANDLERS_CLASS.getClassLoader(), m_frameworks});
                            m_rootURLHandlers = m_streamHandlerFactory;
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception.getMessage());
                        }
                    }
                    catch (Exception exception) {
                        throw error;
                    }
                }
            }
            try {
                URLConnection.setContentHandlerFactory(this);
                m_contentHandlerFactory = this;
                try {
                    m_secureAction.flush(URLConnection.class, URLConnection.class);
                }
                catch (Throwable throwable) {}
            }
            catch (Error error) {
                try {
                    m_contentHandlerFactory = (ContentHandlerFactory)m_secureAction.swapStaticFieldIfNotClass(URLConnection.class, ContentHandlerFactory.class, URLHANDLERS_CLASS, null);
                    if (m_contentHandlerFactory == null) {
                        throw error;
                    }
                    if (!m_contentHandlerFactory.getClass().getName().equals(URLHANDLERS_CLASS.getName())) {
                        URLConnection.setContentHandlerFactory(this);
                    }
                }
                catch (Exception exception) {
                    throw error;
                }
            }
            if (m_streamHandlerFactory != this && URLHANDLERS_CLASS.getName().equals(m_streamHandlerFactory.getClass().getName())) {
                m_sm = null;
                m_handlerToURL.clear();
                m_builtIn.clear();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerFrameworkListsForContextSearch(ClassLoader classLoader, List list) {
        Class<URL> clazz = URL.class;
        synchronized (URL.class) {
            Map map = m_classloaderToFrameworkLists;
            synchronized (map) {
                m_classloaderToFrameworkLists.put(classLoader, list);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterFrameworkListsForContextSearch(ClassLoader classLoader) {
        Class<URL> clazz = URL.class;
        synchronized (URL.class) {
            Map map = m_classloaderToFrameworkLists;
            synchronized (map) {
                m_classloaderToFrameworkLists.remove(classLoader);
                if (m_classloaderToFrameworkLists.isEmpty()) {
                    List list = m_frameworks;
                    synchronized (list) {
                        if (m_frameworks.isEmpty()) {
                            try {
                                m_secureAction.swapStaticFieldIfNotClass(URL.class, URLStreamHandlerFactory.class, null, "streamHandlerLock");
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            if (m_streamHandlerFactory.getClass() != URLHANDLERS_CLASS) {
                                URL.setURLStreamHandlerFactory(m_streamHandlerFactory);
                            }
                            try {
                                m_secureAction.swapStaticFieldIfNotClass(URLConnection.class, ContentHandlerFactory.class, null, null);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            if (m_contentHandlerFactory.getClass() != URLHANDLERS_CLASS) {
                                URLConnection.setContentHandlerFactory(m_contentHandlerFactory);
                            }
                        }
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLStreamHandler getBuiltInStreamHandler(String string, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        Object object = m_builtIn;
        synchronized (object) {
            if (m_builtIn.containsKey(string)) {
                return (URLStreamHandler)m_builtIn.get(string);
            }
        }
        if (uRLStreamHandlerFactory != null && (object = uRLStreamHandlerFactory.createURLStreamHandler(string)) != null) {
            return this.addToCache(string, (URLStreamHandler)object);
        }
        object = this.loadBuiltInStreamHandler(string, null);
        if (object == null) {
            object = this.loadBuiltInStreamHandler(string, ClassLoader.getSystemClassLoader());
        }
        return this.addToCache(string, (URLStreamHandler)object);
    }

    private URLStreamHandler loadBuiltInStreamHandler(String string, ClassLoader classLoader) {
        Object object;
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(m_streamPkgs, "| ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            object = String.valueOf(string2) + "." + string + ".Handler";
            try {
                Class clazz = m_secureAction.forName((String)object, classLoader);
                if (clazz == null) continue;
                return (URLStreamHandler)clazz.newInstance();
            }
            catch (Throwable throwable) {}
        }
        string2 = null;
        if ("file".equalsIgnoreCase(string)) {
            string2 = "libcore.net.url.FileHandler";
        } else if ("ftp".equalsIgnoreCase(string)) {
            string2 = "libcore.net.url.FtpHandler";
        } else if ("http".equalsIgnoreCase(string)) {
            string2 = "libcore.net.http.HttpHandler";
        } else if ("https".equalsIgnoreCase(string)) {
            string2 = "libcore.net.http.HttpsHandler";
        } else if ("jar".equalsIgnoreCase(string)) {
            string2 = "libcore.net.url.JarHandler";
        }
        if (string2 != null) {
            try {
                object = m_secureAction.forName(string2, classLoader);
                if (object != null) {
                    return (URLStreamHandler)((Class)object).newInstance();
                }
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    private synchronized URLStreamHandler addToCache(String string, URLStreamHandler uRLStreamHandler) {
        if (!m_builtIn.containsKey(string)) {
            m_builtIn.put(string, uRLStreamHandler);
            return uRLStreamHandler;
        }
        return (URLStreamHandler)m_builtIn.get(string);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String string) {
        URLStreamHandler uRLStreamHandler = this.getFromStreamCache(string);
        if (uRLStreamHandler != null) {
            return uRLStreamHandler;
        }
        if (string.equals("bundle")) {
            return this.addToStreamCache(string, new URLHandlersBundleStreamHandler(m_secureAction));
        }
        uRLStreamHandler = this.getBuiltInStreamHandler(string, m_streamHandlerFactory != this ? m_streamHandlerFactory : null);
        return this.addToStreamCache(string, new URLHandlersStreamHandlerProxy(string, m_secureAction, uRLStreamHandler, (URL)m_handlerToURL.get(uRLStreamHandler)));
    }

    @Override
    public ContentHandler createContentHandler(String string) {
        ContentHandler contentHandler = this.getFromContentCache(string);
        if (contentHandler != null) {
            return contentHandler;
        }
        return this.addToContentCache(string, new URLHandlersContentHandlerProxy(string, m_secureAction, m_contentHandlerFactory != this ? m_contentHandlerFactory : null));
    }

    private synchronized ContentHandler addToContentCache(String string, ContentHandler contentHandler) {
        if (m_contentHandlerCache == null) {
            m_contentHandlerCache = new HashMap();
        }
        return (ContentHandler)this.addToCache(m_contentHandlerCache, string, contentHandler);
    }

    private synchronized ContentHandler getFromContentCache(String string) {
        return m_contentHandlerCache != null ? m_contentHandlerCache.get(string) : null;
    }

    private synchronized URLStreamHandler addToStreamCache(String string, URLStreamHandler uRLStreamHandler) {
        if (m_streamHandlerCache == null) {
            m_streamHandlerCache = new HashMap();
        }
        return (URLStreamHandler)this.addToCache(m_streamHandlerCache, string, uRLStreamHandler);
    }

    private synchronized URLStreamHandler getFromStreamCache(String string) {
        return m_streamHandlerCache != null ? m_streamHandlerCache.get(string) : null;
    }

    private Object addToCache(Map map, String string, Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = map.get(string);
        if (object2 == null) {
            map.put(string, object);
            object2 = object;
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerFrameworkInstance(Object object, boolean bl) {
        boolean bl2 = false;
        Object object2 = m_frameworks;
        synchronized (object2) {
            if (bl) {
                if (m_handler == null) {
                    bl2 = true;
                } else {
                    m_frameworks.add(object);
                    ++m_counter;
                }
            } else {
                ++m_counter;
            }
        }
        if (!bl2) return;
        object2 = URL.class;
        synchronized (URL.class) {
            Map map = m_classloaderToFrameworkLists;
            synchronized (map) {
                List list = m_frameworks;
                synchronized (list) {
                    if (m_handler == null) {
                        m_handler = new URLHandlers();
                    }
                    m_frameworks.add(object);
                    ++m_counter;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unregisterFrameworkInstance(Object object) {
        boolean bl = false;
        Object object2 = m_frameworks;
        synchronized (object2) {
            if (m_frameworks.contains(object)) {
                if (m_frameworks.size() == 1 && m_handler != null) {
                    bl = true;
                } else {
                    m_frameworks.remove(object);
                    --m_counter;
                }
            } else {
                --m_counter;
            }
        }
        if (!bl) return;
        object2 = URL.class;
        synchronized (URL.class) {
            Map map = m_classloaderToFrameworkLists;
            synchronized (map) {
                List list = m_frameworks;
                synchronized (list) {
                    m_frameworks.remove(object);
                    --m_counter;
                    if (!m_frameworks.isEmpty() || m_handler == null) return;
                    m_handler = null;
                    try {
                        m_secureAction.invoke(m_secureAction.getDeclaredMethod(m_rootURLHandlers.getClass(), "unregisterFrameworkListsForContextSearch", new Class[]{ClassLoader.class}), m_rootURLHandlers, new Object[]{URLHANDLERS_CLASS.getClassLoader()});
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFrameworkFromContext() {
        Class[] classArray = m_classloaderToFrameworkLists;
        synchronized (m_classloaderToFrameworkLists) {
            Object object;
            Object object2;
            if (m_classloaderToFrameworkLists.isEmpty()) {
                object2 = m_frameworks;
                synchronized (object2) {
                    if (m_counter == 1 && m_frameworks.size() == 1) {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 18, 19, 5, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return m_frameworks.get(0);
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            classArray = m_sm.getClassContext();
            object2 = null;
            int n = 0;
            while (n < classArray.length) {
                if (classArray[n].getClassLoader() != null && (((String)(object = classArray[n].getClassLoader().getClass().getName())).startsWith("org.apache.felix.framework.ModuleImpl$ModuleClassLoader") || ((String)object).equals("org.apache.felix.framework.searchpolicy.ContentClassLoader") || ((String)object).startsWith("org.apache.felix.framework.BundleWiringImpl$BundleClassLoader"))) {
                    object2 = classArray[n];
                    break;
                }
                ++n;
            }
            if (object2 != null) {
                Map map = m_classloaderToFrameworkLists;
                synchronized (map) {
                    object = ((Class)object2).getClassLoader().getClass().getClassLoader();
                    List list = (List)m_classloaderToFrameworkLists.get(object);
                    if (list == null && object == URLHANDLERS_CLASS.getClassLoader()) {
                        list = m_frameworks;
                    }
                    if (list != null) {
                        List list2 = list;
                        synchronized (list2) {
                            int n2 = 0;
                            while (n2 < list.size()) {
                                Object e = list.get(n2);
                                try {
                                    if (m_secureAction.invoke(m_secureAction.getDeclaredMethod(e.getClass(), "getBundle", CLASS_TYPE), e, new Object[]{object2}) != null) {
                                        return e;
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                ++n2;
                            }
                        }
                    }
                }
            }
            return null;
        }
    }
}

