/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.BundleWiringImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ResolveContextImpl;
import org.apache.felix.framework.ServiceRegistry;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.resolver.CandidateComparator;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.util.ShrinkableCollection;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.NativeLibrary;
import org.apache.felix.framework.wiring.BundleRequirementImpl;
import org.apache.felix.framework.wiring.BundleWireImpl;
import org.apache.felix.resolver.ResolverImpl;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.CapabilityPermission;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.Resolver;

class StatefulResolver {
    private final Logger m_logger;
    private final Felix m_felix;
    private final ServiceRegistry m_registry;
    private final ResolverImpl m_resolver;
    private boolean m_isResolving = false;
    private final Set<BundleRevision> m_revisions;
    private final Set<BundleRevision> m_fragments;
    private final Map<String, CapabilitySet> m_capSets;
    private final Map<String, List<BundleRevision>> m_singletons;
    private final Set<BundleRevision> m_selectedSingletons;
    private final String m_fwkExecEnvStr;
    private final Set<String> m_fwkExecEnvSet;

    StatefulResolver(Felix felix, ServiceRegistry serviceRegistry) {
        this.m_felix = felix;
        this.m_registry = serviceRegistry;
        this.m_logger = this.m_felix.getLogger();
        this.m_resolver = new ResolverImpl(this.m_logger);
        this.m_revisions = new HashSet<BundleRevision>();
        this.m_fragments = new HashSet<BundleRevision>();
        this.m_capSets = new HashMap<String, CapabilitySet>();
        this.m_singletons = new HashMap<String, List<BundleRevision>>();
        this.m_selectedSingletons = new HashSet<BundleRevision>();
        String string = (String)this.m_felix.getConfig().get("org.osgi.framework.executionenvironment");
        this.m_fwkExecEnvStr = string != null ? string.trim() : null;
        this.m_fwkExecEnvSet = StatefulResolver.parseExecutionEnvironments(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("osgi.wiring.bundle");
        this.m_capSets.put("osgi.wiring.bundle", new CapabilitySet(arrayList, true));
        arrayList = new ArrayList();
        arrayList.add("osgi.wiring.package");
        this.m_capSets.put("osgi.wiring.package", new CapabilitySet(arrayList, true));
        arrayList = new ArrayList();
        arrayList.add("osgi.wiring.host");
        this.m_capSets.put("osgi.wiring.host", new CapabilitySet(arrayList, true));
    }

    void start() {
        this.m_registry.registerService(this.m_felix, new String[]{Resolver.class.getName()}, this.m_resolver, null);
    }

    synchronized void addRevision(BundleRevision bundleRevision) {
        this.removeRevision(bundleRevision);
        this.m_revisions.add(bundleRevision);
        boolean bl = Util.isSingleton(bundleRevision);
        if (bl) {
            StatefulResolver.addToSingletonMap(this.m_singletons, bundleRevision);
        }
        if (!bl || bundleRevision.getWiring() != null) {
            if (Util.isFragment(bundleRevision)) {
                this.m_fragments.add(bundleRevision);
            }
            this.indexCapabilities(bundleRevision);
        }
    }

    synchronized void removeRevision(BundleRevision bundleRevision) {
        if (this.m_revisions.remove(bundleRevision)) {
            this.m_fragments.remove(bundleRevision);
            this.deindexCapabilities(bundleRevision);
            List<BundleRevision> list = this.m_singletons.get(bundleRevision.getSymbolicName());
            if (list != null) {
                list.remove(bundleRevision);
                if (list.isEmpty()) {
                    this.m_singletons.remove(bundleRevision.getSymbolicName());
                }
            }
        }
    }

    boolean isEffective(Requirement requirement) {
        String string = requirement.getDirectives().get("effective");
        return string == null || string.equals("resolve");
    }

    synchronized List<BundleCapability> findProviders(BundleRequirement bundleRequirement, boolean bl) {
        ResolverHookRecord resolverHookRecord = new ResolverHookRecord(Collections.<ServiceReference<ResolverHookFactory>, ResolverHook>emptyMap(), null);
        return this.findProvidersInternal(resolverHookRecord, bundleRequirement, bl, true);
    }

    synchronized List<BundleCapability> findProvidersInternal(ResolverHookRecord resolverHookRecord, Requirement requirement, boolean bl, boolean bl2) {
        Object object;
        ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>();
        CapabilitySet capabilitySet = this.m_capSets.get(requirement.getNamespace());
        if (capabilitySet != null) {
            String object2;
            object = requirement instanceof BundleRequirementImpl ? ((BundleRequirementImpl)requirement).getFilter() : ((object2 = requirement.getDirectives().get("filter")) == null ? new SimpleFilter(null, null, 0) : SimpleFilter.parse(object2));
            Set<Capability> set = capabilitySet.match((SimpleFilter)object, bl);
            for (Object object3 : set) {
                if (!(object3 instanceof BundleCapability)) continue;
                BundleCapability bundleCapability = (BundleCapability)object3;
                if (bl2 && this.filteredBySecurity((BundleRequirement)requirement, bundleCapability) || requirement.getNamespace().equals("osgi.wiring.host") && bundleCapability.getRevision().getWiring() != null) continue;
                arrayList.add(bundleCapability);
            }
        }
        if (bl2 && !arrayList.isEmpty() && !resolverHookRecord.getResolverHookRefs().isEmpty()) {
            if (resolverHookRecord.getBundleRevisionWhitelist() != null) {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    if (resolverHookRecord.getBundleRevisionWhitelist().contains(((BundleCapability)object.next()).getRevision())) continue;
                    object.remove();
                }
            }
            object = new ShrinkableCollection<BundleCapability>(arrayList);
            for (ResolverHook resolverHook : resolverHookRecord.getResolverHooks()) {
                try {
                    Felix.m_secureAction.invokeResolverHookMatches(resolverHook, (BundleRequirement)requirement, (Collection<BundleCapability>)object);
                }
                catch (Throwable throwable) {
                    this.m_logger.log(2, "Resolver hook exception.", throwable);
                }
            }
        }
        Collections.sort(arrayList, new CandidateComparator());
        return arrayList;
    }

    private boolean filteredBySecurity(BundleRequirement bundleRequirement, BundleCapability bundleCapability) {
        if (System.getSecurityManager() != null) {
            BundleRevisionImpl bundleRevisionImpl = (BundleRevisionImpl)bundleRequirement.getRevision();
            if (bundleRequirement.getNamespace().equals("osgi.wiring.package") ? (!((BundleProtectionDomain)((BundleRevisionImpl)bundleCapability.getRevision()).getProtectionDomain()).impliesDirect(new PackagePermission((String)bundleCapability.getAttributes().get("osgi.wiring.package"), "exportonly")) || bundleRevisionImpl != null && !((BundleProtectionDomain)bundleRevisionImpl.getProtectionDomain()).impliesDirect(new PackagePermission((String)bundleCapability.getAttributes().get("osgi.wiring.package"), bundleCapability.getRevision().getBundle(), "import"))) && bundleRevisionImpl != bundleCapability.getRevision() : (bundleRequirement.getNamespace().equals("osgi.wiring.bundle") ? !((BundleProtectionDomain)((BundleRevisionImpl)bundleCapability.getRevision()).getProtectionDomain()).impliesDirect(new BundlePermission(bundleCapability.getRevision().getSymbolicName(), "provide")) || bundleRevisionImpl != null && !((BundleProtectionDomain)bundleRevisionImpl.getProtectionDomain()).impliesDirect(new BundlePermission(bundleRevisionImpl.getSymbolicName(), "require")) : (bundleRequirement.getNamespace().equals("osgi.wiring.host") ? !((BundleProtectionDomain)bundleRevisionImpl.getProtectionDomain()).impliesDirect(new BundlePermission(bundleRevisionImpl.getSymbolicName(), "fragment")) || !((BundleProtectionDomain)((BundleRevisionImpl)bundleCapability.getRevision()).getProtectionDomain()).impliesDirect(new BundlePermission(bundleCapability.getRevision().getSymbolicName(), "host")) : !bundleRequirement.getNamespace().equals("osgi.ee") && (!((BundleProtectionDomain)((BundleRevisionImpl)bundleCapability.getRevision()).getProtectionDomain()).impliesDirect(new CapabilityPermission(bundleRequirement.getNamespace(), "provide")) || bundleRevisionImpl != null && !((BundleProtectionDomain)bundleRevisionImpl.getProtectionDomain()).impliesDirect(new CapabilityPermission(bundleRequirement.getNamespace(), bundleCapability.getAttributes(), bundleCapability.getRevision().getBundle(), "require")))))) {
                return true;
            }
        }
        return false;
    }

    void resolve(Set<BundleRevision> hashSet, Set<BundleRevision> hashSet2) throws ResolutionException, BundleException {
        boolean bl = this.m_felix.acquireGlobalLock();
        if (!bl) {
            throw new ResolveException("Unable to acquire global lock for resolve.", null, null);
        }
        if (this.m_isResolving) {
            this.m_felix.releaseGlobalLock();
            throw new IllegalStateException("Nested resolve operations not allowed.");
        }
        this.m_isResolving = true;
        Map<Resource, List<Wire>> map = null;
        try {
            BundleImpl bundleImpl;
            BundleRevision bundleRevision;
            hashSet = hashSet.isEmpty() ? hashSet : new HashSet<BundleRevision>(hashSet);
            hashSet2 = hashSet2.isEmpty() ? hashSet2 : new HashSet<BundleRevision>(hashSet2);
            ResolverHookRecord resolverHookRecord = this.prepareResolverHooks(hashSet, hashSet2);
            this.selectSingletons(resolverHookRecord);
            Object object = hashSet.iterator();
            while (object.hasNext()) {
                bundleRevision = (BundleRevision)object.next();
                bundleImpl = (BundleImpl)bundleRevision.getBundle();
                if (bundleImpl.isExtension()) {
                    object.remove();
                    continue;
                }
                if (!Util.isSingleton(bundleRevision) || this.isSelectedSingleton(bundleRevision)) continue;
                throw new ResolveException("Singleton conflict.", bundleRevision, null);
            }
            object = hashSet2.iterator();
            while (object.hasNext()) {
                bundleRevision = (BundleRevision)object.next();
                bundleImpl = (BundleImpl)bundleRevision.getBundle();
                if (bundleImpl.isExtension()) {
                    object.remove();
                    continue;
                }
                if (!Util.isSingleton(bundleRevision) || this.isSelectedSingleton(bundleRevision)) continue;
                object.remove();
            }
            object = null;
            try {
                map = this.m_resolver.resolve(new ResolveContextImpl(this, this.getWirings(), resolverHookRecord, hashSet, hashSet2, this.getFragments()));
            }
            catch (ResolutionException resolutionException) {
                object = resolutionException;
            }
            this.releaseResolverHooks(resolverHookRecord);
            if (object != null) {
                throw object;
            }
            this.markResolvedRevisions(map);
        }
        finally {
            this.m_isResolving = false;
            this.m_felix.releaseGlobalLock();
        }
        this.fireResolvedEvents(map);
    }

    BundleRevision resolve(BundleRevision bundleRevision, String string) throws ResolutionException, BundleException {
        BundleRevision bundleRevision2 = null;
        if (bundleRevision.getWiring() != null && this.isAllowedDynamicImport(bundleRevision, string)) {
            Map<Resource, List<Wire>> map;
            block16: {
                boolean bl = this.m_felix.acquireGlobalLock();
                if (!bl) {
                    throw new ResolveException("Unable to acquire global lock for resolve.", bundleRevision, null);
                }
                if (this.m_isResolving) {
                    this.m_felix.releaseGlobalLock();
                    throw new IllegalStateException("Nested resolve operations not allowed.");
                }
                this.m_isResolving = true;
                map = null;
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    List list;
                    bundleRevision2 = ((BundleWiringImpl)bundleRevision.getWiring()).getImportedPackageSource(string);
                    if (bundleRevision2 != null) break block16;
                    ResolverHookRecord resolverHookRecord = this.prepareResolverHooks(Collections.singleton(bundleRevision), Collections.EMPTY_SET);
                    this.selectSingletons(resolverHookRecord);
                    ResolutionException resolutionException = null;
                    try {
                        list = Util.getDynamicRequirements(bundleRevision.getWiring().getRequirements(null));
                        object5 = Collections.singletonMap("osgi.wiring.package", string);
                        object4 = new BundleRequirementImpl(bundleRevision, "osgi.wiring.package", Collections.EMPTY_MAP, (Map<String, Object>)object5);
                        object3 = this.findProvidersInternal(resolverHookRecord, (Requirement)object4, false, true);
                        object2 = null;
                        int n = 0;
                        while (object3.size() > 0 && object2 == null && n < list.size()) {
                            object = object3.iterator();
                            while (object2 == null && object.hasNext()) {
                                Capability capability = (Capability)object.next();
                                if (!CapabilitySet.matches(capability, ((BundleRequirementImpl)list.get(n)).getFilter())) continue;
                                object2 = (BundleRequirementImpl)list.get(n);
                            }
                            ++n;
                        }
                        if (object2 != null) {
                            Iterator<BundleCapability> iterator = object3.iterator();
                            while (iterator.hasNext()) {
                                object = iterator.next();
                                if (CapabilitySet.matches((Capability)object, ((BundleRequirementImpl)object2).getFilter())) continue;
                                iterator.remove();
                            }
                        } else {
                            object3.clear();
                        }
                        map = this.m_resolver.resolve(new ResolveContextImpl(this, this.getWirings(), resolverHookRecord, Collections.<BundleRevision>emptyList(), Collections.<BundleRevision>emptyList(), this.getFragments()), bundleRevision, (Requirement)object2, new ArrayList<Capability>((Collection<Capability>)object3));
                    }
                    catch (ResolutionException resolutionException2) {
                        resolutionException = resolutionException2;
                    }
                    this.releaseResolverHooks(resolverHookRecord);
                    if (resolutionException != null) {
                        throw resolutionException;
                    }
                    if (map != null && map.containsKey(bundleRevision)) {
                        list = (List)map.remove(bundleRevision);
                        object5 = (Wire)list.get(0);
                        this.markResolvedRevisions(map);
                        if (object5 != null && object5.getRequirer() instanceof BundleRevision && object5.getRequirement() instanceof BundleRequirement && object5.getProvider() instanceof BundleRevision && object5.getCapability() instanceof BundleCapability) {
                            object4 = (BundleRevision)object5.getRequirer();
                            object3 = (BundleRequirement)object5.getRequirement();
                            object2 = (BundleRevision)object5.getProvider();
                            BundleCapability bundleCapability = (BundleCapability)object5.getCapability();
                            object = new BundleWireImpl((BundleRevision)object4, (BundleRequirement)object3, (BundleRevision)object2, bundleCapability);
                            this.m_felix.getDependencies().addDependent((BundleWire)object);
                            ((BundleWiringImpl)bundleRevision.getWiring()).addDynamicWire((BundleWire)object);
                            this.m_felix.getLogger().log(4, "DYNAMIC WIRE: " + object5);
                            bundleRevision2 = ((BundleWiringImpl)bundleRevision.getWiring()).getImportedPackageSource(string);
                        }
                    }
                }
                finally {
                    this.m_isResolving = false;
                    this.m_felix.releaseGlobalLock();
                }
            }
            this.fireResolvedEvents(map);
        }
        return bundleRevision2;
    }

    private ResolverHookRecord prepareResolverHooks(Set<BundleRevision> set, Set<BundleRevision> set2) throws BundleException, ResolutionException {
        ShrinkableCollection<BundleRevision> shrinkableCollection;
        LinkedHashMap<ServiceReference<ResolverHookFactory>, ResolverHook> linkedHashMap = new LinkedHashMap<ServiceReference<ResolverHookFactory>, ResolverHook>();
        Set<ServiceReference<ResolverHookFactory>> set3 = this.m_felix.getHookRegistry().getHooks(ResolverHookFactory.class);
        if (!set3.isEmpty()) {
            Set<BundleRevision> set4;
            if (!set.isEmpty() && !set2.isEmpty()) {
                set4 = new HashSet<BundleRevision>(set);
                set4.addAll(set2);
            } else {
                set4 = set.isEmpty() ? set2 : set;
            }
            set4 = Collections.unmodifiableSet(set4);
            BundleException bundleException = null;
            for (ServiceReference<ResolverHookFactory> object : set3) {
                try {
                    Iterator exception = this.m_felix.getService(this.m_felix, object, false);
                    if (exception == null || (exception = Felix.m_secureAction.invokeResolverHookFactory((ResolverHookFactory)((Object)exception), set4)) == null) continue;
                    linkedHashMap.put(object, exception);
                }
                catch (Throwable throwable) {
                    bundleException = new BundleException("Resolver hook exception: " + throwable.getMessage(), 12, throwable);
                    break;
                }
            }
            if (bundleException != null) {
                for (ResolverHook resolverHook : linkedHashMap.values()) {
                    try {
                        Felix.m_secureAction.invokeResolverHookEnd(resolverHook);
                    }
                    catch (Exception exception) {
                        bundleException = new BundleException("Resolver hook exception: " + exception.getMessage(), 12, exception);
                    }
                }
                throw bundleException;
            }
            shrinkableCollection = new ShrinkableCollection<BundleRevision>(this.getUnresolvedRevisions());
            int n = shrinkableCollection.size();
            for (Object object : linkedHashMap.values()) {
                try {
                    Felix.m_secureAction.invokeResolverHookResolvable((ResolverHook)object, shrinkableCollection);
                }
                catch (Throwable throwable) {
                    bundleException = new BundleException("Resolver hook exception: " + throwable.getMessage(), 12, throwable);
                    break;
                }
            }
            if (bundleException != null) {
                for (Object object : linkedHashMap.values()) {
                    try {
                        Felix.m_secureAction.invokeResolverHookEnd((ResolverHook)object);
                    }
                    catch (Exception exception) {
                        bundleException = new BundleException("Resolver hook exception: " + exception.getMessage(), 12, exception);
                    }
                }
                throw bundleException;
            }
            if (shrinkableCollection.size() == n) {
                shrinkableCollection = null;
            }
            if (shrinkableCollection != null && (set.isEmpty() || !set2.isEmpty() || set.iterator().next().getWiring() == null)) {
                set.retainAll(shrinkableCollection);
                set2.retainAll(shrinkableCollection);
                if (set.isEmpty() && set2.isEmpty()) {
                    throw new ResolveException("Resolver hook prevented resolution.", null, null);
                }
            }
        } else {
            shrinkableCollection = null;
        }
        return new ResolverHookRecord(linkedHashMap, shrinkableCollection);
    }

    private void releaseResolverHooks(ResolverHookRecord resolverHookRecord) throws BundleException {
        if (!resolverHookRecord.getResolverHookRefs().isEmpty()) {
            for (ResolverHook resolverHook : resolverHookRecord.getResolverHooks()) {
                try {
                    Felix.m_secureAction.invokeResolverHookEnd(resolverHook);
                }
                catch (Throwable throwable) {
                    this.m_logger.log(2, "Resolver hook exception.", throwable);
                }
            }
            boolean bl = false;
            for (ServiceReference<ResolverHookFactory> serviceReference : resolverHookRecord.getResolverHookRefs()) {
                if (serviceReference.getBundle() == null) {
                    bl = true;
                }
                this.m_felix.ungetService(this.m_felix, serviceReference, null);
            }
            if (bl) {
                throw new BundleException("Resolver hook service unregistered during resolve.", 12);
            }
        }
    }

    boolean isAllowedDynamicImport(BundleRevision bundleRevision, String string) {
        Object object;
        if (bundleRevision.getWiring() == null || string.length() == 0) {
            return false;
        }
        List<BundleRequirement> list = Util.getDynamicRequirements(bundleRevision.getWiring().getRequirements(null));
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (BundleCapability object22 : bundleRevision.getWiring().getCapabilities(null)) {
            if (!object22.getNamespace().equals("osgi.wiring.package") || !object22.getAttributes().get("osgi.wiring.package").equals(string)) continue;
            return false;
        }
        if (((BundleWiringImpl)bundleRevision.getWiring()).hasPackageSource(string)) {
            return false;
        }
        Map<String, Object> map = Collections.singletonMap("osgi.wiring.package", string);
        BundleRequirementImpl bundleRequirementImpl = new BundleRequirementImpl(bundleRevision, "osgi.wiring.package", Collections.EMPTY_MAP, map);
        List<BundleCapability> list2 = this.findProviders(bundleRequirementImpl, false);
        BundleRequirementImpl bundleRequirementImpl2 = null;
        int iterator = 0;
        while (list2.size() > 0 && bundleRequirementImpl2 == null && iterator < list.size()) {
            object = list2.iterator();
            while (bundleRequirementImpl2 == null && object.hasNext()) {
                Capability capability = (Capability)object.next();
                if (!CapabilitySet.matches(capability, ((BundleRequirementImpl)list.get(iterator)).getFilter())) continue;
                bundleRequirementImpl2 = (BundleRequirementImpl)list.get(iterator);
            }
            ++iterator;
        }
        if (bundleRequirementImpl2 != null) {
            Iterator<BundleCapability> iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                if (CapabilitySet.matches((Capability)object, bundleRequirementImpl2.getFilter())) continue;
                iterator2.remove();
            }
        } else {
            list2.clear();
        }
        return !list2.isEmpty();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void markResolvedRevisions(Map<Resource, List<Wire>> var1_1) throws ResolveException {
        v0 = var2_2 = this.m_felix.getLogger().getLogLevel() >= 4;
        if (var1_1 != null) {
            var3_3 = new HashMap<Resource, ArrayList<E>>();
            for (Object var4_5 : var1_1.entrySet()) {
                var6_6 = var4_5.getKey();
                var7_7 = (List)var4_5.getValue();
                if (!Util.isFragment((Resource)var6_6)) continue;
                var8_8 = var7_7.iterator();
                while (var8_8.hasNext()) {
                    var9_9 = (Wire)var8_8.next();
                    var10_10 = (ArrayList<BundleRevision>)var3_3.get(var9_9.getProvider());
                    if (var10_10 == null) {
                        var10_10 = new ArrayList<E>();
                        var3_3.put(var9_9.getProvider(), var10_10);
                    }
                    if (!(var9_9.getRequirer() instanceof BundleRevision)) continue;
                    var10_10.add((BundleRevision)var9_9.getRequirer());
                }
            }
            var4_5 = new HashMap<K, V>(var1_1.size());
            for (Map.Entry var5_4 : var1_1.entrySet()) {
                var7_7 = (Resource)var5_4.getKey();
                if (!(var7_7 instanceof BundleRevision)) continue;
                var8_8 = (BundleRevision)var7_7;
                var9_9 = (List)var5_4.getValue();
                var10_10 = new ArrayList<BundleRevision>(var9_9.size());
                if (var8_8.getWiring() != null && Util.isFragment((BundleRevision)var8_8)) {
                    var10_10.addAll(var8_8.getWiring().getRequiredWires(null));
                }
                var11_11 = new HashMap<String, BundleRevision>();
                var12_12 = new HashMap<String, List<BundleRevision>>();
                var14_14 = var9_9.iterator();
                while (var14_14.hasNext()) {
                    var13_13 = (Wire)var14_14.next();
                    if (!(var13_13.getRequirer() instanceof BundleRevision)) continue;
                    var15_16 = (BundleRevision)var13_13.getRequirer();
                    if (!(var13_13.getRequirement() instanceof BundleRequirement)) continue;
                    var16_17 = (BundleRequirement)var13_13.getRequirement();
                    if (!(var13_13.getProvider() instanceof BundleRevision)) continue;
                    var17_18 = (BundleRevision)var13_13.getProvider();
                    if (!(var13_13.getCapability() instanceof BundleCapability)) continue;
                    var18_20 = (BundleCapability)var13_13.getCapability();
                    var19_21 = new BundleWireImpl((BundleRevision)var15_16, var16_17, var17_18, (BundleCapability)var18_20);
                    var10_10.add((BundleRevision)var19_21);
                    if (Util.isFragment((BundleRevision)var8_8)) {
                        if (!var2_2) continue;
                        this.m_felix.getLogger().log(4, "FRAGMENT WIRE: " + var13_13.toString());
                        continue;
                    }
                    if (var2_2) {
                        this.m_felix.getLogger().log(4, "WIRE: " + var13_13.toString());
                    }
                    if (var18_20.getNamespace().equals("osgi.wiring.package")) {
                        var11_11.put((String)var18_20.getAttributes().get("osgi.wiring.package"), var17_18);
                        continue;
                    }
                    if (!var18_20.getNamespace().equals("osgi.wiring.bundle")) continue;
                    var20_22 = StatefulResolver.calculateExportedAndReexportedPackages(var17_18, var1_1, new HashSet<String>(), new HashSet<BundleRevision>());
                    for (String var21_23 : var20_22) {
                        var23_25 = (ArrayList<BundleRevision>)var12_12.get(var21_23);
                        if (var23_25 == null) {
                            var23_25 = new ArrayList<BundleRevision>();
                            var12_12.put(var21_23, var23_25);
                        }
                        var23_25.add(var17_18);
                    }
                }
                var13_13 = (List)var3_3.get(var8_8);
                try {
                    var4_5.put(var8_8, new BundleWiringImpl(this.m_felix.getLogger(), this.m_felix.getConfig(), this, (BundleRevisionImpl)var8_8, (List<BundleRevision>)var13_13, (List<BundleWire>)var10_10, var11_11, var12_12));
                    continue;
                }
                catch (Exception var14_15) {
                    ** for (var15_16 : var4_5.entrySet())
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        ((BundleWiringImpl)var15_16.getValue()).dispose();
                        continue;
                    }
                    catch (Exception var17_19) {
                        var18_20 = new RuntimeException("Unable to clean up resolver failure.", var17_19);
                        this.m_felix.getLogger().log(1, var18_20.getMessage(), var17_19);
                        throw var18_20;
                    }
                }
lbl83:
                // 1 sources

                var15_16 = new ResolveException("Unable to resolve " + var8_8, (BundleRevision)var8_8, null);
                var15_16.initCause(var14_15);
                this.m_felix.getLogger().log(1, var15_16.getMessage(), var14_15);
                throw var15_16;
            }
            for (Map.Entry var5_4 : var4_5.entrySet()) {
                var7_7 = (BundleRevisionImpl)var5_4.getKey();
                var8_8 = (BundleWiring)var5_4.getValue();
                var7_7.resolve((BundleWiringImpl)var5_4.getValue());
                for (Object var9_9 : var8_8.getRequiredWires(null)) {
                    this.m_felix.getDependencies().addDependent((BundleWire)var9_9);
                }
                this.addRevision((BundleRevision)var7_7);
                this.markBundleResolved((BundleRevision)var7_7);
            }
        }
    }

    private void markBundleResolved(BundleRevision bundleRevision) {
        BundleImpl bundleImpl = (BundleImpl)bundleRevision.getBundle();
        try {
            try {
                this.m_felix.acquireBundleLock(bundleImpl, 38);
            }
            catch (IllegalStateException illegalStateException) {}
            if (bundleImpl.adapt(BundleRevision.class) == bundleRevision) {
                if (bundleImpl.getState() != 2) {
                    this.m_felix.getLogger().log(bundleImpl, 2, "Received a resolve event for a bundle that has already been resolved.");
                } else {
                    this.m_felix.setBundleStateAndNotify(bundleImpl, 4);
                }
            }
        }
        finally {
            this.m_felix.releaseBundleLock(bundleImpl);
        }
    }

    private void fireResolvedEvents(Map<Resource, List<Wire>> map) {
        if (map != null) {
            for (Map.Entry<Resource, List<Wire>> entry : map.entrySet()) {
                Resource resource = entry.getKey();
                if (!(resource instanceof BundleRevision)) continue;
                BundleRevision bundleRevision = (BundleRevision)resource;
                List<BundleRevision> list = Util.getFragments(bundleRevision.getWiring());
                int n = 0;
                while (n < list.size()) {
                    this.m_felix.fireBundleEvent(32, list.get(n).getBundle());
                    ++n;
                }
                this.m_felix.fireBundleEvent(32, bundleRevision.getBundle());
            }
        }
    }

    private static Set<String> calculateExportedAndReexportedPackages(BundleRevision bundleRevision, Map<Resource, List<Wire>> map, Set<String> set, Set<BundleRevision> set2) {
        block5: {
            if (set2.contains(bundleRevision)) break block5;
            set2.add(bundleRevision);
            for (BundleCapability object : bundleRevision.getDeclaredCapabilities(null)) {
                if (!object.getNamespace().equals("osgi.wiring.package")) continue;
                set.add((String)object.getAttributes().get("osgi.wiring.package"));
            }
            if (bundleRevision.getWiring() == null) {
                for (Wire wire : map.get(bundleRevision)) {
                    String string;
                    if (!wire.getCapability().getNamespace().equals("osgi.wiring.bundle") || (string = wire.getRequirement().getDirectives().get("visibility")) == null || !string.equals("reexport")) continue;
                    StatefulResolver.calculateExportedAndReexportedPackages((BundleRevision)wire.getProvider(), map, set, set2);
                }
            } else {
                for (BundleWire bundleWire : bundleRevision.getWiring().getRequiredWires(null)) {
                    String string;
                    if (!bundleWire.getCapability().getNamespace().equals("osgi.wiring.bundle") || (string = bundleWire.getRequirement().getDirectives().get("visibility")) == null || !string.equals("reexport")) continue;
                    StatefulResolver.calculateExportedAndReexportedPackages(bundleWire.getProviderWiring().getRevision(), map, set, set2);
                }
            }
        }
        return set;
    }

    private synchronized void indexCapabilities(BundleRevision bundleRevision) {
        List<BundleCapability> list;
        List<BundleCapability> list2 = list = Util.isFragment(bundleRevision) || bundleRevision.getWiring() == null ? bundleRevision.getDeclaredCapabilities(null) : bundleRevision.getWiring().getCapabilities(null);
        if (list != null) {
            for (BundleCapability bundleCapability : list) {
                if (bundleCapability.getRevision() != bundleRevision) continue;
                CapabilitySet capabilitySet = this.m_capSets.get(bundleCapability.getNamespace());
                if (capabilitySet == null) {
                    capabilitySet = new CapabilitySet(null, true);
                    this.m_capSets.put(bundleCapability.getNamespace(), capabilitySet);
                }
                capabilitySet.addCapability(bundleCapability);
            }
        }
    }

    private synchronized void deindexCapabilities(BundleRevision bundleRevision) {
        List<BundleCapability> list = bundleRevision.getDeclaredCapabilities(null);
        if (list != null) {
            for (BundleCapability bundleCapability : list) {
                CapabilitySet capabilitySet = this.m_capSets.get(bundleCapability.getNamespace());
                if (capabilitySet == null) continue;
                capabilitySet.removeCapability(bundleCapability);
            }
        }
    }

    private synchronized boolean isSelectedSingleton(BundleRevision bundleRevision) {
        return this.m_selectedSingletons.contains(bundleRevision);
    }

    private synchronized void selectSingletons(ResolverHookRecord resolverHookRecord) throws BundleException {
        this.m_selectedSingletons.clear();
        for (Map.Entry<String, List<BundleRevision>> entry : this.m_singletons.entrySet()) {
            for (BundleRevision bundleRevision : entry.getValue()) {
                if (bundleRevision.getWiring() != null) continue;
                this.deindexCapabilities(bundleRevision);
                this.m_fragments.remove(bundleRevision);
            }
        }
        if (resolverHookRecord.getResolverHookRefs().isEmpty()) {
            this.selectDefaultSingletons(resolverHookRecord);
        } else {
            this.selectSingletonsUsingHooks(resolverHookRecord);
        }
    }

    private void selectDefaultSingletons(ResolverHookRecord resolverHookRecord) {
        for (Map.Entry<String, List<BundleRevision>> entry : this.m_singletons.entrySet()) {
            this.selectSingleton(resolverHookRecord, entry.getValue());
        }
    }

    private void selectSingletonsUsingHooks(ResolverHookRecord resolverHookRecord) throws BundleException {
        HashMap<BundleCapability, Collection<BundleCapability>> hashMap = new HashMap<BundleCapability, Collection<BundleCapability>>();
        for (Map.Entry<String, List<BundleRevision>> object22 : this.m_singletons.entrySet()) {
            Collection<BundleCapability> collection;
            Map.Entry entry = new ArrayList();
            for (BundleRevision bundleRevision : object22.getValue()) {
                collection = bundleRevision.getDeclaredCapabilities("osgi.wiring.bundle");
                if (collection.isEmpty()) continue;
                entry.add(collection.get(0));
            }
            Iterator<BundleRevision> iterator = entry.iterator();
            while (iterator.hasNext()) {
                BundleCapability bundleCapability = (BundleCapability)((Object)iterator.next());
                collection = new ShrinkableCollection(new ArrayList(entry));
                collection.remove(bundleCapability);
                hashMap.put(bundleCapability, collection);
            }
        }
        for (ResolverHook resolverHook : resolverHookRecord.getResolverHooks()) {
            for (Map.Entry entry : hashMap.entrySet()) {
                try {
                    Felix.m_secureAction.invokeResolverHookSingleton(resolverHook, (BundleCapability)entry.getKey(), (Collection)entry.getValue());
                }
                catch (Throwable throwable) {
                    throw new BundleException("Resolver hook exception: " + throwable.getMessage(), 12, throwable);
                }
            }
        }
        ArrayList<List<BundleRevision>> arrayList = new ArrayList<List<BundleRevision>>();
        while (!hashMap.isEmpty()) {
            Object object = (BundleCapability)hashMap.entrySet().iterator().next().getKey();
            arrayList.add(this.groupSingletons(hashMap, (BundleCapability)object, new ArrayList<BundleRevision>()));
        }
        for (Object object : arrayList) {
            this.selectSingleton(resolverHookRecord, (List<BundleRevision>)object);
        }
    }

    private List<BundleRevision> groupSingletons(Map<BundleCapability, Collection<BundleCapability>> map, BundleCapability bundleCapability, List<BundleRevision> list) {
        if (!list.contains(bundleCapability.getRevision())) {
            boolean bl;
            list.add(bundleCapability.getRevision());
            Collection<BundleCapability> collection = map.remove(bundleCapability);
            for (BundleCapability bundleCapability2 : collection) {
                this.groupSingletons(map, bundleCapability2, list);
            }
            block1: do {
                bl = false;
                for (Map.Entry<BundleCapability, Collection<BundleCapability>> entry : map.entrySet()) {
                    if (!((Collection)entry.getValue()).contains(bundleCapability)) continue;
                    bl = true;
                    this.groupSingletons(map, (BundleCapability)entry.getKey(), list);
                    continue block1;
                }
            } while (bl);
        }
        return list;
    }

    private void selectSingleton(ResolverHookRecord resolverHookRecord, List<BundleRevision> list) {
        BundleRevision bundleRevision = null;
        for (BundleRevision bundleRevision2 : list) {
            if (bundleRevision2.getWiring() != null) {
                bundleRevision = null;
                break;
            }
            if (resolverHookRecord.getBundleRevisionWhitelist() != null && !resolverHookRecord.getBundleRevisionWhitelist().contains(bundleRevision2) || bundleRevision != null && bundleRevision.getVersion().compareTo(bundleRevision2.getVersion()) <= 0) continue;
            bundleRevision = bundleRevision2;
        }
        if (bundleRevision != null) {
            this.m_selectedSingletons.add(bundleRevision);
            this.indexCapabilities(bundleRevision);
            if (Util.isFragment(bundleRevision)) {
                this.m_fragments.add(bundleRevision);
            }
        }
    }

    private synchronized Set<BundleRevision> getFragments() {
        HashSet<BundleRevision> hashSet = new HashSet<BundleRevision>(this.m_fragments);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            BundleRevision bundleRevision;
            BundleRevision bundleRevision2 = (BundleRevision)iterator.next();
            if (bundleRevision2 == (bundleRevision = bundleRevision2.getBundle().adapt(BundleRevision.class))) continue;
            iterator.remove();
        }
        return hashSet;
    }

    void checkNativeLibraries(BundleRevision bundleRevision) throws ResolveException {
        List<NativeLibrary> list = ((BundleRevisionImpl)bundleRevision).getDeclaredNativeLibraries();
        if (list != null) {
            String string = null;
            int n = 0;
            while (string == null && n < list.size()) {
                String string2 = list.get(n).getEntryName();
                if (string2 != null && !((BundleRevisionImpl)bundleRevision).getContent().hasEntry(string2)) {
                    string = "Native library does not exist: " + string2;
                }
                ++n;
            }
            if (list.isEmpty()) {
                string = "No matching native libraries found.";
            }
            if (string != null) {
                throw new ResolveException(string, bundleRevision, null);
            }
        }
    }

    private synchronized Set<BundleRevision> getUnresolvedRevisions() {
        HashSet<BundleRevision> hashSet = new HashSet<BundleRevision>();
        for (BundleRevision bundleRevision : this.m_revisions) {
            if (bundleRevision.getWiring() != null) continue;
            hashSet.add(bundleRevision);
        }
        return hashSet;
    }

    private synchronized Map<Resource, Wiring> getWirings() {
        HashMap<Resource, Wiring> hashMap = new HashMap<Resource, Wiring>();
        for (BundleRevision bundleRevision : this.m_revisions) {
            if (bundleRevision.getWiring() == null) continue;
            hashMap.put(bundleRevision, bundleRevision.getWiring());
        }
        return hashMap;
    }

    private static Set<String> parseExecutionEnvironments(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken().trim());
            }
        }
        return hashSet;
    }

    private static void addToSingletonMap(Map<String, List<BundleRevision>> map, BundleRevision bundleRevision) {
        List<BundleRevision> list = map.get(bundleRevision.getSymbolicName());
        if (list == null) {
            list = new ArrayList<BundleRevision>();
        }
        list.add(bundleRevision);
        map.put(bundleRevision.getSymbolicName(), list);
    }

    static class ResolverHookRecord {
        final Map<ServiceReference<ResolverHookFactory>, ResolverHook> m_resolveHookMap;
        final Collection<BundleRevision> m_brWhitelist;

        ResolverHookRecord(Map<ServiceReference<ResolverHookFactory>, ResolverHook> map, Collection<BundleRevision> collection) {
            this.m_resolveHookMap = map;
            this.m_brWhitelist = collection;
        }

        Collection<BundleRevision> getBundleRevisionWhitelist() {
            return this.m_brWhitelist;
        }

        Set<ServiceReference<ResolverHookFactory>> getResolverHookRefs() {
            return this.m_resolveHookMap.keySet();
        }

        Iterable<ResolverHook> getResolverHooks() {
            return new Iterable<ResolverHook>(){

                @Override
                public Iterator<ResolverHook> iterator() {
                    return new Iterator<ResolverHook>(){
                        private Iterator<Map.Entry<ServiceReference<ResolverHookFactory>, ResolverHook>> it;
                        private Map.Entry<ServiceReference<ResolverHookFactory>, ResolverHook> next;
                        {
                            this.it = (this).ResolverHookRecord.this.m_resolveHookMap.entrySet().iterator();
                            this.next = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.next == null) {
                                this.findNext();
                            }
                            return this.next != null;
                        }

                        @Override
                        public ResolverHook next() {
                            if (this.next == null) {
                                this.findNext();
                            }
                            if (this.next == null) {
                                throw new NoSuchElementException();
                            }
                            ResolverHook resolverHook = this.next.getValue();
                            this.next = null;
                            return resolverHook;
                        }

                        private void findNext() {
                            while (this.it.hasNext()) {
                                this.next = this.it.next();
                                if (this.next.getKey().getBundle() != null) {
                                    return;
                                }
                                this.next = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
    }
}

