/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.framework.HookRegistry;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ServiceRegistrationImpl;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.wiring.BundleCapabilityImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.resource.Capability;

public class ServiceRegistry {
    private final Logger m_logger;
    private final AtomicLong m_currentServiceId = new AtomicLong(1L);
    private final ConcurrentMap<Bundle, List<ServiceRegistration<?>>> m_regsMap = new ConcurrentHashMap();
    private final CapabilitySet m_regCapSet = new CapabilitySet(Collections.singletonList("objectClass"), false);
    private final ConcurrentMap<Bundle, UsageCount[]> m_inUseMap = new ConcurrentHashMap<Bundle, UsageCount[]>();
    private final ServiceRegistryCallbacks m_callbacks;
    private final HookRegistry hookRegistry = new HookRegistry();

    public ServiceRegistry(Logger logger, ServiceRegistryCallbacks serviceRegistryCallbacks) {
        this.m_logger = logger;
        this.m_callbacks = serviceRegistryCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference<?>[] getRegisteredServices(Bundle bundle) {
        List list = (List)this.m_regsMap.get(bundle);
        if (list != null) {
            ArrayList arrayList = new ArrayList(list.size());
            List list2 = list;
            synchronized (list2) {
                for (ServiceRegistration serviceRegistration : list) {
                    try {
                        arrayList.add(serviceRegistration.getReference());
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            return arrayList.toArray(new ServiceReference[arrayList.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration<?> registerService(Bundle bundle, String[] stringArray, Object object, Dictionary<?, ?> dictionary) {
        ServiceRegistrationImpl serviceRegistrationImpl = new ServiceRegistrationImpl(this, bundle, stringArray, this.m_currentServiceId.getAndIncrement(), object, dictionary);
        this.hookRegistry.addHooks(stringArray, object, serviceRegistrationImpl.getReference());
        ArrayList<ServiceRegistrationImpl> arrayList = new ArrayList<ServiceRegistrationImpl>();
        ArrayList<ServiceRegistrationImpl> arrayList2 = this.m_regsMap.putIfAbsent(bundle, arrayList);
        if (arrayList2 == null) {
            arrayList2 = arrayList;
        }
        ArrayList<ServiceRegistrationImpl> arrayList3 = arrayList2;
        synchronized (arrayList3) {
            arrayList2.add(serviceRegistrationImpl);
        }
        this.m_regCapSet.addCapability((BundleCapabilityImpl)((Object)serviceRegistrationImpl.getReference()));
        return serviceRegistrationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(Bundle bundle, ServiceRegistration<?> serviceRegistration) {
        Object object;
        this.hookRegistry.removeHooks(serviceRegistration.getReference());
        List list = (List)this.m_regsMap.get(bundle);
        if (list != null) {
            object = list;
            synchronized (object) {
                list.remove(serviceRegistration);
            }
        }
        this.m_regCapSet.removeCapability((BundleCapabilityImpl)((Object)serviceRegistration.getReference()));
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(4, serviceRegistration.getReference()), null);
        }
        object = serviceRegistration.getReference();
        this.ungetServices((ServiceReference<?>)object);
        ((ServiceRegistrationImpl)serviceRegistration).invalidate();
        this.ungetServices((ServiceReference<?>)object);
    }

    private void ungetServices(ServiceReference<?> serviceReference) {
        Bundle[] bundleArray = this.getUsingBundles(serviceReference);
        int n = 0;
        while (bundleArray != null && n < bundleArray.length) {
            UsageCount[] usageCountArray = (UsageCount[])this.m_inUseMap.get(bundleArray[n]);
            int n2 = 0;
            while (usageCountArray != null && n2 < usageCountArray.length) {
                if (usageCountArray[n2].m_ref.equals(serviceReference)) {
                    this.ungetService(bundleArray[n], serviceReference, usageCountArray[n2].m_prototype ? usageCountArray[n2].getService() : null);
                }
                ++n2;
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServices(Bundle bundle) {
        List list = (List)this.m_regsMap.remove(bundle);
        if (list != null) {
            ArrayList arrayList;
            Object object2 = list;
            synchronized (object2) {
                arrayList = new ArrayList(list);
            }
            for (Object object2 : arrayList) {
                if (!((ServiceRegistrationImpl)object2).isValid()) continue;
                try {
                    object2.unregister();
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }

    public Collection<Capability> getServiceReferences(String string, SimpleFilter simpleFilter) {
        if (string == null && simpleFilter == null) {
            simpleFilter = new SimpleFilter(null, null, 0);
        } else if (string != null && simpleFilter == null) {
            simpleFilter = new SimpleFilter("objectClass", string, 4);
        } else if (string != null && simpleFilter != null) {
            ArrayList<SimpleFilter> arrayList = new ArrayList<SimpleFilter>(2);
            arrayList.add(new SimpleFilter("objectClass", string, 4));
            arrayList.add(simpleFilter);
            simpleFilter = new SimpleFilter(null, arrayList, 1);
        }
        return this.m_regCapSet.match(simpleFilter, false);
    }

    public ServiceReference<?>[] getServicesInUse(Bundle bundle) {
        UsageCount[] usageCountArray = (UsageCount[])this.m_inUseMap.get(bundle);
        if (usageCountArray != null) {
            ServiceReference[] serviceReferenceArray = new ServiceReference[usageCountArray.length];
            int n = 0;
            while (n < serviceReferenceArray.length) {
                serviceReferenceArray[n] = usageCountArray[n].m_ref;
                ++n;
            }
            return serviceReferenceArray;
        }
        return null;
    }

    public <S> S getService(Bundle bundle, ServiceReference<S> serviceReference, boolean bl) {
        ServiceRegistrationImpl serviceRegistrationImpl;
        Object object;
        UsageCount usageCount;
        block14: {
            boolean bl2 = bl && serviceReference.getProperty("service.scope") == "prototype";
            usageCount = null;
            object = null;
            serviceRegistrationImpl = ((ServiceRegistrationImpl.ServiceReferenceImpl)serviceReference).getRegistration();
            if (serviceRegistrationImpl.currentThreadMarked()) {
                throw new ServiceException("ServiceFactory.getService() resulted in a cycle.", 2, null);
            }
            try {
                serviceRegistrationImpl.markCurrentThread();
                if (!serviceRegistrationImpl.isValid()) break block14;
                usageCount = this.obtainUsageCount(bundle, serviceReference, null, bl2);
                this.incrementToPositiveValue(usageCount.m_count);
                object = usageCount.getService();
                if (bl) {
                    this.incrementToPositiveValue(usageCount.m_serviceObjectsCount);
                }
                if (usageCount == null) break block14;
                ServiceHolder serviceHolder = null;
                while (serviceHolder == null) {
                    ServiceHolder serviceHolder2 = new ServiceHolder();
                    if (usageCount.m_svcHolderRef.compareAndSet(null, serviceHolder2)) {
                        serviceHolder = serviceHolder2;
                        try {
                            serviceHolder.m_service = object = serviceRegistrationImpl.getService(bundle);
                        }
                        finally {
                            serviceHolder.m_latch.countDown();
                        }
                    }
                    serviceHolder = usageCount.m_svcHolderRef.get();
                    if (serviceHolder != null) {
                        try {
                            serviceHolder.m_latch.await();
                        }
                        catch (InterruptedException interruptedException) {
                            throw new RuntimeException(interruptedException);
                        }
                        object = serviceHolder.m_service;
                    }
                    if (serviceHolder == usageCount.m_svcHolderRef.get()) continue;
                    serviceHolder = null;
                }
            }
            catch (Throwable throwable) {
                serviceRegistrationImpl.unmarkCurrentThread();
                if (!serviceRegistrationImpl.isValid() || object == null) {
                    this.flushUsageCount(bundle, serviceReference, usageCount);
                }
                throw throwable;
            }
        }
        serviceRegistrationImpl.unmarkCurrentThread();
        if (!serviceRegistrationImpl.isValid() || object == null) {
            this.flushUsageCount(bundle, serviceReference, usageCount);
        }
        return (S)object;
    }

    private void incrementToPositiveValue(AtomicLong atomicLong) {
        boolean bl = false;
        while (!bl) {
            long l = atomicLong.get();
            long l2 = Math.max(l + 1L, 1L);
            this.checkCountOverflow(l2);
            bl = atomicLong.compareAndSet(l, l2);
        }
    }

    private void checkCountOverflow(long l) {
        if (l == Long.MAX_VALUE) {
            throw new ServiceException("The use count for the service overflowed.", 0, null);
        }
    }

    public boolean ungetService(Bundle bundle, ServiceReference<?> serviceReference, Object object) {
        ServiceRegistrationImpl serviceRegistrationImpl = ((ServiceRegistrationImpl.ServiceReferenceImpl)serviceReference).getRegistration();
        if (serviceRegistrationImpl.currentThreadMarked()) {
            throw new IllegalStateException("ServiceFactory.ungetService() resulted in a cycle.");
        }
        try {
            serviceRegistrationImpl.markCurrentThread();
            UsageCount usageCount = this.obtainUsageCount(bundle, serviceReference, object, null);
            if (usageCount == null) {
                return false;
            }
            if (object != null && usageCount.m_serviceObjectsCount.decrementAndGet() < 0L) {
                return false;
            }
            long l = usageCount.m_count.decrementAndGet();
            try {
                boolean bl;
                if (l <= 0L) {
                    Object object2;
                    ServiceHolder serviceHolder = usageCount.m_svcHolderRef.get();
                    Object object3 = object2 = serviceHolder != null ? serviceHolder.m_service : null;
                    if (object2 != null && usageCount.m_count.get() <= 0L && usageCount.m_svcHolderRef.compareAndSet(serviceHolder, null)) {
                        ((ServiceRegistrationImpl.ServiceReferenceImpl)serviceReference).getRegistration().ungetService(bundle, object2);
                    }
                }
                boolean bl2 = bl = l >= 0L;
                if (!serviceRegistrationImpl.isValid()) {
                    usageCount.m_svcHolderRef.set(null);
                }
                if (!serviceRegistrationImpl.isValid() || l <= 0L && object != null) {
                    this.flushUsageCount(bundle, serviceReference, usageCount);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (!serviceRegistrationImpl.isValid()) {
                    usageCount.m_svcHolderRef.set(null);
                }
                if (!serviceRegistrationImpl.isValid() || l <= 0L && object != null) {
                    this.flushUsageCount(bundle, serviceReference, usageCount);
                }
                throw throwable;
            }
        }
        finally {
            serviceRegistrationImpl.unmarkCurrentThread();
        }
    }

    public void ungetServices(Bundle bundle) {
        UsageCount[] usageCountArray = (UsageCount[])this.m_inUseMap.get(bundle);
        if (usageCountArray == null) {
            return;
        }
        int n = 0;
        while (n < usageCountArray.length) {
            if (usageCountArray[n].m_svcHolderRef.get() != null) {
                while (this.ungetService(bundle, usageCountArray[n].m_ref, usageCountArray[n].m_prototype ? usageCountArray[n].getService() : null)) {
                }
            }
            ++n;
        }
    }

    public Bundle[] getUsingBundles(ServiceReference<?> serviceReference) {
        Bundle[] bundleArray = null;
        for (Map.Entry entry : this.m_inUseMap.entrySet()) {
            Bundle bundle = (Bundle)entry.getKey();
            UsageCount[] usageCountArray = (UsageCount[])entry.getValue();
            int n = 0;
            while (n < usageCountArray.length) {
                if (usageCountArray[n].m_ref.equals(serviceReference)) {
                    if (bundleArray == null) {
                        bundleArray = new Bundle[]{bundle};
                    } else {
                        Bundle[] bundleArray2 = new Bundle[bundleArray.length + 1];
                        System.arraycopy(bundleArray, 0, bundleArray2, 0, bundleArray.length);
                        bundleArray2[bundleArray.length] = bundle;
                        bundleArray = bundleArray2;
                    }
                }
                ++n;
            }
        }
        return bundleArray;
    }

    void servicePropertiesModified(ServiceRegistration<?> serviceRegistration, Dictionary<?, ?> dictionary) {
        this.hookRegistry.updateHooks(serviceRegistration.getReference());
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(2, serviceRegistration.getReference()), dictionary);
        }
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    UsageCount obtainUsageCount(Bundle bundle, ServiceReference<?> serviceReference, Object object, Boolean bl) {
        UsageCount usageCount = null;
        boolean bl2 = false;
        while (!bl2) {
            UsageCount[] usageCountArray;
            UsageCount[] usageCountArray2 = (UsageCount[])this.m_inUseMap.get(bundle);
            if (!Boolean.TRUE.equals(bl)) {
                int n = 0;
                while (usageCountArray2 != null && n < usageCountArray2.length) {
                    if (usageCountArray2[n].m_ref.equals(serviceReference) && (object == null && !usageCountArray2[n].m_prototype || usageCountArray2[n].getService() == object)) {
                        return usageCountArray2[n];
                    }
                    ++n;
                }
            }
            if (bl == null) {
                return null;
            }
            usageCount = new UsageCount(serviceReference, bl);
            if (usageCountArray2 == null) {
                usageCountArray = new UsageCount[]{usageCount};
                bl2 = this.m_inUseMap.putIfAbsent(bundle, usageCountArray) == null;
                continue;
            }
            usageCountArray = new UsageCount[usageCountArray2.length + 1];
            System.arraycopy(usageCountArray2, 0, usageCountArray, 0, usageCountArray2.length);
            usageCountArray[usageCountArray2.length] = usageCount;
            bl2 = this.m_inUseMap.replace(bundle, usageCountArray2, usageCountArray);
        }
        return usageCount;
    }

    void flushUsageCount(Bundle bundle, ServiceReference<?> serviceReference, UsageCount usageCount) {
        boolean bl = false;
        while (!bl) {
            UsageCount[] usageCountArray;
            UsageCount[] usageCountArray2 = usageCountArray = (UsageCount[])this.m_inUseMap.get(bundle);
            int n = 0;
            while (usageCountArray != null && n < usageCountArray.length) {
                if (usageCount == null && usageCountArray[n].m_ref.equals(serviceReference) || usageCount == usageCountArray[n]) {
                    if (usageCountArray.length - 1 == 0) {
                        usageCountArray = null;
                    } else {
                        UsageCount[] usageCountArray3 = new UsageCount[usageCountArray.length - 1];
                        System.arraycopy(usageCountArray, 0, usageCountArray3, 0, n);
                        if (n < usageCountArray3.length) {
                            System.arraycopy(usageCountArray, n + 1, usageCountArray3, n, usageCountArray3.length - n);
                        }
                        usageCountArray = usageCountArray3;
                        --n;
                    }
                }
                ++n;
            }
            if (usageCountArray == usageCountArray2) {
                return;
            }
            if (usageCountArray2 == null) continue;
            bl = usageCountArray != null ? this.m_inUseMap.replace(bundle, usageCountArray2, usageCountArray) : this.m_inUseMap.remove(bundle, usageCountArray2);
        }
    }

    public HookRegistry getHookRegistry() {
        return this.hookRegistry;
    }

    static class ServiceHolder {
        final CountDownLatch m_latch = new CountDownLatch(1);
        volatile Object m_service;

        ServiceHolder() {
        }
    }

    public static interface ServiceRegistryCallbacks {
        public void serviceChanged(ServiceEvent var1, Dictionary<?, ?> var2);
    }

    static class UsageCount {
        final ServiceReference<?> m_ref;
        final boolean m_prototype;
        final AtomicLong m_count = new AtomicLong();
        final AtomicLong m_serviceObjectsCount = new AtomicLong();
        final AtomicReference<ServiceHolder> m_svcHolderRef = new AtomicReference();

        UsageCount(ServiceReference<?> serviceReference, boolean bl) {
            this.m_ref = serviceReference;
            this.m_prototype = bl;
        }

        Object getService() {
            ServiceHolder serviceHolder = this.m_svcHolderRef.get();
            return serviceHolder == null ? null : serviceHolder.m_service;
        }
    }
}

